let _listTable    = null;
let _listData     = [];
let _vmsInfoMap   = new Map();
let _editBtn      = null;
let _addBtn       = null;
let _delBtn       = null;
let _cancelBtn    = null;
let _saveBtn      = null;
let _vmsCtlrNmbr  = null;
let _schTime      = null;
let _luminance    = null;
let _useYn        = null;
const _apiUri     = "/api/vms/schedule/lum_set_sch";
const _vmsUri     = "/api/vms/common/vms-list";

$(()=>{

    //상단 닫기 버튼
    creatBtn($('.close-btn'), 'close', '닫기', '닫기', 'outlined', () => window.close(), 80, false, true, 30);

    //하단 편집 버튼들
    _editBtn   = creatBtn($('.edit-btn'), 'edit', '편집', '편집', 'outlined', editEvent, null, true, true);
    _cancelBtn = creatBtn($('.cancel-btn'), 'edit', '취소', '취소', 'outlined', cancelEvent, null, false, false);
    _addBtn    = creatBtn($('.add-btn'), 'plus', '추가', '추가', 'outlined', addEvent, null, false, true);
    _delBtn    = creatBtn($('.del-btn'), 'minus', '삭제', '삭제', 'outlined', delEvent, null, true, true);
    _saveBtn   = creatBtn($('.save-btn'), 'save', '저장', '저장', 'outlined', saveEvent, null, true, true);

    //VMS 셀렉트 박스
    _vmsCtlrNmbr = $('.vms_ctlr_nmbr').dxSelectBox({
        stylingMode : 'outlined',
        dataSource  : [],
        width       : 400,
        height      : 30,
        disabled    : true,
        displayExpr : 'vms_desc',
        valueExpr   : 'vms_ctlr_nmbr',
    }).dxSelectBox('instance');

    //제어시각
    _schTime = $('.sch_time').dxDateBox({
        stylingMode         : 'outlined',
        width               : 100,
        height              : 30,
        displayFormat       : 'HH:mm',
        type                : 'time',
        interval            : 10,
        value               : firstSettingTime,
        disabled            : true,
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');

    //휘도값
    _luminance = $('.luminance').dxNumberBox({
        stylingMode : 'outlined',
        width       : 100,
        height      : 30,
        min         : 0,
        max         : 100,
        value       : 0,
        showSpinButtons : true,
        readOnly    : true,
        onValueChanged(e){
            if(!e.value) setValue(e.component, 0);
        }
    }).dxNumberBox('instance');

    //VMS 셀렉트 박스
    _useYn = $('.use_yn').dxSelectBox({
        stylingMode : 'outlined',
        dataSource  : [
            {
                use_desc : '[Y] 사용',
                use_yn   : 'Y',
            },
            {
                use_desc : '[N] 사용안함',
                use_yn   : 'N',
            }
        ],
        width       : 150,
        height      : 30,
        readOnly    : true,
        displayExpr : 'use_desc',
        valueExpr   : 'use_yn',
        value       : 'Y',
    }).dxSelectBox('instance');

    //VMS 리스트 테이블
    _listTable = $(".list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['vms_ctlr_nmbr', 'sch_time'],
        selection: {
            mode : 'single',
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'standard',
        },
        paging : {
            pageSize : 1000,
        },
        sorting : {
            showSortIndexes : false,
        },
        groupPanel : {
            visible         : true,
            emptyPanelText  : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "vms_ctlr_nmbr",
                caption      : "VMS 번호",
                alignment    : "center",
                allowEditing : false,
                sortIndex    : 0,
                sortOrder    : "asc",
                groupIndex   : 0,
                cssClass     : 'padding-ctrl',
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                },
            },
            {
                dataField    : "vms_ctrl_id",
                caption      : "VMS ID",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "vms_nm",
                caption      : "VMS 명칭",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField    : "sch_time",
                caption      : "제어시각",
                alignment    : "center",
                sortIndex    : 1,
                sortOrder    : "asc",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "luminance",
                caption      : "휘도값",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "use_desc",
                caption      : "사용여부",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
        ],
        onRowClick(info){
            if(!info.groupIndex && info.groupIndex !== 0){
                listRowClick(info.data);
            }
        },
    }).dxDataGrid("instance");

    fetchBaseData();
})

/*
* 리스트 데이터 수신
*/
function fetchBaseData(){
    getDataAsync(_apiUri, recvListFunc);
    getDataAsync(_vmsUri, recvComboFunc);
}

function recvListFunc(jsonData){
    _listData = jsonData;
    _listTable.option('dataSource', _listData);
}

function recvComboFunc(jsonData) {
    const vmsData = jsonData;
    let comboData = [];
    if (vmsData.length > 0) {
        vmsData.map((item) => {
            let val = '[' + item.vms_ctlr_nmbr + '] ' + item.vms_ctlr_id + ' ' +  item.vms_nm;
            comboData.push({
                vms_ctlr_nmbr : item.vms_ctlr_nmbr,
                vms_desc      : val,
            });

            if (!_vmsInfoMap.get(item.vms_ctlr_nmbr)) {
                _vmsInfoMap.set(item.vms_ctlr_nmbr, new Map());
                let vmsInfo = _vmsInfoMap.get(item.vms_ctlr_nmbr)
                vmsInfo.set('vms_ctrl_id', item.vms_ctlr_id);
                vmsInfo.set('vms_nm', item.vms_nm);
            }
        })
    }

    comboData.sort((a,b)=>{
        return a.vms_ctlr_nmbr - b.vms_ctlr_nmbr
    });

    _vmsCtlrNmbr.option('dataSource', comboData);
    if (comboData.length > 0) {
        setValue(_vmsCtlrNmbr, comboData[0].vms_ctlr_nmbr);
    }

}

/**
 * 리스트 테이블 클릭 이벤트
 * @param {*} rowData : 클릭한 로우의 데이터
 * @returns {void}
 */
function listRowClick(rowData){
    setValue(_vmsCtlrNmbr, rowData.vms_ctlr_nmbr);
    let timeVal = rowData.sch_time;
    let now = nowTime();
    timeVal =  now.substring(0,10) +' '+ timeVal.substring(0,2) + ':' + timeVal.substring(2,4)+ ':00';
    timeVal = new Date(timeVal).getTime();

    setValue(_schTime, timeVal);
    setValue(_luminance, rowData.luminance);
    setValue(_useYn, rowData.use_yn);
    dsblOffBtn(_editBtn);
    dsblOffBtn(_delBtn);
}

/**
 * 편집 버튼 클릭 이벤트
 */
function editEvent(){
    eventOn();
    textOption('edit');
}

/**
 * 추가 버튼 클릭 이벤트
 */
function addEvent(){
    eventOn();
    boxInit();
    textOption('add');
}

/**
 * 취소 버튼 클릭 이벤트
 */
function cancelEvent(){
    eventOff();
    textOption('cancel');
}

/**
 * 저장 버튼 클릭 이벤트
 */
function saveEvent(){
    let vms_ctlr_nmbr= getValue(_vmsCtlrNmbr);
    let updateData = {
        luminance: getValue(_luminance),
        use_desc : null,
        sch_time: getValue(_schTime),
        use_yn: getValue(_useYn),
        vms_nm : _vmsInfoMap.get(vms_ctlr_nmbr).get('vms_nm'),
        vms_ctrl_id : _vmsInfoMap.get(vms_ctlr_nmbr).get('vms_ctrl_id'),
        vms_ctlr_nmbr: vms_ctlr_nmbr,
    }

    updateData.use_desc = updateData.use_yn == 'Y' ? '[Y] 사용' : '[N] 미사용';
    if(!getValue(_schTime)){
        alertWarning('제어시각을 입력해주세요.', null, _schTime);
        return;
    }
    else if(_schTime.option('validationError')){
        alertWarning('제어시각을 형식에 맞게 입력해주세요.', null, _schTime);
        return;
    }

    updateData.sch_time = getSendTime(updateData.sch_time);
    let result = postInsertUpdate(_apiUri, updateData);
    if(result > 0){
        let updateIndex = _listData.findIndex(item => item.vms_ctlr_nmbr === vms_ctlr_nmbr && item.sch_time === updateData.sch_time);
        if (updateIndex === -1){
            _listData.push(updateData);
        }
        else {
            _listData[updateIndex] = updateData;
        }

        _listTable.option('dataSource', _listData);
        _listTable.refresh().then(()=>{
            _listTable.clearSelection();
            _listTable.selectRows({ vms_ctlr_nmbr : updateData.vms_ctlr_nmbr,sch_time: updateData.sch_time }, true);
            _listTable.option('focusedRowKey', { vms_ctlr_nmbr : updateData.vms_ctlr_nmbr,sch_time: updateData.sch_time });
            eventOff();
            textOption('cancel');
        });
        return alertConfirm('휘도제어 스케줄 정보저장<br>휘도제어 스케줄 정보를 저장 하였습니다.');
    }
    //return alertError('휘도제어 스케줄 정보저장<br>휘도제어 스케줄 정보가 저장되지 않았습니다.');
}

/**
 * 삭제 버튼 클릭 이벤트
 */
function delEvent(){
    let selectedData = _listTable.getSelectedRowsData()[0];
    let schTime      = selectedData.sch_time;
    if(schTime && schTime.length === 4) {
        schTime = schTime.substring(0,2) + ':' + schTime.substring(2,4);
    }
    confirmMessage('VMS번호 : '
        + selectedData.vms_ctlr_nmbr
        + '<br>제어시각 : '
        + schTime
        +'<br>선택하신 휘도제어 스케줄 정보를 삭제하시겠습니까?').done((yes) => {
        if (yes === true) {
            let result = deleteData(_apiUri, selectedData.vms_ctlr_nmbr + '/' + selectedData.sch_time);
            if(result > 0){
                let delIndex = _listData.findIndex(item => item.vms_ctlr_nmbr === selectedData.vms_ctlr_nmbr && item.sch_time === selectedData.sch_time);
                _listData.splice(delIndex, 1);
                _listTable.option('dataSource', _listData);
                _listTable.clearSelection();
                _listTable.option('focusedRowIndex', -1);
                eventOff();
                textOption('cancel');
                return alertConfirm('휘도제어 스케줄 정보삭제<br>휘도제어 스케줄 정보를 삭제 하였습니다.');
            }
            //return alertError('휘도제어 스케줄 정보삭제<br>휘도제어 스케줄 정보가 삭제되지 않았습니다.');
        }
    });

}

/**
 * 이벤트 실행시 버튼 옵션 함수
 */
function eventOn(){
    showBtn(_cancelBtn);
    hideBtn(_editBtn);
    dsblOnBtn(_addBtn);
    dsblOnBtn(_delBtn);
    dsblOffBtn(_saveBtn);
    dsblOnBtn(_listTable);
}

/**
 * 이벤트 종료시 버튼 옵션 및 텍스트 상자 값 설정 함수
 */
function eventOff(){
    hideBtn(_cancelBtn);
    showBtn(_editBtn);
    dsblOffBtn(_addBtn);
    dsblOnBtn(_delBtn);
    dsblOnBtn(_saveBtn);
    dsblOnBtn(_editBtn);
    dsblOffBtn(_listTable);
    const selectedData = _listTable.getSelectedRowsData();
    if(selectedData.length > 0){
        dsblOffBtn(_editBtn);
        dsblOffBtn(_delBtn);
        boxInit(selectedData[0]);
        return
    }
    boxInit();
}

/**
 * 텍스트 상자 값 초기화 함수
 * @param {*} data : 리스트 선택된 데이터
 */
function boxInit(data){
    if (data){
        setValue(_vmsCtlrNmbr, data.vms_ctlr_nmbr);
        setValue(_useYn, data.use_yn);
        let timeVal = data.sch_time;
        let now = nowTime();
        timeVal =  now.substring(0,10) +' '+ timeVal.substring(0,2) + ':' + timeVal.substring(2,4)+ ':00';
        timeVal = new Date(timeVal).getTime();
        setValue(_schTime, timeVal);
        setValue(_luminance, data.luminance);
    }
    else {
        setValue(_vmsCtlrNmbr, _vmsCtlrNmbr.option('dataSource')[0].vms_ctlr_nmbr);
        setValue(_useYn, 'Y');
        setValue(_schTime, firstSettingTime);
        setValue(_luminance, 0);
    }
}

/**
 * 텍스트 상자 옵션 설정 함수
 * @param {*} type : 편집/추가/취소
 */
function textOption(type){
    if (type === 'edit'){
        _useYn.option('readOnly', false);
        _luminance.option('readOnly', false);
    }
    else if (type === 'add'){
        dsblOffBtn(_vmsCtlrNmbr);
        dsblOffBtn(_schTime);
        _useYn.option('readOnly', false);
        _luminance.option('readOnly', false);
    }
    else if (type === 'cancel'){
        dsblOnBtn(_vmsCtlrNmbr);
        dsblOnBtn(_schTime);
        _useYn.option('readOnly', true);
        _luminance.option('readOnly', true);
    }
}