let cancleBtn = null;
let searchBtn = null;
let sttsData  = [];
let sttsTable = null;
const commonUri = '/api/vds/monitoring/ctlr-stts';

$(()=>{
    creatBtn($(".close-btn"), "close", "닫기", "닫기", "outlined", () => window.close());
    creatBtn($(".search-btn"), "refresh", "조회", "조회", "outlined", () => fetchListData());

    //CCTV 상태 전체조회 테이블
    sttsTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : sttsData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: false,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : 'ctlr_mngm_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : 'VDS 정보',
                alignment : 'center',
                cssClass  : 'padding-ctrl',
                columns   : [
                    {
                        dataField    : "ctlr_mngm_nmbr",
                        caption      : "관리번호",
                        alignment    : "center",
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                        width        : 140,
                    },
                    {
                        dataField    : "vds_ctlr_id",
                        caption      : "VDS ID",
                        alignment    : "center",
                        width        : 100,
                    },
                    {
                        dataField    : "vds_nm",
                        caption      : "VDS 명칭",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "coll_cnt",
                        caption      : "수집건수",
                        alignment    : "center",
                        width        : 100,
                    },
                    {
                        dataField    : "prnt_volt",
                        caption      : "입력 전압",
                        visible      : false,
                        alignment    : "center",
                        width        : 100,
                    },
                    {
                        dataField    : "inpt_volt",
                        caption      : "출력 전압",
                        visible      : false,
                        alignment    : "center",
                        width        : 100,
                    },
                    {
                        dataField    : "sub_ctlr_val",
                        caption      : "부제어기 값",
                        alignment    : "center",
                        visible      : false,
                        width        : 130,
                    },
                ]
            },
            {
                caption   : '통신',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "updt_dt",
                        caption      : "업데이트 시각",
                        alignment    : "center",
                        format       : "yyyy-MM-dd HH:mm:ss",
                        dataType     : 'datetime'
                    },
                    {
                        dataField    : "cmnc_stts_desc",
                        caption      : "통신",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.cmnc_stts_cd, e.displayValue, c);
                        }
                    },
                    {
                        dataField    : "coll_stts_desc",
                        caption      : "수집상태정보",
                        alignment    : "center",
                        width        : 150,
                        cellTemplate(c,e){
                            if (e.displayValue === '이상') {
                                c.css('padding','2px');
                                c.css('height','1px');
                                const div= $("<div>");
                                div.addClass('yellow');
                                div.text(e.displayValue);
                                return c.append(div);
                            }
                            else {
                                return c.text(e.displayValue);
                            }
                        }
                    },
                    
                ]
            },
            {
                caption   : '함체',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "cbox_door_stts_desc",
                        caption      : "도어",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.cbox_door_stts_cd, e.displayValue, c, e.data.cmnc_stts_cd);
                        }
                    },
                    {
                        dataField    : "fan_stts_desc",
                        caption      : "팬상태",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.fan_stts_cd, e.displayValue, c, e.data.cmnc_stts_cd);
                        }
                    },
                    {
                        dataField    : "hetr_stts_desc",
                        caption      : "히터상태",
                        alignment    : "center",
                        width        : 110,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.hetr_stts_cd, e.displayValue, c, e.data.cmnc_stts_cd);
                        }
                    },
                    {
                        dataField    : "prnt_pwer_stts_desc",
                        caption      : "전원상태",
                        alignment    : "center",
                        visible      : false,
                        width        : 110,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.prnt_pwer_stts_cd, e.displayValue, c, e.data.cmnc_stts_cd);
                        }
                    },
                    {
                        dataField    : "cbox_tmpr",
                        caption      : "온도",
                        alignment    : "center",
                        width        : 100,
                        cellTemplate(c,e){
                            return getSttsClass(e.data.cbox_tmpr, e.displayValue, c);
                        }
                    },
                   
                ]
            },
        ],
    }).dxDataGrid("instance");
    fetchListData();
})

function fetchListData(){
    getDataAsync(commonUri, (jsonData)=>{
        const listData = jsonData;
         if (listData.length > 0){

             listData.map((item)=>{
                 if (item.updt_dt) item.updt_dt = getParseDateTime(item.updt_dt);
             })
        }
        sttsTable.option('dataSource', listData);
    });
}

function getSttsClass(sttsCd, text, container, cmnc_stts_cd) {
    container.css('padding','2px');
    container.css('height','1px');
    let classNm = sttsCd;
    let textVal = text;
    if (sttsCd === null || sttsCd === undefined || sttsCd === 255 || cmnc_stts_cd === 'CMS1' || cmnc_stts_cd === 'CMS2') {
        classNm = 'gray';
        textVal = '-';
    }

    const div = $('<div class='+classNm+'>');
    div.text(textVal);
    container.append(div);
    return container;
}