let leglHldyInfrData    = [];
let updateData          = [];
let insertData          = [];
let _listTable          = null;
let ymdData             = [];
let delData             = [];
let dayTypeArr          = [];
let modalSelectBtn      = null;
let addBtn              = null;
let delBtn              = null;
let applyBtn            = null;
let modalDate           = null;
let modalCancleBtn      = null;
let searchBtn           = null;
const _pageName         = '휴일 관리';
let modalBackground     = null;
const _apiUri           = '/api/database/legl-hldy-infr';

$(()=>{
    //모달창 세팅
    $("body").append(modalDiv);
    modalBackground = $(".modal-background");
    $(".modal-title").prepend($("<div>휴일선택</div>"));
    modalBackground.css("display",'none');
    $(".modal-content").append($("<div class='modal-content-title'>").html("휴일을 선택하세요"),$("<div class='modal-date'>"));

    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchListData();
        }
    }).dxButton("instance")

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")

    //휴일관리 테이블
    _listTable = $(".legl-hldy-infr-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'ymd',
        focusedRowEnabled       : true,
        selection: {
            mode : 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter : {
            visible: true,
        },
        grouping : {
            autoExpandAll : true,
        },
        scrolling : {
            mode : 'standard',
        },
        paging :{
            pageSize : 1000,

        },
        groupPanel :{
            visible : true,
            emptyPanelText : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export : {
            enabled : true,
            texts : {
                exportAll : "엑셀 파일",
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        columns:[
            {
                dataField:"ymd",
                caption:"년월일",
                alignment:"center",
                allowEditing: false,
                sortIndex: 0,
                sortOrder: "asc",
            },
            {
                dataField:"day_type_cd",
                caption:"요일 유형",
                alignment:"center",
                lookup:{
                    dataSource:null,
                    valueExpr: "day_type_cd",
                    displayExpr:"day_type_desc"
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField:"legl_hldy_nm",
                caption:"공휴일명",
                alignment:"center",
                editorOptions : {
                    dataType : 'string',
                    maxLength : 30,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField:"rmrk",
                caption:"비고",
                alignment:"center",
                editorOptions : {
                    dataType : 'string',
                    maxLength : 200,
                },
            },
        ],
        onSelectionChanged(e){
            delData = e.selectedRowsData;
        }
    }).dxDataGrid("instance");

    //하단 편집 버튼
    editBtn = $(".edit-btn").dxButton({
        stylingMode:'outlined',
        text:'편집',
        icon:'edit',
        onClick(){
            eventOn();
        }
    }).dxButton("instance")

    //하단 취소 버튼
    editCancleBtn = $(".edit-cancle-btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        visible:false,
        icon:'close',
        onClick(){
            eventOff();
        }
    }).dxButton("instance")

    //추가 버튼
    addBtn = $(".add-btn").dxButton({
        stylingMode:'outlined',
        text:'추가',
        disabled:true,
        icon:'plus',
        onClick(){
            modalBackground.css("display", "flex");
            setValue(modalDate, new Date());
        }
    }).dxButton("instance")

    //삭제 버튼
    delBtn = $(".del-btn").dxButton({
        stylingMode:'outlined',
        text:'삭제',
        disabled:true,
        icon:'minus',
        onClick(){
            _listTable.option("selection",{
                mode:'multiple',
            });
            _listTable.option("editing",{
                mode:'none',
                allowUpdating : false,
            });
            dsblOnBtn(addBtn);
            dsblOnBtn(delBtn);
        }
    }).dxButton('instance')

    //하단 적용 버튼
    applyBtn = $(".apply-btn").dxButton({
        stylingMode:'outlined',
        text:'적용',
        disabled:true,
        icon:'save',
        onClick(){
            saveEvent();
        }
    }).dxButton("instance")

    //휴일 선택 모달 선택 버튼
    modalSelectBtn = $(".modal-save-Btn").dxButton({
        stylingMode:'outlined',
        text:'선택',
        icon:'check',
        onClick(){
            insertDate();
        },
    }).dxButton("instance")

    modalDate = $(".modal-date").dxDateBox({
        type                : 'date',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        value               : new Date(),
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");

    //휴일 선택 모달 취소 버튼
    $(".modal-cancle-Btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        icon:'close',
        onClick(){
            modalCancel();
        },
    }).dxButton("instance")

    //휴일 선택 모달 x 버튼
    $(".modal-cancle").dxButton({
        stylingMode:'text',
        icon:'close',
        onClick(){
            modalCancel();
        }
    }).dxButton("instance");

    fetchCdData();
    fetchListData();
});
function fetchCdData() {
    //요일 유형 데이터
    getDataAsync("/api/database/legl-hldy-infr/hldy-type", (jsonData)=>{
        dayTypeArr = jsonData;
        _listTable.option('columns[1].lookup.dataSource', dayTypeArr);
        //데이터 정렬
        listDataSorting();
    });
}
function fetchListData(method){
    getDataAsync(_apiUri, (jsonData)=>{ 
        listData = jsonData;
        if (listData.length > 0) {
            ymdData = [];
            listData.map((item)=>{
                ymdData.push(item.ymd);
            });
        }

        _listTable.option('dataSource', listData);
        if (method) {
            _listTable.clearSelection();
            _listTable.refresh().done(()=>{
                method();
            })
        }
    });
}
function listDataSorting() {
    if (dayTypeArr.length > 0) {
        dayTypeArr.sort(function(a,b){
            return (Number(a.day_type_cd.match(/(\d+)/g)[0]))-(Number(b.day_type_cd.match(/(\d+)/g)[0]));
        })
    }
}

function modalCancel(){
    modalBackground.css("display",'none');
}

function eventOn(){
    showBtn(editCancleBtn);
    hideBtn(editBtn);
    dsblOffBtn(applyBtn);
    dsblOffBtn(addBtn);
    dsblOffBtn(delBtn);
    dsblOnBtn(searchBtn);

    _listTable.option("editing",{
        mode                    : 'batch',
        allowUpdating           : true,
        selectTextOnEditStart   : true,
    });

    _listTable.option('toolbar.visible', false);
}

function eventOff(){
    if (_listTable.hasEditData() || delData.length > 0){
        confirmMessage("변경 하신 휴일 정보가 있습니다. 취소 하시겠습니까?").done((yes) => {
            if (yes === true) {
                resetState();
            }
        });
    }
    else {
        resetState();
    }
}

function resetState(){
    showBtn(editBtn);
    hideBtn(editCancleBtn);
    dsblOnBtn(applyBtn);
    dsblOnBtn(addBtn);
    dsblOnBtn(delBtn);
    dsblOffBtn(searchBtn);

    _listTable.option("editing",{
        mode:"none",
        allowUpdating:false,
    });

    _listTable.option("selection",{
        mode:'null',
    });

    _listTable.option('toolbar.visible', true);
}


function insertDate(){
    if (!modalDate.option("value")){
        alertWarning("날짜를 선택해 주세요");
    }
    else if (ymdData.includes(dateFormmater(modalDate.option("value")))){
        alertWarning("이미 선택된 날짜입니다.");
    }
    else {
        _listTable.addRow();
        _listTable.option('editing.changes',[{
            key:_listTable.option('editing.editRowKey'),
            data:{
                ymd           : dateFormmater(modalDate.option("value")),
                day_type_cd   : 'LHT0',
            },
            type:"insert",
        }]);

        modalBackground.css("display","none");
        ymdData.push(dateFormmater(modalDate.option("value")))
        dsblOnBtn(delBtn);
        dsblOnBtn(addBtn);
    }
}

function saveEvent() {
    if (!_listTable.hasEditData() && delData.length === 0) {
        alertWarning("변경하신 데이터가 없습니다.")
    }
    else {
        let updateData = [];

        if (_listTable.hasEditData()) {
            _listTable.option('editing.changes').map((item)=>{
                _listTable.byKey(item.key).done(function(obj) {
                    updateData.push(obj);
                });
            });

            for (let obj of updateData){
                const rowIdx       = _listTable.getRowIndexByKey(obj.ymd);
                const frontContent = '년월일 : ' + obj.ymd;
                if (nullChecker(obj.ymd) === ""){
                    _listTable.focus(_listTable.getCellElement(rowIdx, 'ymd'));
                    return alertWarning(frontContent + '<br>날짜를 입력해 주세요.');
                }
                else if (nullChecker(obj.day_type_cd) === "") {
                    _listTable.focus(_listTable.getCellElement(rowIdx, 'day_type_cd'));
                    return alertWarning(frontContent + '<br>휴일 종류를 선택해 주세요.');
                }
                else if (nullChecker(obj.legl_hldy_nm) === "") {
                    _listTable.focus(_listTable.getCellElement(rowIdx, 'legl_hldy_nm'));
                    return alertWarning(frontContent + '<br>공휴일명을 입력해 주세요.');
                }
                else if(getByteLength(obj.legl_hldy_nm) > 30) {
                    _listTable.focus(_listTable.getCellElement(rowIdx, 'legl_hldy_nm'));
                    return alertWarning(frontContent + '<br>공휴일명을 30바이트 이내로 입력해 주세요.');
                }
                else if(nullChecker(obj.rmrk) !== "" && getByteLength(obj.rmrk) > 200) {
                    _listTable.focus(_listTable.getCellElement(rowIdx, 'rmrk'));
                    return alertWarning(frontContent + '<br>비고를 200바이트 이내로 입력해 주세요.');
                }
            }

            confirmMessage("수정하신 휴일 정보를 적용 하시겠습니까?").done((yes) => {
                if (yes === true) {
                    let result = postInsertUpdate('/api/database/legl-hldy-infr', updateData);

                    if (result > 0) {
                        saveEnd('변경 하신 휴일 정보가 수정 되었습니다.');
                        fetchListData(()=>{
                            const key = updateData[updateData.length - 1].ymd;
                            _listTable.selectRows(key, true).done(()=>{
                                _listTable.option('focusedRowKey', key);
                            })
                        });
                    }
                }
            });
        }

        else if ( delData.length > 0) {
            confirmMessage("선택하신 휴일 정보를 삭제하시겠습니까?").done((yes) => {
                if (yes === true) {
                    let delYmdArr = [];

                    delData.map((item)=>{
                        delYmdArr.push(item.ymd);
                    });

                    let result = deleteDataIds('/api/database/legl-hldy-infr', delYmdArr);

                    if (result > 0) {
                        saveEnd('선택 하신 휴일 정보가 삭제 되었습니다.');
                        fetchListData(()=>{
                            _listTable.option('focusedRowIndex', -1);
                        });
                    }
                }
            });
        }


    }
}

function saveEnd(text){
    leglHldyInfrData = refresh(_listTable, leglHldyInfrData, "/api/database/legl-hldy-infr");
    resetState();
    alertConfirm(text);
}
