let unitSystData     = [];
let updateData       = [];
let insertData       = [];
let idData           = [];
let delData          = [];
let unitSystTable    = null;
let modalText        = null;
let modalCancleBtn   = null;
let modalSelectBtn   = null;
let addBtn           = null;
let delBtn           = null;
let applyBtn         = null;
let searchBtn        = null;
const _pageName       = '프로세스 관리';
const unitSystUri    = "/api/database/unit-syst";
const ipExpr         = /^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$/;
const checkByteArr   = [
    ['syst_type', '시스템 유형', 64, true],
    ['syst_nm', '시스템 명칭', 100, true],
    ['syst_ip_1', '시스템 IP Address1', 20, true],
    ['syst_ip_2', '시스템 IP Address2', 20, false],
    ['prgm_port', '포트', 5, false],
    ['host_nm', '호스트명', 100, false],
    ['os_nm', '운영체제명', 100, false],
]
$(()=>{
    $("body").append(modalDiv);
    $(".modal-title").prepend($("<div>운영자 ID</div>"));
    $(".modal-background").css("display",'none'); 
    $(".modal-content").append($("<div class='modal-content-title'>").html("신규 프로세스 ID를 입력하세요"),$("<div class='modal-text'>"))
    
    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchListData();
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    console.log(unitSystData);
    //프로세스 관리 테이블
    unitSystTable = $(".unit-syst-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'syst_id',
        selection: {
           mode : 'none',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled : true,
            texts   : {
                exportAll :"엑셀 파일",
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        columns:[
            {   
                dataField    : "syst_id",
                caption      : "시스템 ID",
                alignment    : "center",
                allowEditing : false,
                width: 150,
                sortIndex    : 0, 
                sortOrder    : "asc",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField   : "syst_type",
                caption     : "시스템 유형",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 7,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField   : "syst_nmbr",
                caption     : "시스템 번호",
                alignment   : "center",
                editorOptions: {
                    dataType  : 'number',
                    maxLength : 999,
                    format    : '#',
                },
            },
            {   
                dataField   : "syst_nm",
                caption     : "시스템 명칭",
                alignment   : "center",
                visible     : false,
                editorOptions: {
                    dataType : 'string',
                    maxLength : 100,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "syst_desc",
                caption     : "시스템 명칭",
                alignment   : "center",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "syst_ip_1",
                caption     : "IP Address 1",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 20,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "syst_ip_2",
                caption     : "IP Address 2",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 20,
                },
            },
            {   
                dataField   : "prgm_port",
                caption     : "포트",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 5,
                },
            },
            {   
                dataField   : "host_nm",
                caption     : "호스트명",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 100,
                },
            },
            {   
                dataField   : "os_nm",
                caption     : "운영체제명",
                alignment   : "center",
                editorOptions: {
                    dataType : 'string',
                    maxLength : 100,
                },
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {   
                dataField   : "del_yn",
                caption     : "삭제 여부",
                alignment   : "center",
                visible     : false,
                lookup      :{
                    dataSource : ['Y','N'],
                }
            },
            {   
                dataField   : "stts_dspl_yn",
                caption     : "상태표출",
                alignment   : "center",
                lookup      :{
                    dataSource : ['Y','N'],
                }
            },
        ],
        onRowClick(e){
        },
        onRowUpdated(e){
            updateData.push(e.data);
        },
        onRowInserted(e){
            insertData.push(e.data);
        },
        onSelectionChanged(e){
            delData = e.selectedRowsData;
        }
    }).dxDataGrid("instance");
    
    //하단 편집 버튼
    editBtn = $(".edit-btn").dxButton({
        stylingMode:'outlined',
        text:'편집',
        icon:'edit',
        onClick(){
            eventOn();
        }
    }).dxButton("instance")
    
    //하단 취소 버튼
    editCancleBtn = $(".edit-cancle-btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        visible:false,
        icon:'close',
        onClick(){
            if(unitSystTable.hasEditData() || delData.length > 0){
                confirmMessage("변경 하신 데이터가 있습니다. 취소 하시겠습니까?").done((yes) => {
                    if (yes === true) {
                        eventOff();
                    }
                });
            }
            else {
                eventOff();
            }
        }
    }).dxButton("instance")
    
    //추가 버튼
    addBtn = $(".add-btn").dxButton({
        stylingMode:'outlined',
        text:'추가',
        disabled:true,
        icon:'plus',
        onClick(){
            $(".modal-background").css("display","flex");
            setValue(modalText, '');
            modalText.focus();
        }
    }).dxButton("instance")
    
    //삭제 버튼
    delBtn = $(".del-btn").dxButton({
        stylingMode:'outlined',
        text:'삭제',
        disabled:true,
        icon:'minus',
        onClick(){
            unitSystTable.option("selection",{
                mode:'multiple',
            });
            dsblOnBtn(addBtn);
            dsblOnBtn(delBtn);
        }
    }).dxButton("instance")
    
    //하단 적용 버튼
    applyBtn = $(".apply-btn").dxButton({
        stylingMode:'outlined',
        text:'적용',
        disabled:true,
        icon:'save',
        onClick(){
             saveEvent();
        }
    }).dxButton("instance")
    
    //신규 ID 모달 선택 버튼
    modalSelectBtn = $(".modal-save-Btn").dxButton({
        stylingMode:'outlined',
        text:'선택',
        icon:'check',
        onClick(){
            fetchSystemId(getValue(modalText));
        },
    }).dxButton("instance")
    
    modalText = $(".modal-text").dxTextBox({
        width:"250px",
        maxLength: 30,
        stylingMode : 'outlined',
        onEnterKey(e){
            fetchSystemId(e.component._changedValue);
        }
    }).dxTextBox("instance");

    //신규 ID 모달 취소 버튼
    $(".modal-cancle-Btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        icon:'close',
        onClick(){
            $(".modal-background").css("display",'none');
        },
    }).dxButton("instance")
    
    //신규 ID 선택 모달 x 버튼
    modalCancleBtn=$(".modal-cancle").dxButton({
        stylingMode:'text',
        icon:'close',
        onClick(){
            $(".modal-background").css("display",'none');
        }
    }).dxButton("instance");
    
    fetchListData();
})

function fetchListData() {
    getDataAsync(unitSystUri, (jsonData)=>{
        unitSystData = jsonData;
        if (unitSystData.length > 0) {
            unitSystData.map((item) =>{
                idData.push(item.syst_id);
            });
        }
        unitSystTable.option('dataSource', unitSystData);
    });
}

function eventOff(){
    showBtn(editBtn);
    hideBtn(editCancleBtn);
    dsblOnBtn(applyBtn);
    dsblOnBtn(delBtn);
    dsblOnBtn(addBtn);
    dsblOffBtn(searchBtn);
    showColumn(unitSystTable,'syst_desc');
    hideColumn(unitSystTable,'syst_nm');
    
    unitSystTable.option("editing",{
        mode:"none",
        allowUpdating:false,
    });
    
    unitSystTable.option("selection",{
        mode : "none",
    });

    unitSystTable.option('toolbar.visible', true);
    
    fetchListData();
}

function eventOn(){
    showBtn(editCancleBtn);
    hideBtn(editBtn);
    dsblOffBtn(applyBtn);
    dsblOffBtn(addBtn);
    dsblOffBtn(delBtn);
    dsblOnBtn(searchBtn);
    showColumn(unitSystTable,'syst_nm');
    hideColumn(unitSystTable,'syst_desc');
    unitSystTable.option("editing",{
        mode:"batch",
        allowUpdating:true,
    });

    unitSystTable.option('toolbar.visible', false);
}

function saveEvent(){
    if (!unitSystTable.hasEditData() && delData.length <= 0){
        return alertWarning("변경하신 데이터가 없습니다.")   
    }
    else {
            let updateDataArr = [];
            let resultCnt = 0;
            let delCnt = 0;
            const columns = {
                del_yn       : null,
                host_nm      : null,
                os_nm        : null,
                prgm_port    : null,
                stts_dspl_yn : null,
                syst_id      : null,
                syst_ip_1    : null,
                syst_ip_2    : null,
                syst_nm      : null,
                syst_type    : null,
                syst_nmbr    : 0,
            };
            
            if (unitSystTable.hasEditData()) {

                unitSystTable.option('editing.changes').map((item)=>{
                    unitSystTable.byKey(item.key).done(function(obj) {
                        const data = {...obj};
                        updateDataArr.push(data);
                    });
                })

                if (updateDataArr.length > 0) {
                    for ( let obj of updateDataArr ){
                        const frontContent = "시스템 ID : " + obj.syst_id + "<br>";
                        for (let checkByte of checkByteArr) {
                            const value = obj[checkByte[0]];
                            const empty = nullChecker(value) === '';
                            if (empty) {
                                if (checkByte[3]) {
                                    return alertWarning(frontContent + "필수 항목을 입력해주세요. [ " + checkByte[1] +" ]");
                                }
                                obj[checkByte[0]] = null;
                            }
                            else {
                                if (getByteLength(value) > checkByte[2]) {
                                    return alertWarning( frontContent + checkByte[2]+ " 바이트 이내로 입력해주세요. [ " + checkByte[1] + " ]");
                                }
                            }
                        }
                    }

                    confirmMessage("변경하신 프로세스 정보를 적용 하시겠습니까?").done((yes) => {
                        if (yes === true) {
                            if(updateDataArr.length > 0){
                                for ( let ii = 0; ii < updateDataArr.length; ii++ ){
                                    updateData = updateDataArr[ii];
                                    let result = postInsertUpdate( unitSystUri + '/' + encodeURIComponent(updateData.syst_id), updateData);
                                    resultCnt += result;
                                }
                                eventOff();
                                alertConfirm('변경하신 프로세스 정보 ' + resultCnt + '건이 적용되었습니다.');
                            }
                        }
                    });
                }
            }
            else if ( delData.length > 0){
                confirmMessage("선택하신 프로세스 정보를 삭제 하시겠습니까?").done((yes) => {
                    if (yes === true) {
                        delData.map((item)=>{
                            let result = deleteData(unitSystUri, item.syst_id);
                            delCnt += result;
                        });
                        eventOff();
                        alertConfirm('선택하신 프로세스 정보 ' + delCnt + '건이 삭제되었습니다.');
                    }
                });
            }
            
    }
}

function fetchSystemId(value){
    if (!value){
        alertWarning("ID를 입력해 주세요");
    }
    else if (idData.includes(value)){
        alertWarning("이미 사용중인 ID 입니다.");
    }
    else if (getByteLength(value) > 30) {
        alertWarning("ID를 30바이트 이내로 입력해주세요.");
    }
    else {
        unitSystTable.addRow();
        unitSystTable.option('editing.changes',[{
            key  : unitSystTable.option('editing.editRowKey'),  
            data :{
                syst_id      : value,
                del_yn       : 'N',
                stts_dspl_yn : 'N',
            },
            type:"insert",
        }]);

        $(".modal-background").css("display","none");
        idData.push(value);
        dsblOnBtn(addBtn);
        dsblOnBtn(delBtn);
    }
}