export const LayerType = {
    TRAF: 0, //교통정보
    LINK: 1, //링크
    IFSC: 2, //정보제공구간
    ROAD: 3, //도로
    VMSI: 4, //VMS정보제공구간
    NODE: 5, //노드
    FCLT: 6, //시설물
    PARK: 7, //시설물
    BIS: 8, // BIS
    INCD: 9, //돌발정보
    EDIT: 10, //시설물편집
    Select: 11, //선택
    MAX: 12,
};

const TRAF_INDEX_BASE = 0;
const LINK_INDEX_BASE = TRAF_INDEX_BASE;
const IFSC_INDEX_BASE = LINK_INDEX_BASE + 5;
const ROAD_INDEX_BASE = IFSC_INDEX_BASE + 5;
const VMSI_INDEX_BASE = ROAD_INDEX_BASE + 5;
const FCLT_INDEX_BASE = VMSI_INDEX_BASE + 2;
export const LayerIndex = {
    Traffic: TRAF_INDEX_BASE, //교통정보
    Link1: LINK_INDEX_BASE + 1, //링크
    Link2: LINK_INDEX_BASE + 2, //링크
    Link3: LINK_INDEX_BASE + 3, //링크
    Link4: LINK_INDEX_BASE + 4, //링크
    Link5: LINK_INDEX_BASE + 5, //링크
    Ifsc1: IFSC_INDEX_BASE + 1, //정보제공구간
    Ifsc2: IFSC_INDEX_BASE + 2, //정보제공구간
    Ifsc3: IFSC_INDEX_BASE + 3, //정보제공구간
    Ifsc4: IFSC_INDEX_BASE + 4, //정보제공구간
    Ifsc5: IFSC_INDEX_BASE + 5, //정보제공구간
    Road1: ROAD_INDEX_BASE + 1, //도로
    Road2: ROAD_INDEX_BASE + 2, //도로
    Road3: ROAD_INDEX_BASE + 3, //도로
    Road4: ROAD_INDEX_BASE + 4, //도로
    Road5: ROAD_INDEX_BASE + 5, //도로
    VmsIfsc: VMSI_INDEX_BASE + 1, //VMS정보제공구간
    Route: VMSI_INDEX_BASE + 2, //VMS정보제공구간
    Node: FCLT_INDEX_BASE + 1, //노드
    Cctv: FCLT_INDEX_BASE + 2, //CCTV
    Vms: FCLT_INDEX_BASE + 3, //VMS
    Vds: FCLT_INDEX_BASE + 4, //VDS
    VdsDet: FCLT_INDEX_BASE + 5, //VDS검지지점
    VdsR: FCLT_INDEX_BASE + 6, //VDS루프
    VdsRDet: FCLT_INDEX_BASE + 7, //VDS루프검지지점
    VdsC: FCLT_INDEX_BASE + 8, //VDS영상
    VdsCDet: FCLT_INDEX_BASE + 9, //VDS영상검지지점
    Avi: FCLT_INDEX_BASE + 10, //AVI
    Rse: FCLT_INDEX_BASE + 11, //RSE
    Dsrc: FCLT_INDEX_BASE + 12, //DSRC
    Park: FCLT_INDEX_BASE + 13, //주차장
    PVms: FCLT_INDEX_BASE + 14, //주차장VMS
    Station: FCLT_INDEX_BASE + 15, // 정류장
    Bit: FCLT_INDEX_BASE + 16, //BIT
    Bit2: FCLT_INDEX_BASE + 17, //BIT
    Bus: FCLT_INDEX_BASE + 18, // Car
    Sig: FCLT_INDEX_BASE + 19, //신호제어기
    SigDet: FCLT_INDEX_BASE + 29, //신호검지기
    Signal: FCLT_INDEX_BASE + 21, //신호현지
    WCam: FCLT_INDEX_BASE + 22, //웹카메라(CCTV)
    CCam: FCLT_INDEX_BASE + 23, //교차로감시카메라
    ICam: FCLT_INDEX_BASE + 24, //돌발감시카메라
    CCol: FCLT_INDEX_BASE + 25, //교차로수집시스템
    SPCam: FCLT_INDEX_BASE + 26, //자살방지 CCTV
    Event: FCLT_INDEX_BASE + 27, //이벤트
    Wthr: FCLT_INDEX_BASE + 28, //기상
    Atmp: FCLT_INDEX_BASE + 29, //기상예보
    Crs: FCLT_INDEX_BASE + 30, //교차로교통량
    CrsCam: FCLT_INDEX_BASE + 31, //교차로교통량 CCTV
    Incd: FCLT_INDEX_BASE + 32, //돌발정보
    Position: FCLT_INDEX_BASE + 33, //돌발정보
    Select: FCLT_INDEX_BASE + 34, //선택
    MAX: FCLT_INDEX_BASE + 35,
};

export const LayerInfo = {
    Traffic: { type: LayerType.TRAF, index: LayerIndex.Traffic, image: "", name: "교통정보" },
    Link1: { type: LayerType.LINK, index: LayerIndex.Link1, image: "", name: "링크" },
    Link2: { type: LayerType.LINK, index: LayerIndex.Link2, image: "", name: "링크" },
    Link3: { type: LayerType.LINK, index: LayerIndex.Link3, image: "", name: "링크" },
    Link4: { type: LayerType.LINK, index: LayerIndex.Link4, image: "", name: "링크" },
    Link5: { type: LayerType.LINK, index: LayerIndex.Link5, image: "", name: "링크" },
    Ifsc1: { type: LayerType.IFSC, index: LayerIndex.Ifsc1, image: "", name: "정보제공구간" },
    Ifsc2: { type: LayerType.IFSC, index: LayerIndex.Ifsc2, image: "", name: "정보제공구간" },
    Ifsc3: { type: LayerType.IFSC, index: LayerIndex.Ifsc3, image: "", name: "정보제공구간" },
    Ifsc4: { type: LayerType.IFSC, index: LayerIndex.Ifsc4, image: "", name: "정보제공구간" },
    Ifsc5: { type: LayerType.IFSC, index: LayerIndex.Ifsc5, image: "", name: "정보제공구간" },
    Road1: { type: LayerType.ROAD, index: LayerIndex.Road1, image: "", name: "도로" },
    Road2: { type: LayerType.ROAD, index: LayerIndex.Road2, image: "", name: "도로" },
    Road3: { type: LayerType.ROAD, index: LayerIndex.Road3, image: "", name: "도로" },
    Road4: { type: LayerType.ROAD, index: LayerIndex.Road4, image: "", name: "도로" },
    Road5: { type: LayerType.ROAD, index: LayerIndex.Road5, image: "", name: "도로" },
    VmsIfsc: { type: LayerType.VMSI, index: LayerIndex.VmsIfsc, image: "", name: "VMS정보제공구간" },
    Node: { type: LayerType.FCLT, index: LayerIndex.Node, image: "/facility/node_", name: "노드" },
    Cctv: { type: LayerType.FCLT, index: LayerIndex.Cctv, image: "/facility/cctv_", name: "CCTV" },
    Vms: { type: LayerType.FCLT, index: LayerIndex.Vms, image: "/facility/vms_", name: "VMS" },
    Vds: { type: LayerType.FCLT, index: LayerIndex.Vds, image: "/facility/vds_", name: "VDS" },
    VdsDet: { type: LayerType.FCLT, index: LayerIndex.VdsDet, image: "/facility/vdsdet_", name: "VDS검지지점" },
    VdsR: { type: LayerType.FCLT, index: LayerIndex.VdsR, image: "/facility/vdsr_", name: "VDS루프" },
    VdsRDet: { type: LayerType.FCLT, index: LayerIndex.VdsRDet, image: "/facility/vdsrdet_", name: "VDS루프검지지점" },
    VdsC: { type: LayerType.FCLT, index: LayerIndex.VdsC, image: "/facility/vdsc_", name: "VDS영상" },
    VdsCDet: { type: LayerType.FCLT, index: LayerIndex.VdsCDet, image: "/facility/vdscdet_", name: "VDS영상검지지점" },
    Avi: { type: LayerType.FCLT, index: LayerIndex.Avi, image: "/facility/vvi_", name: "AVI" },
    Rse: { type: LayerType.FCLT, index: LayerIndex.Rse, image: "/facility/rse_", name: "RSE" },
    Dsrc: { type: LayerType.FCLT, index: LayerIndex.Dsrc, image: "/facility/dsrc_", name: "DSRC" },
    Park: { type: LayerType.FCLT, index: LayerIndex.Park, image: "/facility/park_", name: "주차장" },
    PVms: { type: LayerType.FCLT, index: LayerIndex.PVms, image: "/facility/pvms_", name: "주차장VMS" },
    Station: { type: LayerType.BIS, index: LayerIndex.Station, image: "/facility/station_", name: "정류장" },
    Bit: { type: LayerType.FCLT, index: LayerIndex.Bit, image: "/facility/bit_", name: "BIT" },
    Bit2: { type: LayerType.BIS, index: LayerIndex.Bit2, image: "/facility/bit_", name: "BIT2" },
    Bus: { type: LayerType.BIS, index: LayerIndex.Bus, image: "/facility/bus_", name: "BUS" },
    Sig: { type: LayerType.FCLT, index: LayerIndex.Sig, image: "/facility/sig_", name: "신호제어기" },
    SigDet: { type: LayerType.FCLT, index: LayerIndex.SigDet, image: "/facility/sigdet_", name: "신호검지기" },
    Signal: { type: LayerType.FCLT, index: LayerIndex.Signal, image: "/facility/signal_", name: "신호현지" },
    WCam: { type: LayerType.FCLT, index: LayerIndex.WCam, image: "/facility/wcam_", name: "웹카메라(CCTV)" },
    CCam: { type: LayerType.FCLT, index: LayerIndex.CCam, image: "/facility/ccam_", name: "교차로감시카메라" },
    ICam: { type: LayerType.FCLT, index: LayerIndex.ICam, image: "/facility/icam_", name: "돌발감시카메라" },
    CCol: { type: LayerType.FCLT, index: LayerIndex.CCol, image: "/facility/ccol_", name: "교차로수집시스템" },
    SPCam: { type: LayerType.FCLT, index: LayerIndex.SPCam, image: "/facility/spcam_", name: "자살방지 CCTV" },
    Event: { type: LayerType.FCLT, index: LayerIndex.Event, image: "/facility/event_", name: "이벤트" },
    Wthr: { type: LayerType.FCLT, index: LayerIndex.Wthr, image: "/facility/wthr_", name: "기상" },
    Atmp: { type: LayerType.FCLT, index: LayerIndex.Atmp, image: "/facility/atmp_", name: "기상예보" },
    Crs: { type: LayerType.FCLT, index: LayerIndex.Crs, image: "/facility/crs_", name: "교차로교통량" },
    CrsCam: { type: LayerType.FCLT, index: LayerIndex.CrsCam, image: "/facility/crscam_", name: "교차로교통량 CCTV" },
    Incd: { type: LayerType.Incd, index: LayerIndex.Incd, image: "/incident/incd_", name: "돌발정보" },
    Position: { type: LayerType.FCLT, index: LayerIndex.Position, image: "/maps/position", name: "위치" },
    Select: { type: LayerType.Select, index: LayerIndex.Select, image: "/maps/select", name: "선택" },
    MAX: { type: LayerType.MAX, index: LayerIndex.MAX, image: "", name: "" },
};

export const FacilityComm = {
    Normal: { state: 0, desc: "정상" },
    Error: { state: 1, desc: "통신이상" },
    Module: { state: 2, desc: "모듈이상" },
    Unknown: { state: 3, desc: "알수없음" },
    Collect: { state: 4, desc: "수집이상" },
};

export const TrafficGrade = {
    NoData: { grade: 0, desc: "정보없음", color: "#888888" },
    Light: { grade: 1, desc: "소통원활", color: "#15B337" },
    Moderate: { grade: 2, desc: "지체", color: "#FFAA00" },
    Heavy: { grade: 3, desc: "정체", color: "#FF0000" },
};
export const TrafficGradeDesc = ["정보없음", "소통원활", "지체", "정체"];
export const TrafficGradeColor = ["#888888", "#15B337", "#FFAA00", "#FF0000"];

export let EditLinkColor = new Array();
// EditLinkColor.push("#15B337"); // default color
// EditLinkColor.push("#FF0000"); // sequence color
// EditLinkColor.push("#0000FF");
// EditLinkColor.push("#FF8200");
// EditLinkColor.push("#9400D3");
// EditLinkColor.push("#000000");
// EditLinkColor.push("#828282");
// EditLinkColor.push("#1E90FF");
// EditLinkColor.push("#B9062F");
// EditLinkColor.push("#8c008c");
// EditLinkColor.push("#FF8200");
// EditLinkColor.push("#9400D3");
// EditLinkColor.push("#B0C4DE");
// EditLinkColor.push("#00BFFF");
// EditLinkColor.push("#87CEEB");
// EditLinkColor.push("#87CEFA");
// EditLinkColor.push("#ADD8E6");
// EditLinkColor.push("#B0E0E6");
// EditLinkColor.push("#E6E6FA");
// EditLinkColor.push("#F0F8FF");
EditLinkColor[0] = "#15B337"; // default color
EditLinkColor[1] = "#FF0000"; // sequence color
EditLinkColor[2] = "#0000FF";
EditLinkColor[3] = "#FF8200";
EditLinkColor[4] = "#9400D3";
EditLinkColor[5] = "#000000";
EditLinkColor[6] = "#828282";
EditLinkColor[7] = "#1E90FF";
EditLinkColor[8] = "#B9062F";
EditLinkColor[9] = "#8c008c";
EditLinkColor[10] = "#FF8200";
EditLinkColor[11] = "#9400D3";
EditLinkColor[12] = "#B0C4DE";
EditLinkColor[13] = "#00BFFF";
EditLinkColor[14] = "#87CEEB";
EditLinkColor[15] = "#87CEFA";
EditLinkColor[16] = "#ADD8E6";
EditLinkColor[17] = "#B0E0E6";
EditLinkColor[18] = "#E6E6FA";
EditLinkColor[19] = "#F0F8FF";

export const EditLinkLineSize = [
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    2,
    2, // 10
    2,
    2,
    3,
    3,
    4,
    4,
    6,
    8,
    8,
    8, // 20
    8,
    8,
    8,
];
