/*
 Highcharts Gantt JS v10.1.0 (2022-04-29)

 Gantt series

 (c) 2016-2021 Lars A. V. Cabrera

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/gantt",["highcharts"],function(H){b(H);b.Highcharts=H;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function H(b,p,v,t){b.hasOwnProperty(p)||(b[p]=t.apply(null,v),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:p,module:b[p]}})))}b=b?b._modules:{};H(b,"Series/XRange/XRangePoint.js",
[b["Core/Series/Point.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,p,v){var t=this&&this.__extends||function(){var b=function(l,h){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(h,d){h.__proto__=d}||function(h,d){for(var r in d)d.hasOwnProperty(r)&&(h[r]=d[r])};return b(l,h)};return function(l,h){function x(){this.constructor=l}b(l,h);l.prototype=null===h?Object.create(h):(x.prototype=h.prototype,new x)}}();v=v.extend;p=function(p){function l(){var h=
null!==p&&p.apply(this,arguments)||this;h.options=void 0;h.series=void 0;return h}t(l,p);l.getColorByCategory=function(h,l){var d=h.options.colors||h.chart.options.colors;h=l.y%(d?d.length:h.chart.options.chart.colorCount);return{colorIndex:h,color:d&&d[h]}};l.prototype.resolveColor=function(){var h=this.series;if(h.options.colorByPoint&&!this.options.color){var x=l.getColorByCategory(h,this);h.chart.styledMode||(this.color=x.color);this.options.colorIndex||(this.colorIndex=x.colorIndex)}else this.color||
(this.color=h.color)};l.prototype.init=function(){b.prototype.init.apply(this,arguments);this.y||(this.y=0);return this};l.prototype.setState=function(){b.prototype.setState.apply(this,arguments);this.series.drawPoint(this,this.series.getAnimationVerb())};l.prototype.getLabelConfig=function(){var h=b.prototype.getLabelConfig.call(this),l=this.series.yAxis.categories;h.x2=this.x2;h.yCategory=this.yCategory=l&&l[this.y];return h};l.prototype.isValid=function(){return"number"===typeof this.x&&"number"===
typeof this.x2};return l}(p.seriesTypes.column.prototype.pointClass);v(p.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]});return p});H(b,"Series/XRange/XRangeComposition.js",[b["Core/Axis/Axis.js"],b["Core/Utilities.js"]],function(b,p){var v=p.addEvent,t=p.pick;v(b,"afterGetSeriesExtremes",function(){var b=this.series,l;if(this.isXAxis){var h=t(this.dataMax,-Number.MAX_VALUE);b.forEach(function(b){b.x2Data&&b.x2Data.forEach(function(d){d>h&&(h=d,l=!0)})});l&&(this.dataMax=h)}})});H(b,"Series/XRange/XRangeSeries.js",
[b["Core/Globals.js"],b["Core/Color/Color.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"],b["Series/XRange/XRangePoint.js"]],function(b,p,v,t,C){var l=this&&this.__extends||function(){var a=function(c,m){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(m,a){m.__proto__=a}||function(m,a){for(var c in a)a.hasOwnProperty(c)&&(m[c]=a[c])};return a(c,m)};return function(c,m){function D(){this.constructor=c}a(c,m);c.prototype=null===m?Object.create(m):(D.prototype=m.prototype,
new D)}}(),h=p.parse,x=v.series,d=v.seriesTypes.column,r=d.prototype,g=t.clamp,A=t.correctFloat,B=t.defined;p=t.extend;var L=t.find,e=t.isNumber,a=t.isObject,c=t.merge,u=t.pick;t=function(E){function G(){var a=null!==E&&E.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}l(G,E);G.prototype.init=function(){d.prototype.init.apply(this,arguments);this.options.stacking=void 0};G.prototype.getColumnMetrics=function(){function a(){c.series.forEach(function(a){var m=a.xAxis;
a.xAxis=a.yAxis;a.yAxis=m})}var c=this.chart;a();var e=r.getColumnMetrics.call(this);a();return e};G.prototype.cropData=function(a,c,e,u){c=x.prototype.cropData.call(this,this.x2Data,c,e,u);c.xData=a.slice(c.start,c.end);return c};G.prototype.findPointIndex=function(a){var m=this.cropped,c=this.cropStart,u=this.points,g=a.id;if(g)var d=(d=L(u,function(a){return a.id===g}))?d.index:void 0;"undefined"===typeof d&&(d=(d=L(u,function(m){return m.x===a.x&&m.x2===a.x2&&!m.touched}))?d.index:void 0);m&&
e(d)&&e(c)&&d>=c&&(d-=c);return d};G.prototype.translatePoint=function(m){var D=this.xAxis,d=this.yAxis,E=this.columnMetrics,F=this.options,h=F.minPointLength||0,r=(m.shapeArgs&&m.shapeArgs.width||0)/2,z=this.pointXOffset=E.offset,n=m.plotX,y=u(m.x2,m.x+(m.len||0)),q=D.translate(y,0,0,0,1);y=Math.abs(q-n);var f=this.chart.inverted,k=u(F.borderWidth,1)%2/2,w=E.offset,J=Math.round(E.width);h&&(h-=y,0>h&&(h=0),n-=h/2,q+=h/2);n=Math.max(n,-10);q=g(q,-10,D.len+10);B(m.options.pointWidth)&&(w-=(Math.ceil(m.options.pointWidth)-
J)/2,J=Math.ceil(m.options.pointWidth));F.pointPlacement&&e(m.plotY)&&d.categories&&(m.plotY=d.translate(m.y,0,1,0,1,F.pointPlacement));F=Math.floor(Math.min(n,q))+k;F={x:F,y:Math.floor(m.plotY+w)+k,width:Math.floor(Math.max(n,q))+k-F,height:J,r:this.options.borderRadius};m.shapeArgs=F;f?m.tooltipPos[1]+=z+r:m.tooltipPos[0]-=r+z-F.width/2;r=F.x;z=r+F.width;0>r||z>D.len?(r=g(r,0,D.len),z=g(z,0,D.len),q=z-r,m.dlBox=c(F,{x:r,width:z-r,centerX:q?q/2:null})):m.dlBox=null;r=m.tooltipPos;z=f?1:0;q=f?0:1;
E=this.columnMetrics?this.columnMetrics.offset:-E.width/2;r[z]=f?r[z]+F.width/2:r[z]+(D.reversed?-1:0)*F.width;r[q]=g(r[q]+(f?-1:1)*E,0,d.len-1);if(d=m.partialFill)a(d)&&(d=d.amount),e(d)||(d=0),m.partShapeArgs=c(F,{r:this.options.borderRadius}),n=Math.max(Math.round(y*d+m.plotX-n),0),m.clipRectArgs={x:D.reversed?F.x+y-n:F.x,y:F.y,width:n,height:F.height}};G.prototype.translate=function(){r.translate.apply(this,arguments);this.points.forEach(function(a){this.translatePoint(a)},this)};G.prototype.drawPoint=
function(m,D){var e=this.options,d=this.chart.renderer,g=m.graphic,E=m.shapeType,r=m.shapeArgs,z=m.partShapeArgs,n=m.clipRectArgs,y=m.partialFill,q=e.stacking&&!e.borderRadius,f=m.state,k=e.states[f||"normal"]||{},w="undefined"===typeof f?"attr":D;f=this.pointAttribs(m,f);k=u(this.chart.options.chart.animation,k.animation);if(m.isNull||!1===m.visible)g&&(m.graphic=g.destroy());else{if(g)g.rect[D](r);else m.graphic=g=d.g("point").addClass(m.getClassName()).add(m.group||this.group),g.rect=d[E](c(r)).addClass(m.getClassName()).addClass("highcharts-partfill-original").add(g);
z&&(g.partRect?(g.partRect[D](c(z)),g.partialClipRect[D](c(n))):(g.partialClipRect=d.clipRect(n.x,n.y,n.width,n.height),g.partRect=d[E](z).addClass("highcharts-partfill-overlay").add(g).clip(g.partialClipRect)));this.chart.styledMode||(g.rect[D](f,k).shadow(e.shadow,null,q),z&&(a(y)||(y={}),a(e.partialFill)&&(y=c(e.partialFill,y)),m=y.fill||h(f.fill).brighten(-.3).get()||h(m.color||this.color).brighten(-.3).get(),f.fill=m,g.partRect[w](f,k).shadow(e.shadow,null,q)))}};G.prototype.drawPoints=function(){var a=
this,c=a.getAnimationVerb();a.points.forEach(function(m){a.drawPoint(m,c)})};G.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"};G.prototype.isPointInside=function(a){var m=a.shapeArgs,c=a.plotX,e=a.plotY;return m?"undefined"!==typeof c&&"undefined"!==typeof e&&0<=e&&e<=this.yAxis.len&&0<=(m.x||0)+(m.width||0)&&c<=this.xAxis.len:E.prototype.isPointInside.apply(this,arguments)};G.defaultOptions=c(d.defaultOptions,{colorByPoint:!0,
dataLabels:{formatter:function(){var m=this.point.partialFill;a(m)&&(m=m.amount);if(e(m)&&0<m)return A(100*m)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 10px">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0});return G}(d);p(t.prototype,{type:"xrange",parallelArrays:["x","x2","y"],requireSorting:!1,animate:x.prototype.animate,cropShoulder:1,
getExtremesFromAll:!0,autoIncrement:b.noop,buildKDTree:b.noop,pointClass:C});v.registerSeriesType("xrange",t);"";return t});H(b,"Series/Gantt/GanttPoint.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,p){var v=this&&this.__extends||function(){var b=function(l,h){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(h,d){h.__proto__=d}||function(h,d){for(var r in d)d.hasOwnProperty(r)&&(h[r]=d[r])};return b(l,h)};return function(l,h){function x(){this.constructor=
l}b(l,h);l.prototype=null===h?Object.create(h):(x.prototype=h.prototype,new x)}}(),t=p.pick;return function(b){function l(){var h=null!==b&&b.apply(this,arguments)||this;h.options=void 0;h.series=void 0;return h}v(l,b);l.setGanttPointAliases=function(h){function b(d,r){"undefined"!==typeof r&&(h[d]=r)}b("x",t(h.start,h.x));b("x2",t(h.end,h.x2));b("partialFill",t(h.completed,h.partialFill))};l.prototype.applyOptions=function(h,x){h=b.prototype.applyOptions.call(this,h,x);l.setGanttPointAliases(h);
return h};l.prototype.isValid=function(){return("number"===typeof this.start||"number"===typeof this.x)&&("number"===typeof this.end||"number"===typeof this.x2||this.milestone)};return l}(b.seriesTypes.xrange.prototype.pointClass)});H(b,"Core/Axis/BrokenAxis.js",[b["Extensions/Stacking.js"],b["Core/Utilities.js"]],function(b,p){var v=p.addEvent,t=p.find,C=p.fireEvent,l=p.isArray,h=p.isNumber,x=p.pick,d;(function(d){function g(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,
!1)}function r(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function B(){var a=this.brokenAxis;if(a&&a.hasBreaks){for(var c=this.tickPositions,e=this.tickPositions.info,g=[],u=0;u<c.length;u++)a.isInAnyBreak(c[u])||g.push(c[u]);this.tickPositions=g;this.tickPositions.info=e}}function L(){this.brokenAxis||(this.brokenAxis=new G(this))}function e(){var a=this.options.connectNulls,c=this.points,e=this.xAxis,g=this.yAxis;if(this.isDirty)for(var u=c.length;u--;){var d=c[u],E=
!(null===d.y&&!1===a)&&(e&&e.brokenAxis&&e.brokenAxis.isInAnyBreak(d.x,!0)||g&&g.brokenAxis&&g.brokenAxis.isInAnyBreak(d.y,!0));d.visible=E?!1:!1!==d.options.visible}}function a(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,x(this.pointArrayMap,["y"]))}function c(a,c){var m=this,e=m.points,g,u,d,z;if(a&&a.brokenAxis&&a.brokenAxis.hasBreaks){var n=a.brokenAxis;c.forEach(function(c){g=n&&n.breakArray||[];u=a.isXAxis?a.min:x(m.options.threshold,a.min);e.forEach(function(n){z=x(n["stack"+
c.toUpperCase()],n[c]);g.forEach(function(f){if(h(u)&&h(z)){d=!1;if(u<f.from&&z>f.to||u>f.from&&z<f.from)d="pointBreak";else if(u<f.from&&z>f.from&&z<f.to||u>f.from&&z>f.to&&z<f.from)d="pointInBreak";d&&C(a,d,{point:n,brk:f})}})})})}}function u(){var a=this.currentDataGrouping,c=a&&a.gapSize;a=this.points.slice();var e=this.yAxis,g=this.options.gapSize,u=a.length-1,d;if(g&&0<u)for("value"!==this.options.gapUnit&&(g*=this.basePointRange),c&&c>g&&c>=this.basePointRange&&(g=c),d=void 0;u--;)d&&!1!==
d.visible||(d=a[u+1]),c=a[u],!1!==d.visible&&!1!==c.visible&&(d.x-c.x>g&&(d=(c.x+d.x)/2,a.splice(u+1,0,{isNull:!0,x:d}),e.stacking&&this.options.stacking&&(d=e.stacking.stacks[this.stackKey][d]=new b(e,e.options.stackLabels,!1,d,this.stack),d.total=0)),d=c);return this.getGraphPath(a)}var E=[];d.compose=function(m,d){-1===E.indexOf(m)&&(E.push(m),m.keepProps.push("brokenAxis"),v(m,"init",L),v(m,"afterInit",g),v(m,"afterSetTickPositions",B),v(m,"afterSetOptions",r));if(-1===E.indexOf(d)){E.push(d);
var D=d.prototype;D.drawBreaks=c;D.gappedPath=u;v(d,"afterGeneratePoints",e);v(d,"afterRender",a)}return m};var G=function(){function a(a){this.hasBreaks=!1;this.axis=a}a.isInBreak=function(a,c){var d=a.repeat||Infinity,m=a.from,e=a.to-a.from;c=c>=m?(c-m)%d:d-(m-c)%d;return a.inclusive?c<=e:c<e&&0!==c};a.lin2Val=function(c){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!h(c))return c;var m;for(m=0;m<d.length;m++){var e=d[m];if(e.from>=c)break;else e.to<c?c+=e.len:a.isInBreak(e,c)&&(c+=e.len)}return c};
a.val2Lin=function(c){var d=this.brokenAxis;d=d&&d.breakArray;if(!d||!h(c))return c;var m=c,e;for(e=0;e<d.length;e++){var g=d[e];if(g.to<=c)m-=g.len;else if(g.from>=c)break;else if(a.isInBreak(g,c)){m-=c-g.from;break}}return m};a.prototype.findBreakAt=function(a,c){return t(c,function(c){return c.from<a&&a<c.to})};a.prototype.isInAnyBreak=function(c,d){var m=this.axis,e=m.options.breaks||[],g=e.length,u;if(g&&h(c)){for(;g--;)if(a.isInBreak(e[g],c)){var z=!0;u||(u=x(e[g].showPoints,!m.isXAxis))}var n=
z&&d?z&&!u:z}return n};a.prototype.setBreaks=function(c,d){var m=this,e=m.axis,g=l(c)&&!!c.length;e.isDirty=m.hasBreaks!==g;m.hasBreaks=g;e.options.breaks=e.userOptions.breaks=c;e.forceRedraw=!0;e.series.forEach(function(a){a.isDirty=!0});g||e.val2lin!==a.val2Lin||(delete e.val2lin,delete e.lin2val);g&&(e.userOptions.ordinal=!1,e.lin2val=a.lin2Val,e.val2lin=a.val2Lin,e.setExtremes=function(a,c,n,y,q){if(m.hasBreaks){for(var f=this.options.breaks||[],k;k=m.findBreakAt(a,f);)a=k.to;for(;k=m.findBreakAt(c,
f);)c=k.from;c<a&&(c=a)}e.constructor.prototype.setExtremes.call(this,a,c,n,y,q)},e.setAxisTranslation=function(){e.constructor.prototype.setAxisTranslation.call(this);m.unitLength=void 0;if(m.hasBreaks){var c=e.options.breaks||[],d=[],n=[],y=x(e.pointRangePadding,0),q=0,f,k=e.userMin||e.min,w=e.userMax||e.max,g;c.forEach(function(c){f=c.repeat||Infinity;h(k)&&h(w)&&(a.isInBreak(c,k)&&(k+=c.to%f-k%f),a.isInBreak(c,w)&&(w-=w%f-c.from%f))});c.forEach(function(a){O=a.from;f=a.repeat||Infinity;if(h(k)&&
h(w)){for(;O-f>k;)O-=f;for(;O<k;)O+=f;for(g=O;g<w;g+=f)d.push({value:g,move:"in"}),d.push({value:g+a.to-a.from,move:"out",size:a.breakSize})}});d.sort(function(f,k){return f.value===k.value?("in"===f.move?0:1)-("in"===k.move?0:1):f.value-k.value});var N=0;var O=k;d.forEach(function(f){N+="in"===f.move?1:-1;1===N&&"in"===f.move&&(O=f.value);0===N&&h(O)&&(n.push({from:O,to:f.value,len:f.value-O-(f.size||0)}),q+=f.value-O-(f.size||0))});m.breakArray=n;h(k)&&h(w)&&h(e.min)&&(m.unitLength=w-k-q+y,C(e,
"afterBreaks"),e.staticScale?e.transA=e.staticScale:m.unitLength&&(e.transA*=(w-e.min+y)/m.unitLength),y&&(e.minPixelPadding=e.transA*(e.minPointOffset||0)),e.min=k,e.max=w)}});x(d,!0)&&e.chart.redraw()};return a}();d.Additions=G})(d||(d={}));return d});H(b,"Core/Axis/GridAxis.js",[b["Core/Axis/Axis.js"],b["Core/Axis/AxisDefaults.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,p,v,t){var C=v.dateFormats,l=t.addEvent,h=t.defined,x=t.erase,d=t.find,r=t.isArray,g=t.isNumber,A=t.merge,B=
t.pick,L=t.timeUnits,e=t.wrap,a;(function(a){function c(f,k){var a={width:0,height:0};k.forEach(function(k){k=f[k];if(t.isObject(k,!0)){var c=t.isObject(k.label,!0)?k.label:{};k=c.getBBox?c.getBBox().height:0;c.textStr&&!g(c.textPxLength)&&(c.textPxLength=c.getBBox().width);var n=g(c.textPxLength)?Math.round(c.textPxLength):0;c.textStr&&(n=Math.round(c.getBBox().width));a.height=Math.max(k,a.height);a.width=Math.max(n,a.width)}});"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode&&
(a.width+=this.options.labels.indentation*((this.treeGrid.mapOfPosToGridNode[-1].height||0)-1));return a}function E(){var f=this.grid;(f&&f.columns||[]).forEach(function(f){f.getOffset()})}function G(f){if(!0===(this.options.grid||{}).enabled){var k=this.axisTitle,c=this.height,n=this.horiz,q=this.left,e=this.offset,N=this.opposite,w=this.options,y=this.top,m=this.width,d=this.tickSize(),g=k&&k.getBBox().width,u=w.title.x,z=w.title.y,J=B(w.title.margin,n?5:10);k=this.chart.renderer.fontMetrics(w.title.style.fontSize,
k).f;d=(n?y+c:q)+(n?1:-1)*(N?-1:1)*(d?d[0]/2:0)+(this.side===a.Side.bottom?k:0);f.titlePosition.x=n?q-(g||0)/2-J+u:d+(N?m:0)+e+u;f.titlePosition.y=n?d-(N?c:0)+(N?k:-k)/2+e+z:y-J+z}}function m(){var f=this.chart,k=this.options.grid;k=void 0===k?{}:k;var a=this.userOptions;if(k.enabled){var c=this.options;c.labels.align=B(c.labels.align,"center");this.categories||(c.showLastLabel=!1);this.labelRotation=0;c.labels.rotation=0}if(k.columns){c=this.grid.columns=[];for(var n=this.grid.columnIndex=0;++n<
k.columns.length;){var q=A(a,k.columns[k.columns.length-n-1],{linkedTo:0,type:"category",scrollbar:{enabled:!1}});delete q.grid.columns;q=new b(this.chart,q);q.grid.isColumn=!0;q.grid.columnIndex=n;x(f.axes,q);x(f[this.coll],q);c.push(q)}}}function D(){var f=this.grid,k=this.options;if(!0===(k.grid||{}).enabled){var c=this.min||0,n=this.max||0;this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions);this.rightWall&&this.rightWall.destroy();if(this.grid&&this.grid.isOuterAxis()&&
this.axisLine){var q=k.lineWidth;if(q){q=this.getLinePath(q);var e=q[0],w=q[1],y=((this.tickSize("tick")||[1])[0]-1)*(this.side===a.Side.top||this.side===a.Side.left?-1:1);"M"===e[0]&&"L"===w[0]&&(this.horiz?(e[2]+=y,w[2]+=y):(e[1]+=y,w[1]+=y));!this.horiz&&this.chart.marginRight&&(e=[e,["L",this.left,e[2]||0]],y=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(n+this.tickmarkOffset)],w=[["M",w[1]||0,this.toPixels(n+this.tickmarkOffset)],y],this.grid.upperBorder||0===c%1||(this.grid.upperBorder=
this.grid.renderBorder(e)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:k.lineColor,"stroke-width":k.lineWidth}),this.grid.upperBorder.animate({d:e})),this.grid.lowerBorder||0===n%1||(this.grid.lowerBorder=this.grid.renderBorder(w)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:k.lineColor,"stroke-width":k.lineWidth}),this.grid.lowerBorder.animate({d:w})));this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:k.lineColor,"stroke-width":k.lineWidth}),this.grid.axisLineExtra.animate({d:q})):
this.grid.axisLineExtra=this.grid.renderBorder(q);this.axisLine[this.showAxis?"show":"hide"]()}}(f&&f.columns||[]).forEach(function(f){f.render()});if(!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){f=this.tickmarkOffset;k=this.tickPositions[this.tickPositions.length-1];q=this.tickPositions[0];for(e=w=void 0;(w=this.hiddenLabels.pop())&&w.element;)w.show();for(;(e=this.hiddenMarks.pop())&&e.element;)e.show();(w=this.ticks[q].label)&&(c-q>f?this.hiddenLabels.push(w.hide()):
w.show());(w=this.ticks[k].label)&&(k-n>f?this.hiddenLabels.push(w.hide()):w.show());(c=this.ticks[k].mark)&&k-n<f&&0<k-n&&this.ticks[k].isLast&&this.hiddenMarks.push(c.hide())}}}function Q(){var f=this.tickPositions&&this.tickPositions.info,k=this.options,a=this.userOptions.labels||{};(k.grid||{}).enabled&&(this.horiz?(this.series.forEach(function(f){f.options.pointRange=0}),f&&k.dateTimeLabelFormats&&k.labels&&!h(a.align)&&(!1===k.dateTimeLabelFormats[f.unitName].range||1<f.count)&&(k.labels.align=
"left",h(a.x)||(k.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function M(f){var k=this.options;f=f.userOptions;var a=k&&t.isObject(k.grid,!0)?k.grid:{};if(!0===a.enabled){var c=A(!0,{className:"highcharts-grid-axis "+(f.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,
style:{fontSize:"13px"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},f);"xAxis"===this.coll&&(h(f.linkedTo)&&!h(f.tickPixelInterval)&&(c.tickPixelInterval=350),h(f.tickPixelInterval)||!h(f.linkedTo)||h(f.tickPositioner)||h(f.tickInterval)||(c.tickPositioner=function(f,k){var a=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;
if(a){for(var n=c.units||[],q=void 0,e=void 0,w=void 0,y=0;y<n.length;y++)if(n[y][0]===a.unitName){q=y;break}n[q+1]?(w=n[q+1][0],e=(n[q+1][1]||[1])[0]):"year"===a.unitName&&(w="year",e=10*a.count);a=L[w];this.tickInterval=a*e;return this.getTimeTicks({unitRange:a,count:e,unitName:w},f,k,this.options.startOfWeek)}}));A(!0,this.options,c);this.horiz&&(k.minPadding=B(f.minPadding,0),k.maxPadding=B(f.maxPadding,0));g(k.grid.borderWidth)&&(k.tickWidth=k.lineWidth=a.borderWidth)}}function F(f){f=(f=f.userOptions)&&
f.grid||{};var k=f.columns;f.enabled&&k&&A(!0,this.options,k[k.length-1])}function K(){(this.grid.columns||[]).forEach(function(f){f.setScale()})}function I(f){var k=p.defaultLeftAxisOptions,a=this.horiz,c=this.maxLabelDimensions,n=this.options.grid;n=void 0===n?{}:n;n.enabled&&c&&(k=2*Math.abs(k.labels.x),a=a?n.cellHeight||k+c.height:k+c.width,r(f.tickSize)?f.tickSize[0]=a:f.tickSize=[a,0])}function z(){this.axes.forEach(function(f){(f.grid&&f.grid.columns||[]).forEach(function(f){f.setAxisSize();
f.setAxisTranslation()})})}function n(f){var k=this.grid;(k.columns||[]).forEach(function(k){k.destroy(f.keepEvents)});k.columns=void 0}function y(f){f=f.userOptions||{};var k=f.grid||{};k.enabled&&h(k.borderColor)&&(f.tickColor=f.lineColor=k.borderColor);this.grid||(this.grid=new J(this));this.hiddenLabels=[];this.hiddenMarks=[]}function q(f){var k=this.label,c=this.axis,n=c.reversed,q=c.chart,e=c.options.grid||{},w=c.options.labels,y=w.align,d=a.Side[c.side],m=f.tickmarkOffset,u=c.tickPositions,
N=this.pos-m;u=g(u[f.index+1])?u[f.index+1]-m:(c.max||0)+m;var z=c.tickSize("tick");m=z?z[0]:0;z=z?z[1]/2:0;if(!0===e.enabled){if("top"===d){e=c.top+c.offset;var J=e-m}else"bottom"===d?(J=q.chartHeight-c.bottom+c.offset,e=J+m):(e=c.top+c.len-(c.translate(n?u:N)||0),J=c.top+c.len-(c.translate(n?N:u)||0));"right"===d?(d=q.chartWidth-c.right+c.offset,n=d+m):"left"===d?(n=c.left+c.offset,d=n-m):(d=Math.round(c.left+(c.translate(n?u:N)||0))-z,n=Math.min(Math.round(c.left+(c.translate(n?N:u)||0))-z,c.left+
c.len));this.slotWidth=n-d;f.pos.x="left"===y?d:"right"===y?n:d+(n-d)/2;f.pos.y=J+(e-J)/2;q=q.renderer.fontMetrics(w.style.fontSize,k&&k.element);k=k?k.getBBox().height:0;w.useHTML?f.pos.y+=q.b+-(k/2):(k=Math.round(k/q.h),f.pos.y+=(q.b-(q.h-q.f))/2+-((k-1)*q.h/2));f.pos.x+=c.horiz&&w.x||0}}function f(f){var k=f.axis,a=f.value;if(k.options.grid&&k.options.grid.enabled){var c=k.tickPositions,n=(k.linkedParent||k).series[0],q=a===c[0];c=a===c[c.length-1];var e=n&&d(n.options.data,function(f){return f[k.isXAxis?
"x":"y"]===a}),w=void 0;e&&n.is("gantt")&&(w=A(e),v.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(w));f.isFirst=q;f.isLast=c;f.point=w}}function k(){var f=this.options,k=this.categories,a=this.tickPositions,c=a[0],n=a[a.length-1],q=this.linkedParent&&this.linkedParent.min||this.min,e=this.linkedParent&&this.linkedParent.max||this.max,w=this.tickInterval;!0!==(f.grid||{}).enabled||k||!this.horiz&&!this.isLinked||(c<q&&c+w>q&&!f.startOnTick&&(a[0]=q),n>e&&n-w<e&&!f.endOnTick&&(a[a.length-
1]=e))}function w(f){var k=this.options.grid;return!0===(void 0===k?{}:k).enabled&&this.categories?this.tickInterval:f.apply(this,Array.prototype.slice.call(arguments,1))}(function(f){f[f.top=0]="top";f[f.right=1]="right";f[f.bottom=2]="bottom";f[f.left=3]="left"})(a.Side||(a.Side={}));a.compose=function(a,d,g){-1===a.keepProps.indexOf("grid")&&(a.keepProps.push("grid"),a.prototype.getMaxLabelDimensions=c,e(a.prototype,"unsquish",w),l(a,"init",y),l(a,"afterGetOffset",E),l(a,"afterGetTitlePosition",
G),l(a,"afterInit",m),l(a,"afterRender",D),l(a,"afterSetAxisTranslation",Q),l(a,"afterSetOptions",M),l(a,"afterSetOptions",F),l(a,"afterSetScale",K),l(a,"afterTickSize",I),l(a,"trimTicks",k),l(a,"destroy",n));l(d,"afterSetChartSize",z);l(g,"afterGetLabelPosition",q);l(g,"labelFormat",f);return a};var J=function(){function f(f){this.axis=f}f.prototype.isOuterAxis=function(){var f=this.axis,k=f.grid.columnIndex,a=f.linkedParent&&f.linkedParent.grid.columns||f.grid.columns,c=k?f.linkedParent:f,n=-1,
q=0;f.chart[f.coll].forEach(function(k,a){k.side!==f.side||k.options.isInternal||(q=a,k===c&&(n=a))});return q===n&&(g(k)?a.length===k:!0)};f.prototype.renderBorder=function(f){var k=this.axis,a=k.chart.renderer,c=k.options;f=a.path(f).addClass("highcharts-axis-line").add(k.axisBorder);a.styledMode||f.attr({stroke:c.lineColor,"stroke-width":c.lineWidth,zIndex:7});return f};return f}();a.Additions=J})(a||(a={}));C.E=function(a){return this.dateFormat("%a",a,!0).charAt(0)};C.W=function(a){var c=this,
e=new this.Date(a);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(a){c.set(a,e,0)});var d=(this.get("Day",e)+6)%7;a=new this.Date(e.valueOf());this.set("Date",a,this.get("Date",e)-d+3);d=new this.Date(this.get("FullYear",a),0,1);4!==this.get("Day",d)&&(this.set("Month",e,0),this.set("Date",e,1+(11-this.get("Day",d))%7));return(1+Math.floor((a.valueOf()-d.valueOf())/6048E5)).toString()};"";return a});H(b,"Gantt/Tree.js",[b["Core/Utilities.js"]],function(b){var p=b.extend,v=b.isNumber,
t=b.pick,C=function(h,b){var d=h.reduce(function(d,g){var r=t(g.parent,"");"undefined"===typeof d[r]&&(d[r]=[]);d[r].push(g);return d},{});Object.keys(d).forEach(function(r,g){var h=d[r];""!==r&&-1===b.indexOf(r)&&(h.forEach(function(d){g[""].push(d)}),delete g[r])});return d},l=function(h,b,d,r,g,A){var B=0,L=0,e=A&&A.after,a=A&&A.before;b={data:r,depth:d-1,id:h,level:d,parent:b};var c,u;"function"===typeof a&&a(b,A);a=(g[h]||[]).map(function(a){var e=l(a.id,h,d+1,a,g,A),m=a.start;a=!0===a.milestone?
m:a.end;c=!v(c)||m<c?m:c;u=!v(u)||a>u?a:u;B=B+1+e.descendants;L=Math.max(e.height+1,L);return e});r&&(r.start=t(r.start,c),r.end=t(r.end,u));p(b,{children:a,descendants:B,height:L});"function"===typeof e&&e(b,A);return b};return{getListOfParents:C,getNode:l,getTree:function(b,x){var d=b.map(function(d){return d.id});b=C(b,d);return l("",null,1,null,b,x)}}});H(b,"Core/Axis/TreeGridTick.js",[b["Core/Utilities.js"]],function(b){var p=b.addEvent,v=b.isObject,t=b.isNumber,C=b.pick,l=b.wrap,h;(function(b){function d(){this.treeGrid||
(this.treeGrid=new L(this))}function r(e,a){e=e.treeGrid;var c=!e.labelIcon,d=a.renderer,g=a.xy,b=a.options,m=b.width||0,r=b.height||0,h=g.x-m/2-(b.padding||0);g=g.y-r/2;var l=a.collapsed?90:180,A=a.show&&t(g),B=e.labelIcon;B||(e.labelIcon=B=d.path(d.symbols[b.type](b.x||0,b.y||0,m,r)).addClass("highcharts-label-icon").add(a.group));B.attr({y:A?0:-9999});d.styledMode||B.attr({cursor:"pointer",fill:C(a.color,"#666666"),"stroke-width":1,stroke:b.lineColor,strokeWidth:b.lineWidth||0});B[c?"attr":"animate"]({translateX:h,
translateY:g,rotation:l})}function g(e,a,c,d,g,b,m,r,h){var u=C(this.options&&this.options.labels,b);b=this.pos;var D=this.axis,E="treegrid"===D.options.type;e=e.apply(this,[a,c,d,g,u,m,r,h]);E&&(a=u&&v(u.symbol,!0)?u.symbol:{},u=u&&t(u.indentation)?u.indentation:0,b=(b=(D=D.treeGrid.mapOfPosToGridNode)&&D[b])&&b.depth||1,e.x+=(a.width||0)+2*(a.padding||0)+(b-1)*u);return e}function h(e){var a=this,c=a.pos,d=a.axis,g=a.label,b=d.treeGrid.mapOfPosToGridNode,m=d.options,h=C(a.options&&a.options.labels,
m&&m.labels),l=h&&v(h.symbol,!0)?h.symbol:{},A=(b=b&&b[c])&&b.depth;m="treegrid"===m.type;var B=-1<d.tickPositions.indexOf(c);c=d.chart.styledMode;m&&b&&g&&g.element&&g.addClass("highcharts-treegrid-node-level-"+A);e.apply(a,Array.prototype.slice.call(arguments,1));m&&g&&g.element&&b&&b.descendants&&0<b.descendants&&(d=d.treeGrid.isCollapsed(b),r(a,{color:!c&&g.styles&&g.styles.color||"",collapsed:d,group:g.parentGroup,options:l,renderer:g.renderer,show:B,xy:g.xy}),l="highcharts-treegrid-node-"+(d?
"expanded":"collapsed"),g.addClass("highcharts-treegrid-node-"+(d?"collapsed":"expanded")).removeClass(l),c||g.css({cursor:"pointer"}),[g,a.treeGrid.labelIcon].forEach(function(c){c&&!c.attachedTreeGridEvents&&(p(c.element,"mouseover",function(){g.addClass("highcharts-treegrid-node-active");g.renderer.styledMode||g.css({textDecoration:"underline"})}),p(c.element,"mouseout",function(){var a=v(h.style)?h.style:{};g.removeClass("highcharts-treegrid-node-active");g.renderer.styledMode||g.css({textDecoration:a.textDecoration})}),
p(c.element,"click",function(){a.treeGrid.toggleCollapse()}),c.attachedTreeGridEvents=!0)}))}var B=!1;b.compose=function(e){B||(p(e,"init",d),l(e.prototype,"getLabelPosition",g),l(e.prototype,"renderLabel",h),e.prototype.collapse=function(a){this.treeGrid.collapse(a)},e.prototype.expand=function(a){this.treeGrid.expand(a)},e.prototype.toggleCollapse=function(a){this.treeGrid.toggleCollapse(a)},B=!0)};var L=function(){function e(a){this.tick=a}e.prototype.collapse=function(a){var c=this.tick,e=c.axis,
d=e.brokenAxis;d&&e.treeGrid.mapOfPosToGridNode&&(c=e.treeGrid.collapse(e.treeGrid.mapOfPosToGridNode[c.pos]),d.setBreaks(c,C(a,!0)))};e.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()};e.prototype.expand=function(a){var c=this.tick,e=c.axis,d=e.brokenAxis;d&&e.treeGrid.mapOfPosToGridNode&&(c=e.treeGrid.expand(e.treeGrid.mapOfPosToGridNode[c.pos]),d.setBreaks(c,C(a,!0)))};e.prototype.toggleCollapse=function(a){var c=this.tick,e=c.axis,d=e.brokenAxis;d&&e.treeGrid.mapOfPosToGridNode&&
(c=e.treeGrid.toggleCollapse(e.treeGrid.mapOfPosToGridNode[c.pos]),d.setBreaks(c,C(a,!0)))};return e}();b.Additions=L})(h||(h={}));return h});H(b,"Series/TreeUtilities.js",[b["Core/Color/Color.js"],b["Core/Utilities.js"]],function(b,p){function v(b,g){var h=g.before,r=g.idRoot,l=g.mapIdToNode[r],e=g.points[b.i],a=e&&e.options||{},c=[],u=0;b.levelDynamic=b.level-(!1!==g.levelIsConstant?0:l.level);b.name=d(e&&e.name,"");b.visible=r===b.id||!0===g.visible;"function"===typeof h&&(b=h(b,g));b.children.forEach(function(a,
e){var d=t({},g);t(d,{index:e,siblings:b.children.length,visible:b.visible});a=v(a,d);c.push(a);a.visible&&(u+=a.val)});h=d(a.value,u);b.visible=0<=h&&(0<u||b.visible);b.children=c;b.childrenTotal=u;b.isLeaf=b.visible&&!u;b.val=h;return b}var t=p.extend,C=p.isArray,l=p.isNumber,h=p.isObject,x=p.merge,d=p.pick;return{getColor:function(h,g){var l=g.index,r=g.mapOptionsToLevel,L=g.parentColor,e=g.parentColorIndex,a=g.series,c=g.colors,u=g.siblings,E=a.points,G=a.chart.options.chart,m;if(h){E=E[h.i];
h=r[h.level]||{};if(r=E&&h.colorByPoint){var D=E.index%(c?c.length:G.colorCount);var x=c&&c[D]}if(!a.chart.styledMode){c=E&&E.options.color;G=h&&h.color;if(m=L)m=(m=h&&h.colorVariation)&&"brightness"===m.key&&l&&u?b.parse(L).brighten(l/u*m.to).get():L;m=d(c,G,x,m,a.color)}var p=d(E&&E.options.colorIndex,h&&h.colorIndex,D,e,g.colorIndex)}return{color:m,colorIndex:p}},getLevelOptions:function(b){var g=null;if(h(b)){g={};var A=l(b.from)?b.from:1;var B=b.levels;var r={};var e=h(b.defaults)?b.defaults:
{};C(B)&&(r=B.reduce(function(a,c){if(h(c)&&l(c.level)){var g=x({},c);var b=d(g.levelIsConstant,e.levelIsConstant);delete g.levelIsConstant;delete g.level;c=c.level+(b?0:A-1);h(a[c])?x(!0,a[c],g):a[c]=g}return a},{}));B=l(b.to)?b.to:1;for(b=0;b<=B;b++)g[b]=x({},e,h(r[b])?r[b]:{})}return g},setTreeValues:v,updateRootId:function(b){if(h(b)){var g=h(b.options)?b.options:{};g=d(b.rootNode,g.rootId,"");h(b.userOptions)&&(b.userOptions.rootId=g);b.rootNode=g}return g}}});H(b,"Core/Axis/TreeGridAxis.js",
[b["Core/Axis/BrokenAxis.js"],b["Core/Axis/GridAxis.js"],b["Gantt/Tree.js"],b["Core/Axis/TreeGridTick.js"],b["Series/TreeUtilities.js"],b["Core/Utilities.js"]],function(b,p,v,t,C,l){var h=C.getLevelOptions,x=l.addEvent,d=l.find,r=l.fireEvent,g=l.isArray,A=l.isObject,B=l.isString,L=l.merge,e=l.pick,a=l.wrap,c;(function(c){function u(a,c){var n=a.collapseEnd||0;a=a.collapseStart||0;n>=c&&(a-=.5);return{from:a,to:n,showPoints:!1}}function l(a,c,n){var e=[],q=[],f={},k="boolean"===typeof c?c:!1,w={},
g=-1;a=v.getTree(a,{after:function(f){f=w[f.pos];var k=0,a=0;f.children.forEach(function(f){a+=(f.descendants||0)+1;k=Math.max((f.height||0)+1,k)});f.descendants=a;f.height=k;f.collapsed&&q.push(f)},before:function(a){var c=A(a.data,!0)?a.data:{},n=B(c.name)?c.name:"",q=f[a.parent];q=A(q,!0)?w[q.pos]:null;var y=function(f){return f.name===n},m;k&&A(q,!0)&&(m=d(q.children,y))?(y=m.pos,m.nodes.push(a)):y=g++;w[y]||(w[y]=m={depth:q?q.depth+1:0,name:n,id:c.id,nodes:[a],children:[],pos:y},-1!==y&&e.push(n),
A(q,!0)&&q.children.push(m));B(a.id)&&(f[a.id]=a);m&&!0===c.collapsed&&(m.collapsed=!0);a.pos=y}});w=function(f,k){var a=function(f,c,n){var e=c+(-1===c?0:k-1),q=(e-c)/2,d=c+q;f.nodes.forEach(function(f){var k=f.data;A(k,!0)&&(k.y=c+(k.seriesIndex||0),delete k.seriesIndex);f.pos=d});n[d]=f;f.pos=d;f.tickmarkOffset=q+.5;f.collapseStart=e+.5;f.children.forEach(function(f){a(f,e+1,n);e=(f.collapseEnd||0)-.5});f.collapseEnd=e+.5;return n};return a(f["-1"],-1,{})}(w,n);return{categories:e,mapOfIdToNode:f,
mapOfPosToGridNode:w,collapsedNodes:q,tree:a}}function m(a){a.target.axes.filter(function(a){return"treegrid"===a.options.type}).forEach(function(c){var n=c.options||{},e=n.labels,q=n.uniqueNames;n=n.max;var f=0;if(!c.treeGrid.mapOfPosToGridNode||c.series.some(function(f){return!f.hasRendered||f.isDirtyData||f.isDirty})){var k=c.series.reduce(function(k,a){a.visible&&((a.options.data||[]).forEach(function(c){a.options.keys&&a.options.keys.length&&(c=a.pointClass.prototype.optionsToObject.call({series:a},
c),a.pointClass.setGanttPointAliases(c));A(c,!0)&&(c.seriesIndex=f,k.push(c))}),!0===q&&f++);return k},[]);if(n&&k.length<n)for(var d=k.length;d<=n;d++)k.push({name:d+"\u200b"});n=l(k,q||!1,!0===q?f:1);c.categories=n.categories;c.treeGrid.mapOfPosToGridNode=n.mapOfPosToGridNode;c.hasNames=!0;c.treeGrid.tree=n.tree;c.series.forEach(function(f){var a=(f.options.data||[]).map(function(a){g(a)&&f.options.keys&&f.options.keys.length&&k.forEach(function(f){0<=a.indexOf(f.x)&&0<=a.indexOf(f.x2)&&(a=f)});
return A(a,!0)?L(a):a});f.visible&&f.setData(a,!1)});c.treeGrid.mapOptionsToLevel=h({defaults:e,from:1,levels:e&&e.levels,to:c.treeGrid.tree&&c.treeGrid.tree.height});"beforeRender"===a.type&&(c.treeGrid.collapsedNodes=n.collapsedNodes)}})}function D(a,c){var e=this.treeGrid.mapOptionsToLevel||{},d=this.ticks,q=d[c],f;if("treegrid"===this.options.type&&this.treeGrid.mapOfPosToGridNode){var k=this.treeGrid.mapOfPosToGridNode[c];(e=e[k.depth])&&(f={labels:e});!q&&F?d[c]=new F(this,c,void 0,void 0,{category:k.name,
tickmarkOffset:k.tickmarkOffset,options:f}):(q.parameters.category=k.name,q.options=f,q.addLabel())}else a.apply(this,Array.prototype.slice.call(arguments,1))}function Q(a,c,e){var n=this,q="treegrid"===e.type;n.treeGrid||(n.treeGrid=new K(n));q&&(x(c,"beforeRender",m),x(c,"beforeRedraw",m),x(c,"addSeries",function(f){f.options.data&&(f=l(f.options.data,e.uniqueNames||!1,1),n.treeGrid.collapsedNodes=(n.treeGrid.collapsedNodes||[]).concat(f.collapsedNodes))}),x(n,"foundExtremes",function(){n.treeGrid.collapsedNodes&&
n.treeGrid.collapsedNodes.forEach(function(f){var k=n.treeGrid.collapse(f);n.brokenAxis&&(n.brokenAxis.setBreaks(k,!1),n.treeGrid.collapsedNodes&&(n.treeGrid.collapsedNodes=n.treeGrid.collapsedNodes.filter(function(k){return f.collapseStart!==k.collapseStart||f.collapseEnd!==k.collapseEnd})))})}),x(n,"afterBreaks",function(){"yAxis"===n.coll&&!n.staticScale&&n.chart.options.chart.height&&(n.isDirty=!0)}),e=L({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],
symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},e,{reversed:!0,grid:{columns:void 0}}));a.apply(n,[c,e]);q&&(n.hasNames=!0,n.options.showLastLabel=!0)}function C(a){var c=this.options;"treegrid"===c.type?(this.min=e(this.userMin,c.min,this.dataMin),this.max=e(this.userMax,c.max,this.dataMax),r(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():
[]):a.apply(this,Array.prototype.slice.call(arguments,1))}var F;c.compose=function(c,e,n,d){-1===c.keepProps.indexOf("treeGrid")&&(c.keepProps.push("treeGrid"),F=d,a(c.prototype,"generateTick",D),a(c.prototype,"init",Q),a(c.prototype,"setTickInterval",C),c.prototype.utils={getNode:v.getNode},p.compose(c,e,d),b.compose(c,n),t.compose(d));return c};var K=function(){function a(a){this.axis=a}a.prototype.setCollapsedStatus=function(a){var c=this.axis,e=c.chart;c.series.forEach(function(c){var f=c.options.data;
if(a.id&&f){var k=e.get(a.id);c=f[c.data.indexOf(k)];k&&c&&(k.collapsed=a.collapsed,c.collapsed=a.collapsed)}})};a.prototype.collapse=function(a){var c=this.axis,e=c.options.breaks||[],q=u(a,c.max);e.push(q);a.collapsed=!0;c.treeGrid.setCollapsedStatus(a);return e};a.prototype.expand=function(a){var c=this.axis,e=c.options.breaks||[],q=u(a,c.max);a.collapsed=!1;c.treeGrid.setCollapsedStatus(a);return e.reduce(function(f,a){a.to===q.to&&a.from===q.from||f.push(a);return f},[])};a.prototype.getTickPositions=
function(){var a=this.axis,c=Math.floor(a.min/a.tickInterval)*a.tickInterval,e=Math.ceil(a.max/a.tickInterval)*a.tickInterval;return Object.keys(a.treeGrid.mapOfPosToGridNode||{}).reduce(function(n,f){f=+f;!(f>=c&&f<=e)||a.brokenAxis&&a.brokenAxis.isInAnyBreak(f)||n.push(f);return n},[])};a.prototype.isCollapsed=function(a){var c=this.axis,e=c.options.breaks||[],q=u(a,c.max);return e.some(function(f){return f.from===q.from&&f.to===q.to})};a.prototype.toggleCollapse=function(a){return this.isCollapsed(a)?
this.expand(a):this.collapse(a)};return a}();c.Additions=K})(c||(c={}));return c});H(b,"Extensions/CurrentDateIndication.js",[b["Core/Axis/Axis.js"],b["Core/Axis/PlotLineOrBand/PlotLineOrBand.js"],b["Core/Utilities.js"]],function(b,p,v){var t=v.addEvent,C=v.merge;v=v.wrap;var l={color:"#ccd6eb",width:2,label:{format:"%a, %b %d %Y, %H:%M",formatter:function(b,l){return this.axis.chart.time.dateFormat(l||"",b)},rotation:0,style:{fontSize:"10px"}}};t(b,"afterSetOptions",function(){var b=this.options,
x=b.currentDateIndicator;x&&(x="object"===typeof x?C(l,x):C(l),x.value=Date.now(),x.className="highcharts-current-date-indicator",b.plotLines||(b.plotLines=[]),b.plotLines.push(x))});t(p,"render",function(){this.label&&this.label.attr({text:this.getLabelText(this.options.label)})});v(p.prototype,"getLabelText",function(b,l){var d=this.options;return d&&d.className&&-1!==d.className.indexOf("highcharts-current-date-indicator")&&d.label&&"function"===typeof d.label.formatter?(d.value=Date.now(),d.label.formatter.call(this,
d.value,d.label.format)):b.call(this,l)})});H(b,"Extensions/StaticScale.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Utilities.js"]],function(b,p,v){var t=v.addEvent,C=v.defined,l=v.isNumber,h=v.pick;t(b,"afterSetOptions",function(){var b=this.chart.options.chart;!this.horiz&&l(this.options.staticScale)&&(!b.height||b.scrollablePlotArea&&b.scrollablePlotArea.minHeight)&&(this.staticScale=this.options.staticScale)});p.prototype.adjustHeight=function(){"adjustHeight"!==this.redrawTrigger&&
((this.axes||[]).forEach(function(b){var d=b.chart,l=!!d.initiatedScale&&d.options.animation,g=b.options.staticScale;if(b.staticScale&&C(b.min)){var A=h(b.brokenAxis&&b.brokenAxis.unitLength,b.max+b.tickInterval-b.min)*g;A=Math.max(A,g);g=A-d.plotHeight;!d.scrollablePixelsY&&1<=Math.abs(g)&&(d.plotHeight=A,d.redrawTrigger="adjustHeight",d.setSize(void 0,d.chartHeight+g,l));b.series.forEach(function(g){(g=g.sharedClipKey&&d.sharedClips[g.sharedClipKey])&&g.attr(d.inverted?{width:d.plotHeight}:{height:d.plotHeight})})}}),
this.initiatedScale=!0);this.redrawTrigger=null};t(p,"render",p.prototype.adjustHeight)});H(b,"Extensions/ArrowSymbols.js",[b["Core/Renderer/SVG/SVGRenderer.js"]],function(b){function p(b,l,h,p){return[["M",b,l+p/2],["L",b+h,l],["L",b,l+p/2],["L",b+h,l+p]]}function v(b,l,h,p){return[["M",b+h,l],["L",b,l+p/2],["L",b+h,l+p],["Z"]]}function t(b,l,h,p){return v(b,l,h/2,p)}b=b.prototype.symbols;b.arrow=p;b["arrow-filled"]=v;b["arrow-filled-half"]=t;b["arrow-half"]=function(b,l,h,t){return p(b,l,h/2,t)};
b["triangle-left"]=v;b["triangle-left-half"]=t;return b});H(b,"Gantt/Connection.js",[b["Core/Globals.js"],b["Core/DefaultOptions.js"],b["Core/Series/Point.js"],b["Core/Utilities.js"]],function(b,p,v,t){function C(d){var e=d.shapeArgs;return e?{xMin:e.x||0,xMax:(e.x||0)+(e.width||0),yMin:e.y||0,yMax:(e.y||0)+(e.height||0)}:(e=d.graphic&&d.graphic.getBBox())?{xMin:d.plotX-e.width/2,xMax:d.plotX+e.width/2,yMin:d.plotY-e.height/2,yMax:d.plotY+e.height/2}:null}"";var l=t.defined,h=t.error,x=t.extend,d=
t.merge,r=t.objectEach,g=b.deg2rad,A=Math.max,B=Math.min;x(p.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});p=function(){function b(e,a,c){this.toPoint=this.pathfinder=this.graphics=this.fromPoint=this.chart=void 0;this.init(e,a,c)}b.prototype.init=function(e,a,c){this.fromPoint=e;this.toPoint=a;this.options=c;this.chart=e.series.chart;this.pathfinder=
this.chart.pathfinder};b.prototype.renderPath=function(e,a,c){var d=this.chart,b=d.styledMode,g=d.pathfinder,m=!d.options.chart.forExport&&!1!==c,h=this.graphics&&this.graphics.path;g.group||(g.group=d.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(d.seriesGroup));g.group.translate(d.plotLeft,d.plotTop);h&&h.renderer||(h=d.renderer.path().add(g.group),b||h.attr({opacity:0}));h.attr(a);e={d:e};b||(e.opacity=1);h[m?"animate":"attr"](e,c);this.graphics=this.graphics||{};this.graphics.path=
h};b.prototype.addMarker=function(e,a,c){var d=this.fromPoint.series.chart,b=d.pathfinder;d=d.renderer;var h="start"===e?this.fromPoint:this.toPoint,m=h.getPathfinderAnchorPoint(a);if(a.enabled&&((c="start"===e?c[1]:c[c.length-2])&&"M"===c[0]||"L"===c[0])){c={x:c[1],y:c[2]};c=h.getRadiansToVector(c,m);m=h.getMarkerVector(c,a.radius,m);c=-c/g;if(a.width&&a.height){var l=a.width;var A=a.height}else l=A=2*a.radius;this.graphics=this.graphics||{};m={x:m.x-l/2,y:m.y-A/2,width:l,height:A,rotation:c,rotationOriginX:m.x,
rotationOriginY:m.y};this.graphics[e]?this.graphics[e].animate(m):(this.graphics[e]=d.symbol(a.symbol).addClass("highcharts-point-connecting-path-"+e+"-marker").attr(m).add(b.group),d.styledMode||this.graphics[e].attr({fill:a.color||this.fromPoint.color,stroke:a.lineColor,"stroke-width":a.lineWidth,opacity:0}).animate({opacity:1},h.series.options.animation))}};b.prototype.getPath=function(e){var a=this.pathfinder,c=this.chart,b=a.algorithms[e.type],g=a.chartObstacles;if("function"!==typeof b)return h('"'+
e.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]};b.requiresObstacles&&!g&&(g=a.chartObstacles=a.getChartObstacles(e),c.options.connectors.algorithmMargin=e.algorithmMargin,a.chartObstacleMetrics=a.getObstacleMetrics(g));return b(this.fromPoint.getPathfinderAnchorPoint(e.startMarker),this.toPoint.getPathfinderAnchorPoint(e.endMarker),d({chartObstacles:g,lineObstacles:a.lineObstacles||[],obstacleMetrics:a.chartObstacleMetrics,hardBounds:{xMin:0,xMax:c.plotWidth,yMin:0,yMax:c.plotHeight},
obstacleOptions:{margin:e.algorithmMargin},startDirectionX:a.getAlgorithmStartDirection(e.startMarker)},e))};b.prototype.render=function(){var e=this.fromPoint,a=e.series,c=a.chart,b=c.pathfinder,g=d(c.options.connectors,a.options.connectors,e.options.connectors,this.options),h={};c.styledMode||(h.stroke=g.lineColor||e.color,h["stroke-width"]=g.lineWidth,g.dashStyle&&(h.dashstyle=g.dashStyle));h["class"]="highcharts-point-connecting-path highcharts-color-"+e.colorIndex;g=d(h,g);l(g.marker.radius)||
(g.marker.radius=B(A(Math.ceil((g.algorithmMargin||8)/2)-1,1),5));e=this.getPath(g);c=e.path;e.obstacles&&(b.lineObstacles=b.lineObstacles||[],b.lineObstacles=b.lineObstacles.concat(e.obstacles));this.renderPath(c,h,a.options.animation);this.addMarker("start",d(g.marker,g.startMarker),c);this.addMarker("end",d(g.marker,g.endMarker),c)};b.prototype.destroy=function(){this.graphics&&(r(this.graphics,function(e){e.destroy()}),delete this.graphics)};return b}();b.Connection=p;x(v.prototype,{getPathfinderAnchorPoint:function(d){var e=
C(this);switch(d.align){case "right":var a="xMax";break;case "left":a="xMin"}switch(d.verticalAlign){case "top":var c="yMin";break;case "bottom":c="yMax"}return{x:a?e[a]:(e.xMin+e.xMax)/2,y:c?e[c]:(e.yMin+e.yMax)/2}},getRadiansToVector:function(d,e){var a;l(e)||(a=C(this))&&(e={x:(a.xMin+a.xMax)/2,y:(a.yMin+a.yMax)/2});return Math.atan2(e.y-d.y,d.x-e.x)},getMarkerVector:function(d,e,a){var c=2*Math.PI,b=C(this),g=b.xMax-b.xMin,h=b.yMax-b.yMin,m=Math.atan2(h,g),l=!1;g/=2;var A=h/2,B=b.xMin+g;b=b.yMin+
A;for(var r=B,p=b,t=1,z=1;d<-Math.PI;)d+=c;for(;d>Math.PI;)d-=c;c=Math.tan(d);d>-m&&d<=m?(z=-1,l=!0):d>m&&d<=Math.PI-m?z=-1:d>Math.PI-m||d<=-(Math.PI-m)?(t=-1,l=!0):t=-1;l?(r+=t*g,p+=z*g*c):(r+=h/(2*c)*t,p+=z*A);a.x!==B&&(r=a.x);a.y!==b&&(p=a.y);return{x:r+e*Math.cos(d),y:p-e*Math.sin(d)}}});return p});H(b,"Gantt/PathfinderAlgorithms.js",[b["Core/Utilities.js"]],function(b){function p(d,b,h){h=h||0;var g=d.length-1;b-=1e-7;for(var e,a;h<=g;)if(e=g+h>>1,a=b-d[e].xMin,0<a)h=e+1;else if(0>a)g=e-1;else return e;
return 0<h?h-1:0}function v(d,b){for(var g=p(d,b.x+1)+1;g--;){var h;if(h=d[g].xMax>=b.x)h=d[g],h=b.x<=h.xMax&&b.x>=h.xMin&&b.y<=h.yMax&&b.y>=h.yMin;if(h)return g}return-1}function t(d){var b=[];if(d.length){b.push(["M",d[0].start.x,d[0].start.y]);for(var g=0;g<d.length;++g)b.push(["L",d[g].end.x,d[g].end.y])}return b}function C(d,b){d.yMin=x(d.yMin,b.yMin);d.yMax=h(d.yMax,b.yMax);d.xMin=x(d.xMin,b.xMin);d.xMax=h(d.xMax,b.xMax)}var l=b.pick,h=Math.min,x=Math.max,d=Math.abs;b=function(b,h,r){function g(a,
c,d,e,b){a={x:a.x,y:a.y};a[c]=d[e||c]+(b||0);return a}function e(a,c,e){var b=d(c[e]-a[e+"Min"])>d(c[e]-a[e+"Max"]);return g(c,e,a,e+(b?"Max":"Min"),b?1:-1)}var a=[],c=l(r.startDirectionX,d(h.x-b.x)>d(h.y-b.y))?"x":"y",u=r.chartObstacles,A=v(u,b);r=v(u,h);if(-1<r){var p=u[r];r=e(p,h,c);p={start:r,end:h};var m=r}else m=h;-1<A&&(u=u[A],r=e(u,b,c),a.push({start:b,end:r}),r[c]>=b[c]===r[c]>=m[c]&&(c="y"===c?"x":"y",h=b[c]<h[c],a.push({start:r,end:g(r,c,u,c+(h?"Max":"Min"),h?1:-1)}),c="y"===c?"x":"y"));
b=a.length?a[a.length-1].end:b;r=g(b,c,m);a.push({start:b,end:r});c=g(r,"y"===c?"x":"y",m);a.push({start:r,end:c});a.push(p);return{path:t(a),obstacles:a}};b.requiresObstacles=!0;var r=function(b,r,B){function g(a,c,f){var k,d=a.x<c.x?1:-1;if(a.x<c.x){var e=a;var b=c}else e=c,b=a;if(a.y<c.y){var n=a;var q=c}else n=c,q=a;for(k=0>d?h(p(I,b.x),I.length-1):0;I[k]&&(0<d&&I[k].xMin<=b.x||0>d&&I[k].xMax>=e.x);){if(I[k].xMin<=b.x&&I[k].xMax>=e.x&&I[k].yMin<=q.y&&I[k].yMax>=n.y)return f?{y:a.y,x:a.x<c.x?I[k].xMin-
1:I[k].xMax+1,obstacle:I[k]}:{x:a.x,y:a.y<c.y?I[k].yMin-1:I[k].yMax+1,obstacle:I[k]};k+=d}return c}function e(a,c,f,k,b){var e=b.soft,n=b.hard,q=k?"x":"y",w={x:c.x,y:c.y},m={x:c.x,y:c.y};b=a[q+"Max"]>=e[q+"Max"];e=a[q+"Min"]<=e[q+"Min"];var h=a[q+"Max"]>=n[q+"Max"];n=a[q+"Min"]<=n[q+"Min"];var y=d(a[q+"Min"]-c[q]),u=d(a[q+"Max"]-c[q]);f=10>d(y-u)?c[q]<f[q]:u<y;m[q]=a[q+"Min"];w[q]=a[q+"Max"];a=g(c,m,k)[q]!==m[q];c=g(c,w,k)[q]!==w[q];f=a?c?f:!0:c?!1:f;f=e?b?f:!0:b?!1:f;return n?h?f:!0:h?!1:f}function a(c,
d,f){if(c.x===d.x&&c.y===d.y)return[];var k=f?"x":"y",b=B.obstacleOptions.margin;var n={soft:{xMin:Q,xMax:M,yMin:F,yMax:K},hard:B.hardBounds};var q=v(I,c);if(-1<q){q=I[q];n=e(q,c,d,f,n);C(q,B.hardBounds);var y=f?{y:c.y,x:q[n?"xMax":"xMin"]+(n?1:-1)}:{x:c.x,y:q[n?"yMax":"yMin"]+(n?1:-1)};var u=v(I,y);-1<u&&(u=I[u],C(u,B.hardBounds),y[k]=n?x(q[k+"Max"]-b+1,(u[k+"Min"]+q[k+"Max"])/2):h(q[k+"Min"]+b-1,(u[k+"Max"]+q[k+"Min"])/2),c.x===y.x&&c.y===y.y?(m&&(y[k]=n?x(q[k+"Max"],u[k+"Max"])+1:h(q[k+"Min"],
u[k+"Min"])-1),m=!m):m=!1);c=[{start:c,end:y}]}else k=g(c,{x:f?d.x:c.x,y:f?c.y:d.y},f),c=[{start:c,end:{x:k.x,y:k.y}}],k[f?"x":"y"]!==d[f?"x":"y"]&&(n=e(k.obstacle,k,d,!f,n),C(k.obstacle,B.hardBounds),n={x:f?k.x:k.obstacle[n?"xMax":"xMin"]+(n?1:-1),y:f?k.obstacle[n?"yMax":"yMin"]+(n?1:-1):k.y},f=!f,c=c.concat(a({x:k.x,y:k.y},n,f)));return c=c.concat(a(c[c.length-1].end,d,!f))}function c(a,c,f){var k=h(a.xMax-c.x,c.x-a.xMin)<h(a.yMax-c.y,c.y-a.yMin);f=e(a,c,f,k,{soft:B.hardBounds,hard:B.hardBounds});
return k?{y:c.y,x:a[f?"xMax":"xMin"]+(f?1:-1)}:{x:c.x,y:a[f?"yMax":"yMin"]+(f?1:-1)}}var u=l(B.startDirectionX,d(r.x-b.x)>d(r.y-b.y)),A=u?"x":"y",G=[],m=!1,D=B.obstacleMetrics,Q=h(b.x,r.x)-D.maxWidth-10,M=x(b.x,r.x)+D.maxWidth+10,F=h(b.y,r.y)-D.maxHeight-10,K=x(b.y,r.y)+D.maxHeight+10,I=B.chartObstacles;var z=p(I,Q);D=p(I,M);I=I.slice(z,D+1);if(-1<(D=v(I,r))){var n=c(I[D],r,b);G.push({end:r,start:n});r=n}for(;-1<(D=v(I,r));)z=0>r[A]-b[A],n={x:r.x,y:r.y},n[A]=I[D][z?A+"Max":A+"Min"]+(z?1:-1),G.push({end:r,
start:n}),r=n;b=a(b,r,u);b=b.concat(G.reverse());return{path:t(b),obstacles:b}};r.requiresObstacles=!0;return{fastAvoid:r,straight:function(d,b){return{path:[["M",d.x,d.y],["L",b.x,b.y]],obstacles:[{start:d,end:b}]}},simpleConnect:b}});H(b,"Gantt/Pathfinder.js",[b["Gantt/Connection.js"],b["Core/Chart/Chart.js"],b["Core/Globals.js"],b["Core/DefaultOptions.js"],b["Core/Series/Point.js"],b["Core/Utilities.js"],b["Gantt/PathfinderAlgorithms.js"]],function(b,p,v,t,C,l,h){function x(a){var c=a.shapeArgs;
return c?{xMin:c.x||0,xMax:(c.x||0)+(c.width||0),yMin:c.y||0,yMax:(c.y||0)+(c.height||0)}:(c=a.graphic&&a.graphic.getBBox())?{xMin:a.plotX-c.width/2,xMax:a.plotX+c.width/2,yMin:a.plotY-c.height/2,yMax:a.plotY+c.height/2}:null}function d(c){for(var d=c.length,b=0,e,g,m=[],h=function(c,d,b){b=a(b,10);var e=c.yMax+b>d.yMin-b&&c.yMin-b<d.yMax+b,f=c.xMax+b>d.xMin-b&&c.xMin-b<d.xMax+b,k=e?c.xMin>d.xMax?c.xMin-d.xMax:d.xMin-c.xMax:Infinity,n=f?c.yMin>d.yMax?c.yMin-d.yMax:d.yMin-c.yMax:Infinity;return f&&
e?b?h(c,d,Math.floor(b/2)):Infinity:E(k,n)};b<d;++b)for(e=b+1;e<d;++e)g=h(c[b],c[e]),80>g&&m.push(g);m.push(80);return u(Math.floor(m.sort(function(a,c){return a-c})[Math.floor(m.length/10)]/2-1),1)}function r(a){if(a.options.pathfinder||a.series.reduce(function(a,c){c.options&&e(!0,c.options.connectors=c.options.connectors||{},c.options.pathfinder);return a||c.options&&c.options.pathfinder},!1))e(!0,a.options.connectors=a.options.connectors||{},a.options.pathfinder),B('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')}
"";var g=l.addEvent,A=l.defined,B=l.error,L=l.extend,e=l.merge,a=l.pick,c=l.splat,u=Math.max,E=Math.min;L(t.defaultOptions,{connectors:{type:"straight",lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}});var G=function(){function e(a){this.lineObstacles=this.group=this.connections=this.chartObstacleMetrics=this.chartObstacles=this.chart=void 0;this.init(a)}e.prototype.init=function(a){this.chart=
a;this.connections=[];g(a,"redraw",function(){this.pathfinder.update()})};e.prototype.update=function(a){var d=this.chart,e=this,g=e.connections;e.connections=[];d.series.forEach(function(a){a.visible&&!a.options.isInternal&&a.points.forEach(function(f){var a=f.options;a&&a.dependency&&(a.connect=a.dependency);var n;a=f.options&&f.options.connect&&c(f.options.connect);f.visible&&!1!==f.isInside&&a&&a.forEach(function(a){n=d.get("string"===typeof a?a:a.to);n instanceof C&&n.series.visible&&n.visible&&
!1!==n.isInside&&e.connections.push(new b(f,n,"string"===typeof a?{}:a))})})});for(var m=0,h=void 0,u=void 0,n=g.length,y=e.connections.length;m<n;++m){u=!1;for(h=0;h<y;++h)if(g[m].fromPoint===e.connections[h].fromPoint&&g[m].toPoint===e.connections[h].toPoint){e.connections[h].graphics=g[m].graphics;u=!0;break}u||g[m].destroy()}delete this.chartObstacles;delete this.lineObstacles;e.renderConnections(a)};e.prototype.renderConnections=function(a){a?this.chart.series.forEach(function(a){var c=function(){var c=
a.chart.pathfinder;(c&&c.connections||[]).forEach(function(c){c.fromPoint&&c.fromPoint.series===a&&c.render()});a.pathfinderRemoveRenderEvent&&(a.pathfinderRemoveRenderEvent(),delete a.pathfinderRemoveRenderEvent)};!1===a.options.animation?c():a.pathfinderRemoveRenderEvent=g(a,"afterAnimate",c)}):this.connections.forEach(function(a){a.render()})};e.prototype.getChartObstacles=function(c){for(var b=[],e=this.chart.series,g=a(c.algorithmMargin,0),m,h=0,u=e.length;h<u;++h)if(e[h].visible&&!e[h].options.isInternal){var n=
0,y=e[h].points.length,q=void 0;for(q=void 0;n<y;++n)q=e[h].points[n],q.visible&&(q=x(q))&&b.push({xMin:q.xMin-g,xMax:q.xMax+g,yMin:q.yMin-g,yMax:q.yMax+g})}b=b.sort(function(f,a){return f.xMin-a.xMin});A(c.algorithmMargin)||(m=c.algorithmMargin=d(b),b.forEach(function(f){f.xMin-=m;f.xMax+=m;f.yMin-=m;f.yMax+=m}));return b};e.prototype.getObstacleMetrics=function(a){for(var c=0,d=0,b,e,g=a.length;g--;)b=a[g].xMax-a[g].xMin,e=a[g].yMax-a[g].yMin,c<b&&(c=b),d<e&&(d=e);return{maxHeight:d,maxWidth:c}};
e.prototype.getAlgorithmStartDirection=function(a){var c="top"!==a.verticalAlign&&"bottom"!==a.verticalAlign;return"left"!==a.align&&"right"!==a.align?c?void 0:!1:c?!0:void 0};return e}();G.prototype.algorithms=h;v.Pathfinder=G;L(C.prototype,{getPathfinderAnchorPoint:function(a){var c=x(this);switch(a.align){case "right":var d="xMax";break;case "left":d="xMin"}switch(a.verticalAlign){case "top":var b="yMin";break;case "bottom":b="yMax"}return{x:d?c[d]:(c.xMin+c.xMax)/2,y:b?c[b]:(c.yMin+c.yMax)/2}},
getRadiansToVector:function(a,c){var d;A(c)||(d=x(this))&&(c={x:(d.xMin+d.xMax)/2,y:(d.yMin+d.yMax)/2});return Math.atan2(c.y-a.y,a.x-c.x)},getMarkerVector:function(a,c,d){var b=2*Math.PI,e=x(this),g=e.xMax-e.xMin,m=e.yMax-e.yMin,h=Math.atan2(m,g),n=!1;g/=2;var u=m/2,q=e.xMin+g;e=e.yMin+u;for(var f=q,k=e,w=1,J=1;a<-Math.PI;)a+=b;for(;a>Math.PI;)a-=b;b=Math.tan(a);a>-h&&a<=h?(J=-1,n=!0):a>h&&a<=Math.PI-h?J=-1:a>Math.PI-h||a<=-(Math.PI-h)?(w=-1,n=!0):w=-1;n?(f+=w*g,k+=J*g*b):(f+=m/(2*b)*w,k+=J*u);d.x!==
q&&(f=d.x);d.y!==e&&(k=d.y);return{x:f+c*Math.cos(a),y:k-c*Math.sin(a)}}});p.prototype.callbacks.push(function(a){!1!==a.options.connectors.enabled&&(r(a),this.pathfinder=new G(this),this.pathfinder.update(!0))});return G});H(b,"Series/Gantt/GanttSeries.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Series/Gantt/GanttPoint.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Axis/Tick.js"],b["Core/Utilities.js"],b["Core/Axis/TreeGridAxis.js"]],function(b,p,v,t,C,l,h){var x=this&&this.__extends||
function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var c in d)d.hasOwnProperty(c)&&(a[c]=d[c])};return d(b,a)};return function(b,a){function c(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),d=t.series,r=t.seriesTypes.xrange,g=l.extend,A=l.isNumber,B=l.merge;h.compose(b,p,d,C);b=function(d){function b(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;
a.options=void 0;a.points=void 0;return a}x(b,d);b.prototype.drawPoint=function(a,c){var d=this.options,b=this.chart.renderer,e=a.shapeArgs,g=a.plotY,h=a.graphic,l=a.selected&&"select",p=d.stacking&&!d.borderRadius;if(a.options.milestone)if(A(g)&&null!==a.y&&!1!==a.visible){e=b.symbols.diamond(e.x||0,e.y||0,e.width||0,e.height||0);if(h)h[c]({d:e});else a.graphic=b.path(e).addClass(a.getClassName(),!0).add(a.group||this.group);this.chart.styledMode||a.graphic.attr(this.pointAttribs(a,l)).shadow(d.shadow,
null,p)}else h&&(a.graphic=h.destroy());else r.prototype.drawPoint.call(this,a,c)};b.prototype.translatePoint=function(a){r.prototype.translatePoint.call(this,a);if(a.options.milestone){var c=a.shapeArgs;var d=c.height||0;a.shapeArgs={x:(c.x||0)-d/2,y:c.y,width:d,height:d}}};b.defaultOptions=B(r.defaultOptions,{grouping:!1,dataLabels:{enabled:!0},tooltip:{headerFormat:'<span style="font-size: 10px">{series.name}</span><br/>',pointFormat:null,pointFormatter:function(){var a=this.series,c=a.xAxis,d=
a.tooltipOptions.dateTimeLabelFormats,b=c.options.startOfWeek,e=a.tooltipOptions,g=e.xDateFormat,h=this.options.milestone,l="<b>"+(this.name||this.yCategory)+"</b>";if(e.pointFormat)return this.tooltipFormatter(e.pointFormat);!g&&A(this.start)&&(g=a.chart.time.getDateFormat(c.closestPointRange,this.start,b,d||{}));c=a.chart.time.dateFormat(g,this.start);a=a.chart.time.dateFormat(g,this.end);l+="<br/>";return h?l+(c+"<br/>"):l+("Start: "+c+"<br/>End: ")+(a+"<br/>")}},connectors:{type:"simpleConnect",
animation:{reversed:!0},startMarker:{enabled:!0,symbol:"arrow-filled",radius:4,fill:"#fa0",align:"left"},endMarker:{enabled:!1,align:"right"}}});return b}(r);g(b.prototype,{pointArrayMap:["start","end","y"],pointClass:v,setData:d.prototype.setData});t.registerSeriesType("gantt",b);"";return b});H(b,"Core/Chart/GanttChart.js",[b["Core/Chart/Chart.js"],b["Core/DefaultOptions.js"],b["Core/Utilities.js"]],function(b,p,v){var t=this&&this.__extends||function(){var d=function(b,g){d=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var g in b)b.hasOwnProperty(g)&&(d[g]=b[g])};return d(b,g)};return function(b,g){function h(){this.constructor=b}d(b,g);b.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}(),C=p.getOptions,l=v.isArray,h=v.merge,x=v.splat;b=function(b){function d(){return null!==b&&b.apply(this,arguments)||this}t(d,b);d.prototype.init=function(d,r){var g=C(),p=d.xAxis,e=d.yAxis,a;d.xAxis=d.yAxis=void 0;var c=h(!0,{chart:{type:"gantt"},
title:{text:null},legend:{enabled:!1},navigator:{series:{type:"gantt"},yAxis:{type:"category"}}},d,{isGantt:!0});d.xAxis=p;d.yAxis=e;c.xAxis=(l(d.xAxis)?d.xAxis:[d.xAxis||{},{}]).map(function(c,d){1===d&&(a=0);return h(g.xAxis,{grid:{enabled:!0},opposite:!0,linkedTo:a},c,{type:"datetime"})});c.yAxis=x(d.yAxis||{}).map(function(a){return h(g.yAxis,{grid:{enabled:!0},staticScale:50,reversed:!0,type:a.categories?a.type:"treegrid"},a)});b.prototype.init.call(this,c,r)};return d}(b);(function(d){d.ganttChart=
function(b,g,h){return new d(b,g,h)}})(b||(b={}));return b});H(b,"Core/Axis/ScrollbarAxis.js",[b["Core/Utilities.js"]],function(b){var p=b.addEvent,v=b.defined,t=b.pick;return function(){function b(){}b.compose=function(l,h){if(-1===b.composed.indexOf(l))b.composed.push(l);else return l;var x=function(b){var d=t(b.options&&b.options.min,b.min),g=t(b.options&&b.options.max,b.max);return{axisMin:d,axisMax:g,scrollMin:v(b.dataMin)?Math.min(d,b.min,b.dataMin,t(b.threshold,Infinity)):d,scrollMax:v(b.dataMax)?
Math.max(g,b.max,b.dataMax,t(b.threshold,-Infinity)):g}};p(l,"afterInit",function(){var b=this;b.options&&b.options.scrollbar&&b.options.scrollbar.enabled&&(b.options.scrollbar.vertical=!b.horiz,b.options.startOnTick=b.options.endOnTick=!1,b.scrollbar=new h(b.chart.renderer,b.options.scrollbar,b.chart),p(b.scrollbar,"changed",function(d){var g=x(b),h=g.axisMax,l=g.scrollMin,r=g.scrollMax-l;v(g.axisMin)&&v(h)&&(b.horiz&&!b.reversed||!b.horiz&&b.reversed?(g=l+r*this.to,l+=r*this.from):(g=l+r*(1-this.from),
l+=r*(1-this.to)),this.shouldUpdateExtremes(d.DOMType)?b.setExtremes(l,g,!0,"mousemove"!==d.DOMType&&"touchmove"!==d.DOMType,d):this.setRange(this.from,this.to))}))});p(l,"afterRender",function(){var b=x(this),h=b.scrollMin,g=b.scrollMax;b=this.scrollbar;var l=this.axisTitleMargin+(this.titleOffset||0),p=this.chart.scrollbarsOffsets,t=this.options.margin||0;b&&(this.horiz?(this.opposite||(p[1]+=l),b.position(this.left,this.top+this.height+2+p[1]-(this.opposite?t:0),this.width,this.height),this.opposite||
(p[1]+=t),l=1):(this.opposite&&(p[0]+=l),b.position(b.options.opposite?this.left+this.width+2+p[0]-(this.opposite?0:t):this.opposite?0:t,this.top,this.width,this.height),this.opposite&&(p[0]+=t),l=0),p[l]+=b.size+b.options.margin,isNaN(h)||isNaN(g)||!v(this.min)||!v(this.max)||this.min===this.max?b.setRange(0,1):(p=(this.min-h)/(g-h),h=(this.max-h)/(g-h),this.horiz&&!this.reversed||!this.horiz&&this.reversed?b.setRange(p,h):b.setRange(1-h,1-p)))});p(l,"afterGetOffset",function(){var b=this.scrollbar&&
!this.scrollbar.options.opposite;b=this.horiz?2:b?3:1;var h=this.scrollbar;h&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[b]+=h.size+h.options.margin)});return l};b.composed=[];return b}()});H(b,"Core/ScrollbarDefaults.js",[b["Core/Globals.js"]],function(b){return{height:b.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",
buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",trackBorderColor:"#f2f2f2",trackBorderWidth:1}});H(b,"Core/Scrollbar.js",[b["Core/DefaultOptions.js"],b["Core/Globals.js"],b["Core/Axis/ScrollbarAxis.js"],b["Core/ScrollbarDefaults.js"],b["Core/Utilities.js"]],function(b,p,v,t,C){var l=b.defaultOptions,h=C.addEvent,x=C.correctFloat,d=C.defined,r=C.destroyObjectProperties,g=C.fireEvent,A=C.merge,B=C.pick,L=C.removeEvent;
b=function(){function b(a,c,b){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(a,c,b)}b.compose=function(a){v.compose(a,b)};b.swapXY=function(a,c){c&&a.forEach(function(a){for(var c=
a.length,b,d=0;d<c;d+=2)b=a[d+1],"number"===typeof b&&(a[d+1]=a[d+2],a[d+2]=b)});return a};b.prototype.addEvents=function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,b=this.scrollbarGroup.element,d=this.track.element,e=this.mouseDownHandler.bind(this),g=this.mouseMoveHandler.bind(this),l=this.mouseUpHandler.bind(this);a=[[c[a[0]].element,"click",this.buttonToMinClick.bind(this)],[c[a[1]].element,"click",this.buttonToMaxClick.bind(this)],[d,"click",this.trackClick.bind(this)],
[b,"mousedown",e],[b.ownerDocument,"mousemove",g],[b.ownerDocument,"mouseup",l]];p.hasTouch&&a.push([b,"touchstart",e],[b.ownerDocument,"touchmove",g],[b.ownerDocument,"touchend",l]);a.forEach(function(a){h.apply(null,a)});this._events=a};b.prototype.buttonToMaxClick=function(a){var c=(this.to-this.from)*B(this.options.step,.2);this.updatePosition(this.from+c,this.to+c);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.buttonToMinClick=function(a){var c=x(this.to-
this.from)*B(this.options.step,.2);this.updatePosition(x(this.from-c),x(this.to-c));g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.cursorToScrollbarPosition=function(a){var c=this.options;c=c.minWidth>this.calculatedWidth?c.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-c),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-c)}};b.prototype.destroy=function(){var a=this,c=a.chart.scroller;a.removeEvents();["track","scrollbarRifles",
"scrollbar","scrollbarGroup","group"].forEach(function(c){a[c]&&a[c].destroy&&(a[c]=a[c].destroy())});c&&a===c.scrollbar&&(c.scrollbar=null,r(c.scrollbarButtons))};b.prototype.drawScrollbarButton=function(a){var c=this.renderer,d=this.scrollbarButtons,e=this.options,g=this.size,h=c.g().add(this.group);d.push(h);h=c.rect().addClass("highcharts-scrollbar-button").add(h);this.chart.styledMode||h.attr({stroke:e.buttonBorderColor,"stroke-width":e.buttonBorderWidth,fill:e.buttonBackgroundColor});h.attr(h.crisp({x:-.5,
y:-.5,width:g+1,height:g+1,r:e.buttonBorderRadius},h.strokeWidth()));h=c.path(b.swapXY([["M",g/2+(a?-1:1),g/2-3],["L",g/2+(a?-1:1),g/2+3],["L",g/2+(a?2:-2),g/2]],e.vertical)).addClass("highcharts-scrollbar-arrow").add(d[a]);this.chart.styledMode||h.attr({fill:e.buttonArrowColor})};b.prototype.init=function(a,c,b){this.scrollbarButtons=[];this.renderer=a;this.userOptions=c;this.options=A(t,l.scrollbar,c);this.chart=b;this.size=B(this.options.size,this.options.height);c.enabled&&(this.render(),this.addEvents())};
b.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};b.prototype.mouseMoveHandler=function(a){var c=this.chart.pointer.normalize(a),b=this.options.vertical?"chartY":"chartX",d=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][b]||(c=this.cursorToScrollbarPosition(c)[b],b=this[b],b=c-b,this.hasDragged=!0,this.updatePosition(d[0]+
b,d[1]+b),this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a}))};b.prototype.mouseUpHandler=function(a){this.hasDragged&&g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};b.prototype.position=function(a,c,b,d){var e=this.options.vertical,g=this.rendered?"animate":"attr",h=d,l=0;this.group.show();this.x=a;this.y=c+this.trackBorderWidth;this.width=
b;this.height=d;this.xOffset=h;this.yOffset=l;e?(this.width=this.yOffset=b=l=this.size,this.xOffset=h=0,this.barWidth=d-2*b,this.x=a+=this.options.margin):(this.height=this.xOffset=d=h=this.size,this.barWidth=b-2*d,this.y+=this.options.margin);this.group[g]({translateX:a,translateY:this.y});this.track[g]({width:b,height:d});this.scrollbarButtons[1][g]({translateX:e?0:b-h,translateY:e?d-l:0})};b.prototype.removeEvents=function(){this._events.forEach(function(a){L.apply(null,a)});this._events.length=
0};b.prototype.render=function(){var a=this.renderer,c=this.options,d=this.size,e=this.chart.styledMode,g=a.g("scrollbar").attr({zIndex:c.zIndex}).hide().add();this.group=g;this.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:c.trackBorderRadius||0,height:d,width:d}).add(g);e||this.track.attr({fill:c.trackBackgroundColor,stroke:c.trackBorderColor,"stroke-width":c.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=
a.g().add(g);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:d,width:d,r:c.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=a.path(b.swapXY([["M",-3,d/4],["L",-3,2*d/3],["M",0,d/4],["L",0,2*d/3],["M",3,d/4],["L",3,2*d/3]],c.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);e||(this.scrollbar.attr({fill:c.barBackgroundColor,stroke:c.barBorderColor,"stroke-width":c.barBorderWidth}),this.scrollbarRifles.attr({stroke:c.rifleColor,
"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};b.prototype.setRange=function(a,c){var b=this.options,e=b.vertical,g=b.minWidth,h=this.barWidth,l=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(d(h)){var r=h*Math.min(c,1);a=Math.max(a,0);var p=Math.ceil(h*a);this.calculatedWidth=
r=x(r-p);r<g&&(p=(h-g+r)*a,r=g);g=Math.floor(p+this.xOffset+this.yOffset);h=r/2-.5;this.from=a;this.to=c;e?(this.scrollbarGroup[l]({translateY:g}),this.scrollbar[l]({height:r}),this.scrollbarRifles[l]({translateY:h}),this.scrollbarTop=g,this.scrollbarLeft=0):(this.scrollbarGroup[l]({translateX:g}),this.scrollbar[l]({width:r}),this.scrollbarRifles[l]({translateX:h}),this.scrollbarLeft=g,this.scrollbarTop=0);12>=r?this.scrollbarRifles.hide():this.scrollbarRifles.show();!1===b.showFull&&(0>=a&&1<=c?
this.group.hide():this.group.show());this.rendered=!0}};b.prototype.shouldUpdateExtremes=function(a){return B(this.options.liveRedraw,p.svg&&!p.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===a||"touchend"===a||!d(a)};b.prototype.trackClick=function(a){var c=this.chart.pointer.normalize(a),b=this.to-this.from,d=this.y+this.scrollbarTop,e=this.x+this.scrollbarLeft;this.options.vertical&&c.chartY>d||!this.options.vertical&&c.chartX>e?this.updatePosition(this.from+b,this.to+b):this.updatePosition(this.from-
b,this.to-b);g(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};b.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,A(!0,this.options,a),this.chart)};b.prototype.updatePosition=function(a,c){1<c&&(a=x(1-x(c-a)),c=1);0>a&&(c=x(c-a),a=0);this.from=a;this.to=c};b.defaultOptions=t;return b}();l.scrollbar=A(!0,b.defaultOptions,l.scrollbar);return b});H(b,"Extensions/RangeSelector.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Globals.js"],
b["Core/DefaultOptions.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Utilities.js"]],function(b,p,v,t,C,l){function h(a){if(-1!==a.indexOf("%L"))return"text";var c="aAdewbBmoyY".split("").some(function(c){return-1!==a.indexOf("%"+c)}),b="HkIlMS".split("").some(function(c){return-1!==a.indexOf("%"+c)});return c&&b?"datetime-local":c?"date":b?"time":"text"}var x=t.defaultOptions,d=l.addEvent,r=l.createElement,g=l.css,A=l.defined,B=l.destroyObjectProperties,L=l.discardElement,e=l.extend,a=l.find,
c=l.fireEvent,u=l.isNumber,E=l.merge,G=l.objectEach,m=l.pad,D=l.pick,H=l.pInt,M=l.splat;e(x,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},
inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#335cad",cursor:"pointer"},labelStyle:{color:"#666666"}}});e(x.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var F=function(){function a(c){this.buttons=void 0;this.buttonOptions=a.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=c;this.init(c)}a.prototype.clickButton=function(a,e){var n=this.chart,f=this.buttonOptions[a],k=n.xAxis[0],g=n.scroller&&
n.scroller.getUnionExtremes()||k||{},h=g.dataMin,m=g.dataMax,l=k&&Math.round(Math.min(k.max,D(m,k.max))),y=f.type;g=f._range;var r,p=f.dataGrouping;if(null!==h&&null!==m){n.fixedRange=g;this.setSelected(a);p&&(this.forcedDataGrouping=!0,b.prototype.setDataGrouping.call(k||{chart:this.chart},p,!1),this.frozenStates=f.preserveDataGrouping);if("month"===y||"year"===y)if(k){y={range:f,max:l,chart:n,dataMin:h,dataMax:m};var t=k.minFromRange.call(y);u(y.newMax)&&(l=y.newMax)}else g=f;else if(g)t=Math.max(l-
g,h),l=Math.min(t+g,m);else if("ytd"===y)if(k)"undefined"===typeof m&&(h=Number.MAX_VALUE,m=Number.MIN_VALUE,n.series.forEach(function(a){a=a.xData;h=Math.min(a[0],h);m=Math.max(a[a.length-1],m)}),e=!1),l=this.getYTDExtremes(m,h,n.time.useUTC),t=r=l.min,l=l.max;else{this.deferredYTDClick=a;return}else"all"===y&&k&&(n.navigator&&n.navigator.baseSeries[0]&&(n.navigator.baseSeries[0].xAxis.options.range=void 0),t=h,l=m);A(t)&&(t+=f._offsetMin);A(l)&&(l+=f._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=
a+1);if(k)k.setExtremes(t,l,D(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var z=M(n.options.xAxis)[0];var v=z.range;z.range=g;var x=z.min;z.min=r;d(n,"load",function(){z.range=v;z.min=x})}c(this,"afterBtnClick")}};a.prototype.setSelected=function(a){this.selected=this.options.selected=a};a.prototype.init=function(a){var b=this,e=a.options.rangeSelector,f=e.buttons||b.defaultButtons.slice(),k=e.selected,n=function(){var a=b.minInput,f=b.maxInput;a&&a.blur&&c(a,"blur");
f&&f.blur&&c(f,"blur")};b.chart=a;b.options=e;b.buttons=[];b.buttonOptions=f;this.eventsToUnbind=[];this.eventsToUnbind.push(d(a.container,"mousedown",n));this.eventsToUnbind.push(d(a,"resize",n));f.forEach(b.computeButtonRange);"undefined"!==typeof k&&f[k]&&this.clickButton(k,!1);this.eventsToUnbind.push(d(a,"load",function(){a.xAxis&&a.xAxis[0]&&d(a.xAxis[0],"setExtremes",function(f){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==f.trigger&&"updatedData"!==f.trigger&&b.forcedDataGrouping&&
!b.frozenStates&&this.setDataGrouping(!1,!1)})}))};a.prototype.updateButtonStates=function(){var a=this,b=this.chart,c=this.dropdown,f=b.xAxis[0],k=Math.round(f.max-f.min),d=!f.hasVisibleSeries,e=b.scroller&&b.scroller.getUnionExtremes()||f,g=e.dataMin,h=e.dataMax;b=a.getYTDExtremes(h,g,b.time.useUTC);var m=b.min,l=b.max,r=a.selected,p=u(r),t=a.options.allButtonsEnabled,z=a.buttons;a.buttonOptions.forEach(function(b,e){var n=b._range,q=b.type,w=b.count||1,y=z[e],J=0,P=b._offsetMax-b._offsetMin;b=
e===r;var u=n>h-g,O=n<f.minRange,N=!1,R=!1;n=n===k;("month"===q||"year"===q)&&k+36E5>=864E5*{month:28,year:365}[q]*w-P&&k-36E5<=864E5*{month:31,year:366}[q]*w+P?n=!0:"ytd"===q?(n=l-m+P===k,N=!b):"all"===q&&(n=f.max-f.min>=h-g,R=!b&&p&&n);q=!t&&(u||O||R||d);w=b&&n||n&&!p&&!N||b&&a.frozenStates;q?J=3:w&&(p=!0,J=2);y.state!==J&&(y.setState(J),c&&(c.options[e+1].disabled=q,2===J&&(c.selectedIndex=e+1)),0===J&&r===e&&a.setSelected())})};a.prototype.computeButtonRange=function(a){var b=a.type,c=a.count||
1,f={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(f[b])a._range=f[b]*c;else if("month"===b||"year"===b)a._range=864E5*{month:30,year:365}[b]*c;a._offsetMin=D(a.offsetMin,0);a._offsetMax=D(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};a.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,c=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,c.useUTC,c):0};a.prototype.setInputValue=
function(a,b){var c=this.options,f=this.chart.time,k="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:this.maxDateBox;if(k){var d=k.getAttribute("data-hc-time");d=A(d)?Number(d):void 0;A(b)&&(A(d)&&k.setAttribute("data-hc-time-previous",d),k.setAttribute("data-hc-time",b),d=b);k.value=f.dateFormat(this.inputTypeFormats[k.type]||c.inputEditDateFormat,d);a&&a.attr({text:f.dateFormat(c.inputDateFormat,d)})}};a.prototype.setInputExtremes=function(a,b,c){if(a="min"===a?this.minInput:this.maxInput){var f=
this.inputTypeFormats[a.type],k=this.chart.time;f&&(b=k.dateFormat(f,b),a.min!==b&&(a.min=b),c=k.dateFormat(f,c),a.max!==c&&(a.max=c))}};a.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var c="text"===a.type,f=this.inputGroup,k=f.translateX;f=f.translateY;var d=this.options.inputBoxWidth;g(a,{width:c?b.width+(d?-2:20)+"px":"auto",height:c?b.height-2+"px":"auto",border:"2px solid silver"});c&&d?g(a,{left:k+
b.x+"px",top:f+"px"}):g(a,{left:Math.min(Math.round(b.x+k-(a.offsetWidth-b.width)/2),this.chart.chartWidth-a.offsetWidth)+"px",top:f-(a.offsetHeight-b.height)/2+"px"})}};a.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&g(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};a.prototype.defaultInputDateParser=function(a,b,c){var f=a.split("/").join("-").split(" ").join("T");-1===f.indexOf("T")&&(f+="T00:00");if(b)f+="Z";else{var k;if(k=v.isSafari)k=f,k=!(6<k.length&&(k.lastIndexOf("-")===
k.length-6||k.lastIndexOf("+")===k.length-6));k&&(k=(new Date(f)).getTimezoneOffset()/60,f+=0>=k?"+"+m(-k)+":00":"-"+m(k)+":00")}f=Date.parse(f);u(f)||(a=a.split("-"),f=Date.UTC(H(a[0]),H(a[1])-1,H(a[2])));c&&b&&u(f)&&(f+=c.getTimezoneOffset(f));return f};a.prototype.drawInput=function(a){function b(){var b=d.getInputValue(a),f=c.xAxis[0],k=c.scroller&&c.scroller.xAxis?c.scroller.xAxis:f,e=k.dataMin;k=k.dataMax;var g=d.maxInput,h=d.minInput;b!==Number(t.getAttribute("data-hc-time-previous"))&&u(b)&&
(t.setAttribute("data-hc-time-previous",b),p&&g&&u(e)?b>Number(g.getAttribute("data-hc-time"))?b=void 0:b<e&&(b=e):h&&u(k)&&(b<Number(h.getAttribute("data-hc-time"))?b=void 0:b>k&&(b=k)),"undefined"!==typeof b&&f.setExtremes(p?b:f.min,p?f.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var c=this.chart,f=this.div,k=this.inputGroup,d=this,n=c.renderer.style||{},m=c.renderer,l=c.options.rangeSelector,p="min"===a,P=x.lang[p?"rangeSelectorFrom":"rangeSelectorTo"]||"";P=m.label(P,0).addClass("highcharts-range-label").attr({padding:P?
2:0,height:P?l.inputBoxHeight:0}).add(k);m=m.label("",0).addClass("highcharts-range-input").attr({padding:2,width:l.inputBoxWidth,height:l.inputBoxHeight,"text-align":"center"}).on("click",function(){d.showInput(a);d[a+"Input"].focus()});c.styledMode||m.attr({stroke:l.inputBoxBorderColor,"stroke-width":1});m.add(k);var t=r("input",{name:a,className:"highcharts-range-selector"},void 0,f);t.setAttribute("type",h(l.inputDateFormat||"%b %e, %Y"));c.styledMode||(P.css(E(n,l.labelStyle)),m.css(E({color:"#333333"},
n,l.inputStyle)),g(t,e({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:n.fontSize,fontFamily:n.fontFamily,top:"-9999em"},l.inputStyle)));t.onfocus=function(){d.showInput(a)};t.onblur=function(){t===v.doc.activeElement&&b();d.hideInput(a);d.setInputValue(a);t.blur()};var z=!1;t.onchange=function(){z||(b(),d.hideInput(a),t.blur())};t.onkeypress=function(a){13===a.keyCode&&b()};t.onkeydown=function(a){z=!0;38!==a.keyCode&&
40!==a.keyCode||b()};t.onkeyup=function(){z=!1};return{dateBox:m,input:t,label:P}};a.prototype.getPosition=function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};a.prototype.getYTDExtremes=function(a,b,c){var f=this.chart.time,k=new f.Date(a),d=f.get("FullYear",k);c=c?f.Date.UTC(d,0,1):+new f.Date(d,0,1);b=Math.max(b,c);k=k.getTime();return{max:Math.min(a||k,k),min:b}};a.prototype.render=
function(a,b){var c=this.chart,f=c.renderer,k=c.container,d=c.options,e=d.rangeSelector,g=D(d.chart.style&&d.chart.style.zIndex,0)+1;d=e.inputEnabled;if(!1!==e.enabled){this.rendered||(this.group=f.g("range-selector-group").attr({zIndex:7}).add(),this.div=r("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),k.parentNode&&k.parentNode.insertBefore(this.div,k),d&&(this.inputGroup=f.g("input-group").add(this.group),f=this.drawInput("min"),this.minDateBox=
f.dateBox,this.minLabel=f.label,this.minInput=f.input,f=this.drawInput("max"),this.maxDateBox=f.dateBox,this.maxLabel=f.label,this.maxInput=f.input));if(d&&(this.setInputValue("min",a),this.setInputValue("max",b),a=c.scroller&&c.scroller.getUnionExtremes()||c.xAxis[0]||{},A(a.dataMin)&&A(a.dataMax)&&(c=c.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-c),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+c,a.dataMax)),
this.inputGroup)){var h=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=a.getBBox().width;b&&(a.attr({x:h}),h+=b+e.inputSpacing)}})}this.alignElements();this.rendered=!0}};a.prototype.renderButtons=function(){var a=this,b=this.buttons,e=this.options,f=x.lang,k=this.chart.renderer,g=E(e.buttonTheme),h=g&&g.states,m=g.width||28;delete g.width;delete g.states;this.buttonGroup=k.g("range-selector-buttons").add(this.group);var l=this.dropdown=r("select",
void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);d(l,"touchstart",function(){l.style.fontSize="16px"});[[v.isMS?"mouseover":"mouseenter"],[v.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(f){var k=f[0],e=f[1];d(l,k,function(){var f=b[a.currentButtonIndex()];f&&c(f.element,e||k)})});this.zoomText=k.label(f&&f.rangeSelectorZoom||"",0).attr({padding:e.buttonTheme.padding,height:e.buttonTheme.height,paddingLeft:0,
paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(e.labelStyle),g["stroke-width"]=D(g["stroke-width"],0));r("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,l);this.buttonOptions.forEach(function(c,f){r("option",{textContent:c.title||c.text},void 0,l);b[f]=k.button(c.text,0,0,function(b){var k=c.events&&c.events.click,d;k&&(d=k.call(c,b));!1!==d&&a.clickButton(f);a.isActive=!0},g,h&&h.hover,h&&h.select,h&&h.disabled).attr({"text-align":"center",width:m}).add(a.buttonGroup);
c.title&&b[f].attr("title",c.title)})};a.prototype.alignElements=function(){var a=this,b=this.buttonGroup,c=this.buttons,f=this.chart,k=this.group,d=this.inputGroup,e=this.options,g=this.zoomText,h=f.options,m=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions;h=e.buttonPosition;var l=e.inputPosition,r=e.verticalAlign,p=function(b,c){return m&&a.titleCollision(f)&&"top"===r&&"right"===c.align&&c.y-b.getBBox().height-12<(m.y||0)+(m.height||0)+f.spacing[0]?-40:0},t=f.plotLeft;
if(k&&h&&l){var u=h.x-f.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var z=0;g&&(z+=g.getBBox().width+5);c.forEach(function(a,b){z+=a.width;b!==c.length-1&&(z+=e.buttonSpacing)});this.initialButtonGroupWidth=z}t-=f.spacing[3];this.updateButtonStates();g=p(b,h);this.alignButtonGroup(g);k.placed=b.placed=f.hasLoaded}b=0;d&&(b=p(d,l),"left"===l.align?u=t:"right"===l.align&&(u=-Math.max(f.axisOffset[1],-b)),d.align({y:l.y,width:d.getBBox().width,align:l.align,x:l.x+u-2},!0,
f.spacingBox),d.placed=f.hasLoaded);this.handleCollision(b);k.align({verticalAlign:r},!0,f.spacingBox);d=k.alignAttr.translateY;b=k.getBBox().height+20;p=0;"bottom"===r&&(p=(p=f.legend&&f.legend.options)&&"bottom"===p.verticalAlign&&p.enabled&&!p.floating?f.legend.legendHeight+D(p.margin,10):0,b=b+p-20,p=d-b-(e.floating?0:e.y)-(f.titleOffset?f.titleOffset[2]:0)-10);if("top"===r)e.floating&&(p=0),f.titleOffset&&f.titleOffset[0]&&(p=f.titleOffset[0]),p+=f.margin[0]-f.spacing[0]||0;else if("middle"===
r)if(l.y===h.y)p=d;else if(l.y||h.y)p=0>l.y||0>h.y?p-Math.min(l.y,h.y):d-b;k.translate(e.x,e.y+Math.floor(p));h=this.minInput;l=this.maxInput;d=this.dropdown;e.inputEnabled&&h&&l&&(h.style.marginTop=k.translateY+"px",l.style.marginTop=k.translateY+"px");d&&(d.style.marginTop=k.translateY+"px")}};a.prototype.alignButtonGroup=function(a,b){var c=this.chart,f=this.buttonGroup,d=this.options.buttonPosition,e=c.plotLeft-c.spacing[3],g=d.x-c.spacing[3];"right"===d.align?g+=a-e:"center"===d.align&&(g-=e/
2);f&&f.align({y:d.y,width:D(b,this.initialButtonGroupWidth),align:d.align,x:g},!0,c.spacingBox)};a.prototype.positionButtons=function(){var a=this.buttons,b=this.chart,c=this.options,f=this.zoomText,d=b.hasLoaded?"animate":"attr",e=c.buttonPosition,g=b.plotLeft,h=g;f&&"hidden"!==f.visibility&&(f[d]({x:D(g+e.x,g)}),h+=e.x+f.getBBox().width+5);this.buttonOptions.forEach(function(b,f){if("hidden"!==a[f].visibility)a[f][d]({x:h}),h+=a[f].width+c.buttonSpacing;else a[f][d]({x:g})})};a.prototype.handleCollision=
function(a){var b=this,c=this.chart,f=this.buttonGroup,d=this.inputGroup,e=this.options,g=e.buttonPosition,h=e.dropdown,n=e.inputPosition;e=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var l=function(b){if(d&&f){var c=d.alignAttr.translateX+d.alignOptions.x-a+d.getBBox().x+2,k=d.alignOptions.width,e=f.alignAttr.translateX+f.getBBox().x;return e+b>c&&c+k>e&&g.y<n.y+d.getBBox().height}return!1},m=function(){d&&f&&d.attr({translateX:d.alignAttr.translateX+
(c.axisOffset[1]>=-a?0:-a),translateY:d.alignAttr.translateY+f.getBBox().height+10})};if(f){if("always"===h){this.collapseButtons(a);l(e())&&m();return}"never"===h&&this.expandButtons()}d&&f?n.align===g.align||l(this.initialButtonGroupWidth+20)?"responsive"===h?(this.collapseButtons(a),l(e())&&m()):m():"responsive"===h&&this.expandButtons():f&&"responsive"===h&&(this.initialButtonGroupWidth>c.plotWidth?this.collapseButtons(a):this.expandButtons())};a.prototype.collapseButtons=function(a){var b=this.buttons,
c=this.buttonOptions,f=this.chart,d=this.dropdown,e=this.options,g=this.zoomText,h=f.userOptions.rangeSelector&&f.userOptions.rangeSelector.buttonTheme||{},n=function(a){return{text:a?a+" \u25be":"\u25be",width:"auto",paddingLeft:D(e.buttonTheme.paddingLeft,h.padding,8),paddingRight:D(e.buttonTheme.paddingRight,h.padding,8)}};g&&g.hide();var l=!1;c.forEach(function(a,c){c=b[c];2!==c.state?c.hide():(c.show(),c.attr(n(a.text)),l=!0)});l||(d&&(d.selectedIndex=0),b[0].show(),b[0].attr(n(this.zoomText&&
this.zoomText.textStr)));c=e.buttonPosition.align;this.positionButtons();"right"!==c&&"center"!==c||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);this.showDropdown()};a.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,c=this.options,f=this.zoomText;this.hideDropdown();f&&f.show();b.forEach(function(b,f){f=a[f];f.show();f.attr({text:b.text,width:c.buttonTheme.width||28,paddingLeft:D(c.buttonTheme.paddingLeft,"unset"),paddingRight:D(c.buttonTheme.paddingRight,
"unset")});2>f.state&&f.setState(0)});this.positionButtons()};a.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-1:0};a.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,c=this.chart,f=this.dropdown;if(a&&f){var d=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();g(f,{left:c.plotLeft+d+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};a.prototype.hideDropdown=function(){var a=
this.dropdown;a&&(g(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};a.prototype.getHeight=function(){var a=this.options,b=this.group,c=a.y,f=a.buttonPosition.y,d=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+c:0;b=Math.min(d,f);if(0>d&&0>f||0<d&&0<f)a+=Math.abs(b);return a};a.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};a.prototype.update=function(a){var b=this.chart;E(!0,b.options.rangeSelector,
a);this.destroy();this.init(b);this.render()};a.prototype.destroy=function(){var b=this,c=b.minInput,d=b.maxInput;b.eventsToUnbind&&(b.eventsToUnbind.forEach(function(a){return a()}),b.eventsToUnbind=void 0);B(b.buttons);c&&(c.onfocus=c.onblur=c.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);G(b,function(c,d){c&&"chart"!==d&&(c instanceof C?c.destroy():c instanceof window.HTMLElement&&L(c));c!==a.prototype[d]&&(b[d]=null)},this)};return a}();F.prototype.defaultButtons=[{type:"month",count:1,
text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];F.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};b.prototype.minFromRange=function(){var a=this.range,b=a.type,c=this.max,d=this.chart.time,f=function(a,c){var f="year"===
b?"FullYear":"Month",e=new d.Date(a),k=d.get(f,e);d.set(f,e,k+c);k===d.get(f,e)&&d.set("Date",e,0);return e.getTime()-a};if(u(a)){var e=c-a;var g=a}else e=c+f(c,-a.count),this.chart&&(this.chart.fixedRange=c-e);var h=D(this.dataMin,Number.MIN_VALUE);u(e)||(e=h);e<=h&&(e=h,"undefined"===typeof g&&(g=f(e,a.count)),this.newMax=Math.min(e+g,this.dataMax));u(c)||(e=void 0);return e};if(!v.RangeSelector){var K=[],I=function(b){function c(){g&&(e=b.xAxis[0].getExtremes(),f=b.legend,h=g&&g.options.verticalAlign,
u(e.min)&&g.render(e.min,e.max),f.display&&"top"===h&&h===f.options.verticalAlign&&(k=E(b.spacingBox),k.y="vertical"===f.options.layout?b.plotTop:k.y+g.getHeight(),f.group.placed=!1,f.align(k)))}var e,g=b.rangeSelector,f,k,h;g&&(a(K,function(a){return a[0]===b})||K.push([b,[d(b.xAxis[0],"afterSetExtremes",function(a){g&&g.render(a.min,a.max)}),d(b,"redraw",c)]]),c())};d(p,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new F(this))});
d(p,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(u(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))});d(p,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var c=this.extraBottomMargin,d=this.extraTopMargin;b&&
b.enabled&&!A(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new F(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(I(this),b=b&&b.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==c||this.extraTopMargin!==d)&&(this.isDirtyBox=!0)});d(p,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,
"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});d(p,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))});p.prototype.callbacks.push(I);d(p,"destroy",function(){for(var a=0;a<K.length;a++){var b=K[a];if(b[0]===this){b[1].forEach(function(a){return a()});K.splice(a,1);break}}});v.RangeSelector=F}return F});H(b,"Core/Axis/NavigatorAxis.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],
function(b,p){var v=b.isTouchDevice,t=p.addEvent,C=p.correctFloat,l=p.defined,h=p.isNumber,x=p.pick,d=function(){function b(b){this.axis=b}b.prototype.destroy=function(){this.axis=void 0};b.prototype.toFixedRange=function(b,d,p,r){var e=this.axis,a=e.chart;a=a&&a.fixedRange;var c=(e.pointRange||0)/2;b=x(p,e.translate(b,!0,!e.horiz));d=x(r,e.translate(d,!0,!e.horiz));e=a&&(d-b)/a;l(p)||(b=C(b+c));l(r)||(d=C(d-c));.7<e&&1.3>e&&(r?b=d-a:d=b+a);h(b)&&h(d)||(b=d=void 0);return{min:b,max:d}};return b}();
return function(){function b(){}b.compose=function(b){b.keepProps.push("navigatorAxis");t(b,"init",function(){this.navigatorAxis||(this.navigatorAxis=new d(this))});t(b,"zoom",function(b){var d=this.chart.options,g=d.navigator,e=this.navigatorAxis,a=d.chart.pinchType,c=d.rangeSelector;d=d.chart.zoomType;this.isXAxis&&(g&&g.enabled||c&&c.enabled)&&("y"===d?b.zoomed=!1:(!v&&"xy"===d||v&&"xy"===a)&&this.options.range&&(g=e.previousZoom,l(b.newMin)?e.previousZoom=[this.min,this.max]:g&&(b.newMin=g[0],
b.newMax=g[1],e.previousZoom=void 0)));"undefined"!==typeof b.zoomed&&b.preventDefault()})};b.AdditionsClass=d;return b}()});H(b,"Core/Navigator.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Core/Axis/NavigatorAxis.js"],b["Core/DefaultOptions.js"],b["Core/Renderer/RendererRegistry.js"],b["Core/Scrollbar.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,p,v,t,C,l,h,x,d,r,g){v=v.parse;var A=t.hasTouch,
B=t.isTouchDevice,H=l.defaultOptions,e=g.addEvent,a=g.clamp,c=g.correctFloat,u=g.defined,E=g.destroyObjectProperties,G=g.erase,m=g.extend,D=g.find,Q=g.isArray,M=g.isNumber,F=g.merge,K=g.pick,I=g.removeEvent,z=g.splat,n=function(a){for(var b=[],c=1;c<arguments.length;c++)b[c-1]=arguments[c];b=[].filter.call(b,M);if(b.length)return Math[a].apply(0,b)};l="undefined"===typeof r.seriesTypes.areaspline?"line":"areaspline";m(H,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle",
"navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:v("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:l,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",
[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,
endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});h.getRendererType().prototype.symbols["navigator-handle"]=function(a,b,c,d,e){a=(e&&e.width||0)/2;b=Math.round(a/3)+.5;e=e&&e.height||0;return[["M",-a-1,.5],["L",a,.5],["L",a,e+.5],["L",-a-1,e+.5],["L",-a-1,.5],["M",-b,4],["L",-b,e-3],["M",b-1,4],["L",b-1,e-3]]};var y=function(){function d(a){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=
this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(a)}d.prototype.drawHandle=function(a,b,c,d){var f=this.navigatorOptions.handles.height;this.handles[b][d](c?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(a,10)+.5-f)}:{translateX:Math.round(this.left+parseInt(a,10)),translateY:Math.round(this.top+
this.height/2-f/2-1)})};d.prototype.drawOutline=function(a,b,c,d){var f=this.navigatorOptions.maskInside,e=this.outline.strokeWidth(),k=e/2,g=e%2/2;e=this.outlineHeight;var h=this.scrollbarHeight||0,l=this.size,m=this.left-h,n=this.top;c?(m-=k,c=n+b+g,b=n+a+g,g=[["M",m+e,n-h-g],["L",m+e,c],["L",m,c],["L",m,b],["L",m+e,b],["L",m+e,n+l+h]],f&&g.push(["M",m+e,c-k],["L",m+e,b+k])):(a+=m+h-g,b+=m+h-g,n+=k,g=[["M",m,n],["L",a,n],["L",a,n+e],["L",b,n+e],["L",b,n],["L",m+l+2*h,n]],f&&g.push(["M",a-k,n],["L",
b+k,n]));this.outline[d]({d:g})};d.prototype.drawMasks=function(a,b,c,d){var f=this.left,e=this.top,k=this.height;if(c){var g=[f,f,f];var h=[e,e+a,e+b];var m=[k,k,k];var l=[a,b-a,this.size-b]}else g=[f,f+a,f+b],h=[e,e,e],m=[a,b-a,this.size-b],l=[k,k,k];this.shades.forEach(function(a,b){a[d]({x:g[b],y:h[b],width:m[b],height:l[b]})})};d.prototype.renderElements=function(){var a=this,b=a.navigatorOptions,c=b.maskInside,d=a.chart,e=d.renderer,g,h={cursor:d.inverted?"ns-resize":"ew-resize"};a.navigatorGroup=
g=e.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!c,c,!c].forEach(function(c,f){var k=e.rect().addClass("highcharts-navigator-mask"+(1===f?"-inside":"-outside")).add(g);d.styledMode||(k.attr({fill:c?b.maskFill:"rgba(0,0,0,0)"}),1===f&&k.css(h));a.shades[f]=k});a.outline=e.path().addClass("highcharts-navigator-outline").add(g);d.styledMode||a.outline.attr({"stroke-width":b.outlineWidth,stroke:b.outlineColor});b.handles.enabled&&[0,1].forEach(function(c){b.handles.inverted=d.inverted;
a.handles[c]=e.symbol(b.handles.symbols[c],-b.handles.width/2-1,0,b.handles.width,b.handles.height,b.handles);a.handles[c].attr({zIndex:7-c}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][c]).add(g);if(!d.styledMode){var f=b.handles;a.handles[c].attr({fill:f.backgroundColor,stroke:f.borderColor,"stroke-width":f.lineWidth}).css(h)}})};d.prototype.update=function(a){(this.series||[]).forEach(function(a){a.baseSeries&&delete a.baseSeries.navigatorSeries});this.destroy();
F(!0,this.chart.options.navigator,this.options,a);this.init(this.chart)};d.prototype.render=function(b,d,e,g){var f=this.chart,k=this.scrollbarHeight,h,m=this.xAxis,l=m.pointRange||0;var n=m.navigatorAxis.fake?f.xAxis[0]:m;var q=this.navigatorEnabled,p,w=this.rendered;var r=f.inverted;var t=f.xAxis[0].minRange,v=f.xAxis[0].options.maxRange;if(!this.hasDragged||u(e)){b=c(b-l/2);d=c(d+l/2);if(!M(b)||!M(d))if(w)e=0,g=K(m.width,n.width);else return;this.left=K(m.left,f.plotLeft+k+(r?f.plotWidth:0));this.size=
p=h=K(m.len,(r?f.plotHeight:f.plotWidth)-2*k);f=r?k:h+2*k;e=K(e,m.toPixels(b,!0));g=K(g,m.toPixels(d,!0));M(e)&&Infinity!==Math.abs(e)||(e=0,g=f);b=m.toValue(e,!0);d=m.toValue(g,!0);var J=Math.abs(c(d-b));J<t?this.grabbedLeft?e=m.toPixels(d-t-l,!0):this.grabbedRight&&(g=m.toPixels(b+t+l,!0)):u(v)&&c(J-l)>v&&(this.grabbedLeft?e=m.toPixels(d-v-l,!0):this.grabbedRight&&(g=m.toPixels(b+v+l,!0)));this.zoomedMax=a(Math.max(e,g),0,p);this.zoomedMin=a(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,
g),0,p);this.range=this.zoomedMax-this.zoomedMin;p=Math.round(this.zoomedMax);e=Math.round(this.zoomedMin);q&&(this.navigatorGroup.attr({visibility:"inherit"}),w=w&&!this.hasDragged?"animate":"attr",this.drawMasks(e,p,r,w),this.drawOutline(e,p,r,w),this.navigatorOptions.handles.enabled&&(this.drawHandle(e,0,r,w),this.drawHandle(p,1,r,w)));this.scrollbar&&(r?(r=this.top-k,n=this.left-k+(q||!n.opposite?0:(n.titleOffset||0)+n.axisTitleMargin),k=h+2*k):(r=this.top+(q?this.height:-k),n=this.left-k),this.scrollbar.position(n,
r,f,k),this.scrollbar.setRange(this.zoomedMin/(h||1),this.zoomedMax/(h||1)));this.rendered=!0}};d.prototype.addMouseEvents=function(){var a=this,b=a.chart,c=b.container,d=[],g,h;a.mouseMoveHandler=g=function(b){a.onMouseMove(b)};a.mouseUpHandler=h=function(b){a.onMouseUp(b)};d=a.getPartsEvents("mousedown");d.push(e(b.renderTo,"mousemove",g),e(c.ownerDocument,"mouseup",h));A&&(d.push(e(b.renderTo,"touchmove",g),e(c.ownerDocument,"touchend",h)),d.concat(a.getPartsEvents("touchstart")));a.eventsToUnbind=
d;a.series&&a.series[0]&&d.push(e(a.series[0].xAxis,"foundExtremes",function(){b.navigator.modifyNavigatorAxisExtremes()}))};d.prototype.getPartsEvents=function(a){var b=this,c=[];["shades","handles"].forEach(function(f){b[f].forEach(function(d,k){c.push(e(d.element,a,function(a){b[f+"Mousedown"](a,k)}))})});return c};d.prototype.shadesMousedown=function(a,b){a=this.chart.pointer.normalize(a);var c=this.chart,d=this.xAxis,f=this.zoomedMin,e=this.left,k=this.size,g=this.range,h=a.chartX;c.inverted&&
(h=a.chartY,e=this.top);if(1===b)this.grabbedCenter=h,this.fixedWidth=g,this.dragOffset=h-f;else{a=h-e-g/2;if(0===b)a=Math.max(0,a);else if(2===b&&a+g>=k)if(a=k-g,this.reversedExtremes){a-=g;var m=this.getUnionExtremes().dataMin}else var l=this.getUnionExtremes().dataMax;a!==f&&(this.fixedWidth=g,b=d.navigatorAxis.toFixedRange(a,a+g,m,l),u(b.min)&&c.xAxis[0].setExtremes(Math.min(b.min,b.max),Math.max(b.min,b.max),!0,null,{trigger:"navigator"}))}};d.prototype.handlesMousedown=function(a,b){this.chart.pointer.normalize(a);
a=this.chart;var c=a.xAxis[0],d=this.reversedExtremes;0===b?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?c.min:c.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?c.max:c.min);a.fixedRange=null};d.prototype.onMouseMove=function(a){var b=this,c=b.chart,d=b.left,f=b.navigatorSize,e=b.range,g=b.dragOffset,h=c.inverted;a.touches&&0===a.touches[0].pageX||(a=c.pointer.normalize(a),c=a.chartX,h&&(d=b.top,c=a.chartY),b.grabbedLeft?(b.hasDragged=
!0,b.render(0,0,c-d,b.otherHandlePos)):b.grabbedRight?(b.hasDragged=!0,b.render(0,0,b.otherHandlePos,c-d)):b.grabbedCenter&&(b.hasDragged=!0,c<g?c=g:c>f+g-e&&(c=f+g-e),b.render(0,0,c-g,c-g+e)),b.hasDragged&&b.scrollbar&&K(b.scrollbar.options.liveRedraw,t.svg&&!B&&!this.chart.isBoosting)&&(a.DOMType=a.type,setTimeout(function(){b.onMouseUp(a)},0)))};d.prototype.onMouseUp=function(a){var b=this.chart,c=this.xAxis,d=this.scrollbar,f=a.DOMEvent||a,e=b.inverted,g=this.rendered&&!this.hasDragged?"animate":
"attr";if(this.hasDragged&&(!d||!d.hasDragged)||"scrollbar"===a.trigger){d=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var h=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var m=this.fixedExtreme;this.zoomedMax===this.size&&(m=this.reversedExtremes?d.dataMin:d.dataMax);0===this.zoomedMin&&(h=this.reversedExtremes?d.dataMax:d.dataMin);c=c.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,h,m);u(c.min)&&b.xAxis[0].setExtremes(Math.min(c.min,c.max),Math.max(c.min,
c.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:f})}"mousemove"!==a.DOMType&&"touchmove"!==a.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&M(this.zoomedMin)&&M(this.zoomedMax)&&(b=Math.round(this.zoomedMin),a=Math.round(this.zoomedMax),this.shades&&this.drawMasks(b,a,e,g),this.outline&&this.drawOutline(b,a,e,g),this.navigatorOptions.handles.enabled&&
Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(b,0,e,g),this.drawHandle(a,1,e,g)))};d.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(a){a()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};d.prototype.removeBaseSeriesEvents=function(){var a=this.baseSeries||[];this.navigatorEnabled&&a[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&a.forEach(function(a){I(a,"updatedData",this.updatedDataHandler)},this),a[0].xAxis&&
I(a[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};d.prototype.init=function(a){var c=a.options,d=c.navigator,f=d.enabled,g=c.scrollbar,h=g.enabled;c=f?d.height:0;var m=h?g.height:0;this.handles=[];this.shades=[];this.chart=a;this.setBaseSeries();this.height=c;this.scrollbarHeight=m;this.scrollbarEnabled=h;this.navigatorEnabled=f;this.navigatorOptions=d;this.scrollbarOptions=g;this.outlineHeight=c+m;this.opposite=K(d.opposite,!(f||!a.inverted));var l=this;f=l.baseSeries;g=a.xAxis.length;
h=a.yAxis.length;var q=f&&f[0]&&f[0].xAxis||a.xAxis[0]||{options:{}};a.isDirtyBox=!0;l.navigatorEnabled?(l.xAxis=new b(a,F({breaks:q.options.breaks,ordinal:q.options.ordinal},d.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},a.inverted?{offsets:[m,0,-m,0],width:c}:{offsets:[0,-m,0,m],height:c})),l.yAxis=new b(a,F(d.yAxis,{id:"navigator-y-axis",alignTicks:!1,
offset:0,index:h,isInternal:!0,reversed:K(d.yAxis&&d.yAxis.reversed,a.yAxis[0]&&a.yAxis[0].reversed,!1),zoomEnabled:!1},a.inverted?{width:c}:{height:c})),f||d.series.data?l.updateNavigatorSeries(!1):0===a.series.length&&(l.unbindRedraw=e(a,"beforeRedraw",function(){0<a.series.length&&!l.series&&(l.setBaseSeries(),l.unbindRedraw())})),l.reversedExtremes=a.inverted&&!l.xAxis.reversed||!a.inverted&&l.xAxis.reversed,l.renderElements(),l.addMouseEvents()):(l.xAxis={chart:a,navigatorAxis:{fake:!0},translate:function(b,
c){var d=a.xAxis[0],f=d.getExtremes(),e=d.len-2*m,g=n("min",d.options.min,f.dataMin);d=n("max",d.options.max,f.dataMax)-g;return c?b*d/e+g:e*(b-g)/d},toPixels:function(a){return this.translate(a)},toValue:function(a){return this.translate(a,!0)}},l.xAxis.navigatorAxis.axis=l.xAxis,l.xAxis.navigatorAxis.toFixedRange=C.AdditionsClass.prototype.toFixedRange.bind(l.xAxis.navigatorAxis));a.options.scrollbar.enabled&&(a.scrollbar=l.scrollbar=new x(a.renderer,F(a.options.scrollbar,{margin:l.navigatorEnabled?
0:10,vertical:a.inverted}),a),e(l.scrollbar,"changed",function(a){var b=l.size,c=b*this.to;b*=this.from;l.hasDragged=l.scrollbar.hasDragged;l.render(0,0,b,c);this.shouldUpdateExtremes(a.DOMType)&&setTimeout(function(){l.onMouseUp(a)})}));l.addBaseSeriesEvents();l.addChartEvents()};d.prototype.getUnionExtremes=function(a){var b=this.chart.xAxis[0],c=this.xAxis,d=c.options,f=b.options,e;a&&null===b.dataMin||(e={dataMin:K(d&&d.min,n("min",f.min,b.dataMin,c.dataMin,c.min)),dataMax:K(d&&d.max,n("max",
f.max,b.dataMax,c.dataMax,c.max))});return e};d.prototype.setBaseSeries=function(a,b){var c=this.chart,d=this.baseSeries=[];a=a||c.options&&c.options.navigator.baseSeries||(c.series.length?D(c.series,function(a){return!a.options.isInternal}).index:0);(c.series||[]).forEach(function(b,c){b.options.isInternal||!b.options.showInNavigator&&(c!==a&&b.options.id!==a||!1===b.options.showInNavigator)||d.push(b)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,b)};d.prototype.updateNavigatorSeries=
function(a,b){var c=this,d=c.chart,f=c.baseSeries,e,g,k=c.navigatorOptions.series,h,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},n=c.series=(c.series||[]).filter(function(a){var b=a.baseSeries;return 0>f.indexOf(b)?(b&&(I(b,"updatedData",c.updatedDataHandler),delete b.navigatorSeries),a.chart&&a.destroy(),!1):!0});f&&f.length&&f.forEach(function(a){var q=
a.navigatorSeries,p=m({color:a.color,visible:a.visible},Q(k)?H.navigator.series:k);q&&!1===c.navigatorOptions.adaptToUpdatedData||(l.name="Navigator "+f.length,e=a.options||{},h=e.navigatorOptions||{},p.dataLabels=z(p.dataLabels),g=F(e,l,p,h),g.pointRange=K(p.pointRange,h.pointRange,H.plotOptions[g.type||"line"].pointRange),p=h.data||p.data,c.hasNavigatorData=c.hasNavigatorData||!!p,g.data=p||e.data&&e.data.slice(0),q&&q.options?q.update(g,b):(a.navigatorSeries=d.initSeries(g),a.navigatorSeries.baseSeries=
a,n.push(a.navigatorSeries)))});if(k.data&&(!f||!f.length)||Q(k))c.hasNavigatorData=!1,k=z(k),k.forEach(function(a,b){l.name="Navigator "+(n.length+1);g=F(H.navigator.series,{color:d.series[b]&&!d.series[b].options.isInternal&&d.series[b].color||d.options.colors[b]||d.options.colors[0]},l,a);g.data=a.data;g.data&&(c.hasNavigatorData=!0,n.push(d.initSeries(g)))});a&&this.addBaseSeriesEvents()};d.prototype.addBaseSeriesEvents=function(){var a=this,b=a.baseSeries||[];b[0]&&b[0].xAxis&&b[0].eventsToUnbind.push(e(b[0].xAxis,
"foundExtremes",this.modifyBaseAxisExtremes));b.forEach(function(b){b.eventsToUnbind.push(e(b,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));b.eventsToUnbind.push(e(b,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&b.xAxis&&b.eventsToUnbind.push(e(b,"updatedData",this.updatedDataHandler));b.eventsToUnbind.push(e(b,"remove",function(){this.navigatorSeries&&(G(a.series,this.navigatorSeries),
u(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};d.prototype.getBaseSeriesMin=function(a){return this.baseSeries.reduce(function(a,b){return Math.min(a,b.xData&&b.xData.length?b.xData[0]:a)},a)};d.prototype.modifyNavigatorAxisExtremes=function(){var a=this.xAxis,b;"undefined"!==typeof a.getExtremes&&(!(b=this.getUnionExtremes(!0))||b.dataMin===a.min&&b.dataMax===a.max||(a.min=b.dataMin,a.max=b.dataMax))};d.prototype.modifyBaseAxisExtremes=function(){var a=
this.chart.navigator,b=this.getExtremes(),c=b.dataMin,d=b.dataMax;b=b.max-b.min;var e=a.stickToMin,g=a.stickToMax,h=K(this.options.overscroll,0),l=a.series&&a.series[0],m=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(e){var n=c;var q=n+b}g&&(q=d+h,e||(n=Math.max(c,q-b,a.getBaseSeriesMin(l&&l.xData?l.xData[0]:-Number.MAX_VALUE))));m&&(e||g)&&M(n)&&(this.min=this.userMin=n,this.max=this.userMax=q)}a.stickToMin=a.stickToMax=null};d.prototype.updatedDataHandler=
function(){var a=this.chart.navigator,b=this.navigatorSeries;a.stickToMax=a.reversedExtremes?0===Math.round(a.zoomedMin):Math.round(a.zoomedMax)>=Math.round(a.size);a.stickToMin=a.shouldStickToMin(this,a);b&&!a.hasNavigatorData&&(b.options.pointStart=this.xData[0],b.setData(this.options.data,!1,null,!1))};d.prototype.shouldStickToMin=function(a,b){b=b.getBaseSeriesMin(a.xData[0]);var c=a.xAxis;a=c.max;var d=c.min;c=c.options.range;return M(a)&&M(d)?c&&0<a-b?a-b<c:d<=b:!1};d.prototype.addChartEvents=
function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(e(this.chart,"redraw",function(){var a=this.navigator,b=a&&(a.baseSeries&&a.baseSeries[0]&&a.baseSeries[0].xAxis||this.xAxis[0]);b&&a.render(b.min,b.max)}),e(this.chart,"getMargins",function(){var a=this.navigator,b=a.opposite?"plotTop":"marginBottom";this.inverted&&(b=a.opposite?"marginRight":"plotLeft");this[b]=(this[b]||0)+(a.navigatorEnabled||!this.inverted?a.outlineHeight:0)+a.navigatorOptions.margin}))};d.prototype.destroy=
function(){this.removeEvents();this.xAxis&&(G(this.chart.xAxis,this.xAxis),G(this.chart.axes,this.xAxis));this.yAxis&&(G(this.chart.yAxis,this.yAxis),G(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(a){a.destroy&&a.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(a){this[a]&&this[a].destroy&&this[a].destroy();this[a]=null},this);[this.handles].forEach(function(a){E(a)},this)};
return d}();t.Navigator||(t.Navigator=y,C.compose(b),e(p,"beforeShowResetZoom",function(){var a=this.options,b=a.navigator,c=a.rangeSelector;if((b&&b.enabled||c&&c.enabled)&&(!B&&"x"===a.chart.zoomType||B&&"x"===a.chart.pinchType))return!1}),e(p,"beforeRender",function(){var a=this.options;if(a.navigator.enabled||a.scrollbar.enabled)this.scroller=this.navigator=new y(this)}),e(p,"afterSetChartSize",function(){var a=this.legend,b=this.navigator;if(b){var c=a&&a.options;var d=b.xAxis;var e=b.yAxis;
var g=b.scrollbarHeight;this.inverted?(b.left=b.opposite?this.chartWidth-g-b.height:this.spacing[3]+g,b.top=this.plotTop+g):(b.left=K(d.left,this.plotLeft+g),b.top=b.navigatorOptions.top||this.chartHeight-b.height-g-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(c&&"bottom"===c.verticalAlign&&"proximate"!==c.layout&&c.enabled&&!c.floating?a.legendHeight+K(c.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));d&&e&&(this.inverted?d.options.left=e.options.left=
b.left:d.options.top=e.options.top=b.top,d.setAxisSize(),e.setAxisSize())}}),e(p,"update",function(a){var b=a.options.navigator||{},c=a.options.scrollbar||{};this.navigator||this.scroller||!b.enabled&&!c.enabled||(F(!0,this.options.navigator,b),F(!0,this.options.scrollbar,c),delete a.options.navigator,delete a.options.scrollbar)}),e(p,"afterUpdate",function(a){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new y(this),
K(a.redraw,!0)&&this.redraw(a.animation))}),e(p,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),e(d,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),p.prototype.callbacks.push(function(a){var b=a.navigator;b&&a.xAxis[0]&&(a=a.xAxis[0].getExtremes(),b.render(a.min,a.max))}));t.Navigator=y;return t.Navigator});H(b,"masters/modules/gantt.src.js",[b["Core/Globals.js"],b["Core/Chart/GanttChart.js"],
b["Core/Scrollbar.js"]],function(b,p,v){b.Scrollbar=v;b.GanttChart=p;b.ganttChart=p.ganttChart;v.compose(b.Axis)})});
//# sourceMappingURL=gantt.js.map