let trafHsData       = [];
let trafHsTable      = null;
let trafHsChart      = null;
let searchBtn        = null;
let strtDateBox      = null;
let strtTimeBox      = null;
let endDateBox       = null;
let endTimeBox       = null;
let linkTabs         = null;
let endDate          = new Date().setDate(new Date().getDate()-1);
let startDate        = new Date().setDate(new Date().getDate()-1);
let linkTable        = null;
let ifscTable        = null;
let roadTable        = null;
let dataSource       = [];
let linkColumns      = [];
let ifscColumns      = [];
let roadColumns      = [];
let linkSeries       = [];
let ifscRoadSeries   = [];
let xAxis            = [];
let data             = [];
let columnArr        = [];
let columns          = [];
const _pageName      = '가공데이터 이력';
const _linkData      = _trafficMap.get('link');
const _ifscData      = _trafficMap.get('ifsc');
const _roadData      = _trafficMap.get('road');
//링크 테이블 데이터


//컬럼 보이기/숨기기 옵션
linkColumns = {
    visible   : [ 'link_id', 'miss_yn_desc', 'smth_sped', 'prcn_sped', 'adjs_sped', 'adjs_sorc_desc', 'prcn_sorc_desc' ],
    devisible : [ 'ifsc_id', 'road_id']
}
ifscColumns = {
    visible   : [ 'ifsc_id' ],
    devisible : [ 'link_id', 'road_id', 'miss_yn_desc', 'prcn_sped', 'smth_sped', 'adjs_sped', 'adjs_sorc_desc', 'prcn_sorc_desc' ],
}
roadColumns = {
    visible   : [ 'road_id' ],
    devisible : [ 'ifsc_id', 'link_id', 'miss_yn_desc', 'prcn_sped', 'smth_sped', 'adjs_sped', 'adjs_sorc_desc', 'prcn_sorc_desc' ],
}

//링크 차트 시리즈
linkSeries     = [
    {
        id   : 'sped',
        name : '속도',
        color: 'rgb(124, 181, 236)',
        data : [],
    },
    {
        id   : 'prcn_sped',
        name : '가공속도',
        color: 'rgb(144, 237, 125)',
        data : [],
    },
    {
        id   : 'smth_sped',
        name : '평활화속도',
        color: 'rgb(43, 144, 143)',
        data : [],
    },
    {
        id   : 'adjs_sped',
        name : '보정속도',
        color: 'rgb(128, 133, 233)',
        data : [],
    },
    {
        id   : 'ptrn_sped',
        name : '패턴속도',
        color: 'rgb(247, 163, 92)',
        data : [],
    },
]

//서비스 링크, 도로 시리즈
ifscRoadSeries = [
    {
        id   : 'sped',
        name : '속도',
        color: 'rgb(124, 181, 236)',
        data : [],
    },
    {
        id   : 'ptrn_sped',
        name : '패턴속도',
        color: 'rgb(247, 163, 92)',
        data : [],
    },
]

$(()=>{

    //검색시작일시 년월일
    strtDateBox = $(".strt-date").dxDateBox({
        type                : 'date',
        value               : startDate,
        width               : '120px',
        height              : '25px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");

    //검색시작일시 시간
    strtTimeBox = $(".strt-time").dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : '90px',
        height              : '25px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox("instance");

    //검색종료일시 년월일
    endDateBox  = $(".end-date").dxDateBox({
        type                : 'date',
        value               : endDate,
        width               : '120px',
        height              : '25px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");

    //검색종료일시 시간
    endTimeBox  = $(".end-time").dxDateBox({
        type                : 'time',
        value               : 1645196399000,
        width               : '90px',
        height              : '25px',
        stylingMode         :'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox("instance");

    //차트 이지미 저장 버튼
    $(".export-button").dxButton({
        stylingMode : 'outlined',
        text        : '차트 저장',
        icon        : 'export',
        height      : '40px',
        width       : '110px',
        onClick(){
            if( trafHsData.length <= 0 || trafHsData[0].length <= 0 ){
                alertWarning("저장하실 차트 데이터가 없습니다.");
                return false;
            }

            confirmMessage("가공데이터 이력 조회 차트를 파일로 저장 하시겠습니까?").done((yes)=>{
                if (yes){
                    trafHsChart.exportChartLocal({
                        filename: '가공데이터 이력조회_'+ excellTime()
                    });
                }
            })
        }
    });

    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
        onClick(){
            switch (linkTabs.option('selectedIndex')) {
                case 0:
                    linkSearch();
                    break;
                case 1:
                    ifscSearch();
                    break;
                case 2:
                    roadSearch();
                    break;

                default:
                    break;
            }
        }
    }).dxButton("instance")

    //차트 변경 버튼
    $(".chart-change").dxMenu({
        dataSource: chartDataSource,
        hideSubmenuOnMouseLeave: true,
        cssClass:'menu-border',
        height: 40,
        showFirstSubmenuMode: {
            name: "onClick",
            delay: { show: 0, hide: 100 },
        },
        displayExpr: "name",
        submenuDirection: "auto",
        visible: true,
        onItemClick(info){
            const item = info.itemData;
            if(item.type){
                const dataSource = [...info.component.option('dataSource')]
                dataSource[0].name = item.name
                dataSource[0].icon = item.type
                info.component.option('dataSource', dataSource);
                trafHsChart.update({
                    chart: {
                        type: item.type,
                    }
                })
            }
        }
    }).dxMenu("instance");


    //가공데이터 차트
    trafHsChart = Highcharts.chart('traf-hs-chart', {
        chart: {
            type: 'line',
            height: 342,
            backgroundColor: '#3f3f4b',
            zoomType: 'x',
            events: {
                load: function() {
                    this.xAxis[0].setExtremes(0, 15);
                }
            },
        },
        title: {
            text: null
        },
        xAxis: {
            categories: null,
            title: {
                text: '수집시각',
                style:{
                    color:'#fff',
                }
            },
            labels:{
                style:{
                    color:'#fff',
                }
            }
        },

        yAxis: {
            min: 0,
            title: {
                text: '속도(km/h)',
                align: 'high',
                style:{
                    color: '#fff',
                }
            },
            labels: {
                overflow: 'justify',
                style:{
                    color: '#fff',
                },
                format: '{value:,.0f}'
            },
        },
        tooltip: {
            valueSuffix: ' km/h'
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            },
            series: {
                lineWidth: 2
            }
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'top',
            floating: false,
            y: 50,
            borderWidth: 1,
            itemStyle:{
                color:'#fff',
            },
            backgroundColor:
                Highcharts.defaultOptions.legend.backgroundColor || '#525260',
            shadow: true,
            borderColor:'#534b4b',
        },
        exporting: {
            chartOptions: { // specific options for the exported image
                plotOptions: {
                    series: {
                        dataLabels: {
                            enabled: true
                        }
                    }
                }
            },
            enabled : false,
            fallbackToExportServer: false,
        },
        credits: {
            enabled: false
        },
        series: null,
    });

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")

    //가공데이터 이력조회 테이블
    trafHsTable = $(".traf-hs-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        keyExpr:'prcn_dt',
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        columns : [
            {
                dataField    : "prcn_dt",
                caption      : "가공시각",
                alignment    : "center",
                sortIndex    : 0,
                sortOrder    : "asc",
            },
            {
                dataField    : "link_id",
                caption      : "링크 ID",
                alignment    : "center",
                dataType     : 'string',
            },
            {
                dataField    : "ifsc_id",
                caption      : "정보제공구간 ID",
                dataType     : 'string',
                visible      : false,
                alignment    : "center",
            },
            {
                dataField    : "road_id",
                caption      : "도로 ID",
                dataType     : 'string',
                visible      : false,
                alignment    : "center",
            },
            {
                dataField    : "tfvl",
                caption      : "교통량",
                alignment    : "center",
                format       : "#,###,##0",
            },
            {
                dataField    : "sped",
                caption      : "속도",
                alignment    : "center",
            },
            {
                dataField    : "cmtr_grad_desc",
                caption      : "소통등급",
                alignment    : "center",
            },
            {
                dataField    : "miss_yn_desc",
                caption      : "결측여부",
                alignment    : "center",
            },
            {
                dataField    : "prcn_sped",
                caption      : "가공 속도",
                alignment    : "center",
            },
            {
                dataField    : "smth_sped",
                caption      : "평활화 속도",
                alignment    : "center",
            },
            {
                dataField    : "adjs_sped",
                caption      : "보정 속도",
                alignment    : "center",
            },
            {
                dataField    : "ptrn_sped",
                caption      : "패턴 속도",
                alignment    : "center",
            },
            {
                dataField    : "prcn_sorc_desc",
                caption      : "가공 소스",
                alignment    : "center",
            },
            {
                dataField    : "adjs_sorc_desc",
                caption      : "보정소스",
                alignment    : "center",
            },
            {
                dataField    : "ocpy_rate",
                caption      : "점유율",
                alignment    : "center",
            },
            {
                dataField    : "trvl_hh",
                caption      : "통행 시간",
                alignment    : "center",
            },
            {
                dataField    : "data_num",
                caption      : "데이터개수",
                alignment    : "center",
            },
        ],
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },

    }).dxDataGrid("instance");


    //링크 테이블
    linkTable = $("<div class='b1 b3 b4'>").width('100%').height('calc(100% - 1px)').dxDataGrid({
        dataSource              : _linkData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'link_id',
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "link_id",
                caption      : "링크 ID",
                alignment    : "center",
                dataType     : 'string',
                allowEditing : false,
                sortIndex    : 0,
                width        : 120,
                cssClass     : 'table-padding',
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_name",
            //     caption:"도로명",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"road_no",
            //     caption:"도로번호",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_rank_desc",
            //     caption:"도로등급",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_rank_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"road_type_desc",
            //     caption:"도로유형",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_use_desc",
            //     caption:"도로사용여부",
            //     alignment:"center",
            // },
            // {
            //     dataField:"lanes",
            //     caption:"차로수",
            //     alignment:"center",
            // },
            // {
            //     dataField:"max_spd",
            //     caption:"최고제한속도",
            //     alignment:"center",
            // },

            // {
            //     dataField:"sect_grad_cd_desc",
            //     caption:"구간등급코드",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.sect_grad_cd_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // }

        ],
    })

    //서비스링크 테이블
    ifscTable = $("<div class='b1 b3 b4'>").width('100%').height('calc(100% - 1px)').dxDataGrid({
        dataSource              : _ifscData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'ifsc_id',
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "ifsc_id",
                caption      : "ID",
                alignment    : "center",
                dataType     : 'string',
                allowEditing : false,
                sortIndex    : 0,
                width        : 100,
                cssClass     : 'table-padding',
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },

            // {
            //     dataField:"ifsc_name",
            //     caption:"명칭",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"drct_cd_desc",
            //     caption:"방향",
            //     alignment:"center",
            // },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"sect_grad_cd_desc",
            //     caption:"구간등급코드",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.sect_grad_cd_desc);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // }
            // {
            //     dataField:"rmrk",
            //     caption:"비고",
            //     alignment:"center",
            // },
            // {
            //     dataField:"extr_cnct_sect_yn",
            //     caption:"외부연계",
            //     alignment:"center",
            // },

        ],
    })

    //로드 테이블
    roadTable = $("<div class='b1 b3 b4'>").width('100%').height('calc(100% - 1px)').dxDataGrid({
        dataSource              : _roadData,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        focusedRowEnabled       : true,
        columnAutoWidth         : true,
        keyExpr                 : 'road_id',
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'virtual',
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        columns:[
            {
                dataField    : "road_id",
                caption      : "ID",
                alignment    : "center",
                dataType     : 'string',
                allowEditing : false,
                sortIndex    : 0,
                width        : 100,
                cssClass     : 'table-padding',
                sortOrder    : "asc",
            },

            {
                dataField    : "from_node",
                caption      : "시작노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.from_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            {
                dataField    : "to_node",
                caption      : "종료노드",
                alignment    : "center",
                cssClass     : 'table-padding',
                cellTemplate(c,e){
                    let result = nullChecker(e.data.to_node);
                    return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                }
            },
            // {
            //     dataField:"link_leng",
            //     caption:"길이(m)",
            //     alignment:"center",
            // },
            // {
            //     dataField:"road_name",
            //     caption:"도로명",
            //     alignment:"center",
            //     cellTemplate(c,e){
            //         let result = nullChecker(e.data.road_name);
            //         return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
            //     }
            // },
            // {
            //     dataField:"drct_cd_desc",
            //     caption:"방향",
            //     alignment:"center",
            // },
        ],
    })

    //링크 tabs
    linkTabs = $('.link-table').width('100%').height('100%').dxTabPanel({
        dataSource:[
            {
                id     : 1,
                name   : '링크(레벨1)',
                table  : linkTable,
                column : 'linkColumns',
            },
            {
                id     : 2,
                name   : '정보제공구간(레벨2)',
                table  : ifscTable,
                column : 'ifscColumns',
            },
            {
                id     : 3,
                name   : '도로(레벨3)',
                table  : roadTable,
                column : 'roadColumns',
            },
        ],
        selectIndex:0,
        loop:false,
        animationEnabled: true,
        swipeEnabled: false,
        itemTitleTemplate: function(e){
            return $('<div style="height:29px; line-height:29px;">'+e.name+'</div>')
        },
        itemTemplate: function(e, i, c){
            c.css({padding:'2px'});
            c.append(e.table);
            return c;
        },
        onSelectionChanged(e){
            $('.selected-index').text(e.component.option('selectedIndex') + 1);
            const table = e.addedItems[0].table.dxDataGrid('instance');
            table.clearSelection();
            table.option('focusedRowIndex', -1);
        },
    }).dxTabPanel('instance');

})

//링크 조회
function linkSearch(){
    const table = linkTable.dxDataGrid('instance');

    if(table.getSelectedRowsData().length <= 0){
        alertWarning("링크 목록을 선택해주세요")
        return false;
    }

    let updateData = {
        FROM_DT : null,
        LINK_ID : null,
        TO_DT   : null,
    }

    tableSettings( table.getSelectedRowsData()[0].link_id, '/api/history/traf-hs/link', 'LINK_ID', updateData, linkSeries , linkColumns );

}

//정보제공구간 조회
function ifscSearch(){
    const table = ifscTable.dxDataGrid('instance');

    if ( table.getSelectedRowsData().length <= 0 ){
        alertWarning("정보제공구간 목록을 선택해주세요")
        return false;
    }

    let updateData = {
        FROM_DT : null,
        IFSC_ID : null,
        TO_DT   : null,
    }


    tableSettings( table.getSelectedRowsData()[0].ifsc_id, '/api/history/traf-hs/ifsc', 'IFSC_ID', updateData, ifscRoadSeries, ifscColumns );

}

//도로 조회
function roadSearch(){
    const table = roadTable.dxDataGrid('instance');

    if ( table.getSelectedRowsData().length <= 0 ){
        alertWarning("도로 목록을 선택해주세요")
        return false;
    }

    let updateData = {
        FROM_DT : null,
        ROAD_ID : null,
        TO_DT   : null,
    }


    tableSettings( table.getSelectedRowsData()[0].road_id, '/api/history/traf-hs/road', 'ROAD_ID', updateData, ifscRoadSeries, roadColumns );

}

//테이블 세팅
function tableSettings( id, uri, idName, updateData, chartData, columns ) {
    if(!validationCheck( strtDateBox, endDateBox, strtTimeBox, endTimeBox)) return false;

    let FROM_DT  = getDate(strtDateBox.option("value"),strtTimeBox.option("value"));
    let TO_DT    = getDate(endDateBox.option("value"),endTimeBox.option("value"));

    if( FROM_DT > TO_DT ){
        alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, strtDateBox);
        return false;
    }

    updateData[ 'FROM_DT' ] = FROM_DT;
    updateData[ 'TO_DT' ]   = TO_DT;
    updateData[ idName ]    = id;
    trafHsData = [];
    //getData( uri, trafHsData, updateData );
    getDataAsync(uri, (jsonData)=>{
        trafHsData = jsonData;
        xAxis      = [];

        for( key in chartData ){
            chartData[key].data = [];
        }

        trafHsData.map((item) => {
            if(item.prcn_dt){
                item.prcn_dt = getParseDateTime(item.prcn_dt);
            }
            xAxis.push(item.prcn_dt)
            if ( chartData.length === 5){
                chartData[0].data.push( item.sped      );
                chartData[1].data.push( item.prcn_sped );
                chartData[2].data.push( item.smth_sped );
                chartData[3].data.push( item.adjs_sped );
                chartData[4].data.push( item.ptrn_sped );
                return
            }
            chartData[0].data.push( item.sped      );
            chartData[1].data.push( item.ptrn_sped );
        })

        trafHsTable.option('dataSource',trafHsData);
        trafHsTable.clearSelection();
        trafHsTable.option('focusedRowIndex', -1);

        if( trafHsChart.series[0] !== undefined){
            trafHsChart.get('sped').remove();
            if(trafHsChart.get('prcn_sped') !== undefined){
                trafHsChart.get('prcn_sped').remove();
                trafHsChart.get('smth_sped').remove();
                trafHsChart.get('adjs_sped').remove();
            }
            trafHsChart.get('ptrn_sped').remove();
        }
        for( key in chartData ){
            trafHsChart.addSeries(chartData[key]);
        }

        trafHsChart.update({
            xAxis : {
                categories : xAxis,
            }
        })
        pageNation(trafHsChart, xAxis);
        //데이터 해당 컬럼 보이기
        for( let ii = 0; ii < columns.visible.length; ii++ ){
            showColumn(trafHsTable, columns.visible[ii]);
        }

        //데이터 해당하지 않는 컬럼 가리기
        for( let ii = 0; ii < columns.devisible.length; ii++ ){
            hideColumn(trafHsTable, columns.devisible[ii]);
        }

        alertConfirm('데이터 조회가 완료 되었습니다. [' + trafHsData.length + '건]');
    }, null, updateData);
}
