//우측 섹션 관련
let reportData       = [];
let reportData2      = [];
let reportTable      = null;
let reportTable2     = null;

let reportToggle1    = {
    summary  : ['fclt_type','cms0_cnt','cms1_cnt'],
    incident : ['incd_strt_dt','cmmn_cd_kor_nm','link_id','incd_titl']
}
let reportToggle2    = {
    error   : ['rgst_dt','fclt_type','fclt_id','fclt_nm'],
    congest : ['prcn_Dt','sped','link_id','cmtr_grad_cd']
    
}

//좌측 섹션 관련
let reportStartDate  = null;
let reportEndDate    = null;
let reportStartTime  = null;
let reportEndTime    = null;
let reportSearchBtn  = null;
let reportSelect     = null;
let selectData       = [];


//공통 uri
let commonUri            = '/api/report/report/';
let pageName             = '시설물 보고서';
let excelSheetName1      = '시설물 현황';
let excelSheetName2      = '장애 현황';
let excelSheetName3      = '돌발 현황';
let excelSheetName4      = '지*정체 현황';
let OFFR_TYPE            = 'LINK';


//기본 날짜 세팅
const strtDate = new Date().setDate(new Date().getDate()-1);
const endDate = new Date().setDate(new Date().getDate()-1);
selectData = [
    {
        frontUri     : 'facility/',
        endUri       : ['summary','error'],
        display      : '시설물 보고서',
        keyExpr      : [['fclt_type'],['fclt_id','rgst_dt']],
    },
    {
        frontUri     : 'traffic/',
        endUri       : ['incident','congest'],
        display      : '교통 보고서',
        keyExpr      : [['prcn_Dt','link_id'],['link_id','incd_strt_dt']],
    }
]

$(()=>{

    //검색시작일시 년월일
    reportStartDate =  $('.strt-date').dxDateBox({
        type                : 'date',
        value               : strtDate,
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');

    //검색종료일시 년월일
    reportEndDate =  $('.end-date').dxDateBox({
        type                : 'date',
        value               : endDate,
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');
    
    //검색시작일시 시각
    reportStartTime =  $('.strt-time').dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : 80,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');

    //검색종료일시 시각
    reportEndTime =  $('.end-time').dxDateBox({
        type                : 'time',
        value               : 1645196399000,
        width               : 80,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');
    
    //보고서 구분
    reportSelect = $('.report-select').dxSelectBox({
        stylingMode     : 'outlined',
        items           : selectData,
        displayExpr     : 'display',
        value           : selectData[0],
        width           : 220,
        height          : 28,
        onItemClick(e){
            switch ( e.itemData ) {
                case selectData[0]:
                    pageName = '시설물보고서';
                    excelSheetName1 = '시설물 현황';
                    excelSheetName2 = '장애 현황';
                    $(".text1").text(excelSheetName1);
                    $(".text2").text(excelSheetName2);
                    reportTable.clearSorting();
                    reportTable2.clearSorting();
                    reportTable.columnOption('fclt_type',{
                        sortIndex    : 0, 
                        sortOrder    : "asc"
                    });
                    reportTable2.columnOption('rgst_dt',{
                        sortIndex    : 0, 
                        sortOrder    : "asc"
                    });
                    reportToggle1.summary.map((item)=>{
                        showColumn(reportTable, item)  
                    })
                    reportToggle1.incident.map((item)=>{
                        hideColumn(reportTable, item)  
                    })
                    
                    reportToggle2.error.map((item) =>{
                        showColumn(reportTable2, item)
                    })
                    reportToggle2.congest.map((item)=>{
                        hideColumn(reportTable2, item)  
                    })
                    reportTable.option('dataSource',[]);
                    reportTable2.option('dataSource',[]);
                    reportTable.option('keyExpr', selectData[0].keyExpr[0]);
                    reportTable2.option('keyExpr', selectData[0].keyExpr[1]);
                    break;
                    
                case selectData[1]:
                    pageName = '교통보고서';
                    excelSheetName1 = '돌발 현황'
                    excelSheetName2 = '지ㆍ정체 현황'
                    $(".text1").text(excelSheetName1);
                    $(".text2").text(excelSheetName2);
                    reportTable.clearSorting();
                    reportTable2.clearSorting();
                    reportTable.columnOption('incd_strt_dt',{
                        sortIndex    : 0, 
                        sortOrder    : "asc"
                    });
                    reportTable2.columnOption('prcn_dt',{
                        sortIndex    : 0, 
                        sortOrder    : "asc"
                    });
                    reportToggle1.summary.map((item)=>{
                        hideColumn(reportTable, item)  
                    })
                    reportToggle1.incident.map((item)=>{
                        showColumn(reportTable, item)  
                    })
                    reportToggle2.error.map((item) =>{
                        hideColumn(reportTable2, item)
                    })
                    reportToggle2.congest.map((item)=>{
                        showColumn(reportTable2, item)  
                    })
                    reportTable.option('dataSource',[]);
                    reportTable2.option('dataSource',[]);
                    reportTable.option('keyExpr', selectData[1].keyExpr[0]);
                    reportTable2.option('keyExpr', selectData[1].keyExpr[1]);
                    break;
                default:
                    break;
            }
           
        }
    }).dxSelectBox('instance');
   
    //상단 조회 버튼
    reportSearchBtn = $('.report-search-btn').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
        onClick(){
            reportEvent();
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    
     //반복 정체 구간 분석 테이블
     reportTable = $(".report-table").width('100%').height('100%').dxDataGrid({
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        focusedRowEnabled       : true,
        keyExpr                 : ['fclt_type'],
        selection: {
            mode: 'single',
        },
        scrolling: {
            mode: 'virtual',
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
         columns:[
            {
                dataField    : "fclt_type",
                caption      : "시설물 구분",
                alignment    : "center",
                sortIndex    : 0, 
                sortOrder    : "asc",
            },
            {
                dataField    : "cms0_cnt",
                caption      : "정상",
                alignment    : "center",
                format       : "#,###,##0"
            },
            {
                dataField    : "cms1_cnt",
                caption      : "장애",
                alignment    : "center",
                format       : "#,###,##0"
            },
            {
                dataField    : "incd_strt_dt",
                caption      : "시작일시",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "cmmn_cd_kor_nm",
                caption      : "돌발 유형",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "link_id",
                caption      : "ID",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "incd_titl",
                caption      : "돌발내용",
                alignment    : "center",
                visible      : false,
                cellTemplate(c, e) {
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
         ],
        onExporting(e){
            gridExcellExporting(e, pageName + '_' + excelSheetName1);
        },
        
    }).dxDataGrid("instance");

     //반복 정체 구간 분석 테이블
     reportTable2 = $(".report-table2").width('100%').height('100%').dxDataGrid({
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['rgst_dt','fclt_id'],
        selection: {
            mode: 'single',
        },
        scrolling: {
            mode: 'virtual',
        },
        export:{
            enabled: true,
            texts: {
                exportAll : "엑셀 파일",
            },
        },
         columns:[
            {
                dataField    : "rgst_dt",
                caption      : "장애일시",
                alignment    : "center",
                sortIndex    : 0, 
                sortOrder    : "asc",
            },
            {
                dataField    : "fclt_type",
                caption      : "장비유형",
                alignment    : "center",
                cellTemplate(c, e) {
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField    : "fclt_id",
                caption      : "ID",
                alignment    : "center",
                cellTemplate(c, e) {
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField    : "fclt_nm",
                caption      : "도로명",
                alignment    : "center",
                cellTemplate(c, e) {
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                }
            },
            {
                dataField    : "prcn_Dt",
                caption      : "가공시각",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "sped",
                caption      : "속도",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "link_id",
                caption      : "ID",
                alignment    : "center",
                visible      : false,
            },
            {
                dataField    : "cmtr_grad_cd",
                caption      : "소통등급",
                alignment    : "center",
                visible      : false,
            },
         ],
        onExporting(e){
            gridExcellExporting(e, pageName + '_' + excelSheetName2);
        },
        
    }).dxDataGrid("instance");
});

//조회 데이터 세팅
function reportEvent() {

    let FROM_DT       = null;
    let TO_DT         = null;
    let updateData    = {};

    //월,시각 null값 체크
    if ( !validationCheck( reportStartDate, reportEndDate, reportStartTime, reportEndTime )) return false;
    
    FROM_DT = getDate( reportStartDate.option('value'), reportStartTime.option('value'));
    TO_DT   = getDate( reportEndDate.option('value'), reportEndTime.option('value'));
    
    updateData[ 'FROM_DT' ] = FROM_DT;
    updateData[ 'TO_DT' ]   = TO_DT;
    finalEvent( commonUri + reportSelect.option('value').frontUri, reportSelect.option('value').endUri, updateData );
}

//테이블 및 차트 세팅
async function finalEvent( frontUri, endUri, updateData ){
    let resultCnt   = 0;
    getDataAsync(frontUri + endUri[0], (jsonData)=>{
        reportData = jsonData;
        getDataAsync(frontUri + endUri[1], (jsonData2)=>{
            reportData2 = jsonData2;
            if (reportData.length > 0){
                reportData.map((item)=>{
                    if(item.incd_strt_dt){
                        if(nullChecker(item.incd_strt_dt) !== ""){
                            item.incd_strt_dt = getParseDateTime(item.incd_strt_dt);
                        }
                    }
                })
            }
            reportTable.option( 'dataSource', reportData);
            reportTable.clearSelection();
            reportTable.option('focusedRowIndex', -1);
            resultCnt += Number(reportData.length);
            if (reportData2.length > 0){
                reportData2.map((item)=>{
                    if(item.rgst_dt){
                        if(nullChecker(item.rgst_dt) !== ""){
                            item.rgst_dt = getParseDateTime(item.rgst_dt);
                        }
                    }
                    if(item.prcn_Dt){
                        if(nullChecker(item.prcn_Dt) !== ""){
                            item.prcn_Dt = getParseDateTime(item.prcn_Dt);
                        }
                    }
                })
            }
            reportTable2.option( 'dataSource', reportData2);
            reportTable2.clearSelection();
            reportTable2.option('focusedRowIndex', -1);
            resultCnt = Number(reportData.length) + Number(reportData2.length);
            alertConfirm('데이터 조회가 완료 되었습니다. [' + resultCnt + '건]')
        }, resultCnt, updateData);
       
    }, resultCnt, updateData);
    
   
    

}
