const colorList = [
    "255,0,0",
    "255,128,128",
    "255,255,128",
    "128,255,128",
    "0,255,128",
    "128,255,255",
    "0,128,255",
    "255,128,192",
    "255,128,255",
    "255,255,0",
    "128,255,0",
    "0,255,64",
    "0,255,255",
    "0,128,192",
    "128,128,192",
    "255,0,255",
    "128,64,64",
    "255,128,64",
    "0,255,0",
    "0,128,128",
    "0,64,128",
    "128,128,255",
    "128,0,64",
    "255,0,128",
    "128,0,0",
    "255,128,0",
    "0,128,0",
    "0,128,64",
    "0,0,255",
    "0,0,160",
    "128,0,128",
    "128,0,255",
    "64,0,0",
    "128,64,0",
    "0,64,0",
    "0,64,64",
    "0,0,128",
    "0,0,64",
    "64,0,64",
    "64,0,128",
    "0,0,0",
    "128,128,0",
    "128,128,64",
    "128,128,128",
    "64,128,128",
    "192,192,192",
    "64,0,64",
    "255,255,255",
];
//code에 따른 컬러 설정
const cmtrColor = [
    {
        name: "LTC0",
        color: "#888888",
    },
    {
        name: "LTC1",
        color: "#15B337",
    },
    {
        name: "LTC2",
        color: "#FFAA00",
    },
    {
        name: "LTC3",
        color: "#ff0000",
    },
];

let _trafficMap = null;
if( window.opener ) {
    _trafficMap = window.opener.$trafficMap;
}

const chartDataSource = [
    {
        id: 1,
        name: "LINE DIAGRAM",
        icon: "line",
        items: [
            {
                beginGroup: true,
                id: "0",
                name: "Bar Diagram",
                type: "bar",
                icon: "bar",
            },
            {
                beginGroup: true,
                id: "1",
                name: "Column Diagram",
                type: "column",
                icon: "column",
            },
            {
                beginGroup: true,
                id: "2",
                name: "Line Diagram",
                type: "line",
                icon: "line",
            },
        ],
    },
];


//시간 00:00:00
const firstSettingTime = 1645110000000;

//시간 23:59:59
const endSettingTime = 1645196399000;

//모달창
let modalDiv = $('<div class="modal-background"></div>');
modalDiv.append(
    $(
        '<div class="modal-screen b0">' +
            '<div class="serve-title color modal-title">' +
            '<span style="margin-left: auto;margin-right: 10px;"><div class="modal-cancle"></div></span>' +
            "</div>" +
            '<div class="modal-content b2"></div>' +
            '<div class="modal-button">' +
            "<div>" +
            '<div class="modal-cancle-Btn"></div>' +
            "</div>" +
            "<div>" +
            '<div class="modal-save-Btn"></div>' +
            "</div>" +
            "</div>" +
            "</div>"
    )
);

//미선택 알러트
function notSelectMsg(pageMsg) {
    alertWarning(pageMsg + "가 선택 되지 않았습니다.<br>" + pageMsg + " 목록에서 " + pageMsg + "를 선택해주세요");
}

//조회 결과 메세지
function selResultMsg(box) {
    alertConfirm("데이터 조회가 완료 되었습니다. [" + box.length + "건]");
}

//추가 및 수정 결과 메세지
function insResultMsg(msg) {
    alertConfirm(msg + " 정보가 저장 되었습니다.");
}

//삭제 결과 메세지
function delResultMsg(msg) {
    alertConfirm(msg + " 정보가 삭제 되었습니다.");
}

function nullChecker(checkItem) {
    let item = "";
    if (!(checkItem === undefined || checkItem === null || checkItem === "")) {
        item = checkItem;
    }
    return item;
}

function timeFormmater(time) {
    let result = time < 10 ? "0" + time.toString() : time.toString();
    return result;
}

function ternaryOperator(item, trueValue, FalseValue) {
    let result = item === FalseValue ? trueValue : FalseValue;
    return result;
}
function sendErrorMsg(error) {
    const jsonError = error.responseJSON;
    console.log(error);
    const timestamp = jsonError.timestamp.replace(/T/g, " ").substring(0, 19);
    alertError(
        `발생시각 : ${timestamp}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;상태 : ${jsonError.status}
        <br> &nbsp;&nbsp;&nbsp;&nbsp;에러명 : ${jsonError.title}
        <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;내용 : ${jsonError.message}
        <br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;경로 : ${jsonError.path}
        <br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;에러 : ${jsonError.errors}`,
        "작업 실행 중 오류가 발생하였습니다."
    );
}
function getData(url, dataArray, param, errFunc) {
    $.ajax({
        url: _apiUrl + url,
        type: "get",
        async: false,
        dataType: "json",
        data: param,
        success: function (data) {
            dataArray.push(data);
        },
        error: function (error) {
            console.log(error);
            //return error.responseJSON;
            if (errFunc) {
                errFunc(error.responseJSON);
            } else {
                ////팝업창......
                if (error.responseJSON) {
                    // 400: Bad Request
                    // 404: Not Found
                    // 417, Expectation Failed
                    let errorObj = error.responseJSON;
                    if (errorObj.status !== 404) {
                        sendErrorMsg(error);
                    }
                }
            }
        },
    });
}

function getDataAsync(url, successCallbackFunc, argument, param, behindLoading) {
    let global = true;
    if (behindLoading) {
        global = false;
    }
    $.ajax({
        url: _apiUrl + url,
        type: "get",
        dataType: "json",
        data: param,
        global: global,
        success: function (data) {
            successCallbackFunc(data, argument);
        },
        error: function (error) {
            if (error.responseJSON) {
                let errorObj = error.responseJSON;
                // 400: Bad Request
                // 404: Not Found
                // 417, Expectation Failed
                if (errorObj.status !== 404) {
                    sendErrorMsg(error);
                }
            }
        },
    });
}

function validationCheck(startDate, endDate, startTime, endTime) {
    if (startDate) {
        if (
            nullChecker(startDate.option("value")) === "" ||
            startDate.option("validationError") !== null ||
            new Date(startDate.option("value")).getFullYear() < 1000 ||
            new Date(startDate.option("value")).getFullYear() >= 10000
        ) {
            alertWarning("검색 시작일이 없거나 형식에 맞지 않습니다.", null, startDate);
            return false;
        }
    }

    if (endDate) {
        if (
            nullChecker(endDate.option("value")) === "" ||
            endDate.option("validationError") !== null ||
            new Date(endDate.option("value")).getFullYear() < 1000 ||
            new Date(endDate.option("value")).getFullYear() >= 10000
        ) {
            alertWarning("검색 종료 일이 없거나 형식에 맞지 않습니다.", null, endDate);
            return false;
        }
    }

    if (startTime) {
        if (nullChecker(startTime.option("value")) === "" || startTime.option("validationError") !== null) {
            alertWarning("검색 시작 시각이 없거나 형식에 맞지 않습니다.", null, startTime);
            return false;
        }
    }

    if (endTime) {
        if (nullChecker(endTime.option("value")) === "" || endTime.option("validationError") !== null) {
            alertWarning("검색 종료 시각이 없거나 형식에 맞지 않습니다.", null, endTime);
            return false;
        }
    }
    return true;
}

function timeSetup(param) {
    let result = "";
    let time = new Date(new Date().setTime(param));
    param = time.toTimeString().substring(0, time.toTimeString().indexOf(" "));
    result += param.substring(0, param.indexOf(":"));
    result += param.substring(param.indexOf(":") + 1, param.lastIndexOf(":"));
    result += param.substring(param.lastIndexOf(":") + 1, param.length);
    return result;
}

function getPostData(url, dataArray, param) {
    $.ajax({
        url: _apiUrl + url,
        type: "POST",
        async: false,
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(param),
        success: function (data) {
            dataArray.push(data);
        },
        error: function (error) {
            console.log(error);
            if (error.responseJSON) {
                let errorObj = error.responseJSON;
                // 400: Bad Request
                // 404: Not Found
                // 417, Expectation Failed
                if (errorObj.status !== 404) {
                    sendErrorMsg(error);
                }
            }
        },
    });
}

function getPostDataAsync(url, successCallbackFunc, param, behindLoading) {
    let global = true;
    if (behindLoading) {
        global = false;
    }
    $.ajax({
        url         : _apiUrl + url,
        type        : "POST",
        dataType    : "json",
        global      : global,
        contentType : "application/json; charset=utf-8",
        data        : JSON.stringify(param),
        success: function (data) {
            successCallbackFunc(data);
        },
        error: function (error) {
            if (error.responseJSON) {
                let errorObj = error.responseJSON;
                // 400: Bad Request
                // 404: Not Found
                // 417, Expectation Failed
                if (errorObj.status !== 404) {
                    sendErrorMsg(error);
                }
            }
        },
    });
}

function getDate(date, time) {
    return dateFormmater(new Date(date)) + timeSetup(time);
}

function getSendDate(dateParam) {
    let year = dateParam.getFullYear().toString();
    let month = timeFormmater(dateParam.getMonth() + 1).toString();
    let date = timeFormmater(dateParam.getDate()).toString();
    let hour = timeFormmater(dateParam.getHours()).toString();
    let minutes = timeFormmater(dateParam.getMinutes()).toString();
    let seconds = timeFormmater(dateParam.getSeconds()).toString();
    return year + month + date + hour + minutes + seconds;
}

function getSendTime(timeParam) {
    time = timeSetup(timeParam).substring(0, 4);
    return time;
}

function postInsertUpdate(url, data) {
    let cnt = 0;
    $.ajax({
        url: _apiUrl + url,
        method: "POST",
        async: false,
        type: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(data),
        success: function (res) {
            cnt++;
        },
        error: function (error) {
            ////팝업창......
            if (error.responseJSON) {
                sendErrorMsg(error);
            }
        },
    });
    return cnt;
}

function postImageChange(url, data, recFunc) {
    let cnt = 0;
    $.ajax({
        url: _apiUrl + url,
        method: "POST",
        async: false,
        type: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(data),
        success: function (res) {
            return recFunc(res);
        },
        error: function (error) {
            cnt = 0;
            if (error.responseJSON) {
                let errorObj = error.responseJSON;
                // 400: Bad Request
                // 404: Not Found
                // 417, Expectation Failed
                if (errorObj.status !== 404) {
                    sendErrorMsg(error);
                }
            }
        },
    });
    return cnt;
}

function putUpdate(url, data) {
    let cnt = 0;
    $.ajax({
        url: _apiUrl + url,
        method: "PUT",
        async: false,
        type: "json",
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(data),
        success: function (res) {
            cnt++;
        },
        error: function (error) {
            if (error.responseJSON) {
                sendErrorMsg(error);
            }
        },
    });
    return cnt;
}

function getPkData(data, array, pkKey) {
    array = [];
    data[0].map((item) => {
        array.push(item[pkKey]);
    });
    return array;
}

function deleteDataIds(url, ids) {
    let cnt = 0;
    $.ajax({
        url: _apiUrl + url,
        type: "DELETE",
        async: false,
        dataType: "json",
        data: JSON.stringify(ids),
        contentType: "application/json; charset=utf-8",
        success: function (res) {
            cnt = 1;
        },
        error: function (error) {
            cnt = 0;
            if (error.responseJSON) {
                sendErrorMsg(error);
            }
        },
    });
    return cnt;
}

function deleteData(url, id) {
    let cnt = 0;
    $.ajax({
        url: _apiUrl + url + "/" + id,
        type: "DELETE",
        async: false,
        dataType: "json",
        contentType: "application/json; charset=utf-8",
        success: function (res) {
            cnt = 1;
        },
        error: function (error) {
            cnt = 0;
            if (error.responseJSON) {
                sendErrorMsg(error);
            }
        },
    });
    return cnt;
}

function nowTime() {
    let now = new Date();
    let year = now.getFullYear().toString();
    let month = timeFormmater(now.getMonth() + 1).toString();
    let date = timeFormmater(now.getDate()).toString();
    let hour = timeFormmater(now.getHours()).toString();
    let minutes = timeFormmater(now.getMinutes()).toString();
    let seconds = timeFormmater(now.getSeconds()).toString();
    return year + "-" + month + "-" + date + " " + hour + ":" + minutes + ":" + seconds;
}

function dateTimeFormmater(dateParam) {
    let year = dateParam.getFullYear().toString();
    let month = timeFormmater(dateParam.getMonth() + 1).toString();
    let date = timeFormmater(dateParam.getDate()).toString();
    let hour = timeFormmater(dateParam.getHours()).toString();
    let minutes = timeFormmater(dateParam.getMinutes()).toString();
    let seconds = timeFormmater(dateParam.getSeconds()).toString();
    return year + "-" + month + "-" + date + " " + hour + ":" + minutes + ":" + seconds;
}

function excellTime() {
    let now = new Date();
    let year = now.getFullYear().toString();
    let month = timeFormmater(now.getMonth() + 1).toString();
    let date = timeFormmater(now.getDate()).toString();
    let hour = timeFormmater(now.getHours()).toString();
    let minutes = timeFormmater(now.getMinutes()).toString();
    let seconds = timeFormmater(now.getSeconds()).toString();
    return year + month + date + hour + minutes + seconds;
}

function dateFormmater(dateVal) {
    let year = dateVal.getFullYear().toString();
    let month = timeFormmater(dateVal.getMonth() + 1).toString();
    let date = timeFormmater(dateVal.getDate()).toString();
    return year + month + date;
}

function getParseDateTime(param) {
    if (param.length <= 14) {
        let str = "";
        str += param.substring(0, 4);
        str += "-";
        str += param.substring(4, 6);
        str += "-";
        str += param.substring(6, 8);
        str += " ";
        str += param.substring(8, 10);
        str += ":";
        str += param.substring(10, 12);
        str += ":";
        str += param.substring(12, 14);
        return str;
    }
    else {
        return param;
    }
}

function getGridDateTime(param) {
    if (param.length <= 19) {
        let str = "";
        str += param.substring(0, 4);
        str += param.substring(5, 7);
        str += param.substring(8, 10);
        str += param.substring(11, 13);
        str += param.substring(14, 16);
        str += param.substring(17, 19);
        return str;
    }
    else {
        return param;
    }
}

function getParseDate(param) {
    if (param.length <= 8) {
        let str = "";
        str += param.substring(0, 4);
        str += "-";
        str += param.substring(4, 6);
        str += "-";
        str += param.substring(6, 8);
        return str;
    }
    else{
        return param
    }
}

function getParseMonth(param) {
    if (param.length <= 6) {
        let str = "";
        str += param.substring(0, 4);
        str += "-";
        str += param.substring(4, 6);
        return str;
    }
    else {
        return param;
    }
}

function showBtn(item) {
    item.option("visible", true);
}

function hideBtn(item) {
    item.option("visible", false);
}

function dsblOnBtn(item) {
    item.option("disabled", true);
}

function dsblOffBtn(item) {
    item.option("disabled", false);
}

function refresh(item, array, url) {
    array = [];
    getData(url, array);
    item.option("dataSource", array[0]);
    return array;
}

function showColumn(item, column) {
    item.columnOption(column, "visible", true);
}

function hideColumn(item, column) {
    item.columnOption(column, "visible", false);
}

//차트 페이지 네이션
function pageNation(chart, xAxis) {
    $(".first-page").off("click");
    $(".next-page").off("click");
    $(".prev-page").off("click");
    $(".end-page").off("click");
    const stepWidth = 15;
    chart.xAxis[0].setExtremes(null);
    if (xAxis.length > stepWidth) {
        chart.xAxis[0].setExtremes(0, stepWidth);

        // the button action
        $(".first-page").on("click", function () {
            chart.xAxis[0].setExtremes(0, stepWidth);
        });

        $(".next-page").on("click", function () {
            const currentMin = chart.xAxis[0].getExtremes().min;
            const currentMax = chart.xAxis[0].getExtremes().max;
            if (currentMax + stepWidth >= xAxis.length) {
                chart.xAxis[0].setExtremes(xAxis.length - 15, xAxis.length - 1);
                return false;
            }
            chart.xAxis[0].setExtremes(currentMin + stepWidth, currentMax + stepWidth);
        });

        $(".prev-page").on("click", function () {
            const currentMin = chart.xAxis[0].getExtremes().min;
            const currentMax = chart.xAxis[0].getExtremes().max;
            if (currentMin - stepWidth <= 0) {
                chart.xAxis[0].setExtremes(0, stepWidth);
                return false;
            }
            chart.xAxis[0].setExtremes(currentMin - stepWidth, currentMax - stepWidth);
        });

        $(".end-page").on("click", function () {
            chart.xAxis[0].setExtremes(xAxis.length - 15, xAxis.length - 1);
        });
    }
}

function setValue(box, value) {
    box.option("value", value);
}

function getValue(box) {
    return box.option("value");
}

//date box 시간 세팅
function modalTimeFommat(date, time) {
    return new Date(getParseDateTime(getDate(getValue(date.box), getValue(time.box))));
}

function fetchMapIconBar(appendPosition, mapManager, lyrIdx, pageName) {
    const iconBar = $(
        `<div>
    <div>
        <div class="capture-btn"></div>
        <a id="image-download" style="display: none"></a>
    </div>
    <div>
        <div class="globe-btn"></div>
    </div>
    <div>
        <div class="zoom-btn"></div>
    </div>
    <div>
        <div class="zoom-out-btn"></div>
    </div>
    <div>
        <div class="refresh-btn"></div>
    </div>
    <div>
        <div class="map-toggle-check"></div>
    </div>
</div>
`
    );

    const captureBtnPosition = iconBar.children().eq(0).children().eq(0);
    const globeBtnPosition = iconBar.children().eq(1).children().eq(0);
    const zoomBtnPosition = iconBar.children().eq(2).children().eq(0);
    const zoomOutBtnPosition = iconBar.children().eq(3).children().eq(0);
    const refreshBtnPosition = iconBar.children().eq(4).children().eq(0);
    const mapTogglePosition = iconBar.children().eq(5).children().eq(0);

    const captureBtn = creatBtn(captureBtnPosition, "save", null, "저장", "text");
    const globeBtn = creatBtn(globeBtnPosition, "globe", null, "표준 영역", "text");
    const zoomBtn = creatBtn(zoomBtnPosition, "plus", null, "확대", "text");
    const zoomOutBtn = creatBtn(zoomOutBtnPosition, "minus", null, "축소", "text");
    const refreshBtn = creatBtn(refreshBtnPosition, "refresh", null, "새로고침", "text");
    const mapToggleChek = mapTogglePosition
        .dxCheckBox({
            value: true,
            text: "위성지도",
        })
        .dxCheckBox("instance");

    captureBtn.on("click", function () {
        mapManager.saveImage(pageName, "image-download");
    });

    globeBtn.on("click", function () {
        mapManager.stdExtent();
    });

    zoomBtn.on("click", function () {
        mapManager.zoomIn();
    });

    zoomOutBtn.on("click", function () {
        mapManager.zoomOut();
    });

    refreshBtn.on("click", function () {
        mapManager.refreshMap();
        mapManager.updateSize();
    });

    mapToggleChek.on("valueChanged", function (e) {
        mapManager.toggleBaseMap(e.value);
    });

    $(appendPosition).append(iconBar);
}

function creatBtn(position, icon, text, hint, stylingMode, method, width, disabled, visible, height) {
    const btn = position
        .dxButton({
            icon: icon,
            text: text,
            hint: hint,
            width: width,
            height: height,
            disabled: disabled,
            visible: visible,
            stylingMode: stylingMode,
            onClick() {
                if (method) {
                    method();
                }
            },
        })
        .dxButton("instance");

    return btn;
}

function alertError(AMessage, ATitle, id) {
    return alertMessage("fa fa-warning", "red", "btn-red", AMessage, ATitle, id);
}

function alertWarning(AMessage, ATitle, id) {
    //return alertMessage("fa fa-asterisk", "blue", "btn-blue", AMessage, ATitle, id);
    return alertMessage("fa fa-warning", "red", "btn-red", AMessage, ATitle, id);
}

function alertConfirm(AMessage, ATitle, id) {
    return alertMessage("fa fa-info-circle", "blue", "btn-blue", AMessage, ATitle, id);
}

function alertMessage(icon, type, btnClass, AMessage, ATitle, id) {
    if (id) {
        id.focus();
    }
    const title = ATitle ?? document.title;
    const message = AMessage;
    $.alert({
        useBootstrap: false,
        title: title,
        content: message,
        titleClass: type,
        //theme: "dark",
        type: type,
        typeAnimated: true,
        columnClass: "col-md-4 col-md-offset-4",
        icon: icon,
        closeIcon: true,
        closeIcon: "close",
        closeIconClass: "fa fa-close " + type,
        draggable: true,
        escapeKey: true,
        backgroundDismiss: false,
        backgroundDismissAnimation: "glow",
        buttons: {
            close: {
                text: " 확 인 ",
                btnClass: btnClass,
                keys: ["enter"],
                action: function () {
                    if (id) {
                        id.focus();
                    }
                },
            },
        },
    });
    return false;
}

function confirmMessage(AMessage, ATitle) {
    const title = ATitle ?? document.title;
    const message = AMessage;
    const ok = new $.Deferred();
    $.alert({
        useBootstrap: false,
        title: title,
        titleClass: "blue",
        content: message,
        //theme: "dark",
        type: "blue",
        typeAnimated: true,
        columnClass: "small",
        icon: "fa fa-check",
        closeIcon: true,
        closeIcon: "cancel",
        closeIconClass: "fa fa-close blue",
        draggable: true,
        escapeKey: false,
        backgroundDismiss: false,
        backgroundDismissAnimation: "glow",
        buttons: {
            close: {
                text: " 확 인 ",
                btnClass: "btn-blue",
                action: function () {
                    ok.resolve(true);
                },
            },
            cancel: {
                text: " 취 소 ",
                //btnClass: "btn-blue",
                action: function () {
                    ok.resolve(false);
                },
            },
        },
    });
    return ok.promise();
}


function CsAppLauncher(options) {
    if (!options) {
        throw new Error("no options");
    }

    let hasFocus = true;
    let didHide = false;
    // window is blurred when dialogs are shown
    function onBlur() {
        hasFocus = false;
    }

    // document is hidden when native app is shown or browser is back grounded
    function onVisibilityChange(e) {
        if (e.target.visibilityState === "hidden") {
            didHide = true;
        }
    }

    // window is focused when dialogs are hidden, or browser comes into view
    function onFocus() {
        if (didHide) {
            if (options.onReturn) {
                options.onReturn();
            }
            didHide = false; // reset
        } else {
            // ignore duplicate focus event when returning from native app on
            // iOS Safari 13.3+
            if (!hasFocus && options.onFallback) {
                // wait for app switch transition to fully complete - only then is
                // 'visibilitychange' fired
                setTimeout(function () {
                    // if browser was not hidden, the deep link failed
                    if (!didHide) {
                        options.onFallback();
                    }
                }, 1000);
            }
        }
        hasFocus = true;
    }

    // add/remove event listeners
    // `mode` can be "add" or "remove"
    function bindEvents(mode) {
        [
            [window, "blur", onBlur],
            [document, "visibilitychange", onVisibilityChange],
            [window, "focus", onFocus],
        ].forEach(function (conf) {
            conf[0][mode + "EventListener"](conf[1], conf[2]);
        });
    }

    // add event listeners
    bindEvents("add");

    // expose public API
    this.destroy = bindEvents.bind(null, "remove");
    
    this.openURL = function (url) {
        const dialogTimeout = 3000;
        setTimeout(()=> {
            if (hasFocus && options.onIgnored) {
                console.log(window);
                options.onIgnored();
            }
        }, dialogTimeout);
        // window.location = url;
        try {
            window.location.href = url;
        } catch (e) {
            console.error(e);
        }
    };
}

function vmsFormEditDownload(){
            const filePath = "/download/vmsFormEdit-setup.exe";
            const fileName = "vmsFormEdit-setup.exe";
            let element = $('<a>');
            element.prop('href', filePath);
            element.prop('download', fileName);
            element[0].click();
}

function gridExcellExporting(gridInfo, pageName){
    if (!gridInfo.component.option('dataSource') || gridInfo.component.option('dataSource').length <= 0) {
        return alertWarning('조회된 데이터가 없습니다.');
    }
    else {
        const workbook = new ExcelJS.Workbook();
        const worksheet = workbook.addWorksheet(pageName);
        
        DevExpress.excelExporter.exportDataGrid({
            component: gridInfo.component,
            worksheet,
            autoFilterEnabled: true,
        }).then(() => {
            workbook.xlsx.writeBuffer().then((buffer) => {
                saveAs(new Blob([buffer], { type: 'application/octet-stream' }), pageName + '_' + excellTime() + '.xlsx');
            });
        });
        gridInfo.cancel = true;
    }
}

function createLoadingDiv(){
    const div = $(`<div class="loading-box">
            <img class="loading-img" alt="" width="150" height="150" src="/images/loading.png">
        </div>`);
    return div;
}

$(()=>{
    const loadingDiv = createLoadingDiv();
    $('body').append(loadingDiv);
    $('html').css({width:'calc(100% - 2px)', height:'calc(100% - 2px)', border: '1px solid #524f4f'})
    //부모창 종료 시 팝업 종료
    $(opener).bind("beforeunload", ()=>{
        window.close();
    });

}).ajaxStart(function(){
    $('.loading-box').css('display','flex');
}).ajaxStop(function(){
    $('.loading-box').css('display','none');
});

class dxBtn{
    constructor(position, text, icon, stylingMode, width, height) {
        this.position    = position;
        this.text        = text;
        this.icon        = icon;
        this.stylingMode = stylingMode;
        this.width       = width;
        this.height      = height;
        this.button      = this.position.dxButton({
            text        : this.text,
            icon        : this.icon,
            stylingMode : this.stylingMode,
            width       : this.width,
            height      : this.height,
        }).dxButton('instance');
    }
    setDisabled(stts) {
        this.button.option('disabled', stts);
    }
    setVisible(stts) {
        this.button.option('visible', stts);
    }
    onClick(method) {
        this.button.on('click', ()=> method());
    }
    offClick() {
        this.button.off('click');
    }
}

class dxTxt{
    constructor(position, column, max, label, width, height, placeholder){
        this.position    = position;
        this.column      = column;
        this.max         = max;
        this.label       = label;
        this.width       = width;
        this.heigt       = height;
        this.placeholder = placeholder;
        this.text        = this.position.dxTextBox({
            width       : this.width,
            height      : this.heigt,
            stylingMode : 'outlined',
            maxLength   : this.max,
            placeholder : this.placeholder,
        }).dxTextBox('instance');
        this.value       = ()=>{
            return this.text.option('value');
        }
    }

    setValue(value){
        this.text.option('value', value);
    }
    onValueChanged(method){
        this.text.on('valueChanged', (e)=>{
            method(e);
        })
    }
    setDisabled(stts) {
        this.text.option('disabled', stts);
    }
    setVisible(stts) {
        this.text.option('visible', stts);
    }
    setReadOnly(stts) {
        this.text.option('readOnly', stts);
    }
}

class dxDate{
    constructor(position, format, label, width, height, type, interval){
        this.position      = position;
        this.format        = format;
        this.type          = type;
        this.label         = label;
        this.width         = width;
        this.heigt         = height;
        this.interval      = interval;
        this.text          = this.position.dxDateBox({
            width               : this.width,
            height              : this.heigt,
            type                : type,
            stylingMode         : 'outlined',
            displayFormat       : this.format,
            interval            : this.interval,
            invalidDateMessage  : '형식에 맞게 입력해주세요',
        }).dxDateBox('instance');
        this.value         = ()=>{
            return this.text.option('value');
        };
    }

    setValue(value){
        this.text.option('value', value);
    }
    getSendDataValue(){
        const value = this.value();
        if (value) {
            return getSendDate(new Date(value));
        }
    }
    getSendTimeValue(){
        const value = this.value(); 
        if (value) {
            return getSendTime(value);
        }
    }
    onValueChanged(method){
        this.text.on('valueChanged', (e)=>{
            method(e);
        })
    }
    setDisabled(stts) {
        this.text.option('disabled', stts);
    }
    setVisible(stts) {
        this.text.option('visible', stts);
    }
    setReadOnly(stts) {
        this.text.option('readOnly', stts);
    }
}



function perentSettings(key, type){
    getDataAsync(commonUri + '/list', recvListData, [key, type]);
}

function recvListData(jsonData, args){
    const key = args[0];
    const type = args[1];
    if (jsonData.length > 0) {
        const openerList       = opener.$('.mont-list').dxSelectBox('instance');
        const openerNm         = getValue(openerList);
        const updateMornitorNm = getValue(nameText);
        const selectedData     = listTable.getSelectedRowsData();

        openerList.option('dataSource', jsonData);
        listTable.option('dataSource', jsonData);

        if (selectedData.length > 0) {
            if ( openerNm === selectedData[0].monitoring_nm ) {
                const searchNm = key ? updateMornitorNm : jsonData[0].monitoring_nm;
                getDataAsync(commonUri + "/" + searchNm, recvMonSectionData, [type, searchNm, openerList]);
            }
        }
        listTable.clearSelection();
        listTable.option('focusedRowIndex', -1);
        if (key) {
            listTable.selectRows(key, true);
            listTable.option('focusedRowKey', key);
        }
    }
}

function recvMonSectionData(jsonData, args){
    const type       = args[0];
    const searchNm   = args[1];
    const openerList = args[2];
    if (type !== 'add') {
        setValue(openerList, searchNm);
        window.opener.montSection(jsonData);
    }
}

//바이트 수 체크
function getByteLength(s,b,i,c){
    s = s.toString();
    for (b=i=0;c=s.charCodeAt(i++);b+=c>>11?3:c>>7?2:1);
    return b;
}
