let selectBox = null;
let searchButton = null;
let textBox = null;
let mainMapPopUpTb = null;
let searchData = [];
let commonUri = "/api/manage/main/search";
let visibleArr = {
    node: {
        visible: ["node_id", "node_name", "node_type_desc"],
        devisible: ["link_id", "road_name", "road_id", "from_node", "to_node", "ifsc_id", "drct_desc", "ifsc_nm", "strt_nm", "end_nm"],
    },
    link: {
        visible: ["link_id", "road_name", "from_node", "to_node"],
        devisible: ["node_id", "node_name", "road_id", "node_type_desc", "ifsc_id", "drct_desc", "ifsc_nm", "strt_nm", "end_nm"],
    },
    ifsc: {
        visible: ["ifsc_id", "drct_desc", "ifsc_nm", "strt_nm", "end_nm"],
        devisible: ["link_id", "road_name", "road_id", "node_id", "node_name", "node_type_desc", "from_node", "to_node"],
    },
    road: {
        visible: ["road_id", "road_name", "drct_desc", "strt_nm", "end_nm"],
        devisible: ["node_id", "node_name", "node_type_desc", "from_node", "to_node", "link_id", "ifsc_id", "ifsc_nm"],
    },
};
$(() => {
    selectBox = $(".select-box")
        .dxSelectBox({
            dataSource: [
                {
                    id: "node",
                    title: "노드",
                },
                {
                    id: "link",
                    title: "링크",
                },
                {
                    id: "ifsc",
                    title: "정보제공구간",
                },
                {
                    id: "road",
                    title: "도로",
                },
            ],
            value: "node",
            valueExpr: "id",
            displayExpr: "title",
            width: 125,
            height: 30,
            stylingMode: "outlined",
            onItemClick(item) {
                mainMapPopUpTb.option("dataSource", []);
                const value = item.itemData.id;
                for (key in visibleArr[value].visible) {
                    showColumn(mainMapPopUpTb, visibleArr[value].visible[key]);
                }
                for (key in visibleArr[value].devisible) {
                    hideColumn(mainMapPopUpTb, visibleArr[value].devisible[key]);
                }
                searchButton.off("click");
                searchButton.on("click", () => searchMap(value, getValue(textBox)));
            },
        })
        .dxSelectBox("instance");

    textBox = $(".text-box")
        .dxTextBox({
            width: 220,
            height: 30,
            stylingMode: "outlined",
            onEnterKey(e) {
                searchMap(getValue(selectBox), getValue(e.component));
            },
        })
        .dxTextBox("instance");

    searchButton = $(".search-btn")
        .dxButton({
            width: 80,
            height: 30,
            stylingMode: "outlined",
            icon: "refresh",
            text: "조회",
        })
        .dxButton("instance")
        .on("click", () => searchMap("node", getValue(textBox)));

    mainMapPopUpTb = $(".main-map-pop-up-tb")
        .width("100%")
        .height("100%")
        .dxDataGrid({
            dataSource: [],
            allowColumnReordering: true,
            allowColumnResizing: true,
            showBorders: true,
            showColumnLines: true,
            rowAlternationEnabled: true,
            columnAutoWidth: true,
            noDataText: "표출할 정보가 없습니다.",
            selection: {
                mode: "single",
            },
            scrolling: {
                mode: "virtual",
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            columns: [
                {
                    dataField: "node_id",
                    alignment: "center",
                    dataType : 'string',
                    caption: "ID",
                },
                {
                    dataField: "link_id",
                    alignment: "center",
                    caption: "ID",
                    visible: false,
                },
                {
                    dataField: "ifsc_id",
                    alignment: "center",
                    dataType : 'string',
                    caption: "ID",
                    visible: false,
                },
                {
                    dataField: "road_id",
                    alignment: "center",
                    dataType : 'string',
                    caption: "ID",
                    visible: false,
                },
                {
                    dataField: "node_name",
                    alignment: "center",
                    caption: "노드명",
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "road_name",
                    alignment: "center",
                    caption: "도로명",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "ifsc_nm",
                    alignment: "center",
                    caption: "명칭",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "node_type_desc",
                    alignment: "center",
                    caption: "노드유형",
                },

                {
                    dataField: "drct_desc",
                    alignment: "center",
                    caption: "방향",
                    visible: false,
                },
                {
                    dataField: "from_node",
                    alignment: "center",
                    caption: "시작노드",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "to_node",
                    alignment: "center",
                    caption: "종료노드",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "strt_nm",
                    alignment: "center",
                    caption: "시점명",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
                {
                    dataField: "end_nm",
                    alignment: "center",
                    caption: "종점명",
                    visible: false,
                    cellTemplate(c,e){
                        c.css('text-align', 'left');
                        c.text(e.displayValue);
                    }
                },
            ],
            onRowDblClick(row) {
                selectGisData(row);
            },
        })
        .dxDataGrid("instance");
        window.addEventListener('beforeunload', function(){
            window.opener.$("#search-map").dxCheckBox('instance').option('value', false);
        });
});
function searchMap(url, text) {
    searchData = [];
    getData(commonUri + '/' +  encodeURIComponent(url), searchData, { filter: text });
    mainMapPopUpTb.option("dataSource", searchData[0]);
}

function selectGisData(ARow) {
    let type = null;
    let id = null;
    console.log(ARow.data);
    if (ARow.data.node_id) {
        type = 0;
        id = ARow.data.node_id;
    } else if (ARow.data.link_id) {
        type = 1;
        id = ARow.data.link_id;
    } else if (ARow.data.ifsc_id) {
        type = 2;
        id = ARow.data.ifsc_id;
    } else if (ARow.data.road_id) {
        type = 3;
        id = ARow.data.road_id;
    }
    console.log(type, id);
    if (type !== null) {
        try {
            window.opener.selectGisData(type, id);
        } catch (err) {
            console.error(err);
        }
    }
}
