import { TMapMngr, TFclt } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex } from "/js/vworld/map-const.js";

let _mapManager = null;
let _selectFcltNmbr = null;
const _lyrIdx = LayerIndex.Cctv;

//우측 섹션 관련
let _managerData    = [];
let _managerTable   = null;
let _idArr          = [];
let cctvNo          = null;
let cctvId          = null;
let cctvX           = null;
let cctvY           = null;
let ctrlIp          = null;
let cctvEncdIp      = null;
let ctlrPort        = null;
let lctnNm          = null;
let istlAddr        = null;
let strmSesnNm      = null;
let outRstp         = null;
let outRtmp         = null;
let outHttp         = null;
let saveBtn         = null;
let cancleBtn       = null;
let addBtn          = null;
let delBtn          = null;
let editBtn         = null;
let addNum          = 0;
const ipExpr = /^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$/;
const _updateColumns = {
    area_cd:  null,
    cctv_area_dvsn:  "1",
    cctv_capt_ip:  null,
    cctv_capt_port:  null,
    cctv_chnl: 0,
    cctv_ctlr_id:  null,
    cctv_ctlr_ip:  null,
    cctv_ctlr_port:  null,
    cctv_encd_ip:  null,
    cctv_fibr_ip:  null,
    cctv_id:  null,
    cctv_mngm_nmbr: 0,
    cctv_sbst_dspl_yn:  "N",
    cctv_sbst_imgn:  null,
    cctv_type:  "1",
    del_yn: "N",
    frst_regr_nmbr:  null,
    frst_rgst_dt:  null,
    intr_rtmp_addr:  null,
    istl_lctn_addr:  null,
    istl_lctn_nm:  null,
    last_crct_dt:  null,
    last_crpr_nmbr:  null,
    link_id: 0,
    node_id: 0,
    rely_port:  null,
    strm_http_addr:  null,
    strm_rtmp_addr:  null,
    strm_rtsp_addr:  null,
    strm_sesn_nm:  null,
    strm_stor_addr:  null,
    strm_svr_ip:  null,
    strm_svr_port:  null,
    syop_cntl_yn:  "N",
    x_crdn: 0,
    y_crdn: 0
};


//공통
let commonUri = "/api/cctv/manager/info";
const _pageName = 'CCTV 기본정보 관리';
const pageMsg = "CCTV";
const inputArr = [
    (cctvNo = {
        box      : null,
        option   : 240,
        disabled : true,
        label    : "CCTV 관리번호",
        column   : "cctv_mngm_nmbr",
        max      : 10,
        must     : true,
    }),
    (cctvId = {
        box      : null,
        option   : 240,
        disabled : false,
        label    : "제어기 ID",
        column   : "cctv_ctlr_id",
        id       : true,
        max      : 30,
        must     : true,
    }),
    (ctrlIp = {
        box      : null,
        option   : 240,
        label    : "제어기 IP",
        disabled : false,
        must     : true,
        expr     : ipExpr,
        column   : "cctv_ctlr_ip",
        max      : 15,
    }),
    (ctlrPort = {
        box      : null,
        option   : 240,
        label    : "제어기 PORT",
        disabled : false,
        port     : true,
        column   : "cctv_ctlr_port",
        max      : 5,
    }),
    (lctnNm = {
        box      : null,
        option   : 240,
        label    : "위치명",
        must     : true,
        disabled : false,
        column   : "istl_lctn_nm",
        max      : 40,
    }),
    (istlAddr = {
        box      : null,
        option   : 240,
        label    : "설치주소",
        disabled : false,
        column   : "istl_lctn_addr",
        max      : 200,
    }),
    (cctvX = {
        box      : null,
        option   : 150,
        label    : "X좌표",
        disabled : false,
        must     : true,
        value    : "0.0000000",
        method: function (e) {
            let x = e.value.toString();
            switch (true) {
                case x.includes("."):
                    switch (true) {
                        case x.substring(0, x.indexOf(".")) === "":
                            e.component.option("value", "0" + x);
                            break;
                        case x.substring(x.indexOf("."), x.length) === "":
                            e.component.option("value", x + "0000000");
                            break;
                        case x.substring(x.indexOf("."), x.length).length < 7:
                            let zero = "";
                            for (let ii = 0; ii < 7 - x.substring(x.indexOf(".") + 1, x.length).length; ii++) {
                                zero += "0";
                            }
                            e.component.option("value", x.substring(0, x.indexOf(".")) + x.substring(x.indexOf("."), x.length) + zero);
                            break;

                        default:
                            break;
                    }

                    break;

                case x === "" || isNaN(x):
                    e.component.option("value", "0.0000000");
                    break;

                case x.length <= 3:
                    e.component.option("value", x + ".0000000");
                    break;

                default:
                    let front = x.substr(0, 3);
                    let end = x.substr(3, x.length);
                    let zero = "";
                    if (end.length < 7) {
                        for (let ii = 0; ii < 7 - end.length; ii++) {
                            zero += "0";
                        }
                    }
                    if (end.length > 7) end = end.substring(0, 7);
                    e.component.option("value", front + "." + end + zero);
                    break;
            }
        },
        column: "x_crdn",
        max: 11,
    }),
    (cctvY = {
        box      : null,
        option   : 150,
        disabled : false,
        label    : "Y좌표",
        must     : true,
        value    : "0.0000000",
        method: function (e) {
            let y = e.value.toString();
            switch (true) {
                case y.includes("."):
                    switch (true) {
                        case y.substring(0, y.indexOf(".")) === "":
                            e.component.option("value", "0" + y);
                            break;
                        case y.substring(y.indexOf("."), y.length) === "":
                            e.component.option("value", y + "0000000");
                            break;
                        case y.substring(y.indexOf("."), y.length).length < 7:
                            let zero = "";
                            for (let ii = 0; ii < 7 - y.substring(y.indexOf("."), y.length).length; ii++) {
                                zero += "0";
                            }
                            e.component.option("value", y.substring(0, y.indexOf(".")) + y.substring(y.indexOf("."), y.length) + zero);
                            break;

                        default:
                            break;
                    }

                    break;

                case y === "" || isNaN(y):
                    e.component.option("value", "0.0000000");
                    break;

                case y.length <= 2:
                    e.component.option("value", y + ".0000000");
                    break;

                default:
                    let front = y.substr(0, 2);
                    let end = y.substr(2, y.length);
                    let zero = "";
                    if (end.length < 7) {
                        for (let ii = 0; ii < 7 - end.length; ii++) {
                            zero += "0";
                        }
                    }
                    if (end.length > 7) end = end.substring(0, 7);
                    e.component.option("value", front + "." + end + zero);
                    break;
            }
        },
        column: "y_crdn",
        max: 10,
    }),
    (cctvEncdIp = {
        box      : null,
        option   : 240,
        label    : "인코더 IP",
        disabled : false,
        column   : "cctv_encd_ip",
        expr     : ipExpr,
        max      : 15,
    }),
    (strmSesnNm = {
        box      : null,
        option   : 240,
        label    : "스트리밍 세션명",
        disabled : false,
        column   : "strm_sesn_nm",
        max      : 200,
    }),
    (outRstp = {
        class    : "out-rstp",
        box      : null,
        option   : 240,
        label    : "외부 스트리밍 (RTSP)",
        disabled : false,
        column   : "strm_rtsp_addr",
        max      : 200,
    }),
    (outRtmp = {
        box      : null,
        option   : 240,
        label    : "외부 스트리밍 (RTMP)",
        disabled : false,
        column   : "strm_rtmp_addr",
        max      : 200,
    }),
    (outHttp = {
        box      : null,
        option   : 240,
        label    : "외부 스트리밍 (HTTP)",
        disabled : false,
        column   : "strm_http_addr",
        max      : 200,
    }),
];

const btnArr = [
    (editBtn = {
        class: "edit-btn",
        box: null,
        option: 80,
        visible: true,
        disabled: true,
        dbdsb: false,
        edit: {
            click: {
                visible: false,
                disabled: false,
            },
            cancle: {
                visible: true,
                disabled: false,
            },
        },
        add: {
            click: {
                visible: false,
                disabled: false,
            },
            selected: {
                visible: true,
                disabled: false,
            },
            unSelected: {
                visible: true,
                disabled: true,
            },
        },
        addvsb: false,
        icon: "edit",
        text: "편집",
        method: function () {
            editEvent();
        },
    }),
    (cancleBtn = {
        class: "cancle-btn",
        box: null,
        option: 80,
        visible: false,
        disabled: false,
        dbdsb: false,
        edit: {
            click: {
                visible: true,
                disabled: false,
            },
            cancle: {
                visible: false,
                disabled: false,
            },
        },
        add: {
            click: {
                visible: true,
                disabled: false,
            },
            selected: {
                visible: false,
                disabled: false,
            },
            unSelected: {
                visible: false,
                disabled: false,
            },
        },
        addvsb: true,
        icon: "close",
        text: "취소",
    }),
    (addBtn = {
        class: "add-btn",
        box: null,
        option: 80,
        disabled: false,
        visible: true,
        edit: {
            click: {
                visible: true,
                disabled: true,
            },
            cancle: {
                visible: true,
                disabled: false,
            },
        },
        add: {
            click: {
                visible: true,
                disabled: true,
            },
            selected: {
                visible: true,
                disabled: false,
            },
            unSelected: {
                visible: true,
                disabled: false,
            },
        },
        dbdsb: false,
        adddsb: true,
        icon: "plus",
        text: "추가",
        method: function () {
            addEvent();
        },
    }),
    (delBtn = {
        class: "del-btn",
        box: null,
        option: 80,
        disabled: true,
        visible: true,
        edit: {
            click: {
                visible: true,
                disabled: true,
            },
            cancle: {
                visible: true,
                disabled: false,
            },
        },
        add: {
            click: {
                visible: true,
                disabled: true,
            },
            selected: {
                visible: true,
                disabled: false,
            },
            unSelected: {
                visible: true,
                disabled: true,
            },
        },
        dbdsb: false,
        adddsb: true,
        icon: "minus",
        text: "삭제",
        method: function () {

            confirmMessage(pageMsg
                + "번호 : "
                + _managerTable.getSelectedRowsData()[0].cctv_mngm_nmbr
                + "<br>선택하신 " + pageMsg + " 정보를 삭제하시겠습니까?").done((yes)=>{
                if (yes === true) {
                    const result = deleteData(commonUri, _managerTable.getSelectedRowsData()[0].cctv_mngm_nmbr);
                    if (result > 0) {
                        delResultMsg(pageMsg);
                        boxInit();
                        buttonReset("add", "unSelected");
                        _managerTable.option("focusedRowKey", null);
                        _managerData = refresh(_managerTable, _managerData, commonUri);
                        newNums();
                        deleteFcltObject(_managerTable.getSelectedRowsData()[0].cctv_mngm_nmbr);
                    }
                }
            });
        },
    }),
    (saveBtn = {
        class: "save-btn",
        box: null,
        option: 80,
        disabled: true,
        dbdsb: true,
        edit: {
            click: {
                visible: true,
                disabled: false,
            },
            cancle: {
                visible: true,
                disabled: true,
            },
        },
        add: {
            click: {
                visible: true,
                disabled: false,
            },
            selected: {
                visible: true,
                disabled: true,
            },
            unSelected: {
                visible: true,
                disabled: true,
            },
        },
        adddsb: false,
        visible: true,
        icon: "save",
        text: "저장",
    }),
];


function recvFcltInfo(jsonData) {
    _managerData = jsonData;
    newNums();
    updateIcon();
}
$(() => {


    //상단 닫기 버튼
    $(".cancle-button")
        .dxButton({
            text: "닫기",
            icon: "close",
            height: "30px",
            width: "80px",
            stylingMode: "outlined",
            onClick() {
                window.close();
            },
        })
        .dxButton("instance");

    inputArr.map((item) => {
        item.box = $("." + item.column)
            .dxTextBox({
                width: item.option,
                stylingMode: "outlined",
                readOnly: true,
                maxLength: item.max,
                height: 27,
            })
            .dxTextBox("instance");
        if (item.value) {
            item.box.option("value", item.value);
        }
        if (item.method) {
            item.box.on("valueChanged", item.method);
        }
    });

    btnArr.map((item) => {
        item.box = $("." + item.class)
            .dxButton({
                icon: item.icon,
                width: item.option,
                text: item.text,
                visible: item.visible,
                disabled: item.disabled,
                focusStateEnabled: false,
                stylingMode: "outlined",
                onClick() {
                    if (item.method) {
                        item.method();
                    }
                },
            })
            .dxButton("instance");
    });

    // 지도객체 생성
    doMap();

    // 시설물 정보를 읽어 온다.
    getData(commonUri, _managerData);

    newNums();
    updateIcon();
    //getDataAsync(commonUri, recvFcltInfo);

    //소통정보 이력분석 테이블
    _managerTable = $(".manager-table")
        .width("100%")
        .height("100%")
        .dxDataGrid({
            dataSource: _managerData[0],
            allowColumnReordering: true,
            showColumnLines: true,
            showBorders: true,
            allowColumnResizing: true,
            rowAlternationEnabled: true,
            focusedRowEnabled: true,
            columnAutoWidth: true,
            noDataText: "표출할 정보가 없습니다.",
            selection: {
                mode: "single",
            },
            keyExpr: "cctv_mngm_nmbr",

            headerFilter: {
                visible: true,
            },
            scrolling: {
                mode: "virtual",
            },
            columns: [
                {
                    dataField: "cctv_ctlr_id",
                    caption: "CCTV ID",
                    width: 120,
                    alignment: "center",
                },
                {
                    dataField: "istl_lctn_nm",
                    caption: "설치 위치",
                    alignment: "center",
                    cellTemplate(c, e) {
                        c.css("text-align", "left");
                        return c.text(e.displayValue);
                    },
                },
            ],
            onRowDblClick(e) {
                _selectFcltNmbr = e.data.cctv_mngm_nmbr;
                selectFcltObject(_selectFcltNmbr);
                inputArr.map((item) => {
                    item.box.option("value", e.data[item.column]);
                });

                btnArr.map((item) => {
                    item.box.option("disabled", item.dbdsb);
                });
            },
        })
        .dxDataGrid("instance");
});

function editEvent() {
    editFcltObject(_selectFcltNmbr, true);
    cancleBtn.box.off("click");
    cancleBtn.box.on("click", () => editCancel());

    eventOn();

    btnArr.map((item) => {
        item.box.option("visible", item.edit.click.visible);
        item.box.option("disabled", item.edit.click.disabled);
    });

    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('edit'));
}

function editCancel() {
    updateIcon();
    eventCancel();
    boxPull();
    buttonReset("edit", "cancle");
}
function getIdArr(){
    let idArr = [];
    if (_managerData[0].length > 0) {
        _managerData[0].map((obj)=>{
            if(obj.cctv_ctlr_id)idArr.push(obj.cctv_ctlr_id);
        })
    }
    return idArr;
}
function saveEvent(type) {
    _idArr = getIdArr();
    for (let input of inputArr) {
        const box   = input.box;
        const value = getValue(box);
        const max   = input.max;
        const label = input.label;
        const empty = nullChecker(value) === "";
        if (empty) {
            if (input.must) {
                return  alertWarning( "필수 항목을 입력해주세요. [ " + label +" ]", null, box);
            }
        }
        else {
            if (max && getByteLength(value) > max) {
                return alertWarning( max + " 바이트 이내로 입력해주세요. [ " + label +" ]", null, box);
            }
            if (input.expr && !input.expr.test(value)) {
                return alertWarning("IP 형식에 맞게 입력해주세요. [ " + label +" ]", null, box);
            }
            if (input.port && isNaN(value)) {
                return alertWarning("PORT 형식에 맞게 입력해주세요. [ " + label + " ]", null, box);
            }
            if (input.id && _idArr.includes(value) && type === "add") {
                    return alertWarning( "제어기 ID : " + value + "<br>이미 사용중인 제어기 ID 입니다.", null, box);
            }
        }
    }
    let updateData = {..._updateColumns};

    if (type === 'edit') {
        // 수정모드일 경우에는....
        const rowData = _managerTable.getSelectedRowsData()[0];
        for (let key in updateData) {
            updateData[key] = rowData[key];
        }
        const idVal = getValue(cctvId.box);
        if (_idArr.includes(idVal) && idVal !== rowData.cctv_ctlr_id){
            return alertWarning( "제어기 ID : " + idVal + "<br>이미 사용중인 제어기 ID 입니다.", null, cctvId.box);
        }
        console.log('edit mode...')
    }



    // 수정모드인 경우와 추가 모드 비교해야함...
    inputArr.map((item) => {
        if (item.column && nullChecker(item.box.option("value")) !== "") {
            updateData[item.column] = item.box.option("value");
        }
    });


    //ctrlIpNum
    let result = postInsertUpdate(commonUri + "/" + updateData.cctv_mngm_nmbr, updateData);
    if (result > 0) {
        insResultMsg(pageMsg);
        _managerData = refresh(_managerTable, _managerData, commonUri);
        _managerTable.clearSelection();
        _managerTable.refresh().done(function () {
            _managerTable.selectRows(updateData.cctv_mngm_nmbr).done(()=>{
                _managerTable.option("focusedRowKey", updateData.cctv_mngm_nmbr);
                boxPull();
                buttonReset("add", "selected");
                newNums();
                updateIcon();
                eventCancel();
            });
        });
    }
}

function addCancel() {
    updateIcon();
    eventCancel();

    if (_managerTable.getSelectedRowsData().length > 0) {
        boxPull();
        buttonReset("add", "selected");
        return;
    }

    boxInit();
    buttonReset("add", "unSelected");
}

function addEvent() {
    eventOn();
    boxInit();
    let center = _mapManager.getCenter();
    cancleBtn.box.off("click");
    cancleBtn.box.on("click", () => addCancel());
    cctvX.box.option("value", center[0].toFixed(7));
    cctvY.box.option("value", center[1].toFixed(7));
    addNum = getNewNmbr();
    addFcltObject(addNum);
    cctvNo.box.option("value", addNum);
    btnArr.map((item) => {
        item.box.option("visible", item.add.click.visible);
        item.box.option("disabled", item.add.click.disabled);
    });
    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('add'));
}

function boxPull() {
    let selectedRow = _managerTable.getSelectedRowsData()[0];
    inputArr.map((item) => {
        item.box.option("value", selectedRow[item.column]);
    });
}

function boxInit() {
    inputArr.map((item) => {
        if (item.value) return item.box.option("value", item.value);
        item.box.option("value", null);
    });
}

function buttonReset(eventName, option) {
    btnArr.map((item) => {
        item.box.option("visible", item[eventName][option].visible);
        item.box.option("disabled", item[eventName][option].disabled);
    });
}

function eventCancel() {
    dsblOffBtn(_managerTable);

    inputArr.map((item) => {
        item.box.option("readOnly", true);
    });

    if(_managerTable.getSelectedRowsData().length > 0){
        _selectFcltNmbr = _managerTable.getSelectedRowsData()[0].cctv_mngm_nmbr;
        selectFcltObject(_selectFcltNmbr);
    }
}

function eventOn() {
    dsblOnBtn(_managerTable);

    inputArr.map((item) => {
        item.box.option("readOnly", item.disabled);
    });
}

function newNums() {
    if (_managerData.length > 0) {
        let sortData = [..._managerData[0]];
        sortData.sort(function (a, b) {
            // 내림차순
            return b["cctv_mngm_nmbr"] - a["cctv_mngm_nmbr"];
        });
        addNum = sortData[0].cctv_mngm_nmbr + 1;
    }
}

/**
 * 제어기 신규 ID 조회
 */
function getNewNmbr() {
    let newId = [];
    getData(commonUri + "/new-id", newId);
    _selectFcltNmbr = newId[0].new_id;
    return _selectFcltNmbr;
}
/**
 * 지도 인터페이스 함수........
 */
function doMap() {
    _mapManager = new TMapMngr("traf-hs-map", "tooltip");
    _mapManager.setEditMode(_lyrIdx, true);
    _mapManager.showLayer(_lyrIdx, true);
    _mapManager.showFcltObjectText(_lyrIdx, true);
    _mapManager.onFcltDragEndFunc = onFcltDragEndFunc; // 객체(시설물) 편집시 객체 이동후 좌표 반환
    _mapManager.onMouseClickFunc = onMouseClickFunc; // 객체 마우스 클릭 이벤트 반환
    fetchMapIconBar($('.map-bar'), _mapManager, _lyrIdx, _pageName);
    _mapManager.toggleBaseMap(true);
}
function onFcltDragEndFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    if (ANmbr === _selectFcltNmbr) {
        cctvX.box.option("value", ACoordX.toFixed(7));
        cctvY.box.option("value", ACoordY.toFixed(7));
    }
    console.log(`onFcltDragEndFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}`);
}
function onMouseClickFunc(ALyrIdx, ALyrName, ANmbr, ACoordX, ACoordY, X, Y) {
    if (ALyrIdx != _lyrIdx) {
        return;
    }
    console.log(`onMouseClickFunc, ${ALyrIdx}, ${ALyrName}, ${ANmbr}, ${ACoordX}, ${ACoordY}, ${X}, ${Y}`);
    const obj = _mapManager.findLayerObject(ALyrIdx, ANmbr);
    if (!obj) {
        return;
    }
}

/**
 * 지도에 시설물 객체 정보를 그린다.
 */
function updateIcon() {
    // 기존 객체를 모두 삭제한다.
    _mapManager.removeLayerObject(_lyrIdx);

    // 시설물 객체를 지도에 그린다.
    const objs = new Array();
    _managerData[0].forEach((obj) => {
        const item = new TFclt(obj.cctv_mngm_nmbr, obj.istl_lctn_nm, obj.x_crdn, obj.y_crdn);
        objs.push(item);
    });

    _mapManager.initFcltObject(_lyrIdx, objs);
}
function selectFcltObject(ANmbr) {
    _mapManager.selectLayerObject(_lyrIdx, ANmbr);
}
function editFcltObject(ANmbr, AIsEdit) {
    _mapManager.editFcltObject(_lyrIdx, ANmbr, AIsEdit, AIsEdit ? "1" : "0");
}
function deleteFcltObject(ANmbr) {
    _mapManager.deleteFcltObject(_lyrIdx, ANmbr);
    _selectFcltNmbr = null;
}
function addFcltObject(ANmbr) {
    _mapManager.createFcltObject(_lyrIdx, ANmbr, "New", "New", "1" /*아이콘색결정,시설물유형_N.png*/ /*, x_crdn, y_crdn*/);
}
