//가운데 섹션 관련
let _fixedData         = [];
let _fixedTableList    = null;
let _dsplHHDataSource  = [];

//좌측 섹션 관련
let _listTable     = null;

//우측 섹션 관련
let _formTableList = null;

//공통
let commonUri     = '/api/vms/schedule/fixed/list';
let addBtn        = null;
let delBtn        = null;
let schSaveBtn    = null;
let allVmsEditBtn = null;
let allVmsAddBtn  = null;
let strtDt        = null;
let endDt         = null;
let strtTime      = null;
let endTime       = null;
let _modalSaveBtn = null;
let _updateData    = {
    dspl_end_hh         : null,
    dspl_hh             : 0,
    dspl_strt_hh        : null,
    four_img_ifsc_id    : null,
    four_vms_ifsc_id    : null,
    frst_img_ifsc_id    : null,
    frst_vms_ifsc_id    : null,
    phase               : 0,
    secd_img_ifsc_id    : null,
    secd_vms_ifsc_id    : null,
    thir_img_ifsc_id    : null,
    thir_vms_ifsc_id    : null,
    trfc_situ_type_cd   : null,
    use_yn              : null,
    vms_ctlr_nmbr       : 0,
    vms_form_id         : 0,
    vms_form_prrt_cd    : null
};

let _vmsTypeData   = [];
let _vmsListMap = new Map();
let _comboVmsType = null;
let _vmsHongboForm = new Map();

//사용 버튼들
const btnBoxArr  = [
    addBtn = {
        column      : 'add-btn',
        box         : null,
        icon        : 'arrowleft',
        text        : '추가',
        method      : function(){
            addEvent();
        }
    },
    delBtn = {
        column      : 'del-btn',
        box         : null,
        icon        : 'arrowright',
        text        : '삭제',
        method      : function(){
            delEvent();
        }
    },
    schSaveBtn = {
        column      : 'sch-save-btn',
        box         : null,
        icon        : 'save',
        text        : '스케줄 저장',
        method      : function(){
            scheduleSaveEvent();
        }
    },
    allVmsEditBtn = {
        column      : 'all-vms-edit-btn',
        box         : null,
        icon        : 'edit',
        text        : '전체 VMS 편집',
        method      : function(){
            allEditPopup();
        }
    },
    allVmsAddBtn = {
        column      : 'all-vms-add-btn',
        box         : null,
        icon        : 'plus',
        text        : '전체 VMS 등록',
        method      : function(){
            allSavePopup();
        }
    },

]

const dataArr = [
    strtDt = {
        box              : null,
        class            : 'strt-date',
        type             : 'date',
        value            : new Date(),
        displayFormat    : 'yyyy-MM-dd',
        width            : 140,
        stylingMode      : 'outlined',
        invalid          : '0000-00-00',
    },
    endDt = {
        box              : null,
        class            : 'end-date',
        type             : 'date',
        value            : new Date(),
        displayFormat    : 'yyyy-MM-dd',
        width            : 140,
        stylingMode      : 'outlined',
        invalid          : '0000-00-00',
    },
    strtTime = {
        box              : null,
        class            : 'strt-time',
        type             : 'time',
        value            : firstSettingTime,
        interval         : 10,
        displayFormat    : 'HH:mm',
        width            : 100,
        stylingMode      : 'outlined',
        invalid          : '00:00',
    },
    endTime = {
        box              : null,
        class            : 'end-time',
        type             : 'time',
        value            : endSettingTime,
        interval         : 10,
        displayFormat    : 'HH:mm',
        width            : 100,
        stylingMode      : 'outlined',
        invalid          : '00:00',
    },

]

for(let ii = 3; ii < 11; ii++){
    _dsplHHDataSource.push(ii);
}

$(()=>{
    //모달창 바디에 넣기
    $("body").append(modalDiv);
    $(".modal-title").prepend($("<div>VMS 폼 표출기간 설정</div>"));
    $(".modal-background").css("display",'none');
    $(".modal-content").append($(`<div class="serve-title b2">표출 시작 기간</div>
    <div class="date-box">
        <div>
            <div>표출 시작 시각</div>
            <div>
                <div class="strt-date"></div>
            </div>
            <div>
                <div class="strt-time"></div>
            </div>
        </div>
        <div>
            <div>표출 종료 시각</div>
            <div>
                <div class="end-date"></div>
            </div>
            <div>
                <div class="end-time"></div>
            </div>
        </div>
    </div>`)
    )

    //모달 x 버튼
    modalCancleBtn = $(".modal-cancle").dxButton({
        stylingMode:'text',
        icon:'close',
        onClick(){
            modalCancleEvent();
        }
    })


    //모달 저장 버튼
    _modalSaveBtn = $(".modal-save-Btn").dxButton({
        stylingMode:'outlined',
        text:'저장',
        icon:'save',
    }).dxButton('instance');

    //모달 취소 버튼
    $(".modal-cancle-Btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        icon:'close',
        onClick(){
            modalCancleEvent();
        },
    }).dxButton('instance');


    btnBoxArr.map((item)=>{
        item.box = $("." + item.column).dxButton({
            stylingMode : 'outlined',
            icon        : item.icon,
            text        : item.text,
            onClick(){
                if(item.method)item.method();
            }
        }).dxButton("instance");
    })

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")

    _comboVmsType = $('.type-select').dxSelectBox({
        dataSource  : null,
        displayExpr : 'vms_type_desc',
        valueExpr   : 'vms_type_cd',
        width       : 250,
        height      : 30,
        stylingMode : 'outlined',
        onItemClick(e){
            const vmsTypeCd = e.itemData.vms_type_cd;
            const vmsTypeWidth = e.itemData.vms_wdth;
            vmsTypeComboboxClick(vmsTypeCd, vmsTypeWidth);
        }
    }).dxSelectBox('instance');

    dataArr.map((item)=>{
        item.box = $("." + item.class).dxDateBox({
            value         : item.value,
            type          : item.type,
            width         : item.width,
            stylingMode   : 'outlined',
            displayFormat : item.displayFormat,
            interval      : item.interval,
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)' + item.invalid,
        }).dxDateBox("instance");
    })

    //소통정보 이력분석 테이블
    _listTable = $(".list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'vms_ctlr_nmbr',
        selection: {
            mode                : 'single',
            showCheckBoxesMode  : "onClick"
        },
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                dataField    : "vms_ctlr_nmbr",
                caption      : "번호",
                alignment    : "center",
                cssClass     : 'no-padding',
                width        : '70'
            },
            {
                dataField    : "vms_ctlr_id",
                caption      : "VMS ID",
                alignment    : "center",
                width        : 110,
                cssClass     : 'no-padding',
            },
            {
                dataField    : "vms_nm",
                caption      : "VMS 명칭",
                alignment    : "center",
                cssClass     : 'no-padding',
                width        : 140,
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue)
                }
            },
            // {
            //     dataField    : 'basic',
            //     caption      : '기본',
            //     alignment    : 'center',
            //     cssClass     : 'no-padding',
            // }
        ],
        onRowClick(e){
            fetchVmsDefaultSchedule(e.data.vms_ctlr_nmbr, e.data.vms_nm);
        },
    }).dxDataGrid("instance");

    _formTableList = $('.form-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'vms_form_id',
        noDataText              : '표출할 정보가 없습니다.',
        scrolling               : {
            mode : 'standard',
        },
        selection: {
            mode: 'single',
        },
        paging: {
            enabled: true,
            pageSize: 1000,
        },
        sorting  : {
            showSortIndexes : false,
            mode            : 'none',
        },
        columns:[
            {
                dataField    : "vms_form_id",
                caption      : "폼 ID",
                alignment    : "center",
                width        : 70,
                cssClass     : 'no-padding',
                sortIndex    : 0,
                sortOrder    : 'asc',
            },
            {
                dataField    : "vms_form_imag",
                caption      : "폼 레이아웃",
                alignment    : "center",
                cssClass     : 'no-padding',
                cellTemplate(c,e){
                    c.css('padding','3px')
                    const imgSrc = 'data:image/png;base64,'+ e.displayValue
                    return c.append($('<img src="'+imgSrc+'">'));
                }
            },
        ],
    }).dxDataGrid('instance');

    _fixedTableList = $('.default-table').width('100%').height('100%').dxDataGrid({
        dataSource              : _fixedData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['vms_ctlr_nmbr','phase'],
        wordWrapEnabled         : true,
        editing                 : {
            confirmDelete : false,
            mode : 'batch',
            allowUpdating : true,
        },
        toolbar                 : {
            visible : false,
        },
        scrolling               : {
            mode : 'standard',
        },
        selection: {
            mode: 'single',
        },
        paging: {
            enabled: true,
            pageSize: 1000,
        },
        sorting  : {
            showSortIndexes : false,
            mode            : 'none',
        },
        columns:[
            {
                dataField    : "vms_form_id",
                caption      : "폼 ID",
                alignment    : "center",
                width        : 50,
                cssClass     : 'no-padding',
                allowEditing : false,
            },
            {
                dataField    : "vms_form_imag",
                caption      : "폼 레이아웃",
                alignment    : "center",
                cssClass     : 'no-padding',
                allowEditing : false,
                cellTemplate(c,e){
                    const imgSrc = 'data:image/png;base64,'+ e.displayValue;
                    const image = $('<img class="img" src="' + imgSrc + '">');
                    return c.append(image);
                }
            },
            {
                dataField    : "phase",
                caption      : "페이즈",
                visible      : false,
                sortIndex    : 0,
                sortOrder    : 'asc',
                alignment    : "center",
                cssClass     : 'no-padding',
                allowEditing : false,
            },
            {
                dataField    : "dspl_hh",
                caption      : "표출(초)",
                alignment    : "center",
                width        : 70,
                lookup       : {
                    dataSource : _dsplHHDataSource,
                },
                cssClass     : 'no-padding',
            },
            {
                dataField    : "dspl_strt_hh",
                caption      : "시작 시각",
                alignment    : "center",
                cssClass     : 'no-padding',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss',
                allowEditing : false,
            },
            {
                dataField    : "dspl_end_hh",
                caption      : "종료 시각",
                alignment    : "center",
                cssClass     : 'no-padding',
                dataType     : 'datetime',
                format       : 'yyyy-MM-dd HH:mm:ss',
                allowEditing : false,
            },
            {
                dataField    : "use_yn",
                caption      : "사용",
                alignment    : "center",
                width        : 60,
                cssClass     : 'no-padding',
                lookup       : {
                    dataSource: ['Y','N'],
                }
            },

        ],
        onFocusedRowChanged(e){
            e.component.selectRowsByIndexes(e.rowIndex);
            e.component.refresh();
        },
    }).dxDataGrid('instance').on('cellDblClick', (cell)=> defaultListDblClick(cell));

    fetchBaseData();
})

// 초기 데이터 로딩
function fetchBaseData() {
    getDataAsync('/api/vms/common/vms-type', recvVmsTypeFunc);
}
// VMS TYPE 데이터 수신
function recvVmsTypeFunc(jsonData) {
    _vmsTypeData = jsonData;
    _vmsTypeData.map((item)=>{
        item.vms_type_desc = item.vms_type_desc + ' (' + item.vms_wdth + 'x' + item.vms_hght + ')';
    });
    _comboVmsType.option('dataSource', _vmsTypeData);

    if( _vmsTypeData.length > 0 ) {
        const defaultVmsTypeCd = _vmsTypeData[0].vms_type_cd;
        _comboVmsType.option('value', defaultVmsTypeCd);
    }
    getDataAsync('/api/vms/common/vms-list', recvVmsListFunc);
}

// VMS LIst 데이터 수신
function recvVmsListFunc(jsonData) {
    jsonData.forEach((obj) => {
        let vmsObjs = _vmsListMap.get(obj.vms_type_cd);
        if (!vmsObjs) {
            vmsObjs = new Array();
            _vmsListMap.set(obj.vms_type_cd, vmsObjs);
        }
        vmsObjs.push(obj);
    });

    if (jsonData.length > 0) {
        vmsTypeComboboxClick(_vmsTypeData[0].vms_type_cd, _vmsTypeData[0].vms_wdth);
    }
}

//VMS TYPE 콤보박스 선택 이벤트
function vmsTypeComboboxClick(vmsTypeCd, vmsTypeWidth) {
    //타이틀 정보 삭제
    _title = $('.title');
    _title.text(null);

    // 고정스케쥴 리스트 삭제
    _fixedTableList.option('dataSource', null);
    // 홍보폼 리스트 삭제
    _formTableList.option('dataSource', null);

    //리스트 불러오기
    const vmsTypeList = _vmsListMap.get(vmsTypeCd);

    //제목 값 세팅
    _title.text(vmsTypeList[0].vms_nm);

    //고정스케줄 리스트 세팅
    _listTable.option('dataSource', vmsTypeList);
    _listTable.refresh().then(()=>{
        _listTable.option('focusedRowIndex', 0);
        _listTable.selectRows(_listTable.getKeyByRowIndex(0), true);
    })

    //고정스케줄 리스트 세팅
    _fixedTableList.option('columns[1].width', vmsTypeWidth + 10);
    _fixedTableList.option('focusedRowIndex', -1);
    _fixedTableList.clearSelection();

    _formTableList.option('focusedRowIndex', -1);
    _formTableList.clearSelection();

    fetchVmsHongboForm(vmsTypeCd);

    if (vmsTypeList) {
        fetchVmsDefaultSchedule(vmsTypeList[0].vms_ctlr_nmbr);
    }
}

//홍보 폼 데이터 수신
function fetchVmsHongboForm(vmsTypeCd) {

    const vmsFormList = _vmsHongboForm.get(vmsTypeCd);
    if (vmsFormList) {
        fillVmsHongboForm(vmsFormList, vmsTypeCd);
    }
    else {
        getDataAsync('/api/vms/schedule/common/form/notice/' + encodeURIComponent(vmsTypeCd), fillVmsHongboForm, vmsTypeCd);
    }
}

//홍보 폼 데이터 세팅
function fillVmsHongboForm(jsonData, vmsTypeCd) {
    _vmsHongboForm.set(vmsTypeCd, jsonData);
    _formTableList.option('dataSource', jsonData);
}

//고정 스케줄 데이터 세팅
function fetchVmsDefaultSchedule(vms_ctlr_nmbr, vms_nm){
    $('.text').text(null);
    let data = [];
    getData(commonUri + '/' + encodeURIComponent(vms_ctlr_nmbr), data);
    if (data.length > 0) {
        data[0].map((item)=>{
            if(item.dspl_strt_hh)item.dspl_strt_hh  = new Date( getParseDateTime(item.dspl_strt_hh) );
            if(item.dspl_end_hh) item.dspl_end_hh  = new Date( getParseDateTime(item.dspl_end_hh) );
        });
        _fixedTableList.option('dataSource', data[0]);
        _fixedTableList.option('focusedRowIndex', -1);
        _fixedTableList.clearSelection();
    }
    $('.title').text(vms_nm);
}

//우측 추가 버튼 이벤트
function addEvent(){
    const formData = _formTableList.getSelectedRowsData();
    if(formData.length > 0){
        modalDateBtnInit();
        $(".modal-background").css('display','flex');
        _modalSaveBtn.off('click');
        _modalSaveBtn.on('click', () => fixedTableListAddHongbo());
    }
}

//우측 삭제 버튼 이벤트
function delEvent(){
    const key = _fixedTableList.getSelectedRowKeys();
    if(key.length > 0){
        const idx = _fixedTableList.getRowIndexByKey(key[0]);
        _fixedTableList.deleteRow(idx);
        _fixedTableList.saveEditData();
        _fixedTableList.refresh().then(()=>{
            if(_fixedTableList.option('focusedRowIndex') !== idx){
                _fixedTableList.option('focusedRowIndex', -1);
            };
            _fixedTableList.selectRowsByIndexes(idx);
            _fixedTableList.refresh();
            console.log(_fixedTableList.option('dataSource'));
        });
    }
}

//전체 VMS 등록 버튼 이벤트
function allSavePopup(){
    const formData = _formTableList.getSelectedRowsData();
    if(formData.length > 0){
        window.open('./fixed-tot-insert-pop-up.html'
            + '?vms_form_id=' + formData[0].vms_form_id
            + '&vms_type_cd=' + formData[0].vms_type_cd,
            + 'VMS 일괄 등록', 'width=1200, height=800, top=89.5, left=360');
        return;
    }
    return alertWarning('VMS 스케줄 일괄 관리<br>등록되어 있는 스케줄 폼을 목록에서 먼저 선택하세요');
}

//전체 VMS 편집 버튼 이벤트
function allEditPopup(){
    const _fixedData = _fixedTableList.getSelectedRowsData();
    console.log(_fixedData);
    if(_fixedData.length > 0){
        window.open('./fixed-tot-edit-pop-up.html'
            + '?vms_form_id=' + _fixedData[0].vms_form_id
            + '&vms_type_cd=' + getValue(_comboVmsType),
            + 'VMS 일괄 편집', 'width=1200, height=800, top=89.5, left=360');
        return;
    }
    return alertWarning('VMS 스케줄 일괄 관리<br>등록되어 있는 스케줄 폼을 목록에서 먼저 선택하세요');
}

//defaultTableList 데이터 초기화
function fixedTableListRefresh(){
    let data = [];

    const vms_ctlr_nmbr = _listTable.getSelectedRowsData()[0].vms_ctlr_nmbr

    getData(commonUri + '/' + encodeURIComponent(vms_ctlr_nmbr), data);
    console.log(data);
    if (data.length > 0) {
        data[0].map((item)=>{
            if(item.dspl_strt_hh)item.dspl_strt_hh  = new Date( getParseDateTime(item.dspl_strt_hh) );
            if(item.dspl_end_hh) item.dspl_end_hh  = new Date( getParseDateTime(item.dspl_end_hh) );
        });
    }
    _fixedTableList.option('dataSource', data[0]);
}

//스케줄 저장 이벤트
function scheduleSaveEvent(){

    const vmsNum = _listTable.getSelectedRowsData()[0].vms_ctlr_nmbr;
    confirmMessage('VMS : ' + vmsNum + '<br>선택한 VMS의 고정 스케줄 정보를 등록하시겠습니까?').done((yes) => {
        if (yes === true) {
            let result = 0;
            _fixedTableList.saveEditData();
            const dataSource       = [..._fixedTableList.option('dataSource')];
            const insertUpdateData = [];
            if(dataSource.length > 0 ){
                dataSource.map((data)=>{
                    let updateData = {};
                    if (data.dspl_strt_hh) data.dspl_strt_hh = getSendDate(data.dspl_strt_hh);
                    if (data.dspl_end_hh)  data.dspl_end_hh  = getSendDate(data.dspl_end_hh);
                    for (let key in _updateData){
                        if (data[key] ===  undefined) {
                            updateData[key] = _updateData[key];
                            continue
                        }
                        updateData[key] = data[key];
                    }

                    insertUpdateData.push(updateData);
                });
                result = postInsertUpdate('/api/vms/schedule/common/' + encodeURIComponent(vmsNum), insertUpdateData);
            }
            else {
                let data = [];
                getData('/api/vms/schedule/fixed/list/' + encodeURIComponent(vmsNum) , data);
                if (data[0].length > 0) {
                    result = deleteDataIds('/api/vms/schedule/common/batch', data[0]);
                }
            }

            if (result > 0) {
                alertConfirm('VMS 고정 스케줄 관리<br>VMS 고정 스케줄 정보를 등록 하였습니다.');
                fixedTableListRefresh();
            }
            //return alertError('VMS 고정 스케줄 관리<br>VMS 고정 스케줄 정보가 저장 되지 않았습니다.');
        }
    });
}

//모달 저장 이벤트 - defaultTableList 홍보 폼 추가
function fixedTableListAddHongbo(){
    if(!validationCheck( strtDt.box, endDt.box, strtTime.box, endTime.box )) return false;

    const dspl_strt_hh = modalTimeFommat(strtDt, strtTime);
    const dspl_end_hh  = modalTimeFommat(endDt, endTime);

    if(dspl_strt_hh > dspl_end_hh) {
        return alertWarning('시작 시각이 종료 시각보다 큽니다.');
    }

    const formData = _formTableList.getSelectedRowsData();
    const dataSource = _fixedTableList.option('dataSource');
    dataSource.push({
        dspl_end_hh       : dspl_end_hh,
        dspl_hh           : 4,
        dspl_strt_hh      : dspl_strt_hh,
        four_img_ifsc_id  : null,
        four_vms_ifsc_id  : null,
        frst_img_ifsc_id  : null,
        frst_vms_ifsc_id  : null,
        phase             : dataSource.length + 1,
        secd_img_ifsc_id  : null,
        secd_vms_ifsc_id  : null,
        thir_img_ifsc_id  : null,
        thir_vms_ifsc_id  : null,
        trfc_situ_type_cd : '5',
        use_yn            : 'N',
        vms_ctlr_nmbr     : _listTable.getSelectedRowsData()[0].vms_ctlr_nmbr,
        vms_form_id       : formData[0].vms_form_id,
        vms_form_imag     : formData[0].vms_form_imag,
    });

    _fixedTableList.option('dataSource', dataSource);
    $(".modal-background").css("display","none");
    _formTableList.clearSelection();
    _formTableList.option('focusedRowIndex', -1);
}

//모달 저장 이벤트 - defaultTableList 시각 변경
function fixedTableListEditTime(cell){
    const table      = cell.component;
    const key        = cell.key;
    const idx        = table.getRowIndexByKey(key);
    let dspl_strt_hh = null;
    let dspl_end_hh  = null;
    let dateArr      = dateValidation(strtDt, endDt, strtTime, endTime, dspl_strt_hh, dspl_end_hh);

    if(!dateArr) return false;

    //모달 창 닫기
    $(".modal-background").css("display","none");
    table.cellValue(idx, 'dspl_strt_hh', dateArr.dspl_strt_hh);
    table.cellValue(idx, 'dspl_end_hh', dateArr.dspl_end_hh);
}

//모달 닫기 이벤트
function modalCancleEvent(){
    $(".modal-background").css("display",'none');
}

//모달 데이트 박스 값 초기화
function modalDateBtnInit(){
    setValue(strtDt.box, new Date());
    setValue(endDt.box, new Date('2099-12-31'));
    setValue(strtTime.box, firstSettingTime);
    setValue(endTime.box,  endSettingTime);
}

function defaultListDblClick(cell){
    console.log(cell);
    if(cell.column){
        if(cell.column.name === 'dspl_hh' || cell.column.name === 'use_yn') return;
        setValue(strtDt.box, cell.data.dspl_strt_hh);
        setValue(strtTime.box, cell.data.dspl_strt_hh.getTime());
        setValue(endDt.box, cell.data.dspl_end_hh);
        setValue(endTime.box, cell.data.dspl_end_hh.getTime());
        $(".modal-background").css('display','flex');
        _modalSaveBtn.off('click');
        _modalSaveBtn.on('click', () => fixedTableListEditTime(cell));
    }

}

function dateValidation( strtdt, enddt, strttm, endtm, dspl_strt_hh, dspl_end_hh) {
    //유효성 검사 - 널체크
    if(!validationCheck( strtdt.box, enddt.box, strttm.box, endtm.box )) return false;

    //유효성 검사 - 시간 크기 검사
    dspl_strt_hh = modalTimeFommat(strtdt, strttm);
    dspl_end_hh  = modalTimeFommat(enddt, endtm);
    if(dspl_strt_hh > dspl_end_hh){
        strtdt.box.focus();
        alertWarning('시작 시각이 종료 시각보다 큽니다.');
        return false;
    }
    return {dspl_strt_hh, dspl_end_hh};
}

