//가운데 섹션 관련
let hsData        = [];
let hsTable       = [];

//좌측 섹션 관련
let hsListTalbe   = null;
let hsListData    = [];
let hsStartDate   = null;
let hsEndDate     = null;
let hsStartTime   = null;
let hsEndTime     = null;
let hsSearchBtn   = null;

//우측 섹션 관련
let vmsIdBox      = null;
let vmsLctnBox    = null;
let vmsDateBox    = null;
let vmsFormNumBox = null;
let dsplData      = [];
let dsplTable     = null;
let vmsNum         = "";
let vmsDate       = "";

//공통
let commonUri     = '/api/vms/history/dspl';
const _pageName    = 'VMS 제공이력';

//우측 버튼들
const dsplBoxArr  = [
    vmsIdBox = {
        column      : 'vms_ctlr_id',
        box         : null, 
        option      : 130, 
        method      : function(){
        }
    }, 
    vmsLctnBox = {
        column      : 'vms_nm',
        box         : null, 
        option      : 230, 
        method      : function(){
        }
    }, 
    vmsDateBox = {
        column      : 'dspl_dt',
        box         : null, 
        option      : 200, 
        method      : function(){
        }
    }, 
    vmsFormNumBox = {
        column      : 'dspl_phase_num',
        box         : null, 
        option      : 160, 
        method      : function(){
        }
    }, 
   
]

//기본 날짜 세팅
getData('/api/vms/common/vms-list', hsListData);

$(()=>{
    
    //검색시작일시 년월일
    hsStartDate =  $('.strt-date').dxDateBox({
        type                : 'date',
        value               : new Date(),
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');

    //검색 시작일시 시간
    hsStartTime =  $('.strt-time').dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : 75,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');
    
    //검색종료일시 년월일
    hsEndDate =  $('.end-date').dxDateBox({
        type                : 'date',
        value               : new Date(),
        width               : 130,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox('instance');
    
    //검색종료일시 시간
    hsEndTime =  $('.end-time').dxDateBox({
        type                : 'time',
        value               : new Date().getTime(),
        width               : 75,
        interval            : 10,
        height              : '28px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH:mm',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
    }).dxDateBox('instance');
    

    //상단 조회 버튼
    hsSearchBtn = $('.traf-hs-search-btn').dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        width: '80px',
        onClick(){
            hsEvent();
            
        }
    }).dxButton("instance")
   
    dsplBoxArr.map((item)=>{
        item.box = $("." + item.column).dxTextBox({
            stylingMode : 'outlined',
            width       : item.option,
            height      : 28,
            readOnly    : true,
        }).dxTextBox("instance");
    })

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
 
    
     //소통정보 이력분석 테이블
     hsListTalbe = $(".hs-list-talbe").width('100%').height('100%').dxDataGrid({
        dataSource              : hsListData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode                : 'multiple',
            showCheckBoxesMode  : "onClick"
        },
        keyExpr : 'vms_ctlr_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
                    {
                        dataField    : "vms_ctlr_nmbr",
                        caption      : "번호",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_ctlr_id",
                        caption      : "VMS ID",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_nm",
                        caption      : "VMS 명칭",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
        ],
      
        
    }).dxDataGrid("instance");

    dsplTable = $('.dspl-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'dspl_phase_num',
        noDataText              : '표출할 정보가 없습니다.',
        scrolling               : {
            mode : 'virtual',
        },
        selection               : {
            mode:'single',
        },
        columns:[
            {
                dataField    : "dspl_phase_num",
                caption      : "순서",
                alignment    : "center",
                width        : 65,
            },
            {
                dataField    : "imag_data",
                caption      : "표출메시지",
                alignment    : "center",
                cellTemplate(c,e){
                    c.css('padding','3px')
                    const imgSrc = 'data:image/png;base64,'+ e.displayValue
                    return c.append($('<img src="'+imgSrc+'">'));
                }
            },
        ],
    }).dxDataGrid('instance');

    hsTable = $('.history-table').width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['vms_ctlr_nmbr', 'dspl_dt', 'dspl_phase_seq'],
        scrolling               : {
            mode : 'standard',
        },
        selection: {
            mode: 'single',
        },
        headerFilter: {
            visible: true,
        },
        paging: {
            enabled: true,
            pageSize: 1000,
        },
        grouping: {
            autoExpandAll: true,
        },
        sorting:{
            showSortIndexes: false,
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled : true,
            texts   : {
                exportAll:"엑셀 파일",
            },
        },
        columns:[
                    {
                        dataField    : "vms_ctlr_nmbr",
                        caption      : "번호",
                        alignment    : "center",
                        width        : 120,
                        sortIndex    : 2, 
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "vms_ctlr_id",
                        caption      : "VMS ID",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_nm",
                        caption      : "VMS 명칭",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "dspl_dt",
                        caption      : "제공 시각",
                        alignment    : "center",
                        sortIndex    : 1, 
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "dspl_phase_seq",
                        caption      : "순서",
                        alignment    : "center",
                        sortIndex    : 3, 
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "trfc_situ_type_desc",
                        caption      : "폼유형",
                        alignment    : "center",
                    },
                    {
                        dataField    : "vms_dspl_msg_txt",
                        caption      : "표출문구",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left')
                            return c.text(e.displayValue)
                        }
                    },
                    {
                        dataField    : "dnld_yn",
                        caption      : "전송결과",
                        alignment    : "center",
                        lookup       :{
                            dataSource:[
                                {
                                    dnld_yn      : 'Y',
                                    dnld_yn_desc : '성공',
                                },
                                {
                                    dnld_yn      : 'N',
                                    dnld_yn_desc : '실패',
                                },
                            ],
                            displayExpr : 'dnld_yn_desc',
                            valueExpr   : 'dnld_yn'
                        },
                        cellTemplate(c,e){
                            c.css('padding', '3px');
                            c.css('height', '1px');
                            const div = $('<span class="tdBox '+e.data.dnld_yn+'">').text(e.displayValue)
                            c.append(div)
                            return c
                        }
                    },
                ],
                onExporting(e){
                    gridExcellExporting(e, _pageName);
                },
                onFocusedRowChanged(e){
                    const rowData = e.row.data;
                    if (rowData){
                        if((vmsNum === "" && vmsDate === "") || vmsNum !== rowData.vms_ctlr_nmbr || vmsDate !== rowData.dspl_dt){
                            dsplData = [];
                            vmsNum  = rowData.vms_ctlr_nmbr;
                            vmsDate = rowData.dspl_dt;
                            const date = getDate(vmsDate.substring(0,10), new Date(vmsDate).getTime())
                            getData( commonUri + "/images", dsplData, {id:vmsNum, DSPL_DT:date} )
                            dsplTable.option('dataSource',dsplData[0]);
                            dsplBoxArr.map((item)=>{
                                item.box.option('value', rowData[item.column])
                            })
                            vmsFormNumBox.box.option('value', "폼 건수 : " + dsplData[0].length )
                        }
                    }
                }
    }).dxDataGrid('instance');
})

 //구간별 데이터 세팅
 function hsEvent() {
     let TO_DT        = null;
     let FROM_DT      = null;
     let id           = "";
     const selectData = hsListTalbe.getSelectedRowsData();
     let updateData = {};
    
     switch (true) {

         case selectData <= 0 :
            alertWarning('VMS가 선택 되지 않았습니다.<br>VMS 목록에서 VMS를 선택해주세요');
            return false;

         case !validationCheck( hsStartDate, hsEndDate, hsStartTime, hsEndTime ) :
            return false;

         case getDate( hsStartDate.option('value'), hsStartTime.option('value') ) > getDate( hsEndDate.option('value'), hsEndTime.option('value') ):
            hsStartDate.focus();
            alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', hsStartDate);
            return false;

         default:

            FROM_DT = getDate( hsStartDate.option('value'), hsStartTime.option('value') );
            TO_DT = getDate( hsEndDate.option('value'), hsEndTime.option('value') );
            for( idx in selectData){
                id += selectData[idx].vms_ctlr_nmbr + ",";
            }
            break;
     }
    
    updateData[ 'FROM_DT' ] = FROM_DT;
    updateData[ 'TO_DT' ]   = TO_DT;
    updateData[ 'id' ]      = id.slice(0,-1)
    hsData = [];
    console.log(updateData);
    getDataAsync( commonUri, (jsonData)=>{
        hsData = jsonData;
        
        if ( hsData.length > 0){
            hsData.map((item)=>{
                if(nullChecker(item.dspl_dt) !== ""){
                    item.dspl_dt = getParseDateTime(item.dspl_dt)
                }
           })
        }

        hsTable.option( 'dataSource', hsData );
        hsTable.option( 'paging', {
            pageIndex : 0,
        })

        alertConfirm('데이터 조회가 완료 되었습니다. [' + hsData.length + '건]');
    }, null,updateData );
 }
