import { EditLinkLineSize, EditLinkColor, TrafficGradeColor } from "./map-const.js";

export class TPolyline {
    constructor(ALyrInfo, ARefObj, AEle) {
        this.lyrInfo = ALyrInfo;
        this.obj = ARefObj;
        this.NMBR = ARefObj.NMBR;
        this.NAME = ARefObj.NAME;
        this.color = 0;
        this.marker = null;
        this.backPoly = null;
        this.infoWin = null;
        this.cmtrGradCd = "9";

        this.X_MIN = 99999;
        this.X_MAX = 0;
        this.Y_MIN = 99999;
        this.Y_MAX = 0;

        this.makePolyline(AEle);
    } // constructor

    getMarker(AZoomLevel) {
        this.setMarkerStyle(AZoomLevel);
        return this.marker;
    }
    // 소통정보 표출 폴리라인 생성
    makePolyline(AEle) {
        const arrX = AEle.x_crdn_arr.split(",");
        const arrY = AEle.y_crdn_arr.split(",");
        let lineCoordinates = [];
        for (let ii = 0; ii < arrX.length; ii++) {
            let lineArr = [];
            lineArr.push(Number(arrX[ii]), Number(arrY[ii]));
            lineCoordinates.push(lineArr);

            this.X_MIN = Math.min(this.X_MIN, AEle.x_crdn_min);
            this.X_MAX = Math.max(this.X_MAX, AEle.x_crdn_max);
            this.Y_MIN = Math.min(this.Y_MIN, AEle.y_crdn_min);
            this.Y_MAX = Math.max(this.Y_MAX, AEle.y_crdn_max);
        }
        this.marker = new ol.Feature({
            obj: this,
            geometry: new ol.geom.LineString(lineCoordinates),
        });
    }

    // 소통정보 폴리라인 스타일 설정
    setMarkerStyle(ACurrZoom, AImmediate) {
        const currZoom = ACurrZoom;
        const CURR_CD = Number(this.cmtrGradCd);
        const GRAD_CD = Number(this.obj.cmtrGradCd);
        const lineWidth = EditLinkLineSize[currZoom];
        if (AImmediate || CURR_CD != GRAD_CD) {
            const featureStyle = [
                new ol.style.Style({
                    stroke: new ol.style.Stroke({
                        color: this.lyrInfo.backPolyColor, //'#000', '#FFFFFF'
                        width: lineWidth + 2,
                        //lineCap: "square",
                        //lineJoin: "round",
                    }),
                    ZIndex: 2,
                }),
                new ol.style.Style({
                    stroke: new ol.style.Stroke({
                        color: TrafficGradeColor[GRAD_CD],
                        width: lineWidth,
                        //lineCap: "square",
                    }),
                    ZIndex: 1,
                }),
            ];
            this.marker.setStyle(featureStyle);
        }
        this.cmtrGradCd = this.obj.cmtrGradCd;
    }

    // 편집용 소통정보 폴리라인 스타일 설정
    setEditMarkerStyle(ACurrZoom) {
        if (this.marker == null) {
            return;
        }
        const currZoom = ACurrZoom;
        let lineWidth = EditLinkLineSize[currZoom];
        if (this.color > 0) {
            lineWidth = lineWidth + 4;
        }
        const featureStyle = [
            new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: this.lyrInfo.backPolyColor, //'#000', '#FFFFFF'
                    width: lineWidth + 2,
                }),
                ZIndex: 2,
            }),
            new ol.style.Style({
                stroke: new ol.style.Stroke({
                    color: EditLinkColor[this.color],
                    width: lineWidth,
                }),
                ZIndex: 1,
            }),
        ];
        this.marker.setStyle(featureStyle);
    }
}

export let _trafMap = new Map();
export class TTraffic {
    constructor(ALyrInfo, AId, AName, AStrtNm, AEndNm, ASectLngt) {
        this.lyrInfo = ALyrInfo;
        this.lyrIdx = ALyrInfo.lyrIdx;
        this.NMBR = AId;
        this.ID = AId;
        this.NAME = AName;
        this.STRT_NM = AStrtNm;
        this.END_NM = AEndNm;
        this.SECT_LNGT = ASectLngt;

        this.cmtrGradCd = "0";
        this.sped = 0;
        this.trvlHh = 0;
        this.missYn = "Y";
        this.prcnDt = "19700101000000";

        this.edit = false;
        this.deleted = false;
    }

    // 소통정보 업데이트
    updateTraf(ADto) {
        const oldCmtrGradCd = this.cmtrGradCd;
        this.cmtrGradCd = ADto.cmtr_grad_cd.slice(-1);
        this.sped = ADto.sped;
        this.trvlHh = ADto.trvl_hh;
        this.missYn = ADto.miss_yn;
        this.prcnDt = ADto.prcn_dt;
    }
    initTraf() {
        this.cmtrGradCd = "0";
        this.sped = 0;
        this.trvlHh = 0;
        this.missYn = "Y";
        this.prcnDt = "19700101000000";
    }
}

export let _linkMap = new Map();
export class TLink extends TTraffic {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.link_id, ADto.road_name, ADto.from_node, ADto.to_node, ADto.link_leng);
        this.fNodeId = ADto.f_node_id;
        this.tNodeId = ADto.t_node_id;
        this.roadUse = ADto.road_use;
        this.lanes = ADto.lanes;
        this.roadRank = ADto.road_rank;
        this.roadType = ADto.road_type;
        this.roadNo = ADto.road_no;
        this.multiLink = ADto.multi_link;
        this.linkConnect = ADto.link_connect;
        this.maxSpd = ADto.max_spd;
        this.restVeh = ADto.rest_veh;
        this.restW = ADto.rest_w;
        this.restH = ADto.rest_h;
        this.rmrk = ADto.rmrk;
        this.delYn = ADto.del_yn;
        this.dfltSped = ADto.dflt_sped;
        this.dfltSpedUseYn = ADto.dflt_sped_use_yn;
        this.sectGradCd = ADto.sect_grad_cd;
        this.areaCd = ADto.area_cd;
        this.paraId = ADto.para_id;
    }
}

export let _ifscMap = new Map();
export class TIfsc extends TTraffic {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.ifsc_id, ADto.ifsc_nm, ADto.strt_nm, ADto.end_nm, ADto.sect_lngt);
        this.drctCd = ADto.drct_cd;
        this.extrCnctSectYn = ADto.extr_cnct_sect_yn;
        this.delYn = ADto.del_yn;
        this.rmrk = ADto.rmrk;
        this.fNodeId = ADto.f_node_id;
        this.tNodeId = ADto.t_node_id;
        this.sectGradCd = ADto.sect_grad_cd;
        this.areaCd = ADto.area_cd;
    }
}

export let _roadMap = new Map();
export class TRoad extends TTraffic {
    constructor(ALyrInfo, ADto) {
        super(ALyrInfo, ADto.road_id, ADto.road_name, ADto.strt_nm, ADto.end_nm, ADto.sect_lngt);
        this.drctCd = ADto.drct_cd;
        this.delYn = ADto.del_yn;
        this.fNodeId = ADto.f_node_id;
        this.tNodeId = ADto.t_node_id;
        this.sectGradCd = ADto.sect_grad_cd;
        this.areaCd = ADto.area_cd;
    }
}
