let inputArr        = [];
let selectListTable = null;
let id              = window.opener.$('.prcd_link_id').dxTextBox('instance').option('value');
if (isNaN(id)) {
    id = id.substring(id.indexOf('[')+1, id.indexOf(']'));
}
$(() => {

    inputArr      = [
        {
            box      : null,
            class    : 'link_id',
            width    : 140,
            disabled : true,
            value    : id
        },
        {
            box      : null,
            class    : 'link_levl',
            width    : 70,
            disabled : false,
            value    : '1',
        },
        {
            box      : null,
            class    : 'link_leng',
            width    : 117,
            disabled : false,
        },
        {
            box      : null,
            class    : 'f_node_id',
            width    : 140,
            disabled : false,
        },
        {
            box      : null,
            class    : 'from_node',
            width    : 320,
            disabled : false,
        },
        {
            box      : null,
            class    : 't_node_id',
            width    : 140,
            disabled : false,
        },
        {
            box      : null,
            class    : 'to_node',
            width    : 320,
            disabled : false,
        },
        {
            box      : null,
            class    : 'road_name',
            width    : 320,
            disabled : false,
        },
    ];

    inputArr.map((item)=>{
        item.box = $('.'+ item.class).dxTextBox({
            width       : item.width,
            stylingMode : 'outlined',
            height      : 25,
            value       : item.value,
            disabled    : item.disabled,
            readOnly    : true,
        }).dxTextBox('instance');
    });

    selectListTable = $('.select-list-table')
        .width('100%')
        .height('100%')
        .dxDataGrid({
            dataSource              : [],
            allowColumnReordering   : true,
            showColumnLines         : true,
            allowColumnResizing     : true,
            showBorders             : true,
            rowAlternationEnabled   : true,
            columnAutoWidth         : true,
            focusedRowEnabled       : true,
            noDataText              : '표출할 정보가 없습니다.',
            keyExpr                 : 'vms_ctlr_id',
            selection: {
                mode: 'single',
            },
            headerFilter: {
                visible: true,
            },
            scrolling: {
                mode: 'virtual',
            },
            grouping: {
                autoExpandAll: true,
            },
            columns: [
                {
                    dataField : 'vms_id',
                    caption   : 'VMS ID',
                    alignment : 'center',
                },
                {
                    dataField : 'vms_ctlr_id',
                    caption   : 'VMS 제어기 ID',
                    alignment : 'center',
                },

                {
                    dataField : 'vms_nm',
                    caption   : 'VMS 명',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },

            ],
        })
        .dxDataGrid('instance');

    $('.cancle-button').dxButton({
        stylingMode : 'outlined',
        icon        : 'close',
        text        : '닫기',
        onClick() {
            window.close();
        },
    });

    fetchBaseData();
});

function fetchBaseData(){
    getDataAsync('/api/manage/incident/vms/link/' + encodeURIComponent(id), recvListData);
    getDataAsync('/api/database/link/' + encodeURIComponent(id), recvInputData);
}

function recvListData(jsonData) {
    selectListTable.option('dataSource', jsonData);
}

function recvInputData(jsonData) {
    linkData = jsonData;
    if(linkData){
        inputArr.map((item)=>{
            if (linkData[item.class]) {
                item.box.option('value', linkData[item.class]);
            }
        });
    }
}