let cancleBtn = null;
let searchBtn = null;
let sttsData  = [];
let sttsTable = null;
const commonUri = '/api/cctv/monitoring/stts';

btnArr = [
    cancleBtn = {
        class  : 'close-btn',
        box    : null,
        text   : '닫기',
        icon   : 'close',
        method : function(){
            window.close();
        }
    },
    searchBtn = {
        class  : 'search-btn',
        box    : null,
        text   : '조회',
        icon   : 'refresh',
        method : function(){
            fetchListData();
        }
    },
]
$(()=>{
    //CCTV 상태 전체조회 테이블
    sttsTable = $(".stts-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        headerFilter: {
            visible: true,
        },
        selection  : {
            mode :'single'
        },
        keyExpr : 'cctv_mngm_nmbr',
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                caption   : 'CCTV 정보',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "cctv_mngm_nmbr",
                        caption      : "번호",
                        alignment    : "center",
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                    },
                    {
                        dataField    : "cctv_ctlr_id",
                        caption      : "CCTV ID",
                        alignment    : "center",
                    },
                    {
                        dataField    : "istl_lctn_nm",
                        caption      : "CCTV 명칭",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('text-align','left');
                            c.text(e.displayValue)
                        }
                    },
                ]
            },
            {
                caption   : '통신',
                alignment : 'center',
                columns   : [
                    {
                        dataField    : "updt_dt",
                        caption      : "업데이트 시각",
                        alignment    : "center",
                    },
                    {
                        dataField    : "cmnc_stts_desc",
                        caption      : "통신 상태",
                        alignment    : "center",
                        cellTemplate(c,e){
                            c.css('padding','2px');
                            c.css('height','1px');
                            
                            const div = $('<div class='+e.data.cmnc_stts_cd+'>').css({width:'100%',height:'100%'});
                            div.text(e.displayValue);
                            return c.append(div);
                        }
                    },
                ]
            },
        ],
      
        
    }).dxDataGrid("instance");

    btnArr.map((obj)=>{
        creatBtn($('.' + obj.class), obj.icon, obj.text, obj.text, 'outlined', obj.method);
    });

    fetchListData();
})

function fetchListData(){
    getDataAsync(commonUri, (jsonData)=>{
        const listData = jsonData;
        if (listData.length > 0) {
            listData.map((item)=>{
                if(item.updt_dt)item.updt_dt = getParseDateTime(item.updt_dt);
            })
        }
        sttsTable.option('dataSource', listData);
    });
}