let listTable       = null;
let commonUri       = "/api/cctv/monitoring/camera";
let nameText        = null;
let saveBtn         = null;
let cancleBtn       = null;
let addBtn          = null;
let delBtn          = null;
let editBtn         = null;
let listDelBtn      = null;
let listAddBtn      = null;
let listUpBtn       = null;
let listDownBtn     = null;
let allTable        = null;
let montPrpcTable   = null;

//하단 버튼들
const btnArr    = [
    editBtn = {
        class       : "edit-btn",
        box         : null,
        option      : 80,
        visible     : true,
        disabled    : true,
        selectdsb   : false,
        click   : {
            visible  : false,
            disabled : false,
        },
        selected : {
            visible  : true,
            disabled : false,
        }
        ,
        unSelected : {
            visible  : true,
            disabled : true,
        },
        addvsb      : false,
        icon        : "edit",
        text        : "편집",
        method      : function(){
            editEvent();
        }
    },
    cancleBtn = {
        class       : "cancle-btn",
        box         : null,
        option      : 80,
        visible     : false,
        disabled    : false,
        selectdsb   : false,
        click   : {
            visible  : true,
            disabled : false,
        },
        selected : {
            visible  : false,
            disabled : false,
        }
        ,
        unSelected : {
            visible  : false,
            disabled : false,
        },
        addvsb      : true,
        icon        : "close",
        text        : "취소",
        method      : function(){
            eventOff();
            const selectedData = listTable.getSelectedRowsData();

            if ( selectedData.length > 0 ){
                let montPrpcData = [];
                refresh( montPrpcTable, montPrpcData, commonUri + "/" + selectedData[0].monitoring_nm );
                btnArr.map((item)=>{
                    item.box.option('visible', item.selected.visible);
                    item.box.option('disabled', item.selected.disabled);
                    setValue(nameText, selectedData[0].monitoring_nm);
                })
                return false;
            }

            btnArr.map((item)=>{
                item.box.option('visible', item.unSelected.visible)
                item.box.option('disabled', item.unSelected.disabled)
            })

            montPrpcTable.option( 'dataSource', [] );
        }
    },
    addBtn = {
        class       : "add-btn",
        box         : null,
        option      : 80,
        disabled    : false,
        visible     : true,
        click   : {
            visible  : true,
            disabled : true,
        },
        selected : {
            visible  : true,
            disabled : false,
        }
        ,
        unSelected : {
            visible  : true,
            disabled : false,
        },
        selectdsb       : false,
        adddsb      : true,
        icon        : "plus",
        text        : "추가",
        method      : function(){
            addEvent();
        }
    },
    delBtn = {
        class       : "del-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        visible     : true,
        click   : {
            visible  : true,
            disabled : true,
        },
        selected : {
            visible  : true,
            disabled : false,
        }
        ,
        unSelected : {
            visible  : true,
            disabled : true,
        },
        selectdsb       : false,
        adddsb      : true,
        icon        : "minus",
        text        : "삭제",
        method      : function(){
            if(listTable.getSelectedRowsData().length > 0 ){
                confirmMessage('선택하신 모니터링 화면 정보를 삭제하시겠습니까?').done((yes)=>{
                    if (yes === true) {
                        let result = deleteData(commonUri, listTable.getSelectedRowsData()[0].monitoring_nm)
                        if(result > 0){
                            alertConfirm('모니터링 화면 정보를 삭제하였습니다.');
                            eventOff();

                            //가운데 테이블 빈값 세팅
                            montPrpcTable.option('dataSource', []);
                            nameText.option('value', null);
                            btnArr.map((item)=>{
                                item.box.option('visible', item.unSelected.visible)
                                item.box.option('disabled', item.unSelected.disabled)
                            });

                            perentSettings(null, 'delete');
                            return false;
                        }
                    }
                });
            }
        }
    },
    saveBtn = {
        class       : "save-btn",
        box         : null,
        option      : 80,
        disabled    : true,
        selectdsb       : true,
        click   : {
            visible  : true,
            disabled : false,
        },
        selected : {
            visible  : true,
            disabled : true,
        }
        ,
        unSelected : {
            visible  : true,
            disabled : true,
        },
        adddsb      : false,
        visible     : true,
        icon        : "save",
        text        : "저장",

    },

]

//우측 버튼들
const listBtnArr    = [
    listAddBtn = {
        class       : "list-add-btn",
        box         : null,
        option      : 95,
        visible     : true,
        disabled    : true,
        icon        : "arrowleft",
        text        : "등록",
        method      : function(){
            insertEvent()
        }
    },
    listDelBtn = {
        class       : "list-del-btn",
        box         : null,
        option      : 95,
        visible     : true,
        disabled    : true,
        icon        : "arrowright",
        text        : "삭제",
        method      : function(){
            deleteEvent();
        }
    },
    listUpBtn = {
        class       : "list-up-btn",
        box         : null,
        option      : 95,
        disabled    : true,
        visible     : true,
        icon        : "spinup",
        text        : "위로",
        method      : function(){
            listMove(-1);
        }
    },
    listDownBtn = {
        class       : "list-down-btn",
        box         : null,
        option      : 95,
        disabled    : true,
        visible     : true,
        icon        : "spindown",
        text        : "아래로",
        method      : function(){
            listMove(1);
        }
    },

]


$(()=>{

    //화면 관리 리스트 테이블
    listTable = $(".list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'monitoring_nm',
        selection: {
            mode: 'single',
        },
        scrolling: {
            mode: 'virtual',
        },
        columns:[
            {
                dataField    : "monitoring_nm",
                caption      : "화면명칭",
                alignment    : "center",
                cellTemplate(c, e){
                    c.css('text-align', 'left')
                    c.text(e.displayValue)
                }
            },
            {
                dataField    : "count",
                caption      : "갯수",
                width        : 50,
                alignment    : "center",
            },

        ],

        onRowClick(e){
            if( e.component.option('selection').mode === 'single' ){
                let montPrpcData = [];
                montPrpcData = refresh(montPrpcTable, montPrpcData, commonUri+"/"+e.data.monitoring_nm);

                nameText.option('value', e.data.monitoring_nm);

                btnArr.map((item)=>{
                    item.box.option('disabled', item.selectdsb)
                })
            }
        }
    }).dxDataGrid("instance");

    //가운데 설정 테이블
    montPrpcTable = $(".mont-prpc-table").width('100%').height('100%').dxDataGrid({
        dataSource              : [],
        allowColumnReordering   : true,
        showColumnLines         : true,
        activeStateEnabled      : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : false,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : "monitoring_seq",
        editing                 :{
            confirmDelete : false,
        },
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard',
        },
        columns:[
            {
                dataField    : "monitoring_seq",
                caption      : "Seq",
                alignment    : "center",
                width        : 80,
            },
            {
                dataField    : "cctv_ctlr_nmbr",
                caption      : "No",
                width        : 70,
                alignment    : "center",
            },
            {
                dataField    : "istl_lctn_nm",
                caption      : "명칭",
                alignment    : "center",
                cellTemplate(c, e){
                    c.css('text-align', 'left')
                    c.text(e.displayValue)
                }
            },
        ],
    }).dxDataGrid("instance");

    //name textbox
    nameText = $(".name-select").dxTextBox({
        width       : 250,
        height      : 25,
        maxLength   : 40,
        stylingMode : 'outlined',
        disabled    : true,
    }).dxTextBox('instance');

    //우측 전체 테이블
    allTable = $(".all-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : false,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'cctv_mngm_nmbr',
        scrolling: {
            mode: 'virtual',
        },
        columns:[
            {
                dataField    : "cctv_mngm_nmbr",
                caption      : "No",
                alignment    : "center",
                width        : 75,
                sortIndex    : 0,
                sortOrder    : "asc",
            },
            {
                dataField    : "cctv_ctlr_id",
                caption      : "ID",
                alignment    : "center",
                width        : 75,
            },
            {
                dataField    : "istl_lctn_nm",
                caption      : "명칭",
                alignment    : "center",
                cellTemplate(c, e){
                    c.css('text-align', 'left')
                    c.text(e.displayValue)
                }
            },
            {
                dataField    : "cctv_type",
                caption      : "유형",
                width        : 55,
                alignment    : "center",
            },
        ],
    }).dxDataGrid("instance");


    // 하단 버튼들 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon,
            width             : item.option,
            text              : item.text,
            visible           : item.visible,
            disabled          : item.disabled,
            focusStateEnabled : false,
            stylingMode       : 'outlined',
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    })

    // 가운데 버튼들 세팅
    listBtnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon,
            width             : item.option,
            text              : item.text,
            visible           : item.visible,
            disabled          : item.disabled,
            focusStateEnabled : false,
            stylingMode       : 'outlined',
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    })
    fetchListData();
})

function fetchListData() {
    getDataAsync( commonUri + '/list', recvData, listTable);
    getDataAsync('/api/cctv/common/cctv-list', recvData, allTable);
}

function recvData(jsonData, table) {
    table.option('dataSource', jsonData);
}

//하단 편집 이벤트
function editEvent(){
    eventOn();
    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('update'));
}

//하단 추가 이벤트
function addEvent(){
    eventOn();
    nameText.option('value', null)
    montPrpcTable.option('dataSource', []);
    saveBtn.box.off('click');
    saveBtn.box.on('click', () => saveEvent('add'));
}

//이벤트 시작
function eventOn(){

    btnArr.map((item)=>{
        item.box.option('visible', item.click.visible)
        item.box.option('disabled', item.click.disabled)
    })

    listTable.option('disabled', true);

    montPrpcTable.option('selection', {
        mode:'multiple',
        deferred: false,
        allowSelectAll:true,
        selectAllMode:"allPages",
        showCheckBoxesMode:"onClick"
    });

    allTable.option('selection', {
        mode:'multiple',
        deferred: false,
        allowSelectAll:true,
        selectAllMode:"allPages",
        showCheckBoxesMode:"onClick"
    })

    nameText.option('disabled', false);

    listBtnArr.map((item)=>{
        item.box.option('disabled', false);
    })
}

//이벤트 취소
function eventOff(){
    //리스트 테이블 클릭온
    listTable.option('disabled', false);

    //가운데 테이블 셀렉트 방지
    montPrpcTable.option('selection', {
        mode: 'none'
    });

    //전체 테이블 셀렉트 방지
    allTable.option('selection', {
        mode: 'none'
    });
    let value = nameText.option('value')
    //네임 텍스트 입력 방지
    nameText.option('disabled', true);

    // 추가 제외 버튼 클릭 방지
    listBtnArr.map((item)=>{
        item.box.option('disabled', true);
    })

    return value

}

//등록 이벤트 우측
function insertEvent(){
    //테이블 선택이 있다면 실행
    if(allTable.getSelectedRowsData().length > 0){

        let dataSource = [...montPrpcTable.option('dataSource')];
        const cctvMngmNmbrArr = [];
        dataSource.map((item)=>{
            cctvMngmNmbrArr.push(item.cctv_ctlr_nmbr);
        });

        const allTableData = allTable.getSelectedRowsData();
        for(let data of allTableData){
            if(cctvMngmNmbrArr.includes(data.cctv_mngm_nmbr)){
                return alertWarning('이미 등록 되어 있는 모니터링 화면이 포함되어 있습니다.');
            }
        }
        allTableData.sort(function(a,b){
            return a['cctv_mngm_nmbr'] > b['cctv_mngm_nmbr']? 1:  a['cctv_mngm_nmbr'] < b['cctv_mngm_nmbr']? -1:0;
        })
        //데이터 값이 있을때 seq설정
        if(dataSource.length > 0){
            //desc sorting
            dataSource.sort(function(a, b){
                return a['monitoring_seq'] < b['monitoring_seq']? -1: a['monitoring_seq'] > b['monitoring_seq']? 1:0;
            })

            //가운데 테이블 데이터에 추가
            for(let key in allTableData){
                dataSource.push({
                    cctv_ctlr_id    : allTableData[key].cctv_ctlr_id,
                    cctv_ctlr_nmbr  : allTableData[key].cctv_mngm_nmbr,
                    istl_lctn_nm    : allTableData[key].istl_lctn_nm,
                    monitoring_nm   : nameText.option('value'),
                    monitoring_seq  : dataSource[dataSource.length - 1].monitoring_seq + 1,
                    monitoring_type : 3,
                    strm_rtmp_addr  : allTableData[key].strm_rtmp_addr
                })
            }
            //테이블 데이터 세팅
            montPrpcTable.option('dataSource', dataSource);
            allTable.clearSelection();
            return
        }
        //데이터 값이 없을때 seq설정
        for( key in allTableData){
            dataSource.push({
                cctv_ctlr_id    : allTableData[key].cctv_ctlr_id,
                cctv_ctlr_nmbr  : allTableData[key].cctv_mngm_nmbr,
                istl_lctn_nm    : allTableData[key].istl_lctn_nm,
                monitoring_nm   : nameText.option('value'),
                monitoring_seq  : Number(key) + 1,
                monitoring_type : 3,
                strm_rtmp_addr  : allTableData[key].strm_rtmp_addr
            })
        }
        montPrpcTable.option('dataSource', dataSource);
        allTable.clearSelection();
    }
}

//삭제 이벤트 우측
function deleteEvent(){
    //가운데 테이블 선택 값이 있을 경우 실행
    if ( montPrpcTable.getSelectedRowKeys().length > 0 ){

        $(montPrpcTable.getSelectedRowKeys()).each(function(index, element){
            let rowIndex = montPrpcTable.getRowIndexByKey(element);
            montPrpcTable.deleteRow(rowIndex);
            montPrpcTable.refresh();
        });

        let dataSource = montPrpcTable.option("dataSource");
        //asc sorting
        dataSource.sort(function(a, b){
            return a['monitoring_seq'] < b['monitoring_seq']? -1: a['monitoring_seq'] > b['monitoring_seq']? 1:0;
        })

        //삭제 값이 중간 값이라면 seq 값 순서대로 세팅
        for(key in dataSource) {
            dataSource[key].monitoring_seq === Number(key) + 1 ? dataSource[key].monitoring_seq : dataSource[key].monitoring_seq = Number(key) + 1
        }


        //테이블에 데이터 세팅
        montPrpcTable.option('dataSource', dataSource);
        montPrpcTable.clearSelection();

    }
}

//위, 아래 리스트 이동 이벤트
let isMove = true;
function listMove(changeNum){
    if (!isMove) {
        console.log("dup click. move dn");
        return;
    }
    const selRowKeys = montPrpcTable.getSelectedRowKeys();
    if (selRowKeys == 0) {
        console.log("unselected: ", montPrpcTable.getSelectedRowsData().length);
        return;
    }
    const selectKey = selRowKeys[0];
    const selectRow = montPrpcTable.getRowIndexByKey(selectKey);
    const changeRow = selectRow + changeNum;
    let result = false;

    if(changeNum === 1){
        result = changeRow < montPrpcTable.option('dataSource').length ? true : false;
    }
    else{
        result = changeRow >= 0 ? true : false;
    }

    if (result) {
        isMove = false;
        const dataSource = [...montPrpcTable.option('dataSource')];
        dataSource.sort(function(a,b){
            return a['monitoring_seq'] - b['monitoring_seq'];
        })
        const selectData = {...dataSource[selectRow]};
        const changeData = {...dataSource[changeRow]};

        const columns = ['cctv_ctlr_nmbr', 'strmrtmpaddr','istl_lctn_nm','cctv_ctlr_id','strm_http_addr','monitoring_nm','monitoring_type'];
        columns.forEach((column) => {
            dataSource[selectRow][column] = changeData[column];
            dataSource[changeRow][column] = selectData[column];
        });

        montPrpcTable.option('dataSource', dataSource);

        montPrpcTable.refresh().done(()=>{
            montPrpcTable.clearSelection();
            montPrpcTable.selectRowsByIndexes(changeRow);
            montPrpcTable.option('focusedRowIndex', changeRow);

            isMove = true;
        });
    }
}
//저장 이벤트
function saveEvent(type){
    let name = nameText.option('value');
    let selectedData = listTable.getSelectedRowsData();
    let updateData = {
        infos: [],
        monitoring_nm: name,
        monitoring_type : 3,
        org_monitoring_nm : name,
    };

    let monitoringNmArr = [];
    listTable.option('dataSource').map((obj)=>{
        monitoringNmArr.push(obj.monitoring_nm);
    });

    if (nullChecker(name) === "") {
        alertWarning('모니터링 화면 명칭을 입력해주세요', null, nameText);
        return false;
    }
    else if (getByteLength(name) > 40) {
        alertWarning('모니터링 화면 명칭을 40바이트 이내로 입력해주세요', null, nameText);
        return false;
    }
    else if ( montPrpcTable.option('dataSource').length <= 0 ){
        alertWarning('모니터링 대상을 추가해주세요');
        return false;
    }
    else if (type !== "update" && monitoringNmArr.includes(name)){
        alertWarning('이미 사용중인 모니터링 화면 명칭입니다.', null, nameText);
        return false;
    }

    if (selectedData.length > 0 && type === "update"){
        if (monitoringNmArr.includes(name) && selectedData[0].monitoring_nm !== name){
            alertWarning('이미 사용중인 모니터링 화면 명칭입니다.', null, nameText);
            return false;
        }
        updateData.org_monitoring_nm = listTable.getSelectedRowsData()[0].monitoring_nm
    }

    montPrpcTable.option('dataSource').map((item) => {
        updateData.infos.push( {
            ctlr_nmbr: item.cctv_ctlr_nmbr,
            monitoring_seq: item.monitoring_seq,
            view_mode: 1,
        });

    });


    let result = postInsertUpdate(commonUri, updateData);
    if(result > 0){
        let key = eventOff();
        perentSettings(key, type);

        btnArr.map((item)=>{
            item.box.option('visible', item.selected.visible)
            item.box.option('disabled', item.selected.disabled)
        });

        return alertConfirm('모니터링 화면 정보를 저장 하셨습니다.');
    }
}
