let listTable       = null;
let commonUri       = "/api/vms/manager/vms-ifsc-rltn";
let allData         = [];
let listData        = [];
let nameList        = [];
let partData        = [];
let montPrpcData    = [];
let nameText        = null;
let saveBtn         = null;
let cancleBtn       = null;
let addBtn          = null;
let delBtn          = null;
let editBtn         = null;
let listDelBtn      = null;
let listAddBtn      = null;
let listUpBtn       = null;
let listDownBtn     = null;
let allTable        = null;
let montPrpcTable   = null;
let shiftKey        = false;
let idArray         = null;

//하단 버튼들
const btnArr    = [
    editBtn = {
        class       : "edit-btn", 
        box         : null, 
        option      : 80, 
        visible     : true, 
        disabled    : true, 
        selectdsb   : false, 
        click   : {
            visible  : false, 
            disabled : false, 
        }, 
        selected : {
            visible  : true, 
            disabled : false, 
        }
        , 
        unSelected : {
            visible  : true, 
            disabled : true, 
        }, 
        addvsb      : false, 
        icon        : "edit", 
        text        : "편집", 
        method      : function(){
            editEvent();
        }
    }, 
    cancleBtn = {
        class       : "cancle-btn", 
        box         : null, 
        option      : 80, 
        visible     : false, 
        disabled    : false, 
        selectdsb   : false, 
        click   : {
            visible  : true, 
            disabled : false, 
        }, 
        selected : {
            visible  : false, 
            disabled : false, 
        }
        , 
        unSelected : {
            visible  : false, 
            disabled : false, 
        }, 
        addvsb      : true, 
        icon        : "close", 
        text        : "취소", 
        method      : function(){
            cancleEvent();
        }
    }, 
    saveBtn = {
        class       : "save-btn", 
        box         : null, 
        option      : 80, 
        disabled    : true, 
        selectdsb       : true, 
        click   : {
            visible  : true, 
            disabled : false, 
        }, 
        selected : {
            visible  : true, 
            disabled : true, 
        }
        , 
        unSelected : {
            visible  : true, 
            disabled : true, 
        }, 
        adddsb      : false, 
        visible     : true, 
        icon        : "save", 
        text        : "저장", 
        method      : function(){
            saveEvent();
        }
    }, 
   
]

//우측 버튼들
const listBtnArr    = [
    listAddBtn = {
        class       : "list-add-btn", 
        box         : null, 
        option      : 95, 
        visible     : true, 
        disabled    : true, 
        icon        : "arrowleft", 
        text        : "등록", 
        method      : function(){
            insertEvent()
        }
    }, 
    listDelBtn = {
        class       : "list-del-btn", 
        box         : null, 
        option      : 95, 
        visible     : true, 
        disabled    : true, 
        icon        : "arrowright", 
        text        : "삭제", 
        method      : function(){
            deleteEvent();
        }
    }, 
]

getData(commonUri + '/vms-ifsc', allData);
getData('/api/vms/common/vms-list', listData);
$(()=>{

    creatBtn($(".close-btn"), "close", "닫기", "닫기", "outlined", () => window.close());
    
    //화면 관리 리스트 테이블
    listTable = $(".list-table").width('100%').height('100%').dxDataGrid({
        dataSource              : listData[0], 
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'vms_ctlr_nmbr',
        selection: {
            mode: 'single', 
        }, 
        scrolling: {
            mode: 'virtual', 
        }, 
        columns:[
            {
                dataField    : "vms_ctlr_nmbr", 
                caption      : "번호", 
                alignment    : "center", 
                sortIndex    : 0, 
                sortOrder    : "asc",
            }, 
            {
                dataField    : "vms_ctlr_id", 
                caption      : "VMS ID", 
                alignment    : "center", 
            }, 
            {
                dataField    : "vms_nm", 
                caption      : "VMS 명칭", 
                alignment    : "center",
                cellTemplate(c, e){
                    c.css('text-align', 'left')
                    c.text(e.displayValue)
                }
            }, 
                    
                   
        ], 
      
        onRowClick(e){
            if( e.component.option('selection').mode === 'single' ){
                
                montPrpcData = refresh(montPrpcTable, montPrpcData, commonUri+"/"+e.data.vms_ctlr_nmbr);
                
                btnArr.map((item)=>{
                    item.box.option('disabled', item.selectdsb)
                })
            }
            idArray = getId();
        }
    }).dxDataGrid("instance");

    //가운데 설정 테이블
    montPrpcTable = $(".mont-prpc-table").width('100%').height('100%').dxDataGrid({
        dataSource              : montPrpcData, 
        allowColumnReordering   : true, 
        showColumnLines         : true,
        activeStateEnabled      : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : false,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : "dspl_prrt",
        editing                 :{
            confirmDelete : false, 
        }, 
        paging: {
            enabled: false,
            pageSize: 1000,
        },
        scrolling: {
            mode: 'standard', 
        },
        columns:[
                    {
                        dataField    : "dspl_prrt", 
                        caption      : "순서", 
                        alignment    : "center", 
                        width        : 90,
                        sortIndex    : 0, 
                        sortOrder    : "asc",
                    }, 
                    {
                        dataField    : "vms_ifsc_id", 
                        caption      : "구간 ID", 
                        width        : 70, 
                        alignment    : "center", 
                    }, 
                    {
                        dataField    : "vms_ifsc_nm", 
                        caption      : "제공구간명", 
                        alignment    : "center", 
                        cellTemplate(c, e){
                            c.css('text-align', 'left')
                            c.text(e.displayValue)
                        }
                    }, 
        ], 
    }).dxDataGrid("instance");

    //우측 전체 테이블
    allTable = $(".all-table").width('100%').height('100%').dxDataGrid({
        dataSource              : allData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : false,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'vms_ifsc_id',
        scrolling: {
            mode: 'virtual', 
        }, 
        columns:[
                    {
                        dataField    : "vms_ifsc_id",
                        caption      : "구간 ID",
                        alignment    : "center",
                        sortIndex    : 0,
                        sortOrder    : "asc",
                        width        : 100,
                    }, 
                    {
                        dataField    : "vms_ifsc_nm",
                        caption      : "제공구간명",
                        alignment    : "center",
                    }, 
                    {
                        dataField    : "dspl_strt_node_nm", 
                        caption      : "시점명", 
                        alignment    : "center", 
                        cellTemplate(c, e){
                            c.css('text-align', 'left')
                            c.text(e.displayValue)
                        }
                    }, 
                    {
                        dataField    : "dspl_end_node_nm", 
                        caption      : "종점명", 
                        alignment    : "center",
                        cellTemplate(c, e){
                            c.css('text-align', 'left')
                            c.text(e.displayValue)
                        }
                    }, 
        ], 
    }).dxDataGrid("instance");

  
    // 하단 버튼들 세팅
    btnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon, 
            width             : item.option, 
            text              : item.text, 
            visible           : item.visible, 
            disabled          : item.disabled, 
            focusStateEnabled : false, 
            stylingMode       : 'outlined', 
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    })

    // 가운데 버튼들 세팅
    listBtnArr.map((item)=>{
        item.box = $("." + item.class).dxButton({
            icon              : item.icon, 
            width             : item.option, 
            text              : item.text, 
            visible           : item.visible, 
            disabled          : item.disabled, 
            focusStateEnabled : false, 
            stylingMode       : 'outlined', 
            onClick(){
                if(item.method){
                    item.method();
                }
            }
        }).dxButton("instance")
    })
})

//하단 편집 이벤트
function editEvent(){
    eventOn()
}

//하단 추가 이벤트
function addEvent(){
    eventOn()
    nameText.option('value', null)
    montPrpcTable.option('dataSource', []);
}

//이벤트 시작
function eventOn(){

    btnArr.map((item)=>{
        item.box.option('visible', item.click.visible)
        item.box.option('disabled', item.click.disabled)
    })

    listTable.option('disabled', true);
    
    montPrpcTable.option('selection', {
        mode:'multiple',
        deferred: false,
        allowSelectAll:true,
        selectAllMode:"allPages",
        showCheckBoxesMode:"onClick"
    });

    allTable.option('selection', {
        mode:'multiple',
        deferred: false,
        allowSelectAll:true,
        selectAllMode:"allPages",
        showCheckBoxesMode:"onClick"
    })

    listBtnArr.map((item)=>{
        item.box.option('disabled', false);
    })
}

//이벤트 취소
function eventOff(){
    //리스트 테이블 클릭온
    listTable.option('disabled', false);

    //가운데 테이블 셀렉트 방지
    montPrpcTable.option('selection', {
        mode: 'none'
    });

    //전체 테이블 셀렉트 방지
    allTable.option('selection', {
        mode: 'none'
    });
   
    // 추가 제외 버튼 클릭 방지
    listBtnArr.map((item)=>{
        item.box.option('disabled', true);
    });
   
}

//등록 이벤트 우측
function insertEvent(){

    //테이블 선택이 있다면 실행
    if(allTable.getSelectedRowsData().length > 0){
        let dataSource = [...montPrpcTable.option('dataSource')];
        const allTableData = allTable.getSelectedRowsData();
        allTableData.sort(function(a,b){
            return a['vms_ifsc_id'] > b['vms_ifsc_id']? 1:  a['vms_ifsc_id'] < b['vms_ifsc_id']? -1:0;
        })

        //데이터 값이 있을때 seq설정
        if(dataSource.length > 0){
            idArray = getId();
            //desc sorting
            dataSource.sort(function(a, b){
                return a['monitoring_seq'] < b['monitoring_seq']? -1: a['monitoring_seq'] > b['monitoring_seq']? 1:0;
            })
            //가운데 테이블 데이터에 추가
            for( let key in allTableData){
                if (idArray.includes(allTableData[key].vms_ifsc_id)) {
                    return alertWarning('선택 된 구간 중 이미 추가 된 구간이 있습니다.');
                }
                dataSource.push({
                    dspl_prrt       : (dataSource[dataSource.length - 1].dspl_prrt + 1),
                    vms_ifsc_id     : allTableData[key].vms_ifsc_id,
                    vms_ifsc_nm     : allTableData[key].vms_ifsc_nm
                })
            }
            //테이블 데이터 세팅
            montPrpcTable.option('dataSource', dataSource);
            allTable.clearSelection();
            return false;
        }
        //데이터 값이 없을때 seq설정
        for( let key in allTableData){
            dataSource.push({
                dspl_prrt       : Number(key) + 1,
                vms_ifsc_id     : allTableData[key].vms_ifsc_id,
                vms_ifsc_nm     : allTableData[key].vms_ifsc_nm
            })
        }
        montPrpcTable.option('dataSource', dataSource);
        allTable.clearSelection();
    }
}

//삭제 이벤트 우측
function deleteEvent(){
    //가운데 테이블 선택 값이 있을 경우 실행
    if ( montPrpcTable.getSelectedRowKeys().length > 0 ){
        
        $(montPrpcTable.getSelectedRowKeys()).each(function(index, element){  
            let rowIndex = montPrpcTable.getRowIndexByKey(element);  
            montPrpcTable.deleteRow(rowIndex);
            montPrpcTable.refresh();  
        });  

        let dataSource = montPrpcTable.option("dataSource");
        //asc sorting
        dataSource.sort(function(a, b){
            return a['monitoring_seq'] < b['monitoring_seq']? -1 : a['monitoring_seq'] > b['monitoring_seq']? 1 : 0;
        })
        
        //삭제 값이 중간 값이라면 seq 값 순서대로 세팅
        for(let key in dataSource) {
            dataSource[key].monitoring_seq === Number(key) + 1 ? dataSource[key].monitoring_seq : dataSource[key].monitoring_seq = Number(key) + 1
        }
        
    
        //테이블에 데이터 세팅
        montPrpcTable.option('dataSource', dataSource);
        montPrpcTable.clearSelection();

    }
}

//저장 이벤트
function saveEvent(){
    let key = listTable.getSelectedRowsData()[0].vms_ctlr_nmbr;
    let updateData = {
        ifscs          : [],
        vms_ctlr_nmbr  : key
    };
    montPrpcTable.option('dataSource').map((item)=>{
        updateData.ifscs.push({
            dspl_prrt : item.dspl_prrt,
            vms_ifsc_id : item.vms_ifsc_id
        })
    });

    let result = postInsertUpdate(commonUri + "/" + encodeURIComponent(key), updateData);
    if(result > 0){
        eventOff();

        btnArr.map((item)=>{
            item.box.option('visible', item.selected.visible)
            item.box.option('disabled', item.selected.disabled)
        })
        return alertConfirm('모니터링 화면 정보를 저장 하셨습니다.');
    }
    //return alertWarning('모니터링 화면 정보가 저장되지 않았습니다.')
}

function getId(){
    let idArr = [];
    montPrpcTable.option('dataSource').map((item)=>{
        idArr.push(item.vms_ifsc_id);
    })
    return idArr;
}

//취소 이벤트
function cancleEvent(){
    eventOff();
    const selectedData = listTable.getSelectedRowsData();
    
    if ( selectedData.length > 0 ){
        refresh( montPrpcTable, montPrpcData, commonUri + "/" + selectedData[0].vms_ctlr_nmbr );
        btnArr.map((item)=>{
            item.box.option('visible', item.selected.visible)
            item.box.option('disabled', item.selected.disabled)
        })
        return false;
    }

    btnArr.map((item)=>{
        item.box.option('visible', item.unSelected.visible)
        item.box.option('disabled', item.unSelected.disabled)
    })
    
    montPrpcTable.option( 'dataSource', [] );
}