/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbResultSetMetaData
implements com.tmax.tibero.jdbc.TbResultSetMetaData {
    private Column[] columnInfoArr = null;

    public TbResultSetMetaData(Column[] columnArray, int n) {
        if (columnArray != null) {
            int n2 = columnArray.length - n;
            this.columnInfoArr = new Column[n2];
            for (int i = 0; i < n2; ++i) {
                this.columnInfoArr[i] = new Column(columnArray[i + n]);
            }
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return DataType.getDataTypeClassName(this.getColumnDataType(n));
    }

    public int getColumnCount() throws SQLException {
        if (this.columnInfoArr != null) {
            return this.columnInfoArr.length;
        }
        throw TbError.newSQLException(-590784);
    }

    private int getColumnDataType(int n) throws SQLException {
        return this.columnInfoArr[n - 1].getDataType();
    }

    private int getColumnMaxLength(int n) throws SQLException {
        return this.columnInfoArr[n - 1].getMaxLength();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        int n3 = this.getColumnMaxLength(n);
        switch (n2) {
            case 2: 
            case 3: {
                if (n3 > 0) {
                    return n3;
                }
                int n4 = this.getColumnName(n).length();
                if (n4 == 0) {
                    return 1;
                }
                return n4;
            }
            case 1: {
                return 45;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 24;
            }
            case 15: {
                return 14;
            }
            case 12: 
            case 13: {
                return 400000000;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        if (n3 > 0) {
            return n3;
        }
        return 65535;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getName();
        }
        throw TbError.newSQLException(-590784);
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getSqlType();
        }
        throw TbError.newSQLException(-590784);
    }

    public String getColumnTypeName(int n) throws SQLException {
        TbTypeDescriptor tbTypeDescriptor;
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        if (DataType.isUDTCategory(n2) && (tbTypeDescriptor = this.columnInfoArr[n - 1].getDescriptor()) instanceof TbTypeDescriptor) {
            return tbTypeDescriptor.getSQLTypeName();
        }
        return DataType.getDBTypeName(n2, this.getColumnPrecision(n));
    }

    private int getColumnPrecision(int n) throws SQLException {
        return this.columnInfoArr[n - 1].getPrecision();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = this.getColumnPrecision(n);
        int n3 = this.getColumnDataType(n);
        switch (n3) {
            case 2: 
            case 3: {
                return this.getColumnMaxLength(n);
            }
            case 12: 
            case 13: {
                return -1;
            }
            case 10: 
            case 11: {
                return Integer.MAX_VALUE;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        return n2 < 0 ? 0 : n2;
    }

    public int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = 0;
        int n3 = this.getColumnDataType(n);
        switch (n3) {
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 0;
            }
        }
        n2 = this.columnInfoArr[n - 1].getScale();
        return n2 < 0 ? 0 : n2;
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (this.columnInfoArr != null) {
            int n2 = this.columnInfoArr.length;
            if (n2 < 0) {
                throw TbError.newSQLException(-90607);
            }
            if (n <= 0 || n > n2) {
                throw TbError.newSQLException(-90609, Integer.toString(n));
            }
        } else {
            throw TbError.newSQLException(-590784);
        }
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return DataType.isCharacterCategory(n2) || n2 == 13 || n2 == 10;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return n2 == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.columnInfoArr == null) {
            throw TbError.newSQLException(-590784);
        }
        boolean bl = this.columnInfoArr[n - 1].isNullable();
        return bl ? 1 : 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return n2 != 11 && n2 != 10 && n2 != 12 && n2 != 13;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        return DataType.isNumberCategory(this.getColumnDataType(n));
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public void reset() {
        this.columnInfoArr = null;
    }
}

