/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.r2dbc;

import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public enum EmbeddedDatabaseConnection {
    NONE(null, null, null),
    H2("H2", "io.r2dbc.h2.H2ConnectionFactoryProvider", "r2dbc:h2:mem:///%s?options=DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE");

    private final String type;
    private final String driverClassName;
    private final String url;

    private EmbeddedDatabaseConnection(String type, String driverClassName, String url) {
        this.type = type;
        this.driverClassName = driverClassName;
        this.url = url;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl(String databaseName) {
        Assert.hasText((String)databaseName, (String)"DatabaseName must not be empty");
        return this.url != null ? String.format(this.url, databaseName) : null;
    }

    public static EmbeddedDatabaseConnection get(ClassLoader classLoader) {
        for (EmbeddedDatabaseConnection candidate : EmbeddedDatabaseConnection.values()) {
            if (candidate == NONE || !ClassUtils.isPresent((String)candidate.getDriverClassName(), (ClassLoader)classLoader)) continue;
            return candidate;
        }
        return NONE;
    }
}

