/*
 * Decompiled with CFR 0.152.
 */
package org.qlrm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class FileUtil {
    public static String getFileAsString(String filename) {
        try {
            InputStream inputStream = FileUtil.class.getClassLoader().getResourceAsStream(filename);
            if (inputStream == null) {
                throw new IllegalArgumentException("File " + filename + " not found!");
            }
            int bufferSize = 1024;
            char[] buffer = new char[1024];
            StringBuilder out = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                int rsz;
                while ((rsz = ((Reader)reader).read(buffer, 0, buffer.length)) >= 0) {
                    out.append(buffer, 0, rsz);
                }
            }
            return out.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

