/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffHeader;
import org.apache.sanselan.formats.tiff.constants.TagInfo;
import org.apache.sanselan.util.Debug;

public class TiffContents {
    public final TiffHeader header;
    public final ArrayList directories;

    public TiffContents(TiffHeader tiffHeader, ArrayList directories) {
        this.header = tiffHeader;
        this.directories = directories;
    }

    public ArrayList getElements() throws ImageReadException {
        ArrayList<TiffElement> result = new ArrayList<TiffElement>();
        result.add(this.header);
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffDirectory directory = (TiffDirectory)this.directories.get(i);
            result.add(directory);
            ArrayList fields = directory.entries;
            for (int j = 0; j < fields.size(); ++j) {
                TiffField field = (TiffField)fields.get(j);
                TiffElement oversizeValue = field.getOversizeValueElement();
                if (null == oversizeValue) continue;
                result.add(oversizeValue);
            }
            if (directory.hasTiffImageData()) {
                result.addAll(directory.getTiffRawImageDataElements());
            }
            if (!directory.hasJpegImageData()) continue;
            result.add(directory.getJpegRawImageDataElement());
        }
        return result;
    }

    public TiffField findField(TagInfo tag) throws ImageReadException {
        for (int i = 0; i < this.directories.size(); ++i) {
            TiffDirectory directory = (TiffDirectory)this.directories.get(i);
            TiffField field = directory.findField(tag);
            if (null == field) continue;
            return field;
        }
        return null;
    }

    public void dissect(boolean verbose) throws ImageReadException {
        ArrayList elements = this.getElements();
        Collections.sort(elements, TiffElement.COMPARATOR);
        int lastEnd = 0;
        for (int i = 0; i < elements.size(); ++i) {
            String verbosity;
            TiffElement element = (TiffElement)elements.get(i);
            if (element.offset > lastEnd) {
                Debug.debug("\tgap: " + (element.offset - lastEnd));
            }
            if (element.offset < lastEnd) {
                Debug.debug("\toverlap");
            }
            Debug.debug("element, start: " + element.offset + ", length: " + element.length + ", end: " + (element.offset + element.length) + ": " + element.getElementDescription(false));
            if (verbose && null != (verbosity = element.getElementDescription(true))) {
                Debug.debug(verbosity);
            }
            lastEnd = element.offset + element.length;
        }
        Debug.debug("end: " + lastEnd);
        Debug.debug();
    }
}

