/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbRSFwOnly;
import com.tmax.tibero.jdbc.driver.TbRSScrollable;
import com.tmax.tibero.jdbc.driver.TbRSSensitive;
import com.tmax.tibero.jdbc.driver.TbRSUpdatable;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbResultSetFactory {
    public static TbResultSet buildResultSet(TbStatement tbStatement, int n, int n2, int n3, byte[] byArray) throws SQLException {
        if (tbStatement == null) {
            throw TbError.newSQLException(-90608);
        }
        RsetType rsetType = tbStatement.getRealRsetType();
        switch (rsetType.getRank()) {
            case 2: {
                TbRSFwOnly tbRSFwOnly = new TbRSFwOnly(tbStatement, n, n2, n3, byArray);
                return new TbRSUpdatable(tbRSFwOnly, RsetType.FWUP);
            }
            case 3: {
                return new TbRSScrollable(tbStatement, n, n2, n3, byArray);
            }
            case 4: {
                TbRSScrollable tbRSScrollable = new TbRSScrollable(tbStatement, n, n2, n3, byArray);
                return new TbRSUpdatable(tbRSScrollable, RsetType.SIUP);
            }
            case 5: {
                return new TbRSSensitive(tbStatement, n, n2, n3, byArray);
            }
            case 6: {
                TbRSSensitive tbRSSensitive = new TbRSSensitive(tbStatement, n, n2, n3, byArray);
                return new TbRSUpdatable(tbRSSensitive, RsetType.SSUP);
            }
        }
        return new TbRSFwOnly(tbStatement, n, n2, n3, byArray);
    }

    public static TbResultSet buildEmptyResultSet(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        return new TbRSFwOnly(tbStatement, n, n2, n3, null);
    }

    private TbResultSetFactory() {
    }
}

