/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;

public class TbBlob
extends TbLob
implements Blob {
    private static final TbBlob EMPTY_BLOB = new TbBlob(null, new byte[1], false);

    public TbBlob(TbConnection tbConnection, byte[] byArray, boolean bl) {
        super(tbConnection, byArray, bl);
    }

    public static TbBlob createEmptyBlob() {
        return EMPTY_BLOB;
    }

    public static TbBlob createTemporary(Connection connection) throws SQLException {
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-590713);
        }
        return ((TbConnection)connection).createTbBlob();
    }

    public static void freeTemporary(TbBlob tbBlob) throws SQLException {
        if (tbBlob == null) {
            throw TbError.newSQLException(-590713);
        }
        tbBlob.free();
    }

    public void freeTemporary() throws SQLException {
        this.free();
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long l) throws SQLException {
        return this.setBinaryStream(l);
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this, 1L, Integer.MAX_VALUE);
    }

    private TbBlobAccessor getBlobAccessor() {
        return this.getConnection().getBlobAccessor();
    }

    protected TbLobAccessor getLobAccessor() {
        return this.getBlobAccessor();
    }

    public long getBytes(long l, byte[] byArray) throws SQLException {
        return this.getBytes(l, byArray, 0L, byArray.length);
    }

    public long getBytes(long l, byte[] byArray, long l2) throws SQLException {
        return this.getBytes(l, byArray, 0L, l2);
    }

    public long getBytes(long l, byte[] byArray, long l2, long l3) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (l3 < 0L) {
            throw TbError.newSQLException(-590765, l3);
        }
        if (l3 > (long)byArray.length) {
            l3 = byArray.length;
        }
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = this.getBlobAccessor().read(this, l - 1L, byArray, l2, l3);
        long l5 = this.getLengthInternal();
        if (l5 > -1L && l == 1L && l5 <= l4 && this.getIsTempLob() && this.freeTmpLobOnEOF()) {
            this.getLobAccessor().freeTemporary(this);
        }
        return l4;
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (n < 0) {
            throw TbError.newSQLException(-590765, n);
        }
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte[] byArray2 = new byte[n];
        long l2 = this.getBytes(l, byArray2);
        if (l2 < (long)n) {
            byArray = new byte[(int)l2];
            System.arraycopy(byArray2, 0, byArray, 0, (int)l2);
            byArray2 = null;
        } else if (l2 == (long)n) {
            byArray = byArray2;
        }
        return byArray;
    }

    public long position(Blob blob, long l) throws SQLException {
        return super.position((TbLob)((Object)blob), l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590766, l);
        }
        return this.getBlobAccessor().position(this, byArray, l - 1L);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.checkInvalidActionOnEmpty();
        return new TbLobOutputStream(this, l == 0L ? 1L : l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (n2 < 0) {
            throw TbError.newSQLException(-590765, n2);
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        if (n2 <= 0) {
            return 0;
        }
        return (int)this.getBlobAccessor().write(this, l - 1L, byArray, n, n2);
    }
}

