/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class MS1252ByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};
    private static final char[] MS1252_TO_UNICODE_PAGE = new char[]{'\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178'};

    private int decodeFromUcs(byte by, byte by2) {
        return (by << 8) + (by2 & 0xFF);
    }

    private void encodeUCharToUCS2(char[] cArray, int n, int n2) {
        boolean bl = false;
        byte by = (byte)n2;
        cArray[n] = (char)(bl ? 1 : 0);
        cArray[n++] = (char)by;
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws SQLException {
        int n5 = n;
        int n6 = n3;
        while (n5 < n2) {
            int n7 = this.decodeFromUcs((byte)0, byArray[n5]);
            if (n7 < 128 || n7 >= 160) {
                cArray[n6++] = (char)n7;
                ++n5;
                continue;
            }
            int n8 = n7 - 128;
            if ((n7 = MS1252_TO_UNICODE_PAGE[n8]) != 65533) {
                cArray[n6++] = (char)n7;
                ++n5;
                continue;
            }
            if (this.subMode) {
                this.encodeUCharToUCS2(cArray, n6, this.subChars[0]);
                ++n6;
                continue;
            }
            throw TbError.newSQLException(-590742, n7);
        }
        return n6 - n3;
    }
}

