/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbDriver;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetReader;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetWriter;
import com.tmax.tibero.jdbc.rowset.TbRow;
import com.tmax.tibero.jdbc.rowset.TbRowSet;
import com.tmax.tibero.jdbc.rowset.TbRowSetMetaData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;

public class TbCachedRowSet
extends TbRowSet
implements RowSetInternal,
Serializable {
    private static final long serialVersionUID = -3966681529200633668L;
    private Connection conn;
    private ResultSet rs;
    private boolean isConnectionOpened = false;
    private RowSetMetaData rowsetMetaData;
    private Vector rows = new Vector();
    protected int currentRowIndex = 0;
    private int columnCount = 0;
    protected int rowCount = 0;
    private RowSetReader reader;
    private RowSetWriter writer;
    private String[] columnNames;
    private boolean isOnUpdate = false;
    private int updateRowIndex;
    private boolean isOnInsert = false;
    private int insertRowIndex;
    private TbRow temporaryRow;
    private int pageSize = 0;
    private int currentPageIndex = 0;
    private boolean prevColumnWasNull = false;
    private boolean isInitializedDriver = false;
    private boolean isPopulateCompleted = false;
    private int[] keyColumns;
    private String tableName;

    public TbCachedRowSet() throws SQLException {
        this.setReader(new TbCachedRowSetReader());
        this.setWriter(new TbCachedRowSetWriter());
    }

    public boolean absolute(int n) throws SQLException {
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590758);
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        this.currentRowIndex = n >= 0 ? n : this.rowCount + n + 1;
        this.notifyCursorMoved();
        return true;
    }

    public void acceptChanges() throws SQLException {
        this.getWriter().writeData(this);
    }

    public void acceptChanges(Connection connection) throws SQLException {
        this.conn = connection;
        this.isConnectionOpened = true;
        this.acceptChanges();
    }

    public void afterLast() throws SQLException {
        this.currentRowIndex = this.rowCount + 1;
    }

    public void beforeFirst() throws SQLException {
        this.currentRowIndex = 0;
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isDeleted()) {
            throw TbError.newSQLException(-90858);
        }
        this.getCurrentRow().markDeleted(false);
        this.notifyRowChanged();
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isInserted()) {
            this.rows.remove(--this.currentRowIndex);
            --this.rowCount;
        } else {
            throw TbError.newSQLException(-90862);
        }
        this.notifyRowChanged();
    }

    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isUpdated()) {
            throw TbError.newSQLException(-90863);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(false);
        this.notifyRowChanged();
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (this.readOnly) {
            throw TbError.newSQLException(-90825);
        }
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
    }

    public void close() throws SQLException {
        this.release();
        this.isClosed = true;
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    public RowSet createCopy() throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new ByteArrayOutputStream());
            objectOutputStream.writeObject(this);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (RowSet)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new SQLException("createCopy() failed:" + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("createCopy() failed:" + classNotFoundException.getMessage());
        }
    }

    public RowSet createShared() throws SQLException {
        int n;
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rows = this.rows;
        tbCachedRowSet.setDataSourceName(this.getDataSourceName());
        tbCachedRowSet.setUsername(this.getUsername());
        tbCachedRowSet.setPassword(this.getPassword());
        tbCachedRowSet.setUrl(this.getUrl());
        tbCachedRowSet.setTypeMap(this.getTypeMap());
        tbCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        tbCachedRowSet.setMaxRows(this.getMaxRows());
        tbCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        tbCachedRowSet.setFetchSize(this.getFetchSize());
        tbCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        tbCachedRowSet.setConcurrency(this.getConcurrency());
        tbCachedRowSet.setReadOnly(this.readOnly);
        tbCachedRowSet.rowsetType = this.getType();
        tbCachedRowSet.setFetchDirection(this.getFetchDirection());
        tbCachedRowSet.setCommand(this.getCommand());
        tbCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        tbCachedRowSet.currentRowIndex = this.currentRowIndex;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = this.rowCount;
        tbCachedRowSet.showDeleted = this.showDeleted;
        tbCachedRowSet.currentPageIndex = this.currentPageIndex;
        tbCachedRowSet.pageSize = this.pageSize;
        tbCachedRowSet.tableName = this.tableName != null ? new String(this.tableName) : null;
        tbCachedRowSet.keyColumns = this.keyColumns != null ? (int[])this.keyColumns.clone() : null;
        int n2 = this.listeners.size();
        for (n = 0; n < n2; ++n) {
            tbCachedRowSet.listeners.add(this.listeners.elementAt(n));
        }
        tbCachedRowSet.rowsetMetaData = new TbRowSetMetaData(this.rowsetMetaData);
        n2 = this.params.size();
        for (n = 0; n < n2; ++n) {
            tbCachedRowSet.params.add(this.params.elementAt(n));
        }
        tbCachedRowSet.columnNames = new String[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, tbCachedRowSet.columnNames, 0, this.columnNames.length);
        return tbCachedRowSet;
    }

    public void deleteRow() throws SQLException {
        this.getCurrentRow().markDeleted(true);
        this.notifyRowChanged();
    }

    public synchronized void execute() throws SQLException {
        this.isConnectionOpened = false;
        this.reader.readData(this);
    }

    public synchronized void execute(Connection connection) throws SQLException {
        this.conn = connection;
        this.execute();
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        string = string.toUpperCase();
        for (n = 0; n < this.columnCount && !this.columnNames[n].equals(string); ++n) {
        }
        if (n == this.columnCount) {
            throw TbError.newSQLException(-90835, string);
        }
        return n + 1;
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Array) {
            return (Array)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream != null ? inputStream : null;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Number number = this.getNumeric(n);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Number) {
            return new BigDecimal(number.doubleValue());
        }
        throw TbError.newSQLException(-90836, number.toString());
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = this.getStream(n);
        return inputStream != null ? inputStream : null;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof TbBlob) {
            return (Blob)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return tbBlob.getBytes(0L, 1)[0];
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, 1).getBytes()[0];
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return tbBlob.getBytes(0L, (int)tbBlob.length());
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, (int)tbClobBase.length()).getBytes();
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this.getCharacterStreamInternal(n);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStreamInternal(this.findColumn(string));
    }

    private Reader getCharacterStreamInternal(int n) throws SQLException {
        InputStream inputStream = this.getAsciiStream(n);
        if (inputStream == null) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((n2 = inputStream.read()) != -1) {
                stringBuffer.append((char)n2);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            return new CharArrayReader(cArray);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof TbClobBase) {
            return (Clob)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            String string3 = this.getUrl();
            String string4 = this.getDataSourceName();
            if (string4 != null && !string4.equals("")) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(string4);
                    if (this.username == null || string2 == null) {
                        this.conn = object.getConnection();
                    }
                    this.conn = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    throw TbError.newSQLException(-90828, namingException.getMessage());
                }
            } else if (string3 != null && !string3.equals("")) {
                if (!this.isInitializedDriver) {
                    DriverManager.registerDriver(new TbDriver());
                    this.isInitializedDriver = true;
                }
                if (string.equals("") || string2.equals("")) {
                    throw TbError.newSQLException(-90854, "(" + string + "," + string2 + ")");
                }
                this.conn = DriverManager.getConnection(string3, string, string2);
            } else {
                throw TbError.newSQLException(-90852);
            }
        }
        return this.conn;
    }

    protected TbRow getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 1 || this.currentRowIndex > this.rowCount) {
            throw TbError.newSQLException(-90847, "(" + this.currentRowIndex + "," + this.rowCount + ")");
        }
        return (TbRow)this.rows.elementAt(this.currentRowIndex - 1);
    }

    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public Date getDate(int n) throws SQLException {
        return this.getDateInternal(n, null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDateInternal(n, calendar);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDateInternal(this.findColumn(string), null);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDateInternal(this.findColumn(string), calendar);
    }

    private Date getDateInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return new Date(((Time)object).getTime());
        }
        if (object instanceof Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Date(calendar.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public double getDouble(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.doubleValue() : 0.0;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.floatValue() : 0.0f;
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.intValue() : 0;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.longValue() : 0L;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    private synchronized Number getNumeric(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return new Integer((Boolean)object != false ? 1 : 0);
        }
        if (!(object instanceof String)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        try {
            return new BigDecimal((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw TbError.newSQLException(-90829, ((String)object).toString());
        }
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        object = !this.isUpdated(n) ? this.getCurrentRow().getColumn(n) : this.getCurrentRow().getChangedColumn(n);
        this.prevColumnWasNull = object == null;
        return object;
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public ResultSet getOriginal() throws SQLException {
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = this.rowCount;
        tbCachedRowSet.currentRowIndex = 0;
        tbCachedRowSet.setType(1004);
        tbCachedRowSet.setConcurrency(1008);
        tbCachedRowSet.setReader(null);
        tbCachedRowSet.setWriter(null);
        TbRow tbRow = null;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            tbRow = new TbRow(this.columnCount, ((TbRow)iterator.next()).getOriginalRow());
            tbCachedRowSet.rows.add(tbRow);
        }
        return tbCachedRowSet;
    }

    public ResultSet getOriginalRow() throws SQLException {
        TbCachedRowSet tbCachedRowSet = new TbCachedRowSet();
        tbCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        tbCachedRowSet.columnCount = this.columnCount;
        tbCachedRowSet.rowCount = 1;
        tbCachedRowSet.currentRowIndex = 0;
        tbCachedRowSet.setReader(null);
        tbCachedRowSet.setWriter(null);
        TbRow tbRow = new TbRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        tbCachedRowSet.rows.add(tbRow);
        return tbCachedRowSet;
    }

    public RowSetReader getReader() throws SQLException {
        return this.reader;
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Ref) {
            return (Ref)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public int getRow() throws SQLException {
        if (this.currentRowIndex > this.rowCount) {
            return this.rowCount;
        }
        return this.currentRowIndex;
    }

    public short getShort(int n) throws SQLException {
        Number number = this.getNumeric(n);
        return number != null ? number.shortValue() : (short)0;
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() throws SQLException {
        if (this.rs == null) {
            throw TbError.newSQLException(-90859);
        }
        return this.rs.getStatement();
    }

    private synchronized InputStream getStream(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof TbClobBase) {
            return ((TbClobBase)object).getAsciiStream();
        }
        if (object instanceof TbBlob) {
            return ((TbBlob)object).getBinaryStream();
        }
        if (!(object instanceof Reader)) {
            try {
                int n2 = 0;
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                PipedInputStream pipedInputStream = new PipedInputStream();
                PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n2 = bufferedReader.read()) != -1) {
                    pipedOutputStream.write(n2);
                }
                pipedOutputStream.close();
                return pipedInputStream;
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90829, iOException.getMessage());
            }
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public String getString(int n) throws SQLException {
        return this.getStringInternal(n);
    }

    public String getString(String string) throws SQLException {
        return this.getStringInternal(this.findColumn(string));
    }

    private String getStringInternal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof Date) {
            return ((Date)object).toString();
        }
        if (object instanceof Timestamp) {
            return ((Date)object).toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof TbClobBase) {
            TbClobBase tbClobBase = (TbClobBase)object;
            return tbClobBase.getSubString(0L, (int)tbClobBase.length());
        }
        if (object instanceof TbBlob) {
            TbBlob tbBlob = (TbBlob)object;
            return new String(tbBlob.getBytes(0L, (int)tbBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (!(object instanceof Reader)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        try {
            Reader reader = (Reader)object;
            char[] cArray = new char[1024];
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(1024);
            while ((n2 = reader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n2);
            }
            return stringBuffer.substring(0, stringBuffer.length());
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        return this.getTimeInternal(n, null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTimeInternal(n, calendar);
    }

    public Time getTime(String string) throws SQLException {
        return this.getTimeInternal(this.findColumn(string), null);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTimeInternal(this.findColumn(string), calendar);
    }

    private Time getTimeInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Time(calendar.getTime().getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampInternal(n, null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestampInternal(n, calendar);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestampInternal(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestampInternal(this.findColumn(string), calendar);
    }

    private Timestamp getTimestampInternal(int n, Calendar calendar) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTime((Date)object);
            return new Timestamp(((java.util.Date)object).getTime());
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        throw TbError.newSQLException(-90836, object.toString());
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    public RowSetWriter getWriter() throws SQLException {
        return this.writer;
    }

    public void insertRow() throws SQLException {
        if (!this.isOnInsert) {
            throw TbError.newSQLException(-90822);
        }
        if (!this.temporaryRow.isPopulationCompleted()) {
            throw TbError.newSQLException(-90865);
        }
        this.temporaryRow.insertRow();
        this.rows.insertElementAt(this.temporaryRow, this.insertRowIndex - 1);
        this.isOnInsert = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rowCount > 0 && this.currentRowIndex == this.rowCount + 1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rowCount > 0 && this.currentRowIndex == 0;
    }

    boolean isConnectionOpened() {
        return this.isConnectionOpened;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRowIndex == 1;
    }

    public boolean isLast() throws SQLException {
        return this.currentRowIndex == this.rowCount;
    }

    private final boolean isUpdated(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
        return this.getCurrentRow().isColumnChanged(n);
    }

    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    public void moveToCurrentRow() throws SQLException {
        this.isOnInsert = false;
        this.isOnUpdate = false;
        this.absolute(this.currentRowIndex);
    }

    public void moveToInsertRow() throws SQLException {
        this.temporaryRow = new TbRow(this.columnCount, true);
        this.isOnInsert = true;
        this.insertRowIndex = this.isAfterLast() ? this.currentRowIndex : this.currentRowIndex + 1;
    }

    public boolean next() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        this.populate(this.rs);
        ++this.currentPageIndex;
        return !this.isPopulateCompleted;
    }

    protected synchronized void notifyCursorMoved() {
        if (this.isOnInsert) {
            this.isOnInsert = false;
            this.temporaryRow.markUpdated(false);
            this.warnings.setNextWarning(new SQLWarning("Insertion is canceled because of the cursor"));
        } else if (this.isOnUpdate) {
            try {
                this.isOnUpdate = false;
                int n = this.currentRowIndex;
                this.currentRowIndex = this.updateRowIndex;
                this.getCurrentRow().markUpdated(false);
                this.currentRowIndex = n;
                this.warnings.setNextWarning(new SQLWarning("All Updates are canceled because of the cursor"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    public void populate(ResultSet resultSet) throws SQLException {
        int n;
        if (this.rows == null) {
            this.rows = new Vector(100, 10);
        }
        this.rowsetMetaData = new TbRowSetMetaData(resultSet.getMetaData());
        this.columnCount = this.rowsetMetaData.getColumnCount();
        this.columnNames = new String[this.columnCount];
        for (n = 0; n < this.columnCount; ++n) {
            this.columnNames[n] = this.rowsetMetaData.getColumnName(n + 1);
        }
        n = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        int n2 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n == 0) {
            resultSet.afterLast();
        }
        while (this.rowCount < n2 && (n != 0 ? resultSet.next() : resultSet.previous())) {
            TbRow tbRow = new TbRow(this.columnCount);
            for (int i = 1; i <= this.columnCount; ++i) {
                tbRow.setColumn(i, resultSet.getObject(i));
                tbRow.markNull(i, resultSet.wasNull());
            }
            if (n != 0) {
                this.rows.add(tbRow);
            } else {
                this.rows.add(1, tbRow);
            }
            ++this.rowCount;
        }
        if (n != 0 && resultSet.isAfterLast() || n == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateCompleted = true;
        }
        this.conn = null;
        this.notifyRowSetChanged();
    }

    public void populate(ResultSet resultSet, int n) throws SQLException {
        if (n < 0) {
            throw TbError.newSQLException(-90847, Integer.toString(n));
        }
        if (resultSet == null) {
            throw TbError.newSQLException(-90823);
        }
        if (resultSet.getType() == 1003) {
            int n2 = 0;
            for (n2 = 0; resultSet.next() && n2 < n; ++n2) {
            }
            if (n2 < n) {
                throw TbError.newSQLException(-90868);
            }
        } else {
            resultSet.absolute(n);
        }
        this.populate(resultSet);
    }

    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.currentRowIndex + 1 <= this.rowCount) {
                ++this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.currentRowIndex - 1 > 0) {
                --this.currentRowIndex;
                if (!this.showDeleted && this.getCurrentRow().isDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.currentRowIndex = 0;
            return false;
        }
        return false;
    }

    public boolean previousPage() throws SQLException {
        if (this.rs != null && this.rs.getType() == 1003) {
            throw TbError.newSQLException(-90850);
        }
        if (this.rows.size() == 0 && !this.isPopulateCompleted) {
            throw TbError.newSQLException(-90853);
        }
        if (this.fetchDirection == 1001) {
            this.rs.relative(this.pageSize * 2);
        } else {
            this.rs.relative(-2 * this.pageSize);
        }
        this.populate(this.rs);
        if (this.currentPageIndex > 0) {
            --this.currentPageIndex;
        }
        return this.currentPageIndex != 0;
    }

    public void refreshRow() throws SQLException {
        TbRow tbRow = this.getCurrentRow();
        if (tbRow.isUpdated()) {
            tbRow.cancelUpdated();
        }
    }

    public boolean relative(int n) throws SQLException {
        return this.absolute(this.currentRowIndex + n);
    }

    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.conn != null && !this.conn.isClosed()) {
            this.conn.close();
        }
        this.rowCount = 0;
        this.currentRowIndex = 0;
        this.notifyRowSetChanged();
    }

    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow tbRow = (TbRow)this.rows.elementAt(i);
            if (tbRow.isInserted()) {
                this.rows.remove(i);
                --this.rowCount;
                --i;
                bl = true;
                continue;
            }
            if (tbRow.isUpdated()) {
                tbRow.markUpdated(false);
                bl = true;
                continue;
            }
            if (!tbRow.isDeleted()) continue;
            tbRow.markDeleted(false);
            bl = true;
        }
        if (!bl) {
            throw TbError.newSQLException(-90857);
        }
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    public void rollback() throws SQLException {
        this.getConnection().rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.getConnection();
        boolean bl = connection.getAutoCommit();
        connection.setAutoCommit(false);
        try {
            connection.rollback(savepoint);
            connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            connection.setAutoCommit(bl);
            throw sQLException;
        }
    }

    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isDeleted();
    }

    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isInserted();
    }

    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isUpdated();
    }

    protected void setConnection(Connection connection) throws SQLException {
        this.conn = connection;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (this.rowsetType == 1005) {
            throw TbError.newSQLException(-590759);
        }
        switch (n) {
            case 1000: 
            case 1002: {
                this.currentRowIndex = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw TbError.newSQLException(-590760);
                }
                this.currentRowIndex = this.rowCount + 1;
                break;
            }
            default: {
                throw TbError.newSQLException(-90838, Integer.toString(n));
            }
        }
        super.setFetchDirection(n);
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.columnCount = rowSetMetaData.getColumnCount();
        }
    }

    public void setOriginal() throws SQLException {
        int n = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalInternal(n)) continue;
            ++n;
        } while (n <= this.rowCount);
        this.notifyRowSetChanged();
        this.currentRowIndex = 0;
    }

    private boolean setOriginalInternal(int n) throws SQLException {
        if (n < 1 || n > this.rowCount) {
            throw TbError.newSQLException(-90837);
        }
        boolean bl = false;
        TbRow tbRow = (TbRow)this.rows.elementAt(n - 1);
        if (tbRow.isDeleted()) {
            this.rows.remove(n - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (tbRow.isInserted()) {
                tbRow.markInserted(false);
            }
            if (tbRow.isUpdated()) {
                tbRow.commitChangedColumns();
            }
        }
        return bl;
    }

    public void setOriginalRow() throws SQLException {
        if (this.isOnInsert) {
            throw TbError.newSQLException(-90851);
        }
        this.setOriginalInternal(this.currentRowIndex);
    }

    public void setPageSize(int n) throws SQLException {
        if (n < 0 || this.maxRows > 0 && n > this.maxRows) {
            throw TbError.newSQLException(-90843, Integer.toString(n));
        }
        this.pageSize = n;
    }

    public void setReader(RowSetReader rowSetReader) throws SQLException {
        this.reader = rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) throws SQLException {
        this.writer = rowSetWriter;
    }

    public int size() {
        return this.rowCount;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i = 0; i < this.rowCount; ++i) {
                map.put(new Integer(i), ((TbRow)this.rows.elementAt(i)).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            throw TbError.newSQLException(-90831);
        }
        return map.values();
    }

    public Collection toCollection(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            TbRow tbRow = (TbRow)this.rows.elementAt(i);
            Object object = tbRow.isColumnChanged(i) ? tbRow.getChangedColumn(i) : tbRow.getColumn(i);
            vector.add(object);
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.findColumn(string));
    }

    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateObject(n, (Object)array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += inputStreamReader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n3 += inputStream.read(byArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new ByteArrayInputStream(byArray));
            byArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateObject(n, (Object)blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Byte(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 += reader.read(cArray, n3, n2 - n3)) < n2) {
            }
            this.updateObject(n, (Object)new CharArrayReader(cArray));
            cArray = null;
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90829, iOException.getMessage());
        }
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateObject(n, (Object)clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateNull(int n) throws SQLException {
        this.updateObject(n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.checkColumnIndex(n);
        if (this.isOnInsert) {
            this.temporaryRow.updateObject(n, object);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.isOnUpdate = true;
            this.updateRowIndex = this.currentRowIndex;
            this.getCurrentRow().updateObject(n, object);
        } else {
            throw TbError.newSQLException(-90855);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (!(object instanceof Number)) {
            throw TbError.newSQLException(-90836, object.toString());
        }
        this.updateObject(n, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n2));
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateObject(n, (Object)ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateRow() throws SQLException {
        if (!this.isOnUpdate) {
            throw TbError.newSQLException(-90824);
        }
        this.isOnUpdate = false;
        this.getCurrentRow().markUpdated(true);
        this.notifyRowChanged();
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Short(s));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public boolean wasNull() throws SQLException {
        return this.prevColumnWasNull;
    }
}

