/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbWebRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TbFilteredRowSet
extends TbWebRowSet {
    private static final long serialVersionUID = 8256521646635679356L;
    private boolean isOnInsert;

    public boolean absolute(int n) throws SQLException {
        int n2;
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        int n3 = n >= 0 ? n : this.rowCount + n + 1;
        this.currentRowIndex = 0;
        for (n2 = 0; n2 < n3 && this.currentRowIndex <= this.rowCount; ++n2) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n2 == n3) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int n, Object object) throws SQLException {
    }

    public void insertRow() throws SQLException {
        this.isOnInsert = false;
        super.insertRow();
    }

    public void moveToInsertRow() throws SQLException {
        this.isOnInsert = true;
        super.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        ++this.currentRowIndex;
        bl = true;
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex <= 1) {
            return false;
        }
        boolean bl = false;
        --this.currentRowIndex;
        bl = true;
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void updateArray(int n, Array array) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, array);
        }
        super.updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, inputStream);
        }
        super.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, bigDecimal);
        }
        super.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, inputStream);
        }
        super.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, blob);
        }
        super.updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Boolean(bl));
        }
        super.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Byte(by));
        }
        super.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, byArray);
        }
        super.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, reader);
        }
        super.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, clob);
        }
        super.updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, date);
        }
        super.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Double(d));
        }
        super.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Float(f));
        }
        super.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Integer(n2));
        }
        super.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Long(l));
        }
        super.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, object);
        }
        super.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, object);
        }
        super.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, ref);
        }
        super.updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateShort(int n, short s) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Short(s));
        }
        super.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, string);
        }
        super.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, time);
        }
        super.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, timestamp);
        }
        super.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }
}

