/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modelmapper.spi.PropertyNameInfo;
import org.modelmapper.spi.Tokens;

class InexactMatcher {
    protected final PropertyNameInfo propertyNameInfo;
    protected final List<Tokens> sourceTokens;
    protected final List<Tokens> destTokens;

    InexactMatcher(PropertyNameInfo propertyNameInfo) {
        this.propertyNameInfo = propertyNameInfo;
        this.sourceTokens = propertyNameInfo.getSourcePropertyTokens();
        this.destTokens = propertyNameInfo.getDestinationPropertyTokens();
    }

    static int matchTokens(Tokens src, Tokens dst, int dstStartIndex) {
        block0: for (int srcStartIndex = 0; srcStartIndex < src.size(); ++srcStartIndex) {
            TokensIterator srcTokensIterator = TokensIterator.of(src, srcStartIndex);
            TokensIterator dstTokensIterator = TokensIterator.of(dst, dstStartIndex);
            StringIterator srcStrIterator = StringIterator.of(srcTokensIterator.next());
            StringIterator dstStrIterator = StringIterator.of(dstTokensIterator.next());
            while ((srcStrIterator.hasNext() || srcStrIterator.hasNext()) && InexactMatcher.matchToken(srcStrIterator, dstStrIterator)) {
                if (!srcStrIterator.hasNext() && !dstStrIterator.hasNext()) {
                    return dstTokensIterator.pos() - dstStartIndex + 1;
                }
                if (!srcStrIterator.hasNext() && !srcTokensIterator.hasNext() || !dstStrIterator.hasNext() && !dstTokensIterator.hasNext()) continue block0;
                if (!srcStrIterator.hasNext() && srcTokensIterator.hasNext()) {
                    srcStrIterator = StringIterator.of(srcTokensIterator.next());
                }
                if (dstStrIterator.hasNext() || !dstTokensIterator.hasNext()) continue;
                dstStrIterator = StringIterator.of(dstTokensIterator.next());
            }
        }
        return 0;
    }

    static boolean matchToken(StringIterator srcStrIterator, StringIterator destStrIterator) {
        while (srcStrIterator.hasNext() && destStrIterator.hasNext()) {
            char srcChar = srcStrIterator.next().charValue();
            char destChar = destStrIterator.next().charValue();
            if (Character.toUpperCase(srcChar) == Character.toUpperCase(destChar) && Character.toLowerCase(srcChar) == Character.toLowerCase(destChar)) continue;
            return false;
        }
        return true;
    }

    boolean matchSourceClass(String destination) {
        for (String token : this.propertyNameInfo.getSourceClassTokens()) {
            if (!token.equalsIgnoreCase(destination)) continue;
            return true;
        }
        return false;
    }

    boolean matchSourcePropertyType(String destination) {
        for (Tokens tokens : this.propertyNameInfo.getSourcePropertyTypeTokens()) {
            for (String token : tokens) {
                if (!token.equalsIgnoreCase(destination)) continue;
                return true;
            }
        }
        return false;
    }

    DestTokensMatcher matchSourcePropertyName(Tokens destTokens, int destStartIndex) {
        int[] matchedTokens = new int[this.sourceTokens.size()];
        for (int sourceIndex = 0; sourceIndex < this.sourceTokens.size(); ++sourceIndex) {
            Tokens srcTokens = this.sourceTokens.get(sourceIndex);
            matchedTokens[sourceIndex] = InexactMatcher.matchTokens(srcTokens, destTokens, destStartIndex);
        }
        return new DestTokensMatcher(matchedTokens);
    }

    static class DestTokensMatcher {
        int[] counts;

        DestTokensMatcher(int[] counts) {
            this.counts = counts;
        }

        boolean match() {
            for (int count : this.counts) {
                if (count <= 0) continue;
                return true;
            }
            return false;
        }

        boolean match(int index) {
            return this.counts[index] > 0;
        }

        int maxMatchTokens() {
            int maxIndex = 0;
            for (int i = 1; i < this.counts.length; ++i) {
                if (this.counts[i] <= this.counts[maxIndex]) continue;
                maxIndex = i;
            }
            return this.counts[maxIndex];
        }

        Collection<Integer> matchSources() {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] <= 0) continue;
                indexes.add(i);
            }
            return indexes;
        }
    }

    static class StringIterator {
        private String text;
        private int pos = -1;

        static StringIterator of(String text) {
            return new StringIterator(text);
        }

        StringIterator(String text) {
            this.text = text;
        }

        public boolean hasNext() {
            return this.pos < this.text.length() - 1;
        }

        public Character next() {
            return Character.valueOf(this.text.charAt(++this.pos));
        }
    }

    static class TokensIterator {
        private Tokens tokens;
        private int pos;

        static TokensIterator of(Tokens tokens, int pos) {
            return new TokensIterator(tokens, pos - 1);
        }

        TokensIterator(Tokens tokens, int pos) {
            this.tokens = tokens;
            this.pos = pos;
        }

        public boolean hasNext() {
            return this.pos < this.tokens.size() - 1;
        }

        public String next() {
            return this.tokens.token(++this.pos);
        }

        public int pos() {
            return this.pos;
        }
    }
}

