/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoRegistry;
import org.modelmapper.spi.PropertyInfo;

interface PropertyInfoResolver<M extends Member, PI extends PropertyInfo> {
    public static final PropertyInfoResolver<Field, Mutator> FIELDS = new DefaultPropertyResolver<Field, Mutator>(){

        @Override
        public Mutator propertyInfoFor(Class<?> initialType, Field field, Configuration configuration, String name) {
            return PropertyInfoRegistry.fieldPropertyFor(initialType, field, configuration, name);
        }

        public Field[] membersFor(Class<?> type) {
            return type.getDeclaredFields();
        }
    };
    public static final PropertyInfoResolver<Method, Accessor> ACCESSORS = new DefaultPropertyResolver<Method, Accessor>(){

        @Override
        public boolean isValid(Method method) {
            return super.isValid(method) && !method.isBridge() && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
        }

        @Override
        public Accessor propertyInfoFor(Class<?> initialType, Method method, Configuration configuration, String name) {
            return PropertyInfoRegistry.accessorFor(initialType, method, configuration, name);
        }

        public Method[] membersFor(Class<?> type) {
            return type.getDeclaredMethods();
        }
    };
    public static final PropertyInfoResolver<Method, Mutator> MUTATORS = new DefaultPropertyResolver<Method, Mutator>(){

        @Override
        public boolean isValid(Method method) {
            return super.isValid(method) && !method.isBridge() && method.getParameterTypes().length == 1 && (method.getReturnType().equals(Void.TYPE) || method.getReturnType().equals(method.getDeclaringClass()));
        }

        @Override
        public Mutator propertyInfoFor(Class<?> initialType, Method method, Configuration configuration, String name) {
            return PropertyInfoRegistry.mutatorFor(initialType, method, configuration, name);
        }

        public Method[] membersFor(Class<?> type) {
            return type.getDeclaredMethods();
        }
    };

    public boolean isValid(M var1);

    public PI propertyInfoFor(Class<?> var1, M var2, Configuration var3, String var4);

    public M[] membersFor(Class<?> var1);

    public static abstract class DefaultPropertyResolver<M extends Member, PI extends PropertyInfo>
    implements PropertyInfoResolver<M, PI> {
        @Override
        public boolean isValid(M member) {
            return !Modifier.isStatic(member.getModifiers()) && !member.isSynthetic();
        }
    }
}

