/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.detector;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import com.ulisesbocchio.jasyptspringboot.detector.DefaultPropertyDetector;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class DefaultLazyPropertyDetector
implements EncryptablePropertyDetector {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyPropertyDetector.class);
    private Singleton<EncryptablePropertyDetector> singleton;

    public DefaultLazyPropertyDetector(ConfigurableEnvironment environment, String customDetectorBeanName, boolean isCustom, BeanFactory bf) {
        this.singleton = new Singleton<EncryptablePropertyDetector>(() -> Optional.of(customDetectorBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (EncryptablePropertyDetector)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Detector Bean {} with name: {}", bean, (Object)customDetectorBeanName))).orElseGet(() -> {
            if (isCustom) {
                throw new IllegalStateException(String.format("Property Detector custom Bean not found with name '%s'", customDetectorBeanName));
            }
            log.info("Property Detector custom Bean not found with name '{}'. Initializing Default Property Detector", (Object)customDetectorBeanName);
            return this.createDefault(environment);
        }));
    }

    public DefaultLazyPropertyDetector(ConfigurableEnvironment environment) {
        this.singleton = new Singleton<EncryptablePropertyDetector>(() -> this.createDefault(environment));
    }

    private DefaultPropertyDetector createDefault(ConfigurableEnvironment environment) {
        JasyptEncryptorConfigurationProperties props = JasyptEncryptorConfigurationProperties.bindConfigProps(environment);
        return new DefaultPropertyDetector(props.getProperty().getPrefix(), props.getProperty().getSuffix());
    }

    @Override
    public boolean isEncrypted(String property) {
        return this.singleton.get().isEncrypted(property);
    }

    @Override
    public String unwrapEncryptedValue(String property) {
        return this.singleton.get().unwrapEncryptedValue(property);
    }
}

