/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    public static <U, T> IterableDecorator<U, T> decorate(Iterable<U> source, Function<U, T> transform, Predicate<U> filter) {
        return new IterableDecorator<U, T>(source, transform, filter);
    }

    public static <U, T> IterableDecorator<U, T> transform(Iterable<U> source, Function<U, T> transform) {
        return new IterableDecorator<Object, T>(source, transform, v -> true);
    }

    public static <T> IterableDecorator<T, T> filter(Iterable<T> source, Predicate<T> filter) {
        return new IterableDecorator(source, Function.identity(), filter);
    }

    public static class IteratorDecorator<U, T>
    implements Iterator<T> {
        private final Iterator<U> source;
        private final Function<U, T> transform;
        private final Predicate<U> filter;
        private T next = null;

        public IteratorDecorator(Iterator<U> source, Function<U, T> transform, Predicate<U> filter) {
            this.source = source;
            this.transform = transform;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            this.maybeFetchNext();
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T val = this.next;
            this.next = null;
            return val;
        }

        private void maybeFetchNext() {
            U val;
            if (this.next == null && this.source.hasNext() && this.filter.test(val = this.source.next())) {
                this.next = this.transform.apply(val);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class IterableDecorator<U, T>
    implements Iterable<T> {
        private final Function<U, T> transform;
        private final Predicate<U> filter;
        private final Iterable<U> source;

        IterableDecorator(Iterable<U> source, Function<U, T> transform, Predicate<U> filter) {
            this.source = source;
            this.transform = transform;
            this.filter = filter;
        }

        @Override
        public Iterator<T> iterator() {
            return new IteratorDecorator<U, T>(this.source.iterator(), this.transform, this.filter);
        }
    }
}

