/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.pool.OracleDataSource;

class NTFJMSConnection
extends Thread {
    private String jmsConnectionId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    NTFJMSConnection(String string, ArrayList<String> arrayList, String string2, String string3, String string4, String string5, String string6, int n2) {
        this.userName = string4;
        this.password = OpaqueString.newOpaqueString(string5);
        this.serviceName = string3;
        this.jmsConnectionId = string;
        this.listenerAddresses = arrayList;
        this.instanceName = string2;
        this.connClass = string6;
        this.numberOfRegistrations = n2;
        assert (arrayList != null) : "listenerAddresses is null";
        assert (string2 != null) : "instancename is null";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            this.conn = this.getConnection();
            while (!this.needToBeClosed) {
                this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.jmsConnectionId);
                try {
                    this.oaqnfy.doRPC();
                }
                catch (IOException iOException) {
                    throw iOException;
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Connection getConnection() throws SQLException, InterruptedException {
        Connection connection = null;
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setUser(this.userName);
        oracleDataSource.setPassword(this.password.get());
        if (this.connClass != null) {
            Properties properties = new Properties();
            properties.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            properties.put("oracle.jdbc.jmsNotification", "true");
            properties.put("oracle.jdbc.ReadTimeout", (Object)0);
            properties.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
            oracleDataSource.setConnectionProperties(properties);
        }
        int n2 = 0;
        while (connection == null && n2++ < 5 && !this.needToBeClosed) {
            connection = this.tryListenerAddressesToGetConnection(oracleDataSource);
            Thread.sleep(n2 * 5000);
        }
        if (connection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource oracleDataSource) {
        for (String string : this.listenerAddresses) {
            String string2 = "jdbc:oracle:thin:@(DESCRIPTION=" + string + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            oracleDataSource.setURL(string2);
            try {
                NTFJMSConnection nTFJMSConnection = this;
                synchronized (nTFJMSConnection) {
                    if (this.needToBeClosed) {
                        return null;
                    }
                    Connection connection = oracleDataSource.getConnection();
                    if (connection != null) {
                        return connection;
                    }
                }
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    synchronized void closeThisListener() {
        this.needToBeClosed = true;
        try {
            if (this.oaqnfy != null) {
                this.oaqnfy.stopListening();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations += n2;
    }

    void decrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations += n2;
    }
}

