/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIkpdnrack;

class T4CTTIkpdnrreq {
    byte[] clientIdBytes;
    short registrationOpCode;
    boolean acknowledgement = false;
    T4CTTIkpdnrack notificationAcknowledgment;
    T4CMAREngine mar;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIkpdnrreq(T4CConnection t4CConnection) {
        this.mar = t4CConnection.mare;
    }

    void send(byte[] byArray, OpCode opCode) throws IOException {
        this.clientIdBytes = byArray;
        this.registrationOpCode = opCode.getCode();
        this.marshal();
    }

    void marshal() throws IOException {
        if (this.clientIdBytes != null && this.clientIdBytes.length != 0) {
            this.mar.marshalUB2(this.clientIdBytes.length);
            this.mar.marshalCLR(this.clientIdBytes, 0, this.clientIdBytes.length);
        } else {
            this.mar.marshalSWORD(0);
        }
        this.mar.marshalUB1(this.registrationOpCode);
        if (this.acknowledgement) {
            this.notificationAcknowledgment.send(null, 0L, null);
        } else {
            this.mar.marshalSWORD(0);
        }
    }

    static enum OpCode {
        INIT_KPDNRREQ(1),
        COMMIT_KPDNRREQ(2),
        ROLLBACK_KPDNRREQ(3),
        REINIT_KPDNRREQ(4);

        private final short mode;

        private OpCode(short s2) {
            this.mode = s2;
        }

        public final short getCode() {
            return this.mode;
        }
    }
}

