/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.jar.asm.ConstantDynamic;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaType;

public interface JavaConstant {
    public Object asConstantPoolValue();

    public TypeDescription getTypeDescription();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Dynamic
    implements JavaConstant {
        private static final String CONSTANT_BOOTSTRAPS = "java/lang/invoke/ConstantBootstraps";
        private final ConstantDynamic value;
        private final TypeDescription typeDescription;

        protected Dynamic(ConstantDynamic value, TypeDescription typeDescription) {
            this.value = value;
            this.typeDescription = typeDescription;
        }

        public static Dynamic ofNullConstant() {
            return new Dynamic(new ConstantDynamic("nullConstant", TypeDescription.OBJECT.getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, "nullConstant", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", false), new Object[0]), TypeDescription.OBJECT);
        }

        public static JavaConstant ofPrimitiveType(Class<?> type) {
            return Dynamic.ofPrimitiveType(TypeDescription.ForLoadedType.of(type));
        }

        public static JavaConstant ofPrimitiveType(TypeDescription typeDescription) {
            if (!typeDescription.isPrimitive()) {
                throw new IllegalArgumentException("Not a primitive type: " + typeDescription);
            }
            return new Dynamic(new ConstantDynamic(typeDescription.getDescriptor(), TypeDescription.CLASS.getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, "primitiveClass", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Class;", false), new Object[0]), TypeDescription.CLASS);
        }

        public static JavaConstant ofEnumeration(Enum<?> enumeration) {
            return Dynamic.ofEnumeration(new EnumerationDescription.ForLoadedEnumeration(enumeration));
        }

        public static JavaConstant ofEnumeration(EnumerationDescription enumerationDescription) {
            return new Dynamic(new ConstantDynamic(enumerationDescription.getValue(), enumerationDescription.getEnumerationType().getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, "enumConstant", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Enum;", false), new Object[0]), enumerationDescription.getEnumerationType());
        }

        public static Dynamic ofField(Field field) {
            return Dynamic.ofField(new FieldDescription.ForLoadedField(field));
        }

        public static Dynamic ofField(FieldDescription.InDefinedShape fieldDescription) {
            Object[] objectArray;
            if (!fieldDescription.isStatic() || !fieldDescription.isFinal()) {
                throw new IllegalArgumentException("Field must be static and final: " + fieldDescription);
            }
            boolean selfDeclared = fieldDescription.getType().isPrimitive() ? fieldDescription.getType().asErasure().asBoxed().equals(fieldDescription.getType().asErasure()) : fieldDescription.getDeclaringType().equals(fieldDescription.getType().asErasure());
            String string = fieldDescription.getInternalName();
            String string2 = fieldDescription.getDescriptor();
            Handle handle = new Handle(6, CONSTANT_BOOTSTRAPS, "getStaticFinal", selfDeclared ? "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;" : "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", false);
            if (selfDeclared) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = Type.getType(fieldDescription.getDeclaringType().getDescriptor());
            }
            return new Dynamic(new ConstantDynamic(string, string2, handle, objectArray), fieldDescription.getType().asErasure());
        }

        public static Dynamic ofInvocation(Method method, Object ... constant) {
            return Dynamic.ofInvocation(method, Arrays.asList(constant));
        }

        public static Dynamic ofInvocation(Method method, List<?> constants) {
            return Dynamic.ofInvocation((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), constants);
        }

        public static Dynamic ofInvocation(Constructor<?> constructor, Object ... constant) {
            return Dynamic.ofInvocation(constructor, Arrays.asList(constant));
        }

        public static Dynamic ofInvocation(Constructor<?> constructor, List<?> constants) {
            return Dynamic.ofInvocation((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), constants);
        }

        public static Dynamic ofInvocation(MethodDescription.InDefinedShape methodDescription, Object ... constant) {
            return Dynamic.ofInvocation(methodDescription, Arrays.asList(constant));
        }

        public static Dynamic ofInvocation(MethodDescription.InDefinedShape methodDescription, List<?> constants) {
            if (!methodDescription.isConstructor() && methodDescription.getReturnType().represents(Void.TYPE)) {
                throw new IllegalArgumentException("Bootstrap method is no constructor or non-void static factory: " + methodDescription);
            }
            if (methodDescription.isVarArgs() ? methodDescription.getParameters().size() + (methodDescription.isStatic() || methodDescription.isConstructor() ? 0 : 1) > constants.size() + 1 : methodDescription.getParameters().size() + (methodDescription.isStatic() || methodDescription.isConstructor() ? 0 : 1) != constants.size()) {
                throw new IllegalArgumentException("Cannot assign " + constants + " to " + methodDescription);
            }
            Object[] argument = new Object[constants.size() + 1];
            argument[0] = new Handle(methodDescription.isConstructor() ? 8 : 6, methodDescription.getDeclaringType().getInternalName(), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getDeclaringType().isInterface());
            TypeList parameters = methodDescription.isStatic() || methodDescription.isConstructor() ? methodDescription.getParameters().asTypeList().asErasures() : CompoundList.of(methodDescription.getDeclaringType(), methodDescription.getParameters().asTypeList().asErasures());
            Iterator<Object> iterator = methodDescription.isVarArgs() ? CompoundList.of(parameters.subList(0, parameters.size() - 1), Collections.nCopies(constants.size() - parameters.size() + 1, ((TypeDescription)parameters.get(parameters.size() - 1)).getComponentType())).iterator() : parameters.iterator();
            int index = 0;
            for (Object constant : constants) {
                JavaConstant wrapped = Simple.wrap(constant);
                if (!wrapped.getTypeDescription().isAssignableTo((TypeDescription)iterator.next())) {
                    throw new IllegalArgumentException("Cannot assign " + constants + " to " + methodDescription);
                }
                argument[++index] = wrapped.asConstantPoolValue();
            }
            return new Dynamic(new ConstantDynamic("invoke", (methodDescription.isConstructor() ? methodDescription.getDeclaringType() : methodDescription.getReturnType().asErasure()).getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, "invoke", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/invoke/MethodHandle;[Ljava/lang/Object;)Ljava/lang/Object;", false), argument), methodDescription.isConstructor() ? methodDescription.getDeclaringType() : methodDescription.getReturnType().asErasure());
        }

        public static JavaConstant ofVarHandle(Field field) {
            return Dynamic.ofVarHandle(new FieldDescription.ForLoadedField(field));
        }

        public static JavaConstant ofVarHandle(FieldDescription.InDefinedShape fieldDescription) {
            return new Dynamic(new ConstantDynamic(fieldDescription.getInternalName(), JavaType.VAR_HANDLE.getTypeStub().getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, fieldDescription.isStatic() ? "staticFieldVarHandle" : "fieldVarHandle", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", false), Type.getType(fieldDescription.getDeclaringType().getDescriptor()), Type.getType(fieldDescription.getType().asErasure().getDescriptor())), JavaType.VAR_HANDLE.getTypeStub());
        }

        public static JavaConstant ofArrayVarHandle(Class<?> type) {
            return Dynamic.ofArrayVarHandle(TypeDescription.ForLoadedType.of(type));
        }

        public static JavaConstant ofArrayVarHandle(TypeDescription typeDescription) {
            if (!typeDescription.isArray()) {
                throw new IllegalArgumentException("Not an array type: " + typeDescription);
            }
            return new Dynamic(new ConstantDynamic("arrayVarHandle", JavaType.VAR_HANDLE.getTypeStub().getDescriptor(), new Handle(6, CONSTANT_BOOTSTRAPS, "arrayVarHandle", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;", false), Type.getType(typeDescription.getDescriptor())), JavaType.VAR_HANDLE.getTypeStub());
        }

        public static Dynamic bootstrap(String name, Method method, Object ... constant) {
            return Dynamic.bootstrap(name, method, Arrays.asList(constant));
        }

        public static Dynamic bootstrap(String name, Method method, List<?> constants) {
            return Dynamic.bootstrap(name, (MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method), constants);
        }

        public static Dynamic bootstrap(String name, Constructor<?> constructor, Object ... constant) {
            return Dynamic.bootstrap(name, constructor, Arrays.asList(constant));
        }

        public static Dynamic bootstrap(String name, Constructor<?> constructor, List<?> constants) {
            return Dynamic.bootstrap(name, (MethodDescription.InDefinedShape)new MethodDescription.ForLoadedConstructor(constructor), constants);
        }

        public static Dynamic bootstrap(String name, MethodDescription.InDefinedShape bootstrapMethod, Object ... constant) {
            return Dynamic.bootstrap(name, bootstrapMethod, Arrays.asList(constant));
        }

        public static Dynamic bootstrap(String name, MethodDescription.InDefinedShape bootstrap, List<?> constants) {
            if (name.length() == 0 || name.contains(".")) {
                throw new IllegalArgumentException("Not a valid field name: " + name);
            }
            Object[] argument = new Object[constants.size()];
            ArrayList<TypeDescription> types = new ArrayList<TypeDescription>(constants.size());
            int index = 0;
            for (Object constant : constants) {
                JavaConstant wrapped = Simple.wrap(constant);
                argument[index++] = wrapped.asConstantPoolValue();
                types.add(wrapped.getTypeDescription());
            }
            if (!bootstrap.isConstantBootstrap(types)) {
                throw new IllegalArgumentException("Not a valid bootstrap method " + bootstrap + " for " + Arrays.asList(argument));
            }
            return new Dynamic(new ConstantDynamic(name, (bootstrap.isConstructor() ? bootstrap.getDeclaringType() : bootstrap.getReturnType().asErasure()).getDescriptor(), new Handle(bootstrap.isConstructor() ? 8 : 6, bootstrap.getDeclaringType().getInternalName(), bootstrap.getInternalName(), bootstrap.getDescriptor(), false), argument), bootstrap.isConstructor() ? bootstrap.getDeclaringType() : bootstrap.getReturnType().asErasure());
        }

        public JavaConstant withType(Class<?> type) {
            return this.withType(TypeDescription.ForLoadedType.of(type));
        }

        public JavaConstant withType(TypeDescription typeDescription) {
            if (typeDescription.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Constant value cannot represent void");
            }
            if (this.value.getBootstrapMethod().getName().equals("<init>") ? !this.typeDescription.isAssignableTo(typeDescription) : !typeDescription.asBoxed().isInHierarchyWith(this.typeDescription.asBoxed())) {
                throw new IllegalArgumentException(typeDescription + " is not compatible with bootstrapped type " + this.typeDescription);
            }
            Object[] bootstrapMethodArgument = new Object[this.value.getBootstrapMethodArgumentCount()];
            for (int index = 0; index < this.value.getBootstrapMethodArgumentCount(); ++index) {
                bootstrapMethodArgument[index] = this.value.getBootstrapMethodArgument(index);
            }
            return new Dynamic(new ConstantDynamic(this.value.getName(), typeDescription.getDescriptor(), this.value.getBootstrapMethod(), bootstrapMethodArgument), typeDescription);
        }

        @Override
        public Object asConstantPoolValue() {
            return this.value;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.typeDescription;
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.typeDescription.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Dynamic dynamic = (Dynamic)other;
            return this.value.equals(dynamic.value) && this.typeDescription.equals(dynamic.typeDescription);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodHandle
    implements JavaConstant {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final HandleType handleType;
        private final TypeDescription ownerType;
        private final String name;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodHandle(HandleType handleType, TypeDescription ownerType, String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.handleType = handleType;
            this.ownerType = ownerType;
            this.name = name;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodHandle ofLoaded(Object methodHandle) {
            return MethodHandle.ofLoaded(methodHandle, DISPATCHER.publicLookup());
        }

        public static MethodHandle ofLoaded(Object methodHandle, Object lookup) {
            if (!JavaType.METHOD_HANDLE.isInstance(methodHandle)) {
                throw new IllegalArgumentException("Expected method handle object: " + methodHandle);
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.isInstance(lookup)) {
                throw new IllegalArgumentException("Expected method handle lookup object: " + lookup);
            }
            Dispatcher dispatcher = DISPATCHER.initialize();
            Object methodHandleInfo = dispatcher.reveal(lookup, methodHandle);
            Object methodType = dispatcher.getMethodType(methodHandleInfo);
            return new MethodHandle(HandleType.of(dispatcher.getReferenceKind(methodHandleInfo)), TypeDescription.ForLoadedType.of(dispatcher.getDeclaringClass(methodHandleInfo)), dispatcher.getName(methodHandleInfo), TypeDescription.ForLoadedType.of(dispatcher.returnType(methodType)), new TypeList.ForLoadedTypes(dispatcher.parameterArray(methodType)));
        }

        public static MethodHandle of(Method method) {
            return MethodHandle.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodHandle of(Constructor<?> constructor) {
            return MethodHandle.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodHandle of(MethodDescription.InDefinedShape methodDescription) {
            return new MethodHandle(HandleType.of(methodDescription), methodDescription.getDeclaringType().asErasure(), methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofSpecial(Method method, Class<?> type) {
            return MethodHandle.ofSpecial(new MethodDescription.ForLoadedMethod(method), TypeDescription.ForLoadedType.of(type));
        }

        public static MethodHandle ofSpecial(MethodDescription.InDefinedShape methodDescription, TypeDescription typeDescription) {
            if (!methodDescription.isSpecializableFor(typeDescription)) {
                throw new IllegalArgumentException("Cannot specialize " + methodDescription + " for " + typeDescription);
            }
            return new MethodHandle(HandleType.ofSpecial(methodDescription), typeDescription, methodDescription.getInternalName(), methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodHandle ofGetter(Field field) {
            return MethodHandle.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofGetter(FieldDescription.InDefinedShape fieldDescription) {
            return new MethodHandle(HandleType.ofGetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodHandle ofSetter(Field field) {
            return MethodHandle.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodHandle ofSetter(FieldDescription.InDefinedShape fieldDescription) {
            return new MethodHandle(HandleType.ofSetter(fieldDescription), fieldDescription.getDeclaringType().asErasure(), fieldDescription.getInternalName(), TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        @Override
        public Object asConstantPoolValue() {
            return new Handle(this.getHandleType().getIdentifier(), this.getOwnerType().getInternalName(), this.getName(), this.getDescriptor(), this.getOwnerType().isInterface());
        }

        @Override
        public TypeDescription getTypeDescription() {
            return JavaType.METHOD_HANDLE.getTypeStub();
        }

        public HandleType getHandleType() {
            return this.handleType;
        }

        public TypeDescription getOwnerType() {
            return this.ownerType;
        }

        public String getName() {
            return this.name;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        public String getDescriptor() {
            switch (this.handleType) {
                case GET_FIELD: 
                case GET_STATIC_FIELD: {
                    return this.returnType.getDescriptor();
                }
                case PUT_FIELD: 
                case PUT_STATIC_FIELD: {
                    return this.parameterTypes.get(0).getDescriptor();
                }
            }
            StringBuilder stringBuilder = new StringBuilder().append('(');
            for (TypeDescription typeDescription : this.parameterTypes) {
                stringBuilder.append(typeDescription.getDescriptor());
            }
            return stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
        }

        public int hashCode() {
            int result = this.handleType.hashCode();
            result = 31 * result + this.ownerType.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodHandle)) {
                return false;
            }
            MethodHandle methodHandle = (MethodHandle)other;
            return this.handleType == methodHandle.handleType && this.name.equals(methodHandle.name) && this.ownerType.equals(methodHandle.ownerType) && this.parameterTypes.equals(methodHandle.parameterTypes) && this.returnType.equals(methodHandle.returnType);
        }

        public static Class<?> lookupType(Object callerClassLookup) {
            return DISPATCHER.lookupType(callerClassLookup);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum HandleType {
            INVOKE_VIRTUAL(5, false),
            INVOKE_STATIC(6, false),
            INVOKE_SPECIAL(7, false),
            INVOKE_INTERFACE(9, false),
            INVOKE_SPECIAL_CONSTRUCTOR(8, false),
            PUT_FIELD(3, true),
            GET_FIELD(1, true),
            PUT_STATIC_FIELD(4, true),
            GET_STATIC_FIELD(2, true);

            private final int identifier;
            private final boolean field;

            private HandleType(int identifier, boolean field) {
                this.identifier = identifier;
                this.field = field;
            }

            protected static HandleType of(MethodDescription.InDefinedShape methodDescription) {
                if (methodDescription.isTypeInitializer()) {
                    throw new IllegalArgumentException("Cannot create handle of type initializer " + methodDescription);
                }
                if (methodDescription.isStatic()) {
                    return INVOKE_STATIC;
                }
                if (methodDescription.isConstructor()) {
                    return INVOKE_SPECIAL_CONSTRUCTOR;
                }
                if (methodDescription.isPrivate()) {
                    return INVOKE_SPECIAL;
                }
                if (methodDescription.getDeclaringType().isInterface()) {
                    return INVOKE_INTERFACE;
                }
                return INVOKE_VIRTUAL;
            }

            protected static HandleType of(int identifier) {
                for (HandleType handleType : HandleType.values()) {
                    if (handleType.getIdentifier() != identifier) continue;
                    return handleType;
                }
                throw new IllegalArgumentException("Unknown handle type: " + identifier);
            }

            protected static HandleType ofSpecial(MethodDescription.InDefinedShape methodDescription) {
                if (methodDescription.isStatic() || methodDescription.isAbstract()) {
                    throw new IllegalArgumentException("Cannot invoke " + methodDescription + " via invokespecial");
                }
                return methodDescription.isConstructor() ? INVOKE_SPECIAL_CONSTRUCTOR : INVOKE_SPECIAL;
            }

            protected static HandleType ofGetter(FieldDescription.InDefinedShape fieldDescription) {
                return fieldDescription.isStatic() ? GET_STATIC_FIELD : GET_FIELD;
            }

            protected static HandleType ofSetter(FieldDescription.InDefinedShape fieldDescription) {
                return fieldDescription.isStatic() ? PUT_STATIC_FIELD : PUT_FIELD;
            }

            public int getIdentifier() {
                return this.identifier;
            }

            public boolean isField() {
                return this.field;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public Object reveal(Object var1, Object var2);

            public Object getMethodType(Object var1);

            public int getReferenceKind(Object var1);

            public Class<?> getDeclaringClass(Object var1);

            public String getName(Object var1);

            public Class<?> returnType(Object var1);

            public List<? extends Class<?>> parameterArray(Object var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Initializable
            {
                INSTANCE;


                @Override
                public Dispatcher initialize() {
                    throw new UnsupportedOperationException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                @Override
                public Object publicLookup() {
                    throw new UnsupportedOperationException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    throw new UnsupportedOperationException("Unsupported type on current JVM: java.lang.invoke.MethodHandle");
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava7CapableVm
            extends AbstractBase
            implements PrivilegedAction<Dispatcher> {
                private final Constructor<?> methodInfo;

                protected ForJava7CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass, Constructor<?> methodInfo) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray, lookupClass);
                    this.methodInfo = methodInfo;
                }

                @Override
                public Dispatcher initialize() {
                    return AccessController.doPrivileged(this);
                }

                @Override
                public Dispatcher run() {
                    this.methodInfo.setAccessible(true);
                    this.getName.setAccessible(true);
                    this.getDeclaringClass.setAccessible(true);
                    this.getReferenceKind.setAccessible(true);
                    this.getMethodType.setAccessible(true);
                    return this;
                }

                @Override
                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.methodInfo.newInstance(methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodInfo()", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodInfo()", exception.getCause());
                    }
                    catch (InstantiationException exception) {
                        throw new IllegalStateException("Error constructing java.lang.invoke.MethodInfo", exception);
                    }
                }

                @Override
                public boolean equals(Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.methodInfo.equals(((ForJava7CapableVm)object).methodInfo);
                }

                @Override
                public int hashCode() {
                    return super.hashCode() * 31 + this.methodInfo.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava8CapableVm
            extends AbstractBase {
                private final Method revealDirect;

                protected ForJava8CapableVm(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass, Method revealDirect) {
                    super(publicLookup, getName, getDeclaringClass, getReferenceKind, getMethodType, returnType, parameterArray, lookupClass);
                    this.revealDirect = revealDirect;
                }

                public Object reveal(Object lookup, Object methodHandle) {
                    try {
                        return this.revealDirect.invoke(lookup, methodHandle);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles.Lookup#revealDirect", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles.Lookup#revealDirect", exception.getCause());
                    }
                }

                public Dispatcher initialize() {
                    return this;
                }

                public boolean equals(Object object) {
                    if (!super.equals(object)) {
                        return false;
                    }
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.revealDirect.equals(((ForJava8CapableVm)object).revealDirect);
                }

                public int hashCode() {
                    return super.hashCode() * 31 + this.revealDirect.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class AbstractBase
            implements Dispatcher,
            Initializable {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                protected final Method publicLookup;
                protected final Method getName;
                protected final Method getDeclaringClass;
                protected final Method getReferenceKind;
                protected final Method getMethodType;
                protected final Method returnType;
                protected final Method parameterArray;
                protected final Method lookupClass;

                protected AbstractBase(Method publicLookup, Method getName, Method getDeclaringClass, Method getReferenceKind, Method getMethodType, Method returnType, Method parameterArray, Method lookupClass) {
                    this.publicLookup = publicLookup;
                    this.getName = getName;
                    this.getDeclaringClass = getDeclaringClass;
                    this.getReferenceKind = getReferenceKind;
                    this.getMethodType = getMethodType;
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                    this.lookupClass = lookupClass;
                }

                @Override
                public Object publicLookup() {
                    try {
                        return this.publicLookup.invoke(null, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles#publicLookup", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles#publicLookup", exception.getCause());
                    }
                }

                @Override
                public Object getMethodType(Object methodHandleInfo) {
                    try {
                        return this.getMethodType.invoke(methodHandleInfo, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getMethodType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getMethodType", exception.getCause());
                    }
                }

                @Override
                public int getReferenceKind(Object methodHandleInfo) {
                    try {
                        return (Integer)this.getReferenceKind.invoke(methodHandleInfo, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getReferenceKind", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getReferenceKind", exception.getCause());
                    }
                }

                @Override
                public Class<?> getDeclaringClass(Object methodHandleInfo) {
                    try {
                        return (Class)this.getDeclaringClass.invoke(methodHandleInfo, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getDeclaringClass", exception.getCause());
                    }
                }

                @Override
                public String getName(Object methodHandleInfo) {
                    try {
                        return (String)this.getName.invoke(methodHandleInfo, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandleInfo#getName", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandleInfo#getName", exception.getCause());
                    }
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public List<? extends Class<?>> parameterArray(Object methodType) {
                    try {
                        return Arrays.asList((Class[])this.parameterArray.invoke(methodType, NO_ARGUMENTS));
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodType#parameterArray", exception.getCause());
                    }
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    try {
                        return (Class)this.lookupClass.invoke(lookup, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.MethodHandles.Lookup#lookupClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.MethodHandles.Lookup#lookupClass", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.publicLookup.equals(((AbstractBase)object).publicLookup)) {
                        return false;
                    }
                    if (!this.getName.equals(((AbstractBase)object).getName)) {
                        return false;
                    }
                    if (!this.getDeclaringClass.equals(((AbstractBase)object).getDeclaringClass)) {
                        return false;
                    }
                    if (!this.getReferenceKind.equals(((AbstractBase)object).getReferenceKind)) {
                        return false;
                    }
                    if (!this.getMethodType.equals(((AbstractBase)object).getMethodType)) {
                        return false;
                    }
                    if (!this.returnType.equals(((AbstractBase)object).returnType)) {
                        return false;
                    }
                    if (!this.parameterArray.equals(((AbstractBase)object).parameterArray)) {
                        return false;
                    }
                    return this.lookupClass.equals(((AbstractBase)object).lookupClass);
                }

                public int hashCode() {
                    return (((((((17 * 31 + this.publicLookup.hashCode()) * 31 + this.getName.hashCode()) * 31 + this.getDeclaringClass.hashCode()) * 31 + this.getReferenceKind.hashCode()) * 31 + this.getMethodType.hashCode()) * 31 + this.returnType.hashCode()) * 31 + this.parameterArray.hashCode()) * 31 + this.lookupClass.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        return new ForJava8CapableVm(Class.forName("java.lang.invoke.MethodHandles").getMethod("publicLookup", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getName", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getDeclaringClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getReferenceKind", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getMethodType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("returnType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("parameterArray", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("lookupClass", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("revealDirect", JavaType.METHOD_HANDLE.load()));
                    }
                    catch (Exception ignored) {
                        try {
                            return new ForJava7CapableVm(Class.forName("java.lang.invoke.MethodHandles").getMethod("publicLookup", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getName", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getDeclaringClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getReferenceKind", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getMethod("getMethodType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("returnType", new Class[0]), JavaType.METHOD_TYPE.load().getMethod("parameterArray", new Class[0]), JavaType.METHOD_HANDLES_LOOKUP.load().getMethod("lookupClass", new Class[0]), Class.forName("java.lang.invoke.MethodHandleInfo").getConstructor(JavaType.METHOD_HANDLE.load()));
                        }
                        catch (Exception ignored2) {
                            return ForLegacyVm.INSTANCE;
                        }
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static interface Initializable {
                public Dispatcher initialize();

                public Object publicLookup();

                public Class<?> lookupType(Object var1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    implements JavaConstant {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        protected MethodType(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public static MethodType ofLoaded(Object methodType) {
            if (!JavaType.METHOD_TYPE.isInstance(methodType)) {
                throw new IllegalArgumentException("Expected method type object: " + methodType);
            }
            return MethodType.of(DISPATCHER.returnType(methodType), DISPATCHER.parameterArray(methodType));
        }

        public static MethodType of(Class<?> returnType, Class<?> ... parameterType) {
            return MethodType.of(TypeDescription.ForLoadedType.of(returnType), new TypeList.ForLoadedTypes(parameterType));
        }

        public static MethodType of(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            return new MethodType(returnType, parameterTypes);
        }

        public static MethodType of(Method method) {
            return MethodType.of(new MethodDescription.ForLoadedMethod(method));
        }

        public static MethodType of(Constructor<?> constructor) {
            return MethodType.of(new MethodDescription.ForLoadedConstructor(constructor));
        }

        public static MethodType of(MethodDescription methodDescription) {
            return new MethodType(methodDescription.getReturnType().asErasure(), methodDescription.getParameters().asTypeList().asErasures());
        }

        public static MethodType ofSetter(Field field) {
            return MethodType.ofSetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofSetter(FieldDescription fieldDescription) {
            return new MethodType(TypeDescription.VOID, Collections.singletonList(fieldDescription.getType().asErasure()));
        }

        public static MethodType ofGetter(Field field) {
            return MethodType.ofGetter(new FieldDescription.ForLoadedField(field));
        }

        public static MethodType ofGetter(FieldDescription fieldDescription) {
            return new MethodType(fieldDescription.getType().asErasure(), Collections.emptyList());
        }

        public static MethodType ofConstant(Object instance) {
            return MethodType.ofConstant(instance.getClass());
        }

        public static MethodType ofConstant(Class<?> type) {
            return MethodType.ofConstant(TypeDescription.ForLoadedType.of(type));
        }

        public static MethodType ofConstant(TypeDescription typeDescription) {
            return new MethodType(typeDescription, Collections.emptyList());
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription typeDescription : this.parameterTypes) {
                stringBuilder.append(typeDescription.getDescriptor());
            }
            return stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
        }

        @Override
        public Object asConstantPoolValue() {
            StringBuilder stringBuilder = new StringBuilder().append('(');
            for (TypeDescription parameterType : this.getParameterTypes()) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            return Type.getMethodType(stringBuilder.append(')').append(this.getReturnType().getDescriptor()).toString());
        }

        @Override
        public TypeDescription getTypeDescription() {
            return JavaType.METHOD_TYPE.getTypeStub();
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodType)) {
                return false;
            }
            MethodType methodType = (MethodType)other;
            return this.parameterTypes.equals(methodType.parameterTypes) && this.returnType.equals(methodType.returnType);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static interface Dispatcher {
            public Class<?> returnType(Object var1);

            public Class<?>[] parameterArray(Object var1);

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public Class<?> returnType(Object methodType) {
                    throw new UnsupportedOperationException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    throw new UnsupportedOperationException("Unsupported type for the current JVM: java.lang.invoke.MethodType");
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava7CapableVm
            implements Dispatcher {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                private final Method returnType;
                private final Method parameterArray;

                protected ForJava7CapableVm(Method returnType, Method parameterArray) {
                    this.returnType = returnType;
                    this.parameterArray = parameterArray;
                }

                @Override
                public Class<?> returnType(Object methodType) {
                    try {
                        return (Class)this.returnType.invoke(methodType, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#returnType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#returnType", exception.getCause());
                    }
                }

                @Override
                public Class<?>[] parameterArray(Object methodType) {
                    try {
                        return (Class[])this.parameterArray.invoke(methodType, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodType#parameterArray", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodType#parameterArray", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.returnType.equals(((ForJava7CapableVm)object).returnType)) {
                        return false;
                    }
                    return this.parameterArray.equals(((ForJava7CapableVm)object).parameterArray);
                }

                public int hashCode() {
                    return (17 * 31 + this.returnType.hashCode()) * 31 + this.parameterArray.hashCode();
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum CreationAction implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> methodType = JavaType.METHOD_TYPE.load();
                        return new ForJava7CapableVm(methodType.getMethod("returnType", new Class[0]), methodType.getMethod("parameterArray", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Simple
    implements JavaConstant {
        private final Object value;
        private final TypeDescription typeDescription;

        protected Simple(Object value, TypeDescription typeDescription) {
            this.value = value;
            this.typeDescription = typeDescription;
        }

        public static JavaConstant ofLoaded(Object value) {
            if (value instanceof Integer) {
                return new Simple(value, TypeDescription.ForLoadedType.of(Integer.TYPE));
            }
            if (value instanceof Long) {
                return new Simple(value, TypeDescription.ForLoadedType.of(Long.TYPE));
            }
            if (value instanceof Float) {
                return new Simple(value, TypeDescription.ForLoadedType.of(Float.TYPE));
            }
            if (value instanceof Double) {
                return new Simple(value, TypeDescription.ForLoadedType.of(Double.TYPE));
            }
            if (value instanceof String) {
                return new Simple(value, TypeDescription.STRING);
            }
            if (value instanceof Class) {
                return new Simple(Type.getType((Class)value), TypeDescription.CLASS);
            }
            if (JavaType.METHOD_HANDLE.isInstance(value)) {
                return MethodHandle.ofLoaded(value);
            }
            if (JavaType.METHOD_TYPE.isInstance(value)) {
                return MethodType.ofLoaded(value);
            }
            throw new IllegalArgumentException("Not a loaded Java constant value: " + value);
        }

        public static JavaConstant of(TypeDescription typeDescription) {
            return new Simple(Type.getType(typeDescription.getDescriptor()), TypeDescription.CLASS);
        }

        public static JavaConstant wrap(Object value) {
            if (value instanceof JavaConstant) {
                return (JavaConstant)value;
            }
            if (value instanceof TypeDescription) {
                return Simple.of((TypeDescription)value);
            }
            return Simple.ofLoaded(value);
        }

        public static List<JavaConstant> wrap(List<?> values) {
            ArrayList<JavaConstant> constants = new ArrayList<JavaConstant>(values.size());
            for (Object value : values) {
                constants.add(Simple.wrap(value));
            }
            return constants;
        }

        @Override
        public Object asConstantPoolValue() {
            return this.value;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.typeDescription;
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.typeDescription.hashCode();
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Simple simple = (Simple)object;
            if (!this.value.equals(simple.value)) {
                return false;
            }
            return this.typeDescription.equals(simple.typeDescription);
        }
    }
}

