/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.TypeInfoImpl;

class TypeInfoRegistry {
    private static final Map<TypeInfoKey, TypeInfoImpl<?>> cache = new ConcurrentHashMap();

    TypeInfoRegistry() {
    }

    static <T> TypeInfoImpl<T> typeInfoFor(Accessor accessor, InheritingConfiguration configuration) {
        return TypeInfoRegistry.typeInfoFor(null, accessor.getType(), configuration);
    }

    static <T> TypeInfoImpl<T> typeInfoFor(T source, Class<T> sourceType, InheritingConfiguration configuration) {
        if (configuration.valueAccessStore.getFirstSupportedReader(sourceType) != null && source != null) {
            return new TypeInfoImpl<T>(source, sourceType, configuration);
        }
        return TypeInfoRegistry.typeInfoFor(sourceType, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> TypeInfoImpl<T> typeInfoFor(Class<T> sourceType, InheritingConfiguration configuration) {
        TypeInfoKey pair = new TypeInfoKey(sourceType, configuration);
        TypeInfoImpl<Object> typeInfo = cache.get(pair);
        if (typeInfo == null) {
            Map<TypeInfoKey, TypeInfoImpl<?>> map = cache;
            synchronized (map) {
                typeInfo = cache.get(pair);
                if (typeInfo == null) {
                    typeInfo = new TypeInfoImpl<Object>(null, sourceType, configuration);
                    cache.put(pair, typeInfo);
                }
            }
        }
        return typeInfo;
    }

    private static class TypeInfoKey {
        private final Class<?> type;
        private final Configuration configuration;

        TypeInfoKey(Class<?> type, Configuration configuration) {
            this.type = type;
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeInfoKey)) {
                return false;
            }
            TypeInfoKey other = (TypeInfoKey)o;
            return this.type.equals(other.type) && this.configuration.equals(other.configuration);
        }

        public int hashCode() {
            int result = 31 * this.type.hashCode();
            return 31 * result + this.configuration.hashCode();
        }
    }
}

