/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jasypt.encryption.StringEncryptor;

public class PooledStringEncryptor
implements StringEncryptor {
    private final int size;
    private final StringEncryptor[] pool;
    private final AtomicInteger roundRobin;

    public PooledStringEncryptor(int size, Supplier<StringEncryptor> encryptorFactory) {
        this.size = size;
        this.pool = (StringEncryptor[])IntStream.range(0, this.size).boxed().map(v -> {
            StringEncryptor encryptor = (StringEncryptor)encryptorFactory.get();
            if (encryptor instanceof ThreadSafeStringEncryptor) {
                return encryptor;
            }
            return new ThreadSafeStringEncryptor(encryptor);
        }).toArray(StringEncryptor[]::new);
        this.roundRobin = new AtomicInteger();
    }

    private <T> T robin(Function<StringEncryptor, T> producer) {
        int position = this.roundRobin.getAndUpdate(value -> (value + 1) % this.size);
        return producer.apply(this.pool[position]);
    }

    public String encrypt(String message) {
        return this.robin(e -> e.encrypt(message));
    }

    public String decrypt(String encryptedMessage) {
        return this.robin(e -> e.decrypt(encryptedMessage));
    }

    public static class ThreadSafeStringEncryptor
    implements StringEncryptor {
        private final StringEncryptor delegate;

        public ThreadSafeStringEncryptor(StringEncryptor delegate) {
            this.delegate = delegate;
        }

        public synchronized String encrypt(String message) {
            return this.delegate.encrypt(message);
        }

        public synchronized String decrypt(String encryptedMessage) {
            return this.delegate.decrypt(encryptedMessage);
        }
    }
}

