/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.ws.wsdl.wsdl11.DefaultWsdl11Definition;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.springframework.xml.xsd.commons.CommonsXsdSchemaCollection;
import org.w3c.dom.Element;

class DynamicWsdlBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final boolean commonsSchemaPresent = ClassUtils.isPresent((String)"org.apache.ws.commons.schema.XmlSchema", (ClassLoader)DynamicWsdlBeanDefinitionParser.class.getClassLoader());

    DynamicWsdlBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        BeanDefinitionBuilder wsdlBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultWsdl11Definition.class);
        wsdlBuilder.setRole(2);
        wsdlBuilder.getRawBeanDefinition().setSource(source);
        this.addProperty(element, wsdlBuilder, "portTypeName");
        this.addProperty(element, wsdlBuilder, "targetNamespace");
        this.addProperty(element, wsdlBuilder, "requestSuffix");
        this.addProperty(element, wsdlBuilder, "responseSuffix");
        this.addProperty(element, wsdlBuilder, "faultSuffix");
        this.addProperty(element, wsdlBuilder, "createSoap11Binding");
        this.addProperty(element, wsdlBuilder, "createSoap12Binding");
        this.addProperty(element, wsdlBuilder, "transportUri");
        this.addProperty(element, wsdlBuilder, "locationUri");
        this.addProperty(element, wsdlBuilder, "serviceName");
        List schemas = DomUtils.getChildElementsByTagName((Element)element, (String)"xsd");
        if (commonsSchemaPresent) {
            RootBeanDefinition collectionDef = this.createBeanDefinition(CommonsXsdSchemaCollection.class, source);
            collectionDef.getPropertyValues().addPropertyValue("inline", (Object)"true");
            ManagedList xsds = new ManagedList();
            xsds.setSource(source);
            for (Element schema : schemas) {
                xsds.add((Object)schema.getAttribute("location"));
            }
            collectionDef.getPropertyValues().addPropertyValue("xsds", (Object)xsds);
            String collectionName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)collectionDef);
            wsdlBuilder.addPropertyReference("schemaCollection", collectionName);
        } else {
            if (schemas.size() > 1) {
                throw new IllegalArgumentException("Multiple <xsd/> elements requires Commons XMLSchema.Please put Commons XMLSchema on the classpath.");
            }
            RootBeanDefinition schemaDef = this.createBeanDefinition(SimpleXsdSchema.class, source);
            Element schema = (Element)schemas.iterator().next();
            schemaDef.getPropertyValues().addPropertyValue("xsd", (Object)schema.getAttribute("location"));
            String schemaName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)schemaDef);
            wsdlBuilder.addPropertyReference("schema", schemaName);
        }
        return wsdlBuilder.getBeanDefinition();
    }

    private void addProperty(Element element, BeanDefinitionBuilder builder, String propertyName) {
        String propertyValue = element.getAttribute(propertyName);
        if (StringUtils.hasText((String)propertyValue)) {
            builder.addPropertyValue(propertyName, (Object)propertyValue);
        }
    }

    private RootBeanDefinition createBeanDefinition(Class<?> beanClass, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
        beanDefinition.setSource(source);
        beanDefinition.setRole(2);
        return beanDefinition;
    }
}

