/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.wsdl.wsdl11.Wsdl4jDefinition;
import org.springframework.ws.wsdl.wsdl11.provider.BindingsProvider;
import org.springframework.ws.wsdl.wsdl11.provider.ImportsProvider;
import org.springframework.ws.wsdl.wsdl11.provider.MessagesProvider;
import org.springframework.ws.wsdl.wsdl11.provider.PortTypesProvider;
import org.springframework.ws.wsdl.wsdl11.provider.ServicesProvider;
import org.springframework.ws.wsdl.wsdl11.provider.TypesProvider;

public class ProviderBasedWsdl4jDefinition
extends Wsdl4jDefinition
implements InitializingBean {
    public static final String TARGET_NAMESPACE_PREFIX = "tns";
    private ImportsProvider importsProvider;
    private TypesProvider typesProvider;
    private MessagesProvider messagesProvider;
    private PortTypesProvider portTypesProvider;
    private BindingsProvider bindingsProvider;
    private ServicesProvider servicesProvider;
    private String targetNamespace;

    public ImportsProvider getImportsProvider() {
        return this.importsProvider;
    }

    public void setImportsProvider(ImportsProvider importsProvider) {
        this.importsProvider = importsProvider;
    }

    public TypesProvider getTypesProvider() {
        return this.typesProvider;
    }

    public void setTypesProvider(TypesProvider typesProvider) {
        this.typesProvider = typesProvider;
    }

    public MessagesProvider getMessagesProvider() {
        return this.messagesProvider;
    }

    public void setMessagesProvider(MessagesProvider messagesProvider) {
        this.messagesProvider = messagesProvider;
    }

    public PortTypesProvider getPortTypesProvider() {
        return this.portTypesProvider;
    }

    public void setPortTypesProvider(PortTypesProvider portTypesProvider) {
        this.portTypesProvider = portTypesProvider;
    }

    public BindingsProvider getBindingsProvider() {
        return this.bindingsProvider;
    }

    public void setBindingsProvider(BindingsProvider bindingsProvider) {
        this.bindingsProvider = bindingsProvider;
    }

    public ServicesProvider getServicesProvider() {
        return this.servicesProvider;
    }

    public void setServicesProvider(ServicesProvider servicesProvider) {
        this.servicesProvider = servicesProvider;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void afterPropertiesSet() throws WSDLException {
        Assert.notNull((Object)this.getTargetNamespace(), (String)"'targetNamespace' is required");
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        Definition definition = wsdlFactory.newDefinition();
        definition.setTargetNamespace(this.getTargetNamespace());
        definition.addNamespace(TARGET_NAMESPACE_PREFIX, this.getTargetNamespace());
        if (this.importsProvider != null) {
            this.importsProvider.addImports(definition);
        }
        if (this.typesProvider != null) {
            this.typesProvider.addTypes(definition);
        }
        if (this.messagesProvider != null) {
            this.messagesProvider.addMessages(definition);
        }
        if (this.portTypesProvider != null) {
            this.portTypesProvider.addPortTypes(definition);
        }
        if (this.bindingsProvider != null) {
            this.bindingsProvider.addBindings(definition);
        }
        if (this.servicesProvider != null) {
            this.servicesProvider.addServices(definition);
        }
        this.setDefinition(definition);
    }
}

