const _apiUri = '/api/database/user-infr/pswd';
const columns = [
    'id', 'old_pwd', 'pwd', 'check-pwd'
];
const textArr = [
    'ID', '기존 비밀번호', '신규 비밀번호', '신규 비밀번호 확인',
];

const inputMap = new Map();
$(()=>{
    for (let idx in columns) {
        let column = columns[idx];
        let box = $('.' + column).dxTextBox({
            stylingMode: 'outlined',
            width: 220,
            height: 27,
        }).dxTextBox('instance');

        if(column !== 'id') {
            box.option('placeholder', textArr[idx]);
            box.option('mode', 'password');
        }
        inputMap.set(column, new Map());
        inputMap.get(column).set('box', box);
        inputMap.get(column).set('text', textArr[idx]);
        inputMap.get(column).get('box').on('keyDown', ()=>{
            $('.' + column + '-text').css('display', 'none');
        })
    }
    

    //ID로 대체
    setValue(inputMap.get('id').get('box'), window.opener.$userId);
    inputMap.get('id').get('box').option('readOnly', true);

    
    creatBtn($('.save-btn'), 'save', '저장', '저장', 'outlined', changePwd);
    creatBtn($('.cancel-btn'), 'close', '취소', '취소', 'outlined', ()=>{window.close()});
    
})

function changePwd(ev){
    let data = [];
    let cnt = 0;
    inputMap.forEach((obj, key)=>{
        if (nullChecker(getValue(obj.get('box'))) === '') {
            $('.' + key + '-text').css('display', 'flex');
            $('.' + key + '-null').css('display', 'block');
            $('.' + key + '-error').css('display', 'none');
            obj.get('box').focus();
            cnt++;
        }
    });
    
    if (cnt > 0) return;

    getData('/api/database/user-infr/' + encodeURIComponent(getValue(inputMap.get('id').get('box'))), data);
    if (data[0]){
        if (getValue(inputMap.get('old_pwd').get('box')) === getValue(inputMap.get('pwd').get('box'))) {
            $('.pwd-text').css('display', 'flex');
            $('.pwd-null').css('display', 'none');
            $('.pwd-error').css('display', 'block');
            inputMap.get('pwd').get('box').focus();
        }
        else if (getValue(inputMap.get('old_pwd').get('box')) === data[0].pwd){
            if (getValue(inputMap.get('pwd').get('box')) === getValue(inputMap.get('check-pwd').get('box'))){
                let param = {
                    old_pwd: getValue(inputMap.get('old_pwd').get('box')),
                    pwd    : getValue(inputMap.get('pwd').get('box')),
                }
                let result = putUpdate(_apiUri + '/' + encodeURIComponent(getValue(inputMap.get('id').get('box'))), param);
                if (result > 0) {
                   $('.bl').css('display', 'flex');
                   setValue(inputMap.get('old_pwd').get('box'), null);
                   setValue(inputMap.get('pwd').get('box'), null);
                   setValue(inputMap.get('check-pwd').get('box'), null);
                   let timeOut = setTimeout(() => {
                        $('.bl').css('display', 'none');
                        clearTimeout(timeOut);
                   }, 5000);
                }
            }
            else {
                $('.check-pwd-text').css('display', 'flex');
                $('.check-pwd-null').css('display', 'none');
                $('.check-pwd-error').css('display', 'block');
                inputMap.get('check-pwd').get('box').focus();
            }
        }
        else {
            $('.old_pwd-text').css('display', 'flex');
            $('.old_pwd-null').css('display', 'none');
            $('.old_pwd-error').css('display', 'block');
            inputMap.get('old_pwd').get('box').focus();
        }
    }
}