let dataColumns = [
    "id",
    "levl",
    "sect_lngt",
    "f_node_id",
    "f_node_nm",
    "t_node_id",
    "t_node_nm",
]
const _textMap   = new Map();
let _sectGradCd = null;
let _listTable  = null;
let url = new URL(document.location);
let _type = url.searchParams.get('type');
const _apiUri = '/api/database/cmtr-grad-clsf/list';
$(() => {
    
    //소통 등급 리스트 
    _listTable = $(".list").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['sect_grad_cd', 'cmtr_grad_cd'],
        selection: {
           mode : 'single',
        },
        scrolling: {
            mode : 'standard',
        },
        sorting : {
            showSortIndexes : false,
            mode:'none',
        },
        columns:[
            {   
                dataField    : "cmtr_grad_cd",
                caption      : "코드",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "cmtr_grad_desc",
                caption      : "명칭",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
                cellTemplate(c,e){
                    c.css('text-align','left');
                    c.text(e.displayValue)
                }
            },
            {   
                dataField    : "lwst_trvl_sped",
                caption      : "속도(Low)",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
            {
                dataField    : "hghs_trvl_sped",
                caption      : "속도(High)",
                alignment    : "center",
                cssClass     : 'padding-ctrl',
            },
        ],
    }).dxDataGrid("instance");

    dataColumns.forEach( (column) => {
        let textBox = $('.' + column).dxTextBox({
            value: null,
            stylingMode : "outlined",
            height      : 23,
            readOnly    : true,
        }).dxTextBox('instance');

        _textMap.set(column, textBox);
    });

    _sectGradCd = $('.sect_grad_cd').dxSelectBox({
        dataSource: [],
        valueExpr: 'sect_grad_cd',
        displayExpr: 'sect_grad_desc',
        stylingMode: "outlined",
        height: 30,
        width : 302,
        onItemClick(e){
            let dataSource = [];
            getData(_apiUri + '/' + encodeURIComponent(e.itemData.sect_grad_cd), dataSource);
            _listTable.option('dataSource', dataSource[0]);
        }
    }).dxSelectBox('instance');


    creatBtn($('.apply-btn'), 'check', '등급적용', '등급적용', 'outlined', sectGradApply);
    fetchBaseData();
});

function fetchBaseData(){
    let dataArr = window.opener.getListData();
    if(dataArr[0]){
        dataColumns.map((item)=>{
            setValue(_textMap.get(item), dataArr[0][item]);
        })
    };

    _sectGradCd.option('dataSource', dataArr[1]);
    _sectGradCd.option('value', dataArr[0].sect_grad_cd);
    let dataSource = [];

    getData(_apiUri + '/' + encodeURIComponent(dataArr[0].sect_grad_cd), dataSource);
    _listTable.option('dataSource', dataSource[0]);
}
function sectGradApply(){
 
    confirmMessage("소통등급의 변경은 소통정보에 큰 영향을 미칩니다. 계속하시겠습니까?<br>[주의] - 반드시 정보를 확인후 진행하세요!!!!!").done((yes)=>{
        if (yes) {
            const sectGradCd = getValue(_sectGradCd);
            let result = putUpdate('/api/database/' + encodeURIComponent(_type) + '/sect-grad/' + encodeURIComponent(getValue(_textMap.get('id'))), {sect_grad_cd : sectGradCd});

            if(result > 0){
                alertConfirm("소통정보 등급 구분을 적용 하였습니다.");
                window.opener.updateListData(sectGradCd);
                return false;
            }
        }
    })
  
} 