$(() => {
    let selectData;
    let selectListData = [];
    const _trafficMap  = window.opener.getTrafficMap();
    const _linkData    = _trafficMap.get('link');
    if(_linkData.length > 0){
        _linkData.map((item, idx)=>{
            selectListData.push({...item});
            if(item.f_node_id && item.from_node)selectListData[idx].from_node_desc = '[' + item.f_node_id + '] ' + item.from_node
            if(item.t_node_id && item.to_node)selectListData[idx].to_node_desc = '[' + item.t_node_id + '] ' + item.to_node
        })
    }

    $('.select-list-table')
        .width('100%')
        .height('100%')
        .dxDataGrid({
            dataSource              : selectListData,
            allowColumnReordering   : true,
            showColumnLines         : true,
            allowColumnResizing     : true,
            showBorders             : true,
            rowAlternationEnabled   : true,
            columnAutoWidth         : true,
            focusedRowEnabled       : true,
            keyExpr                 : 'link_id',
            selection: {
                mode: 'single',
            },
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            scrolling: {
                mode: 'virtual',
            },
            grouping: {
                autoExpandAll: true,
            },
            groupPanel: {
                visible: true,
                emptyPanelText: '그룹 지을 항목을 여기에 끌어다 놓으세요',
            },
            columns: [
                {
                    dataField : 'link_id',
                    caption   : 'ID',
                    alignment : 'center',
                    width     : 100,
                    sortIndex : 0,
                    sortOrder : 'asc',
                    dataType  : 'string',
                },
                {
                    dataField : 'from_node_desc',
                    caption   : '시작 노드',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },
                {
                    dataField : 'to_node_desc',
                    caption   : '종료 노드',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },
                {
                    dataField : 'link_leng',
                    caption   : '길이',
                    alignment : 'center',
                },
                {
                    dataField : 'road_name',
                    caption   : '도로명',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },
                {
                    dataField : 'road_rank_desc',
                    caption   : '도로 등급',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },
                {
                    dataField : 'road_type_desc',
                    caption   : '도로 유형',
                    alignment : 'center',
                    cellTemplate(c, e) {
                        c.css('text-align','left');
                        return c.text(e.displayValue);
                    },
                },
                {
                    dataField : 'lanes',
                    caption   : '차로수',
                    alignment : 'center',
                },
                {
                    dataField : 'max_spd',
                    caption   : '최고제한속도',
                    alignment : 'center',
                },
            ],
            onRowDblClick(e){
                let str = '[' + e.data.link_id + '] ' + e.data.from_node + ' > ' + e.data.to_node;
                window.opener.$('.prcd_link_id').dxTextBox('instance').option('value', str);
                window.opener.$('.prcd_x_crdn').dxTextBox('instance').option('value', e.data.from_x_crdn);
                window.opener.$('.prcd_y_crdn').dxTextBox('instance').option('value', e.data.from_y_crdn);
                window.close();
            },
            onSelectionChanged(e) {
                selectData = e.selectedRowsData[0];
            },
        })
        .dxDataGrid('instance');

    $('.select-button').dxButton({
        stylingMode : 'outlined',
        width       : '100px',
        icon        : 'check',
        text        : '선택',
        onClick() {
            if (selectData === undefined) {
                alertWarning('선택된 데이터가 없습니다.');
            } else {
                let str ='[' + selectData.link_id + '] ' + selectData.from_node + ' > ' + selectData.to_node;
                window.opener.$('.prcd_link_id').dxTextBox('instance').option('value', str);
                window.opener.$('.prcd_x_crdn').dxTextBox('instance').option('value', e.data.from_x_crdn);
                window.opener.$('.prcd_y_crdn').dxTextBox('instance').option('value', e.data.from_y_crdn);
                window.close();
            }
        },
    });

});

