let unitSystSttsHsData  = [];
let unitSystSttsHsTable = null;
let searchBtn           = null;
let unitSystSttsHsUri   = '/api/history/unit-syst-stts-hs';
let searchDateBox       = null;
let procSelectBox       = null;
let startDate           = new Date();
let procData            = [];
let selectlist          = [];
const _pageName           = '프로세스 상태이력';

$(()=>{

    //데이트 박스
    searchDateBox = $(".search-date").dxDateBox({
        type                : 'date',
        value               : startDate,
        width               : '250px',
        height              : '30px',
        stylingMode         :'outlined',
        displayFormat       : 'yyyy-MM-dd',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
    }).dxDateBox("instance");

    procSelectBox = $(".proc-select").dxSelectBox({
        width       : '250px',
        height      : '30px',
        stylingMode : 'outlined',
        displayExpr : 'syst_desc',
        valueExpr   : 'syst_id',
    }).dxSelectBox("instance");
    

    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        fontSize:'16px',
        width: '80px',
        onClick(){
            let SYST_ID = getValue(procSelectBox);
            if( nullChecker( searchDateBox.option( "value" ) ) === "") {
                alertWarning('검색 일자가 없습니다.', null, searchDateBox);
                return false;
            }
            
            let CRTN_DT = dateFormmater(new Date(searchDateBox.option("value"))); 
            let updateData = {
                CRTN_DT: CRTN_DT,
                SYST_ID: SYST_ID,
            }
            
            unitSystSttsHsData = [];
            getDataAsync(unitSystSttsHsUri, (jsonData)=>{
                unitSystSttsHsData = jsonData;
                unitSystSttsHsData.map((item)=>{
                    if (item.crtn_dt) {
                        item.crtn_dt = getParseDateTime(item.crtn_dt);
                    }
                    else {
                        item.crtn_dt = "-"
                    }
                })
                unitSystSttsHsTable.option("dataSource", unitSystSttsHsData);
            }, null, updateData);
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    //프로세스 상태 이력 테이블
    unitSystSttsHsTable = $(".unit-syst-stts-hs-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true, 
        keyExpr                 : ['crtn_idx', 'hhmm'],
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
           mode: 'single',
        },
       
        headerFilter: {
            visible: true,
        },
        grouping: {
            autoExpandAll: true,
        },
        scrolling: {
            mode: 'standard',
        },
        paging:{
            pageSize: 1000,
        },
        groupPanel:{
            visible: true,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        onExporting(e){
            let name = getValue(procSelectBox);
            const dataSource = procSelectBox.option('dataSource');
            const idx = dataSource.findIndex((obj)=>obj.syst_id === name);
            name = dataSource[idx].syst_nm;
            gridExcellExporting(e, _pageName + ' - ' + name);
        },
        columns:[
            {   
                dataField:"crtn_idx",
                caption:"순번",
                alignment:"center",
                allowEditing: false,
                sortIndex: 0, 
                sortOrder: "asc",
            },
            {
                dataField:"hhmm",
                caption:"기준 시각",
                alignment:"center",
            },
            {
                dataField:"crtn_dt",
                caption:"등록시각",
                alignment:"center",
            },
            {
                dataField:"syst_stts_desc",
                caption:"상태",
                alignment:"center",
            },
            
        ],
    }).dxDataGrid("instance");
    fetchComboData();
    
})

function fetchComboData() {
    getDataAsync('/api/history/unit-syst-stts-hs/type', recvComboData);
}

function recvComboData(jsonData) {
    procData = jsonData;
    procSelectBox.option('dataSource', procData);
    if (procData.length > 0) {
        setValue(procSelectBox, procData[0].syst_id);
    }

}