
//공통 uri
let commouUri            = '/api/statistics/atrd';
const _pageName          = '간선도로 통계';
let tabs                 = null;

//차트 관련
let dailySeries          = [];
let timeSeries           = [];
let timeX                = [];
let dailyX               = [];
let chartTypeSelect      = null;

//시간대별 관련
let timeTable            = null;
let timeColumns          = [];
let timeDate             = null;
let timeBtn              = null;
let timeTableData        = [];
let timeChart            = null;
let timeCheckArr         = [];
let lgndAllBtn           = null;
let lgndRevsBtn          = null;
let lgndElmtBtn          = null;
let lgndBtnArr           = [];
let timeSelectedRow      = null;

//일별 관련
let dailyColumns         = [];
let dailyTable           = null;
let dailyMonth           = null;
let dailyCheckArr        = [];
let strtTime             = null;
let endTime              = null; 
let dailyBtn             = null;
let dailyTableData       = [];
let dailySelectedRow     = null;
let dailyChart             = null;

//모달 관련
let modal                = null;
let modalcontentArr      = [];
let colorModalContentArr = [];
let colorBox             = null;
let modalText            = null;
let modalCheck           = null;
let modalChartType       = null;
let modalSaveBtn         = null;

//범례 버튼 array
lgndBtnArr = [
    //전체 버튼
    lgndAllBtn  = {
        box   : null,
        text  : '전체',
        class : 'lgnd-all-btn',
    },
    //반전 버튼
    lgndRevsBtn = {
        box  : null,
        text : '반전',
        class : 'lgnd-revs-btn',
    },
    //속성 버튼
    lgndElmtBtn = {
        box  : null,
        text : '속성',
        class : 'lgnd-elmt-btn',
    },
];

//모달 내용 array
modalcontentArr = [
    {
        title : '차트 제목',
        class : 'modal-text',
    },
    {
        title : '활성여부',
        class : 'modal-check',
    },
    {
        title : '차트색상',
        class : 'modal-color',
    },
    {
        title : '차트유형',
        class : 'modal-chart-type',
    }
]

//컬러 모달 색상 어레이
colorModalContentArr = [
    {
        line  : 1,
        color : [
            '255,128,128',
            '255,255,128',
            '128,255,128',
            '0,255,128',
            '128,255,255',
            '0,128,255',
            '255,128,192',
            '255,128,255',
        ]
    },
    {
        line  : 2,
        color : [
            '255,0,0',
            '255,255,0',
            '128,255,0',
            '0,255,64',
            '0,255,255',
            '0,128,192',
            '128,128,192',
            '255,0,255',
        ]
    },
    {
        line  : 3,
        color : [
            '128,64,64',
            '255,128,64',
            '0,255,0',
            '0,128,128',
            '0,64,128',
            '128,128,255',
            '128,0,64',
            '255,0,128',
        ]
    },
    {
        line  : 4,
        color : [
            '128,0,0',
            '255,128,0',
            '0,128,0',
            '0,128,64',
            '0,0,255',
            '0,0,160',
            '128,0,128',
            '128,0,255',
        ]
    },
    {
        line  : 5,
        color : [
            '64,0,0',
            '128,64,0',
            '0,64,0',
            '0,64,64',
            '0,0,128',
            '0,0,64',
            '64,0,64',
            '64,0,128',
        ]
    },
    {
        line  : 6,
        color : [
            '0,0,0',
            '128,128,0',
            '128,128,64',
            '128,128,128',
            '64,128,128',
            '192,192,192',
            '64,0,64',
            '255,255,255',
        ]
    },
]

//모달
modal = $('<div class="modal-background"></div>')
modal.append(
  $(`<div class="modal-screen b0">
        <div class="color modal-title">
            <div>차트 표출속성 설정</div>
            <span style="margin-left: auto;margin-right: 10px;">
                <div class="modal-cancle"></div>
            </span>
        </div>
        <div class="modal-content">
        </div>
        <div class="modal-button b1">
            <div>
                <div class="modal-save-Btn"></div>
            </div>
        </div>
    </div>`)
);

//모달 내용 추가
for (key in modalcontentArr) {
    $(modal).children().eq(0).children().eq(1).append(
        $(`<div class='content-size'>
            <div>${modalcontentArr[key].title}</div>
            <div>
                <div class=${modalcontentArr[key].class}></div>
            </div>
        </div>`)
    )
}

//컬러 모달
let colorModal = $(`<div class="color-modal-background">
                        <div class="color-modal b0">
                            <div class="modal-title color b2">
                                <div>색</div>
                                <span style="margin-left: auto;margin-right: 10px;">
                                    <div class="color-modal-cancle"></div>
                                </span>
                            </div>
                            <div class='modal-content'>
                                <div style="width:230px; height:20px">기본 색(B):</div>
                            </div>
                            <div class="modal-button b1">
                                <div>
                                    <div class="color-modal-save-Btn"></div>
                                </div>
                                <div>
                                    <div class="color-modal-cancle-Btn"></div>
                                </div>
                            </div>
                        </div>
                    </div>`)
//컬러 모달 내용 추가
for(idx in colorModalContentArr){
    let div = $('<div class="color-modal-content">')
    for(idx2 in colorModalContentArr[idx].color){
        let colorDiv = null;
        colorDiv = $(`<div class='${colorModalContentArr[idx].line + idx2}' style="padding:10px; background-color:rgb(${colorModalContentArr[idx].color[idx2]});"></div>`)
        div.append(colorDiv)

        $(colorDiv).on('click', function(){
            colorBox.option('value', $(this).css('background-color'))
        })
    }
    $(colorModal).children().eq(0).children().eq(1).append(div)
}

//컬러 설정 설정 div 추가
$(colorModal).children().eq(0).children().eq(1).append($(`<div>
    <div>사용자 지정 색(C)</div>
    <div>
        <div class="select-color"></div>
    </div>
</div`))

//1~23시 까지 컬럼 세팅
for(let ii = 0; ii <= 23; ii++){
    if( ii < 10 ){
        timeColumns.push( {
            dataField    : "c0" + ii,
            caption      : "0" + ii + "시",
            alignment    : "center",
            cssClass     : 'padding-ctrl',
            allowSorting : false,
        })
        timeX.push('0'+ii);
        continue;
    }
    timeColumns.push( {
        dataField    : "c" + ii,
        caption      : ii + "시",
        alignment    : "center",
        cssClass     : 'padding-ctrl',
        allowSorting : false,
    })

    timeX.push(ii.toString());
}
//1~31일 까지 컬럼 세팅
for(let ii = 1; ii <= 31; ii++){
    if( ii < 10 ){
        dailyColumns.push({
            dataField    : "c0" + ii,
            caption      :  ii + '일',
            alignment    : "center",
            cssClass     : 'padding-ctrl',
            allowSorting : false,
        })
        dailyX.push('0'+ii);
        continue;
    }
    dailyColumns.push({
        dataField    : "c" + ii,
        caption      :  ii  + '일',
        alignment    : "center",
        cssClass     : 'padding-ctrl',
        allowSorting : false,
    })
    dailyX.push(ii.toString());
}


$(()=>{

    //모달 추가 및 가리기
    $('body').append(modal, colorModal);
    $(".modal-background").css("display","none");
    $(".color-modal-background").css("display","none");

    
    //======================모달=================================
    //모달 취소 버튼
    $(".modal-cancle").dxButton({
        stylingMode : 'text',
        icon        : 'close',
        onClick(){
            $(".modal-background").css("display",'none');
        },
    }).dxButton('instance');

     //모달 색상 클릭시 설정 컬러 변경 이벤트
     $(".modal-color").on('click', function(){
        $(".color-modal-background").css('display','flex')
        colorBox.option('value', $(this).css('background-color'))
    })

    //모달 적용 버튼
    modalSaveBtn = $(".modal-save-Btn").dxButton({
        stylingMode : 'outlined',
        icon        : 'save',
        text        : '적용',
    }).dxButton('instance');

    //모달 차트 타입 셀렉트 박스
    modalChartType = $(".modal-chart-type").dxSelectBox({
        items       : ['line','area','column'],
        stylingMode : 'outlined',
        width       : 300,
        height      : 30,
        value       : 'line',
    }).dxSelectBox('instance');

    //모달 차트 내용
    modalText = $(".modal-text").dxTextBox({
        stylingMode       : 'outlined',
        width             : 300,
        height            : 30,
        readOnly          : true,
        focusStateEnabled : false,
    }).dxTextBox('instance');

    //모달 체크박스
    modalCheck = $(".modal-check").dxCheckBox({
        text : '활성(보이기)',
        name : null,
    }).dxCheckBox('instance')

    
    //=======================컬러 모달===========================
    //컬러 모달 취소 버튼
    $(".color-modal-cancle").dxButton({
        stylingMode : 'text',
        icon        : 'close',
        onClick(){
            $(".color-modal-background").css("display",'none');
        },
    }).dxButton('instance');

    //컬러 모달 확인 버튼
    $('.color-modal-save-Btn').dxButton({
        stylingMode : 'outlined',
        text        : '확인',
        onClick(){
            $(".modal-color").css( 'background-color', colorBox.option('value') );
            $(".color-modal-background").css("display","none");
        }
    }).dxButton('instance');
    
    //컬러 모달 취소 버튼
    $('.color-modal-cancle-Btn').dxButton({
        stylingMode : 'outlined',
        text        : '취소',
        onClick(){
            $(".color-modal-background").css('display','none');
        }
    }).dxButton('instance');

    //사용자 설정 컬러 박스
    colorBox = $(".select-color").dxColorBox({
        width            : 230,
        height           : 30,
        value            : '#f05b41',
        editAlphaChannel : true,
        stylingMode      : 'outlined'
    }).dxColorBox('instance')

   
    //범례 버튼 어레이 화면 세팅
    lgndBtnArr.map((item)=>{
        item.box = $( "." + item.class ).dxButton({
            text        : item.text,
            stylingMode : 'outlined',
            onClick(){
                if(item.method){
                    item.method()
                }
            }
        }).dxButton('instance');
    })

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance");

    //시간별 테이블 세팅
    timeTable = $('<div>').width('100%').height('calc(100% - 50px)').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'idx',
        noDataText              : '표출할 정보가 없습니다.',
        scrolling: {
            mode: 'virtual',
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        columns : [
            {
                caption   : "구분",
                alignment : "center",
                columns:[
                    {
                        dataField    : "atrd_nm",
                        caption      : "간선도로명",
                        allowSorting : false,
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        width        : 100,
                        cellTemplate(c, e) {
                            c.css('text-align', 'left');
                            c.text(e.displayValue);
                        }
                    },
                    {
                        dataField    : "drct_cd_desc",
                        caption      : "방향",
                        allowSorting : false,
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                        
                    },
                    {
                        dataField    : "sect_lngt",
                        caption      : "길이(m)",
                        allowSorting : false,
                        format       : "#,###,##0",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "avg_sped",
                        caption      : "평균",
                        allowSorting : false,
						format       : "#,###,##0",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                ]
            },   
            {
                caption   : "시간대별 통계(km/h)",
                alignment : "center",
                columns: timeColumns
                
            },   
           
        ],
        onExporting(e){
            gridExcellExporting(e, _pageName+ '_시간대별 통계');
        },
        
    })

    //일별 테이블 세팅
    dailyTable = $('<div>').width('100%').height('calc(100% - 50px)').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        showBorders             : true,
        allowColumnResizing     : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        keyExpr                 : 'idx',
        noDataText              : '표출할 정보가 없습니다.',
        selection: {
            mode: 'single',
        },
        scrolling: {
            mode: 'virtual',
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        columns : [
            {
                caption   : "구분",
                alignment : "center",
                columns:[
                    {
                        dataField    : "atrd_nm",
                        caption      : "간선도로명",
                        allowSorting : false,
                        alignment    : "center",
                        cssClass     : 'padding-ctrl',
                        width        :  100,
                        cellTemplate(c, e) {
                            c.css('text-align', 'left');
                            c.text(e.displayValue);
                        }
                    },
                    {
                        dataField    : "drct_cd_desc",
                        caption      : "방향",
                        allowSorting : false,
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                        
                    },
                    {
                        dataField    : "sect_lngt",
                        caption      : "길이(m)",
                        allowSorting : false,
                        format       : "#,###,##0",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                    {
                        dataField    : "avg_sped",
                        caption      : "평균",
                        allowSorting : false,
						format       : "#,###,##0",
                        cssClass     : 'padding-ctrl',
                        alignment    : "center",
                    },
                ]
            },   
            {
                caption   : "일별 통계(km/h)",
                alignment : "center",
                columns: dailyColumns
                
            },   
           
        ],
        onExporting(e){
            gridExcellExporting(e, _pageName+ '_일별 통계');
        },
        
    })

    //테이블 상단 datebox
    timeDate = $('<div>').dxDateBox({
        type                : 'date',
        value               : new Date().setDate(new Date().getDate()-1),
        width               : '160px',
        height              : '30px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy년 MM월 dd일',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월 00일',
    })

    //테이블 시간대별 조회 버튼
    timeBtn  = $('<div>').dxButton({
        text        : '조회',
        icon        : 'refresh',
        height      : '30px',
        width       : '80px',
        stylingMode : 'outlined',
        onClick(){
            let updateData = {};
            let STAT_DAY   = null;
            
            if ( !validationCheck( timeDate.dxDateBox('instance') )) return false;
            
            STAT_DAY = dateFormmater( new Date(timeDate.dxDateBox('instance').option('value')));
            
            updateData['STAT_DAY'] = STAT_DAY;
            timeChart = fetchChartInfo( timeChart, timeX, '/hourly', timeTable, timeTableData, 
                        updateData, createTimeChart, timeSeries, 
                        $('.time-legend-content'), 'time');
            
        }
    });

    dailyMonth = $('<div>').dxDateBox({
        type                : 'date',
        value               : new Date().setMonth(new Date().getMonth()-1),
        width               : '120px',
        height              : '30px',
        stylingMode         : 'outlined',
        displayFormat       : 'yyyy년 MM월',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000년 00월',
    })

    strtTime = $('<div>').dxDateBox({
        type                : 'time',
        value               : 1645110000000,
        width               : '110px',
        height              : '30px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH시 mm분',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00시 00분',
    })

    endTime = $('<div>').dxDateBox({
        type                : 'time',
        value               : 1645196399000,
        width               : '110px',
        height              : '30px',
        stylingMode         : 'outlined',
        displayFormat       : 'HH시 mm분',
        invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00시 00분',
    })

    //일별 통계 조회 버튼
    dailyBtn = $('<div>').dxButton({
        text        : '조회',
        icon        : 'refresh',
        height      : '30px',
        width       : '80px',
        stylingMode : 'outlined',
        onClick(){
            let FROM_HM    = null;
            let TO_HM      = null;
            let updateData = {};
            let STAT_DAY   = "";
            strtVal        = strtTime.dxDateBox('instance').option('value');
            endVal         = endTime.dxDateBox('instance').option('value');
            
            if ( !validationCheck( dailyMonth.dxDateBox('instance'), null, strtTime.dxDateBox('instance'), endTime.dxDateBox('instance') )) return false;
            
            STAT_DAY = dateFormmater( new Date(dailyMonth.dxDateBox('instance').option('value'))).substring(0,6);
            FROM_HM = timeSetup( strtVal ).substring( 0, 4 );
            TO_HM   = timeSetup( endVal ).substring( 0, 4 );

            if( FROM_HM > TO_HM ){
                alertWarning('검색 시작 시각이 검색 종료 시각보다 큽니다.', null, strtTime.dxDateBox('instance'));
                return false;
            };
            updateData['STAT_DAY'] = STAT_DAY;
            updateData['FROM_HM']  = FROM_HM;
            updateData['TO_HM']    = TO_HM;
            dailyChart = fetchChartInfo( dailyChart, dailyX, '/daily',  dailyTable, 
                        dailyTableData, updateData, createDayChart, 
                        dailySeries, $('.day-legend-content'), 'daily');
        }
    })

    //차트 유형 셀렉트
    chartTypeSelect = $('.chart-type-select').dxSelectBox({
        items       : ['line','area','column'],
        stylingMode : 'outlined',
        width       : 200,
        height      : 30,
        value       : 'line',
    }).dxSelectBox('instance');
    
    //tabs
    tabs = $('.tabs').width('100%').height('100%').dxTabPanel({
        dataSource:[
           {
               id          : 1,
               name        : '시간대별 통계',
               table       : timeTable,
               box         : [timeDate,timeBtn],
               type        : 'time',
               display     : [$('.time-legend-content'), $('#time-chart')],
               div         : $(`<div class="time-bar b2">
                                    <div>통계일</div>
                                    <div>
                                        <div class="time-date"></div>
                                    </div>
                                    <div>
                                        <div class="time-btn"></div>
                                    </div>
                                </div>`)
           },
           {
               id          : 2,
               name        : '일별 통계',
               table       : dailyTable,
               type        : 'day',
               box         : [dailyMonth, strtTime, endTime, dailyBtn],
               display     : [$('.day-legend-content'), $('#day-chart')],
               div         : $(`<div class="daily-bar b2">
                            <div>통계월</div>
                            <div>
                                <div class="daily-month"></div>
                            </div>
                            <div>
                                <div class="strt-time"></div>
                            </div>
                            <div> ~ </div>
                            <div>
                                <div class="end-time"></div>
                            </div>
                            <div>
                                <div class="daily-btn"></div>
                            </div>
                        </div>`)
           },
        ],
        selectIndex:0,
        loop:false,
        animationEnabled: true,
        swipeEnabled: false,
        itemTitleTemplate: function(e){
        return $('<div style="height:29px; line-height:29px;">'+e.name+'</div>');
        },
        itemTemplate: function(e,idx,c){
            
            for(idx in e.box){
                if(Number(idx) >= 2) {
                    e.div.children().eq(Number(idx)+2).children().eq(0).append(e.box[idx]);
                    continue
                }
                e.div.children().eq(Number(idx)+1).children().eq(0).append(e.box[idx]);
            }
            const tableContainer = $('<div class="table-container">').append(e.table);
            c.append(e.div, tableContainer);
            return c
        },
        onSelectionChanged(e){
            tabSelectionChanged(e);
        },
    }).dxTabPanel('instance');

    timeChart = createTimeChart(timeSeries);
    dailyChart = createDayChart(dailySeries);
    lgndAllBtn.box.on('click', ()=>lgndAllBtnClick('time'));
    lgndRevsBtn.box.on('click', ()=>lgndRevsBtnClick('time'));
})

function tabSelectionChanged(tabInfo){
    const selectObj = tabInfo.addedItems[0]
    const chart = selectObj.type === 'time' ? timeChart : dailyChart;
    const seires = selectObj.type === 'time' ? timeSeries : dailySeries;
    tabInfo.removedItems[0].display.map((item)=>{
        item.addClass('dp-none');
    });
    
    selectObj.display.map((item)=>{
        item.removeClass('dp-none');
    });

    lgndAllBtn.box.off('click');
    lgndRevsBtn.box.off('click');
    lgndAllBtn.box.on('click', ()=>lgndAllBtnClick(selectObj.type));
    lgndRevsBtn.box.on('click', ()=>lgndRevsBtnClick(selectObj.type));
    lgndElmtBtn.box.off('click');
    modalSaveBtn.off('click');
    chartTypeSelect.off('itemClick');
    if (seires.length <= 0) {
        setValue(chartTypeSelect, 'line');
    }
    else {
        setValue(chartTypeSelect, seires[0].type);
        chartTypeSelect.on('itemClick', (info)=>chartTypeSelectClick(info, seires, chart));
    }
    const childrenArr = selectObj.display[0].children();
    if (childrenArr.length > 0){
        for (let ii = 0; ii < childrenArr.length; ii++) {
            if (childrenArr.eq(ii).css('background-color') === 'rgb(45, 88, 151)') {
                const selectedRow = childrenArr.eq(ii);
                modalSaveBtn.on('click', ()=> modalSaveBtnClick(seires, chart, selectedRow));
                lgndElmtBtn.box.on('click', () => lgndElmtBtnClick(selectedRow, seires));
                break;
            }
        }
    }
}

function chartTypeSelectClick(info, series, chart){
    if (series.length > 0) {
        series.map((item)=>{
            item.type = info.itemData
        });
        
        chart.update({
            series:series
        })
    }
}

function modalSaveBtnClick(series, chart, selectedRow){
    series.map((item)=>{
        if(item.name === selectedRow.children().eq(2).text()){
            item.color = $(".modal-color").css('background-color');
            item.type = modalChartType.option('value');
        }
    })

    chart.update({
        series:series
    })

    selectedRow.children().eq(0).dxCheckBox('instance').option('value', modalCheck.option('value'));
    selectedRow.children().eq(1).css('background-color',$(".modal-color").css('background-color'));
    $(".modal-background").css("display","none"); 
}

function chartInit(table, type){
    table.dxDataGrid('instance').option('dataSource', []);
    if (type === 'time') {
        $('#time-chart').empty();
        timeSeries = [];
        $('.time-legend-content').empty();
    }
    else {
        $('#day-chart').empty();
        dailySeries = [];
        $('.day-legend-content').empty();
    }
}

function lgndAllBtnClick(type){
    const arr = type === 'time' ? timeCheckArr : dailyCheckArr;
    const series = type === 'time' ? timeSeries : dailySeries;
    const chart = type === 'time' ? timeChart : dailyChart;
    if (arr.length > 0 ) {
        arr.map((item)=>{
            item.off('valueChanged');
            item.option('value',true)
            item.on('valueChanged', (info)=>checkValueChanged(info, series, chart));
        });
        series.map((item)=>{
            item.visible = true;
        });
    
        chart.update({
            series: series,
        });
    };
}

function lgndRevsBtnClick(type) {
    const arr = type === 'time' ? timeCheckArr : dailyCheckArr;
    const series = type === 'time' ? timeSeries : dailySeries;
    const chart = type === 'time' ? timeChart : dailyChart;

    if (arr.length > 0 ){
        arr.map((item)=>{
            item.off('valueChanged');
            item.option('value', !getValue(item));
            const result = series.filter((obj)=>obj.name === item.option('name'));
            result[0].visible = getValue(item);
            item.on('valueChanged', (info)=>checkValueChanged(info, series, chart));
        });

        chart.update({
            series: series,
        });
    };
}

function lgndElmtBtnClick(selectedRow, series){
    if (selectedRow !== null) {
        //모달 띄우기
        $(".modal-background").css('display', 'flex' );
        
        //차트 설명
        modalText.option( 'value', selectedRow[0].innerText );
        
        //체크 되어있는지 확인
        const checkVal = selectedRow.children().eq(0)[0].ariaChecked === 'true';
        modalCheck.option( 'value', checkVal );
        
        //현재 차트 색상 적용
        $(".modal-color").css( 'background-color', selectedRow.children().eq(1).css('background-color') );
        
        //해당 차트 타입 적용
        series.map((item)=>{
            if(item.name === selectedRow[0].innerText)modalChartType.option('value', item.type);
        })
    }
}

function fetchChartInfo(chart, axisType, url, table, tableData, updateData, method, series, legend, type){
    tableData = [];
    series    = [];
    getDataAsync(commouUri + url, (jsonData) => {
        
        if (chart) {
            chartInit( table, type );
        }

        if (jsonData.length <= 0) {
            selResultMsg(jsonData);
            return 
        }

        const dataArr = jsonData;
        for (idx in dataArr) {
                let data = [];

                dataArr[idx]['idx'] = idx

                axisType.map((item)=>{
                    data.push(dataArr[idx]["c"+item])
                });

                series.push({
                    id           : idx,
                    type         : getValue(chartTypeSelect),
                    showInLegend : false,
                    name         : dataArr[idx]['atrd_nm'] + ":" + dataArr[idx]['drct_cd_desc'],
                    data         : data,
                });
                
        }

        chart = method(series);

        for (let ii = 0; ii < chart.series.length; ii++) {
            series[ii].color = chart.series[ii].color;
        }

        series.map((obj)=>{
            let div = $('<div class="flex-content">');
            div.html(`<div></div>
                    <div class="color-box" style="background-color: ${obj.color};"></div> 
                    <div>${obj.name}</div>`
            );

            div.on('dblclick', ()=> lgndElmtBtnClick(div, series));

            let box = $(div).children().eq(0).dxCheckBox({
                            name  : obj.name,
                            value : true,
                }).dxCheckBox('instance').on('valueChanged', (info)=>checkValueChanged(info, series, chart));
                
                legend.append(div);
                
                if (type === 'time') {
                    fetchLegendOption(timeCheckArr, $('.time-legend-content'), series, box, div, chart);
                    timeSeries = series;
                    timeChart  = chart;
                }
                else {
                    fetchLegendOption(dailyCheckArr, $('.day-legend-content'), series, box, div, chart);
                    dailySeries = series;
                    dailyChart  = chart;
                }
        });

        chartTypeSelect.off('itemClick');
        if (chart) {
            chartTypeSelect.on('itemClick', (info)=>chartTypeSelectClick(info, series, chart));
        }

        table.dxDataGrid('instance').option('dataSource', dataArr);
        selResultMsg(dataArr);
    }, null, updateData);
}

function checkValueChanged(info, series, chart){
    series.map((item) => {
        if (item.name === info.component.option('name')) {
             chart.get(item.id).setVisible(info.value); 
        }
    });
}

function fetchLegendOption(checkArr, container, series, box, div, chart){
    checkArr.push(box);
    div.on('click', function(){
        for (let ii  = 0; ii < container.children().length; ii++) {
            container.children().eq(ii).css('background-color','')
        }
        $(this).css('background-color', '#2d5897');
        lgndElmtBtn.box.off('click');
        lgndElmtBtn.box.on('click', () => lgndElmtBtnClick(div, series));
        modalSaveBtn.off('click');
        modalSaveBtn.on('click',()=> modalSaveBtnClick(series, chart, div));
    })
}

function createTimeChart(series){
    return Highcharts.chart('time-chart', {
        chart: {
            backgroundColor: '#3f3f4b',
            zoomType: 'x',
        },
        title: {
            text: '',
            style:{
                color: '#fff',
            }
        },
        xAxis: {
            categories: timeX,
            title: {
                text: '시간대별 통계(시)',
                style:{
                    color:'#fff',
                }
            },
            labels:{
                style:{
                    color:'#fff',
                }
            }
        },
    
        yAxis: {
            min: 0,
            title: '평균(km/h)',
            labels: {
                overflow: 'justify',
                style:{
                    color: '#fff',
                },
                format: '{value:,.0f}'
            },
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            },
            series: {
                lineWidth: 1
            }
        },
        tooltip: {
            formatter: function () {
                let date = dateFormmater(new Date(timeDate.dxDateBox('instance').option('value')));
                date = date.substring(0,4)+"-"+date.substring(4,6)+"-"+date.substring(6,8);
                return date +'<br>'+this.series.name +"<br>"+ this.x +
                    '시<br> <b>평균속도:' + this.y + 'km/h</b>';
            }
        },
        exporting : {
            enabled : false,
        },
        credits : {
            enabled : false
        },
        series : series
    });
}

function createDayChart(series){
    //일별 통계 차트
    return Highcharts.chart('day-chart', {
        chart: {
            backgroundColor: '#3f3f4b',
            zoomType: 'x',
        },
        title: {
            text: '',
            style:{
                color: '#fff',
            }
        },
        xAxis: {
            categories: dailyX,
            title: {
                text: '일별 통계(일)',
                style:{
                    color:'#fff',
                }
            },
            labels:{
                style:{
                    color:'#fff',
                }
            }
        },
       
        yAxis: {
            min: 0,
            title: '평균(km/h)',
            labels: {
                overflow: 'justify',
                style:{
                    color: '#fff',
                },
                format: '{value:,.0f}'
            },
        },
        plotOptions: {
            bar: {
                dataLabels: {
                    enabled: true
                }
            },
            series: {
                lineWidth: 1
            }
        },
        tooltip: {
            formatter: function () {
                let date = dateFormmater( new Date(dailyMonth.dxDateBox('instance').option('value'))).substring(0,6);
                date = date.substring(0,4)+"-"+date.substring(4,6);
                return date +'<br>'+this.series.name +"<br>"+ this.x +
                    '일<br> <b>평균속도:' + this.y + 'km/h</b>';
            }
        },
        exporting : {
            enabled : false,
        },
        credits : {
            enabled : false
        },
        series : series
    });
}