//데이터, 테이블, 상단 버튼
let _listTable            = null;
let searchBtn             = null;
let fltrCheck2            = null;
let fltrCheck1            = null;
let fltrLwstSped          = null;
let fltrHghsSped          = null;
let trafMinNum            = null;
let trafMaxNum            = null;
let fifoCheck             = null;
let fifoTable             = null;
let weightCheck           = null;
let weightTable           = null;
let adjsNoCheck           = null;
let adjsCheck             = null;
let adjsPttr              = null;
let adjsWghtAvrgPre3Cycl  = null;
let adjsWghtAvrgPre2Cycl  = null;
let adjsWghtAvrgPre1Cycl  = null;
let fftnPttrCheck         = null;
let loopNum               = null;
let smthNoCheck           = null;
let smthLimitCheck        = null;
let minSpedNum            = null;
let maxSpedNum            = null;
let smthFiftAvgCheck      = null;
let smthWghtAvrgPre2Cycl  = null;
let smthWghtAvrgPre1Cycl  = null;
let smthWghtAvrgPrst      = null;
let allActiveBtn          = null;
let selectActiveBtn       = null;
let fifoData              = [];
let fltrChecker           = [];
let fusnChecker           = [];
let adjsChecker           = [];
let smthChecker           = [];
let fusnData              = [];
let _selectedLink         = null;

const fusnUri             = '/api/database/clct-syst-stup';
const clctSystStupLinkUri = '/api/database/link';
getData(fusnUri, fusnData);

if(fusnData.length > 0){
    for ( let ii = 1; ii <= fusnData[0].length; ii++){
        if(fusnData[0].length === ii){
            fifoData.push({fusn_prrt:ii});
            fifoData.push({fusn_prrt:'사용안함'});
            break;
        } 
        
        fifoData.push({
            fusn_prrt:ii,
        })
    }
}


$(()=>{
    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            const selectedData = _listTable.getSelectedRowsData();
            if (selectedData.length > 0) {
                fetchListData(settingData(selectedData[0].link_id));
            }
            else {
                fetchListData();
            }
        }
    }).dxButton("instance")
    
    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton("instance")
    
    //전체 선택 버튼
    $(".all-sel-btn").dxButton({
        text:'전체선택',
        height:'30px',
        width: '100px',
        stylingMode:'outlined',
        onClick(){
            _listTable.selectAll();
        }
    }).dxButton("instance")

    //전체 해제 버튼
    $(".all-desel-btn").dxButton({
        text:'전체해제',
        height:'30px',
        width: '100px',
        stylingMode:'outlined',
        onClick(){
            _listTable.deselectAll();
        }
    }).dxButton("instance")

    //필터링 파라미터
    //사용안함 체크
    fltrCheck1 = $('.fltr-check1').dxCheckBox({
        value: false,
        text: '사용안함',
        onValueChanged(data) {
            fltrCheck2.option("value",!data.value);
        },
    }).dxCheckBox("instance");
    
    //범위값 체크
    fltrCheck2 = $('.fltr-check2').dxCheckBox({
        value: true,
        text: '범위값 사용',
        onValueChanged(data) {
            fltrCheck1.option("value",!data.value);
            trafMaxNum.option("disabled",!data.value);
            trafMinNum.option("disabled",!data.value);
            fltrHghsSped.option("disabled",!data.value);
            fltrLwstSped.option("disabled",!data.value);
            $(".fltr-box").toggleClass("toggleBackground");
            $(".fltr-box").toggleClass("dx-theme-accent-as-background-color");
        },
    }).dxCheckBox("instance");
    
    //교통량 최저 넘버
    trafMinNum = $(".traf-min").dxNumberBox({
        width           : '100px',
        height          : '25px',
        value           : 1,
        showSpinButtons : true,
        min             : 0,
        max             : 999999,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");

    //교통량 최대 넘버
    trafMaxNum = $(".traf-max").dxNumberBox({
        width           : '100px',
        height          : '25px',
        value           : 200,
        min             : 0,
        max             : 999999,
        showSpinButtons : true,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    
    //속도 최저 넘버
    fltrLwstSped = $(".sped-min").dxNumberBox({
        width           : '100px',
        height          : '25px',
        value           : 1,
        min             : 0,
        max             : 999,
        showSpinButtons : true,
        stylingMode:"outlined",
    }).dxNumberBox("instance");
    
    //속도 최대 넘버    
    fltrHghsSped = $(".sped-max").dxNumberBox({
        width           : '100px',
        height          : '25px',
        value           : 200,
        min             : 0,
        max             : 999,
        showSpinButtons : true,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");

    //퓨전 파라미터
    //우선순위 체크
    fifoCheck = $('.fifo-check').dxCheckBox({
        value: true,
        text: '우선순위',
        onValueChanged(data) {
            weightCheck.option("value",!data.value);
            fifoTable.option("disabled",!data.value);
            weightTable.option("disabled",data.value);
            $(".fifo-box").toggleClass("toggleBackground");
            $(".fifo-box").toggleClass("dx-theme-accent-as-background-color");
            
        },
    }).dxCheckBox("instance");
    
    //우선순위 테이블
    fifoTable = $(".fifo-table").width('100%').height("100%").dxDataGrid({
        dataSource              : fusnData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'clct_syst_cd',
        selection: {
            mode : 'single',
        },
        headerFilter: {
            visible : false,
        },
        editing:{
            mode: 'cell',
            allowUpdating: true,
        },
        scrolling: {
            mode : 'virtual',
        },
        columns:[
            {   
                dataField    : "clct_syst_expl",
                caption      : "수집원",
                alignment    : "center",
                allowEditing : false,
                // sortIndex    : 0,
                // sortOrder    : "asc",
                cssClass     : "noPadding",
                validationRules: [{ type: 'required' }],
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField :"fusn_prrt",
                caption   :"우선순위",
                alignment :"center",
                cssClass  : "noPadding",
                lookup    :{
                    dataSource:fifoData,
                    displayExpr:'fusn_prrt',
                    valueExpr:'fusn_prrt',
                },
                cellTemplate(c,e){
                    if (nullChecker(e.data.fusn_prrt) === "" ){
                        return c.text("사용안함")
                    }
                    return c.text(e.data.fusn_prrt);
                }
            },]
    }).dxDataGrid("instance");

    //가중치 체크
    weightCheck = $('.weight-check').dxCheckBox({
        value: false,
        text: '가중치',
        onValueChanged(data) {
            fifoCheck.option("value",!data.value);
            fifoTable.option("disabled",data.value);
            weightTable.option("disabled",!data.value);
            $(".weight-box").toggleClass("toggleBackground");
            $(".weight-box").toggleClass("dx-theme-accent-as-background-color");
        },
    }).dxCheckBox("instance");
    
    //가중치 테이블
    weightTable = $(".weight-table").width('100%').height("100%").dxDataGrid({
        dataSource              : fusnData[0],
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        disabled                : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'clct_syst_cd',
        headerFilter: {
            visible : false,
        },
        editing:{
            mode: 'cell',
            allowUpdating: true,
        },
        selection: {
            mode : 'single',
        },
        scrolling: {
            mode : 'virtual',
        },
        disabled : true,
        columns:[
            {   
                dataField    : "clct_syst_expl",
                caption      : "수집원",
                alignment    : "center",
                allowEditing : false,
                // sortIndex    : 0,
                // sortOrder    : "asc",
                cssClass     : "noPadding",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField    : "fusn_wght",
                caption      : "가중치",
                alignment    : "center",
                cssClass     : "noPadding",
                editorOptions:{
                    dataType        : "number",
                    showSpinButtons : true,
                    format          : '##0',
                    min             : 0,
                    max             : 100,
                },
                cellTemplate(c,e){
                    if(nullChecker(e.data.fusn_wght) === ""){
                        return c.text(10);
                    }
                    return c.text(e.data.fusn_wght);
                }
                
            },]
    }).dxDataGrid("instance");

    
    //보정 파라미터
    //체크 박스 꺼짐 방지
    $(".adjs-check").on('click',()=>{
        if(adjsCheck.option("value"))return false;
    });
    $(".adjs-no-check").on('click',()=>{
        if(adjsNoCheck.option("value"))return false;
    })
    $(".adjs-pttr").on('click',()=>{
        if(adjsPttr.option("value"))return false;
    })

    //3주기전 평균 넘버
    adjsWghtAvrgPre3Cycl = $(".thr-week-num").dxNumberBox({
        width           : '70px',
        height          : '25px',
        value           : 20,
        min             : 0,
        max             : 100,
        showSpinButtons : true,
        format          : '##0',
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    
    //2주기전 평균 넘버
    adjsWghtAvrgPre2Cycl = $(".two-week-num").dxNumberBox({
        width           : '70px',
        height          : '25px',
        value           : 30,
        min             : 0,
        max             : 100,
        showSpinButtons : true,
        format          : '##0',
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    
    //1주기전 평균 넘버
    adjsWghtAvrgPre1Cycl = $(".one-week-num").dxNumberBox({
        width           : '70px',
        height          : '25px',
        value           : 50,
        min             : 0,
        max             : 100,
        showSpinButtons : true,
        format          : '##0',
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    //단기 결측 판단 주기 넘버
    loopNum = $(".loop-num").dxNumberBox({
        width           : '70px',
        height          : '25px',
        value           : 3,
        min             : 0,
        max             : 99,
        showSpinButtons : true,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    
    //사용안함 체크
    adjsNoCheck = $(".adjs-no-check").dxCheckBox({
        value: false,
        text: '사용안함',
        onValueChanged(data) {
            if(data.value){
                adjsCheck.option("value",false)
                adjsPttr.option("value",false)
            }
        },
    }).dxCheckBox("instance");
    
    //단기(15분이동평균)/장기(패턴) 체크
    adjsCheck = $(".adjs-check").dxCheckBox({
        value: true,
        text: '단기(15분이동평균)/장기(패턴)',
        onValueChanged(data) {
            if(data.value){
                adjsNoCheck.option("value",false);
                adjsPttr   .option("value",false);
            }
            $(".adjs-box").toggleClass("dx-theme-accent-as-background-color");
            $(".adjs-box").toggleClass("toggleBackground");
            adjsWghtAvrgPre3Cycl    .option("disabled",!data.value);
            adjsWghtAvrgPre2Cycl    .option("disabled",!data.value);
            adjsWghtAvrgPre1Cycl    .option("disabled",!data.value);
            fftnPttrCheck .option("disabled",!data.value);
            loopNum       .option("disabled",!data.value);
        },
    }).dxCheckBox("instance");
    
    //패턴 적용 체크
    adjsPttr = $(".adjs-pttr").dxCheckBox({
        value: false,
        text: '패턴적용',
        onValueChanged(data) {
            if(data.value){
                adjsCheck.option("value",false)
                adjsNoCheck.option("value",false)
            }
        },
    }).dxCheckBox("instance");
    
    //15분 패턴 추가 적용 체크
    fftnPttrCheck = $(".fftn-pttr-check").dxCheckBox({
        value: false,
        text: '15분 패턴 추가적용(장기 결측시)',
        onValueChanged(data) {
        },
    }).dxCheckBox("instance");

    //평활화 파라미터
    //체크박스 꺼짐 방지
    $(".smth-fift-avg-check").on("click",()=>{
        if(smthFiftAvgCheck.option("value"))return false
    })
    $(".smth-no-check").on("click",()=>{
        if(smthNoCheck.option("value"))return false
    })
    $(".smth-limit-check").on("click",()=>{
        if(smthLimitCheck.option("value"))return false
    })

    //사용안함 체크
    smthNoCheck = $(".smth-no-check").dxCheckBox({
        stylingMode:'outlined',
        text:'사용안함',
        value: false,
        onValueChanged(data) {
            if(data.value){
                smthFiftAvgCheck.option("value",false);
                smthLimitCheck.option("value",false);
            }
        },
    }).dxCheckBox("instance");

    //편차제한 체크
    smthLimitCheck = $(".smth-limit-check").dxCheckBox({
        stylingMode:'outlined',
        text:'편차제한(최저-최대)',
        value: true,
        onValueChanged(data) {
            if(data.value){
                smthFiftAvgCheck.option("value",false);
                smthNoCheck.option("value",false);
            }
            $(".smth-sped-box").toggleClass("toggleBackground");
            $(".smth-sped-box").toggleClass("dx-theme-accent-as-background-color");
            minSpedNum.option("disabled",!data.value)
            maxSpedNum.option("disabled",!data.value)
            
        },
    }).dxCheckBox("instance");

    //15분 이동 평균 체크
    smthFiftAvgCheck = $(".smth-fift-avg-check").dxCheckBox({
        stylingMode:'outlined',
        text:'15분 이동평균(전체합=100)',
        value: false,
        onValueChanged(data) {
            if(data.value){
                smthLimitCheck.option("value",false);
                smthNoCheck.option("value",false);
            }
            $(".smth-avg-box").toggleClass("toggleBackground");
            $(".smth-avg-box").toggleClass("dx-theme-accent-as-background-color");
            smthWghtAvrgPre2Cycl.option("disabled",!data.value);
            smthWghtAvrgPre1Cycl.option("disabled",!data.value);
            smthWghtAvrgPrst.option("disabled",!data.value);
        },
    }).dxCheckBox("instance");

    //최저 속도 넘버
    minSpedNum = $(".min-sped-num").dxNumberBox({
        width           : '75px',
        height          : '25px',
        value           : 0.20,
        format          : '#0.##00',
        min             : 0.00,
        max             : 9.99,
        showSpinButtons : true,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    //최대 속도 넘버
    maxSpedNum = $(".max-sped-num").dxNumberBox({
        width           : '75px',
        height          : '25px',
        value           : 2.00,
        format          : '#0.##00',
        min             : 0.00,
        max             : 9.99,
        showSpinButtons : true,
        stylingMode     : "outlined",
    }).dxNumberBox("instance");
    
    //2주기 가중치 넘버
    smthWghtAvrgPre2Cycl = $(".two-week-weight-num").dxNumberBox({
        stylingMode     :'outlined',
        width           : '70px',
        height          : '25px',
        min             : 0,
        max             : 100,
        format          : '##0',
        showSpinButtons : true,
        disabled:true,
    }).dxNumberBox("instance");

    //1주기 가중치 넘버
    smthWghtAvrgPre1Cycl = $(".one-week-weight-num").dxNumberBox({
        stylingMode     :'outlined',
        width           : '70px',
        height          : '25px',
        min             : 0,
        max             : 100,
        format          : '##0',
        showSpinButtons : true,
        disabled:true,
    }).dxNumberBox("instance");

    //현재 가중치 넘버
    smthWghtAvrgPrst = $(".crnt-weight-num").dxNumberBox({
        stylingMode     :'outlined',
        width           : '70px',
        height          : '25px',
        min             : 0,
        max             : 100,
        format          : '##0',
        showSpinButtons : true,
        disabled:true,
    }).dxNumberBox("instance");

    allActiveBtn = $(".all-active-btn").dxButton({
        stylingMode :'outlined',
        icon        : 'check',
        text        :'전체구간 적용',
        disabled    : true,
        onClick(){
            let updateData = updateSettingData();
            if(updateData){
                confirmMessage("전체 구간에 대하여 파라미터 정보를 설정합니다.<br>전체 구간에 대하여 파라미터 정보를 적용하시겠습니까?").done((yes) => {
                    if (yes === true) {
                        getPostDataAsync("/api/database/link-prcs-para", (data)=>{
                            if (data) {
                                return alertConfirm("파라미터 정보를 설정하였습니다.");
                            }
                        }, updateData);
                        // let result = postInsertUpdate("/api/database/link-prcs-para", updateData)
                        // if(result > 0){
                        //     return alertConfirm("파라미터 정보를 설정하였습니다.");
                        // }
                    }
                });
            }
               
        }
    }).dxButton("instance");

    selectActiveBtn = $(".select-active-btn").dxButton({
        stylingMode:'outlined',
        icon : 'check',
        text:'선택구간 적용',
        disabled    : true,
        onClick(){
            let updateData = updateSettingData();
            if (updateData) {

                if(_listTable.getSelectedRowsData().length <= 0){
                    alertWarning("선택된 데이터가 없습니다. 파리미터 정보를 설정할 데이터를 선택해주세요");
                    return false;
                }
                
                confirmMessage("선택된 구간에 대하여 파라미터 정보를 설정합니다.<br>선택한 구간에 대하여 파라미터 정보를 적용하시겠습니까?").done((yes) => {
                    if (yes === true) {
                        let result = 0;
                        let updateId = [];
                        for(let ii = 0; ii < _listTable.getSelectedRowsData().length; ii ++){
                            updateId.push(_listTable.getSelectedRowsData()[ii].link_id)
                        }

                        result = postInsertUpdate("/api/database/link-prcs-para/" + encodeURIComponent(updateId), updateData);
                        if (result > 0) {
                            alertConfirm("파라미터 정보를 설정하였습니다.");
                            settingData(updateId[updateId.length - 1]);
                        }
                    }
                });

            }
        }
    }).dxButton("instance");
    
    fltrChecker   = [
        {
            check:fltrCheck1,
            data:"FMT0"
        },
        {
            check:fltrCheck2,
            data:"FMT1"
        }
    ]
    
    fusnChecker   = [
        {
            check:fifoCheck,
            data:"FST1",
        },
        {
            check:weightCheck,
            data:"FST2",
        }
    ]
    
    adjsChecker   = [
        {
            check:adjsNoCheck,
            data:"MCA0",
        },
        {
            check:adjsCheck,
            data:"MCA1",
        },
        {
            check:adjsPttr,
            data:"MCA2",
        },
    ]
    
    smthChecker   = [
        {
            check:smthNoCheck,
            data:"SMT0",
        },
        {
            check:smthLimitCheck,
            data:"SMT1",
        },
        {
            check:smthFiftAvgCheck,
            data:"SMT2",
        },
    ]
    
    //링크 관리 테이블
    _listTable = $(".clct-syst-stup-table").width('100%').height("100%").dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        focusedRowEnabled       : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : 'link_id',
        filterRow: {
            visible: true,
            applyFilter: "auto",
            showOperationChooser:false,
        },
        scrolling               : {
            mode : 'standard',
        },
        paging: {
            enabled: true,
            pageSize: 1000,
        },
        selection: {
            mode        : 'single',
        },
        headerFilter: {
            visible : true,
        },
        grouping: {
            autoExpandAll : true,
        },
        scrolling: {
            mode : 'virtual',
        },
        groupPanel:{
            visible         : true,
            emptyPanelText  : "그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        
        columns:[
            {   
                dataField    : "link_id",
                caption      : "링크 ID",
                alignment    : "center",
                dataType     : 'string',
                allowEditing : false,
                sortIndex    : 0, 
                sortOrder    : "asc",
                validationRules: [{ type: 'required' }],
            },
            {
                dataField:"from_node",
                caption:"시작노드",
                alignment:"center",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField:"to_node",
                caption:"종료노드",
                alignment:"center",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField:"link_leng",
                caption:"길이(m)",
                alignment:"center",
            },
            {
                dataField:"road_name",
                caption:"도로명",
                alignment:"center",
                cellTemplate(c,e){
                    let result = nullChecker(e.displayValue);
                    return  $('<div style="text-align: left;">'+result+'</div>')
                }
            },
            {
                dataField:"road_no",
                caption:"도로번호",
                alignment:"center",
            },
            {
                dataField:"road_type_desc",
                caption:"도로유형",
                alignment:"center",
                cellTemplate(c, e) {
                    c.css('text-align', 'left');
                    c.text(e.displayValue);
                    return c;
                }
            },
            {
                dataField:"lanes",
                caption:"차로수",
                alignment:"center",
            },
        ],
        onRowClick(e) {
            if ( _selectedLink !== e.data.link_id ) {
                _selectedLink = e.data.link_id;
                dsblOnBtn(allActiveBtn);
                dsblOnBtn(selectActiveBtn);
            }
        },
        onRowDblClick(e){
            if(nullChecker(e.data.link_id) !== ""){
                settingData(e.data.link_id);
            }
        }

    }).dxDataGrid("instance");
    
    fetchListData();
});

function fetchListData(method){
    getDataAsync(clctSystStupLinkUri, (jsonData)=>{ 
        _listTable.option('dataSource', jsonData);
        if(method) {
            method();
        }
    });
}

function settingData(id){
    let paramData = [];
        let stup      = [];
        let detl      = [];
        let systlist  = [];
        fifoData      = [];
        getData('/api/database/link-prcs-para/' + encodeURIComponent(id), paramData);
        stup          = paramData[0].stup;
        detl          = paramData[0].detl;
        systlist      = paramData[0].systlist;

        for ( let ii = 0; ii < fusnData[0].length; ii++ ) {
            fusnData[0][ii].fusn_wght = null;
            fusnData[0][ii].fusn_prrt = null;
            for( let jj = 0; jj < systlist.length; jj++ ){
                if(fusnData[0][ii].clct_syst_cd === systlist[jj].clct_syst_cd){
                    fusnData[0][ii].fusn_wght = systlist[jj].fusn_wght * 100
                    fusnData[0][ii].fusn_prrt = systlist[jj].fusn_prrt
                }
            }
        }

        weightTable.option('dataSource', fusnData[0]);
        fifoTable.option('dataSource', fusnData[0]);
        
        fltrChecker.map((item)=>{
            if(item.data === stup.fltr_mthd_cd) {
                return item.check.option("value",true)
            };
        });

        fusnChecker.map((item)=>{
            if(item.data === stup.fusn_mthd_cd){
                return item.check.option("value",true);
                
            } 
        });

        smthChecker.map((item)=>{
            if(item.data === stup.smth_mthd_cd){
                return item.check.option("value",true);
            }
        });

        adjsChecker.map((item)=>{
            if(item.data === stup.adjs_mthd_cd) {
                return item.check.option("value",true);
            }
        });

        if (detl) {
            adjsWghtAvrgPre3Cycl.option( "value", detl.adjs_wght_avrg_pre_3cycl * 100 );
            adjsWghtAvrgPre2Cycl.option( "value", detl.adjs_wght_avrg_pre_2cycl * 100 );
            adjsWghtAvrgPre1Cycl.option( "value", detl.adjs_wght_avrg_pre_1cycl * 100 );
            minSpedNum.option( "value", detl.smth_lwst_sped_fctr );
            maxSpedNum.option( "value", detl.smth_hghs_sped_fctr );
            smthWghtAvrgPre2Cycl.option( "value", detl.smth_wght_avrg_pre_2cycl * 100 );
            smthWghtAvrgPre1Cycl.option( "value", detl.smth_wght_avrg_pre_1cycl * 100 );
            smthWghtAvrgPrst.option( "value", detl.smth_wght_avrg_prst * 100 );
            fltrLwstSped.option( "value", detl.fltr_lwst_sped );
            fltrHghsSped.option( "value", detl.fltr_hghs_sped );
            trafMinNum.option( "value", detl.fltr_min_tfvl );
            trafMaxNum.option( "value", detl.fltr_max_tfvl );
            loopNum.option( "value", detl.adjs_shtr_miss_decs_cycl );
            let result = detl.adjs_15m_ptrn_aply_yn === 'Y';
            fftnPttrCheck.option( "value", result );
        }
        dsblOffBtn(allActiveBtn);
        dsblOffBtn(selectActiveBtn);
}

function updateSettingData(){
    let adjs_mthd_cd = null;
    let fltr_mthd_cd = null;
    let fusn_mthd_cd = null;
    let smth_mthd_cd = null;
    fifoTable.saveEditData();
    weightTable.saveEditData();

    //체크 값 데이터
    fltrChecker.map((item)=>{
        if (item.check.option("value")) return fltr_mthd_cd = item.data;
    });

    fusnChecker.map((item)=>{
        if(item.check.option("value")) return fusn_mthd_cd = item.data;
    });

    adjsChecker.map((item)=>{
        if(item.check.option("value")) return adjs_mthd_cd = item.data;
    });

    smthChecker.map((item)=>{
        if(item.check.option("value")) return smth_mthd_cd = item.data;
    });
    
    let fifoTableData   = fifoTable.option('dataSource');
    let weightTableData = weightTable.option('dataSource');

    let systlist        = [];
    let totWeight       = 0;
    let fusnTot         = 0;
    let dataPrrtTot     = 0;
    let adjsWghtAvrgTot = adjsWghtAvrgPre3Cycl.option( "value" )
                        + adjsWghtAvrgPre2Cycl.option( "value" )
                        + adjsWghtAvrgPre1Cycl.option( "value" );

    let smthWghtAvrgTot = smthWghtAvrgPre2Cycl.option( "value" )
                        + smthWghtAvrgPre1Cycl.option( "value" )
                        + smthWghtAvrgPrst.option( "value" );


    let cnt = 1;
    for ( let ii = 0; ii < fifoTableData.length; ii++ ) {
        let fusn_prrt = null;
        let fusn_wght = null;
        if (fusn_mthd_cd === 'FST1') {
            //사용안함 제외 syslist 데이터
            fusn_prrt = fifoTableData[ii].fusn_prrt;

            if (fusn_prrt === '사용안함' || nullChecker(fusn_prrt) === "") {
                continue;
            }
            else {
                dataPrrtTot += cnt++;
                fusnTot += fusn_prrt;
                fusn_wght = 0.1;
            }
        }
        else if(fusn_mthd_cd === 'FST2') {
            fusn_wght = weightTableData[ii].fusn_wght;
            fusn_prrt = ii + 1;
            if (fusn_wght) {
                totWeight += fusn_wght;
                fusn_wght = (fusn_wght / 100);
            }
        }
        systlist.push({
            clct_syst_cd : fifoTableData[ii].clct_syst_cd,
            fusn_prrt    : fusn_prrt,
            fusn_wght    : fusn_wght,
        });
    }

    //유효성 검사
    switch (true) {
        case fltr_mthd_cd === "FMT1" && validationText(trafMinNum):
            alertWarning("필터링 파라미터 - 범위값 사용<br>교통량 최저 범위를 입력하세요", null, trafMinNum);
            return false;
        case fltr_mthd_cd === "FMT1" && validationText(trafMaxNum):
            alertWarning("필터링 파라미터 - 범위값 사용<br>교통량 최대 범위를 입력하세요", null, trafMaxNum);
            return false;
        case fltr_mthd_cd === "FMT1" && getValue(trafMinNum) > getValue(trafMaxNum):
            alertWarning("필터링 파라미터 - 범위값 사용<br>최저 범위가 최대 범위 보다 큽니다.", null, trafMaxNum);
            return false;
        case fltr_mthd_cd === "FMT1" && validationText(fltrLwstSped):
            alertWarning("필터링 파라미터 - 범위값 사용<br>속도 최저 범위를 입력하세요", null, fltrLwstSped);
            return false;
        case fltr_mthd_cd === "FMT1" && validationText(fltrHghsSped):
            alertWarning("필터링 파라미터 - 범위값 사용<br>속도 최대 범위를 입력하세요.", null, fltrHghsSped);
            return false;
        case fltr_mthd_cd === "FMT1" && getValue(fltrLwstSped) > getValue(fltrHghsSped):
            alertWarning("필터링 파라미터 - 범위값 사용<br>속도 최저 범위가 최대 범위보다 작아야 합니다.", null, fltrHghsSped);
            return false;
        case (fusn_mthd_cd === "FST1" && dataPrrtTot === 0):
            alertWarning("퓨전 파라미터 - 우선순위<br>우선 순위가 지정되지 않았습니다.");
            return false;
        case fusn_mthd_cd === "FST1" && dataPrrtTot !== fusnTot:
            alertWarning("퓨전 파라미터 - 우선순위<br>우선 순위는 순서에 맞게 각자 다른값을 가져야 합니다.");
            return false;
        case fusn_mthd_cd === "FST2" && totWeight !== 100:
            alertWarning("퓨전 파라미터 - 가중치<br>가중치의 전체합은 100 이어야 합니다.");
            return false;
        case adjs_mthd_cd === "MCA1" && validationText(adjsWghtAvrgPre3Cycl):
            alertWarning("보정 파라미터 - 단기(15분이동평균)/장기(패턴)<br>3주기전 평균 가중치 값을 입력해주세요.", null, adjsWghtAvrgPre3Cycl);
            return false;
        case adjs_mthd_cd === "MCA1" && validationText(adjsWghtAvrgPre2Cycl):
            alertWarning("보정 파라미터 - 단기(15분이동평균)/장기(패턴)<br>2주기전 평균 가중치 값을 입력해주세요.", null, adjsWghtAvrgPre2Cycl);
            return false;
        case adjs_mthd_cd === "MCA1" && validationText(adjsWghtAvrgPre1Cycl):
            alertWarning("보정 파라미터 - 단기(15분이동평균)/장기(패턴)<br>1주기전 평균 가중치 값을 입력해주세요.", null, adjsWghtAvrgPre1Cycl)
            return false;
        case adjs_mthd_cd === "MCA1" && adjsWghtAvrgTot !== 100:
            alertWarning("보정 파라미터 - 단기(15분이동평균)/장기(패턴)<br>평균 가중치의 전체합은 100 이어야 합니다.", null, adjsWghtAvrgPre1Cycl);
            return false;
        case adjs_mthd_cd === "MCA1" && validationText(loopNum):
            alertWarning("보정 파라미터 - 단기(15분이동평균)/장기(패턴)<br>단기 결측 판단 주기 값을 입력해주세요.", null, loopNum);
            return false;
            
        case smth_mthd_cd === "SMT1" && validationText(minSpedNum):
            alertWarning("평활화 파라미터 - 편차제한(최저-최대)<br>최저속도계수 값을 입력해주세요.", null, minSpedNum);
            return false;
            
        case smth_mthd_cd === "SMT1" && validationText(maxSpedNum):
            alertWarning("평활화 파라미터 - 편차제한(최저-최대)<br>최대속도계수 값을 입력해주세요.", null, maxSpedNum);
            return false;
        case smth_mthd_cd === "SMT1" && getValue(minSpedNum) > getValue(maxSpedNum):
            alertWarning("평활화 파라미터 - 편차제한(최저-최대)<br>최저속도계수 값이 최대속도계수 값보다 작아야 합니다.", null, maxSpedNum);
            return false;
        case smth_mthd_cd === "SMT2" && validationText(smthWghtAvrgPre2Cycl):
            alertWarning("평활화 파라미터 - 15분 이동평균(전체합=100)<br>2주기전 가중치 평균 값을 입력해주세요.", null, smthWghtAvrgPre2Cycl);
            return false;
            
        case smth_mthd_cd === "SMT2" && validationText(smthWghtAvrgPre1Cycl):
            alertWarning("평활화 파라미터 - 15분 이동평균(전체합=100)<br>1주기전 가중치 평균 값을 입력해주세요.", null, smthWghtAvrgPre1Cycl);
            return false;
            
        case smth_mthd_cd === "SMT2" && validationText(smthWghtAvrgPrst):
            alertWarning("평활화 파라미터 - 15분 이동평균(전체합=100)<br>현재 가중치 평균 값을 입력해주세요.", null, smthWghtAvrgPrst);
            return false;
            
        case smth_mthd_cd === "SMT2" && smthWghtAvrgTot !== 100:
            alertWarning("평활화 파라미터 - 15분 이동평균(전체합=100)<br>분 이동평균값 가중치의 전체합은 100 이어야 합니다.", null, smthWghtAvrgPrst);
            return false;
            

    }

    let adjs_wght_avrg_pre_3cycl = adjsWghtAvrgPre3Cycl.option( "value" ) / 100;
    let adjs_wght_avrg_pre_2cycl = adjsWghtAvrgPre2Cycl.option( "value" ) / 100;
    let adjs_wght_avrg_pre_1cycl = adjsWghtAvrgPre1Cycl.option( "value" ) / 100;
    let smth_lwst_sped_fctr      = minSpedNum.option( "value" ).toFixed(2);
    let smth_hghs_sped_fctr      = maxSpedNum.option( "value" ).toFixed(2);
    let smth_wght_avrg_pre_2cycl = smthWghtAvrgPre2Cycl.option( "value" ) / 100;
    let smth_wght_avrg_pre_1cycl = smthWghtAvrgPre1Cycl.option( "value" ) / 100;
    let smth_wght_avrg_prst      = smthWghtAvrgPrst.option( "value" ) / 100;
    let fltr_lwst_sped           = fltrLwstSped.option( "value" );
    let fltr_hghs_sped           = fltrHghsSped.option( "value" );
    let fltr_min_tfvl            = trafMinNum.option( "value" );
    let fltr_max_tfvl            = trafMaxNum.option( "value" );
    let adjs_shtr_miss_decs_cycl = loopNum.option( "value" );
    let adjs_15m_ptrn_aply_yn    = fftnPttrCheck.option( "value" )?'Y':'N';

    let updateData   = {
        detl: {
            adjs_15m_ptrn_aply_yn     : adjs_15m_ptrn_aply_yn,
            adjs_shtr_miss_decs_cycl  : adjs_shtr_miss_decs_cycl,
            adjs_wght_avrg_pre_1cycl  : adjs_wght_avrg_pre_1cycl,
            adjs_wght_avrg_pre_2cycl  : adjs_wght_avrg_pre_2cycl,
            adjs_wght_avrg_pre_3cycl  : adjs_wght_avrg_pre_3cycl,
            fltr_hghs_sped            : fltr_hghs_sped,
            fltr_lwst_sped            : fltr_lwst_sped,
            fltr_max_tfvl             : fltr_max_tfvl,
            fltr_min_tfvl             : fltr_min_tfvl,
            smth_hghs_sped_fctr       : smth_hghs_sped_fctr,
            smth_lwst_sped_fctr       : smth_lwst_sped_fctr,
            smth_wght_avrg_pre_1cycl  : smth_wght_avrg_pre_1cycl,
            smth_wght_avrg_pre_2cycl  : smth_wght_avrg_pre_2cycl,
            smth_wght_avrg_prst       : smth_wght_avrg_prst,                
        },
        stup: {
            adjs_mthd_cd : adjs_mthd_cd,
            fltr_mthd_cd : fltr_mthd_cd,
            fusn_mthd_cd : fusn_mthd_cd,
            smth_mthd_cd : smth_mthd_cd
        },
        systlist: systlist
    }
    return updateData;
}

function validationText(textBox) {
    return nullChecker(getValue(textBox)) === "";
}