let updateData          = [];
let cmtrGradClsfTable   = null;
const _pageName         = '소통등급관리';
const _apiUri           = '/api/database/cmtr-grad-clsf';
let editCancleBtn       = null;
let editBtn             = null;
let searchBtn           = null;
let applyBtn            = null;

$(()=>{
    //상단 조회 버튼
    searchBtn = $(".search-button").dxButton({
        stylingMode:'outlined',
        text:'조회',
        icon:'refresh',
        height:'30px',
        width: '80px',
        onClick(){
            fetchListData();
        }
    }).dxButton('instance');

    //상단 닫기 버튼
    $(".cancle-button").dxButton({
        text:'닫기',
        icon:'close',
        height:'30px',
        width: '80px',
        stylingMode:'outlined',
        onClick(){
            window.close();
        }
    }).dxButton('instance');

    //소통 등급 테이블
    cmtrGradClsfTable = $(".cmtr-grad-clsf-table").width('100%').height('100%').dxDataGrid({
        dataSource              : null,
        allowColumnReordering   : true,
        showColumnLines         : true,
        allowColumnResizing     : true,
        showBorders             : true,
        rowAlternationEnabled   : true,
        columnAutoWidth         : true,
        noDataText              : '표출할 정보가 없습니다.',
        keyExpr                 : ['cmtr_grad_cd','sect_grad_desc'],
        focusedRowEnabled       : true,
        scrolling: {
            mode: "standard",
        },
        paging: {
            enabled: true,
            pageSize: 1000,
        },
        selection: {
            mode: 'single',
        },
        // headerFilter: {
        //     visible: true,
        // },
        grouping: {
            autoExpandAll: true,
        },
        groupPanel:{
            visible: false,
            emptyPanelText:"그룹 지을 항목을 여기에 끌어다 놓으세요"
        },
        export:{
            enabled: true,
            texts: {
                exportAll:"엑셀 파일",
            },
        },
        onExporting(e){
            gridExcellExporting(e, _pageName);
        },
        columns:[
            {
                caption   : "구분",
                alignment : 'center',
                width     : 80,
                visible   : false,
                columns:[{
                    dataField:"sect_grad_desc",
                    caption:"도로등급",
                    alignment:"center",
                    allowEditing: false,
                    groupIndex: 0,
                    sortIndex: 0,
                    sortOrder: "asc",
                }]

            },
            {
                caption:"소통등급 파라미터",
                alignment:"center",
                columns:[{
                    dataField:"cmtr_grad_desc",
                    caption:"소통 등급",
                    alignment:"center",
                    allowEditing: false,
                    cellTemplate(c,e){
                        let result = nullChecker(e.data.cmtr_grad_desc);
                        return  $('<div style="text-align: left; padding-left: 10px;">'+result+'</div>')
                    }
                },
                    {
                        dataField:"lwst_trvl_sped",
                        caption:"최저 통행 속도",
                        alignment:"center",
                        editorOptions : {
                            dataType  : 'number',
                            min       : 0,
                            max       : 999,
                        }
                    },
                    {
                        dataField:"hghs_trvl_sped",
                        caption:"최고 통행 속도",
                        alignment:"center",
                        editorOptions : {
                            dataType  : 'number',
                            min       : 0,
                            max       : 999,
                        }
                    },
                    {
                        dataField:"cngs_grad_yn",
                        caption:"정체 등급 여부",
                        alignment:"center",
                        lookup: {
                            dataSource: ['Y','N'],
                        },
                    },
                    {
                        dataField:"cmtr_grad_cd",
                        caption:"표출색상",
                        alignment:"center",
                        allowEditing: false,
                        cellTemplate(c,e){
                            c.addClass("no-padding");
                            let color="";
                            cmtrColor.map((item)=>{
                                if (item.name === e.data.cmtr_grad_cd) {
                                    color = item.color
                                }
                            })
                            return  $('<div class="background-color" style="background-color:'+color+';width:100%;height:30px;">&nbsp;</div>')
                        }
                    },]
            },
        ],
        onRowClick(e){
        },
        onRowDblClick(e){
        },
        onRowUpdated(e){
            updateData.push(e.data);
        }

    }).dxDataGrid("instance");

    //하단 편집 버튼
    editBtn = $(".edit-btn").dxButton({
        stylingMode:'outlined',
        text:'편집',
        icon:'edit',
        onClick(){
            eventOn();
        }
    }).dxButton('instance');

    //하단 취소 버튼
    editCancleBtn = $(".edit-cancle-btn").dxButton({
        stylingMode:'outlined',
        text:'취소',
        visible:false,
        icon:'close',
        onClick(){
            //변경된 데이터가 없을때
            if (!cmtrGradClsfTable.hasEditData()) {
                eventOff();
            }
            else {
                //변경 데이터가 있을때
                confirmMessage('변경하신 소통등급 정보가 있습니다. 취소하시겠습니까?').done((yes)=>{
                    if (yes === true) {
                        eventOff();
                    }
                })
            }
        }
    }).dxButton('instance');

    //하단 적용 버튼
    applyBtn = $(".apply-btn").dxButton({
        stylingMode:'outlined',
        text:'적용',
        disabled:true,
        icon:'save',
        onClick(){
            saveEvent();
        }
    }).dxButton('instance');

    fetchListData();
})

//소통등급 리스트 정보 수신
function fetchListData(){
    getDataAsync(_apiUri, (jsonData)=>{cmtrGradClsfTable.option('dataSource', jsonData)});
}

//하단 적용 이벤트
function saveEvent(){
    //변경 데이터 유무 확인
    if ( !cmtrGradClsfTable.hasEditData() ){
        return alertWarning("변경하신 데이터가 없습니다.")
    }
    else {
        let dataSource = cmtrGradClsfTable.option('dataSource');
        let updateDataFommat = [];
        let cmtrGradCdMap = new Map();
        dataSource.map((item)=>{
            cmtrGradClsfTable.byKey({cmtr_grad_cd : item.cmtr_grad_cd, sect_grad_desc:item.sect_grad_desc}).done(function(rowData){
                if (!cmtrGradCdMap.get(rowData.sect_grad_cd)){
                    cmtrGradCdMap.set(rowData.sect_grad_cd, new Map());
                }
                cmtrGradCdMap.get(rowData.sect_grad_cd).set(rowData.cmtr_grad_cd, rowData);
                updateDataFommat.push(
                    {
                        cmtr_grad_cd   : rowData.cmtr_grad_cd,
                        cngs_grad_yn   : rowData.cngs_grad_yn,
                        hghs_trvl_sped : rowData.hghs_trvl_sped,
                        lwst_trvl_sped : rowData.lwst_trvl_sped,
                        sect_grad_cd   : rowData.sect_grad_cd,
                    }
                );
            });
        });

        for (let updateData of updateDataFommat){
            if ( updateData.lwst_trvl_sped > updateData.hghs_trvl_sped ) {
                alertWarning(updateData.sect_grad_desc+"<br>최저 통행 속도가 최고 통행 속도보다 큽니다..");
                return false;
            }
        };

        for (let [key, obj] of cmtrGradCdMap){
            const lct0 = obj.get('LTC0');
            const lct3 = obj.get('LTC3');
            const lct2 = obj.get('LTC2');
            const lct1 = obj.get('LTC1');

            if (nullChecker(lct0.lwst_trvl_sped) === "") {
                alertWarning(lct0.sect_grad_desc + '<br>정보없음 구간 최저 통행 속도를 입력해주세요.');
                return false
            }
            else if (nullChecker(lct0.hghs_trvl_sped) === "") {
                alertWarning(lct0.sect_grad_desc + '<br>정보없음 구간 최고 통행 속도를 입력해주세요.');
                return false
            }
            else if ((lct0.hghs_trvl_sped + 1) !== lct3.lwst_trvl_sped) {
                alertWarning(lct0.sect_grad_desc + '<br>정보없음 구간 최고 통행 속도 및 정체 최저 통행 속도를 확인해주세요.');
                return false
            }
            else if ((lct3.hghs_trvl_sped + 1) !== lct2.lwst_trvl_sped) {
                alertWarning(lct3.sect_grad_desc + '<br>정체 구간 최고 통행 속도 및 부분지체 최저 통행 속도를 확인해주세요.');
                return false
            }
            else if ((lct2.hghs_trvl_sped + 1) !== lct1.lwst_trvl_sped) {
                alertWarning(lct2.sect_grad_desc + '<br>부분지체 구간 최고 통행 속도 및 소통원활 최저 통행 속도를 확인해주세요.');
                return false;
            }
        }

        //소통등급 관리 정보 수정 API 호출
        const result = postInsertUpdate('/api/database/cmtr-grad-clsf', updateDataFommat);

        //수정 됐을 시
        if (result > 0){
            fetchListData();
            eventOff();
            alertConfirm("소통등급 정보를 수정하였습니다.");
        }
    }
}

//편집 이벤트 종료 함수
function eventOff(){
    showBtn(editBtn);
    hideBtn(editCancleBtn);
    dsblOnBtn(applyBtn);
    dsblOffBtn(searchBtn);
    cmtrGradClsfTable.option("editing",{
        mode:"none",
        allowUpdating:false,
    });
    cmtrGradClsfTable.option('toolbar.visible', true);
    cmtrGradClsfTable.clearSelection();
    cmtrGradClsfTable.option('focusedRowIndex', -1);
    //fetchListData();
}

//편집 이벤트 시작 함수
function eventOn() {
    showBtn(editCancleBtn);
    hideBtn(editBtn);
    dsblOffBtn(applyBtn);
    dsblOnBtn(searchBtn);
    cmtrGradClsfTable.option("editing",{
        mode:'batch',
        allowUpdating: true,
    });
    cmtrGradClsfTable.option('toolbar.visible', false);
}