
export function apiGet(uri) {
    const apiUri = _apiUrl + uri;
    return fetch(apiUri);
}

export function requestGet(uri, successFunc, successArgs, errorFunc) {
    const apiUri = _apiUrl + uri;
    fetch(apiUri)
        .then((res) => {
            return res.json();
        })
        .then((data) => {
            if (successArgs == null) {
                return successFunc(data, apiUri);
            } else {
                return successFunc(data, successArgs, apiUri);
            }
        })
        .catch((err) => {
            if (errorFunc == null) {
                errorResponse(uri, err);
            } else {
                errorFunc(apiUri, err);
            }
            return new Error(uri + err);
        });
}

function errorResponse(uri, err) {
    console.log(uri, err);
}
