
export class TMapConfig {
    constructor() {
        this.mapCenter = [127.109873, 37.283203];
        this.mapDefZoom = 14;
        this.mapMinZoom = 10;
        this.mapMaxZoom = 18;

        this.mapView = new ol.View({
            center: this.mapCenter,
            zoom: this.mapDefZoom,
            projection: "EPSG:4326",
            minZoom: this.mapMinZoom,
            maxZoom: this.mapMaxZoom,
            constrainResolution: true, // force zooming to a integer zoom
        });

        this.poiGroup = new ol.layer.Group({
            title: "시설물",
            visible: true,
            layers: [],
        });

        this.eventGroup = new ol.layer.Group({
            title: "이벤트",
            visible: false,
            layers: [],
        });

        this.trafGroup = new ol.layer.Group({
            title: "소통정보",
            visible: true,
            layers: [],
        });

        this.baseMapLyr = {
            normal: new ol.layer.Group({
                title: "일반",
                visible: true,
                layers: [
                    new ol.layer.WebGLTile({
                        source: new ol.source.XYZ({
                            //attributions: ["&copy;Vworld"],
                            opaque: false,
                            crossOrigin: "anonymous",
                            url: _normalUrl,
                        }),
                        name: "normal",
                    }),
                ],
            }),

            satellite: new ol.layer.Group({
                title: "위성+하이브리드",
                visible: false,
                layers: [
                    new ol.layer.WebGLTile({
                        source: new ol.source.XYZ({
                            //attributions: ["&copy;Vworld"],
                            opaque: false,
                            crossOrigin: "anonymous",
                            url: _satelliteUrl,
                        }),
                        name: "satellite",
                    }),
                    new ol.layer.WebGLTile({
                        source: new ol.source.XYZ({
                            //attributions: ["&copy;Vworld"],
                            opaque: false,
                            crossOrigin: "anonymous",
                            url: _hybridUrl,
                        }),
                        name: "hybrid",
                    }),
                ],
            }),
        };

        this.baseMapGroup = new ol.layer.Group({
            title: "배경지도",
            visible: true,
            layers: [this.baseMapLyr.normal, this.baseMapLyr.satellite],
        });
    }
}
