/*
 Highcharts JS v10.1.0 (2022-04-29)

 (c) 2014-2021 Highsoft AS
 Authors: Jon Arild Nygard / Oystein Moseng

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/treemap",["highcharts"],function(v){a(v);a.Highcharts=v;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function v(a,d,c,k){a.hasOwnProperty(d)||(a[d]=k.apply(null,c),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:d,module:a[d]}})))}a=a?a._modules:{};v(a,
"Series/ColorMapMixin.js",[a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,d,c){var k=a.noop;a=a.seriesTypes;var p=c.defined;c=c.addEvent;c(d,"afterSetState",function(a){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:a&&"hover"===a.state?1:0})});return{PointMixin:{dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value}},SeriesMixin:{pointArrayMap:["value"],axisTypes:["xAxis",
"yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:k,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:a.column.prototype.pointAttribs,colorAttribs:function(a){var r={};!p(a.color)||a.state&&"normal"!==a.state||(r[this.colorProp||"fill"]=a.color);return r}}}});v(a,"Series/Treemap/TreemapAlgorithmGroup.js",[],function(){return function(){function a(a,c,k,p){this.height=a;this.width=c;this.plot=p;this.startDirection=this.direction=k;this.lH=this.nH=this.lW=
this.nW=this.total=0;this.elArr=[];this.lP={total:0,lH:0,nH:0,lW:0,nW:0,nR:0,lR:0,aspectRatio:function(a,c){return Math.max(a/c,c/a)}}}a.prototype.addElement=function(a){this.lP.total=this.elArr[this.elArr.length-1];this.total+=a;0===this.direction?(this.lW=this.nW,this.lP.lH=this.lP.total/this.lW,this.lP.lR=this.lP.aspectRatio(this.lW,this.lP.lH),this.nW=this.total/this.height,this.lP.nH=this.lP.total/this.nW,this.lP.nR=this.lP.aspectRatio(this.nW,this.lP.nH)):(this.lH=this.nH,this.lP.lW=this.lP.total/
this.lH,this.lP.lR=this.lP.aspectRatio(this.lP.lW,this.lH),this.nH=this.total/this.width,this.lP.nW=this.lP.total/this.nH,this.lP.nR=this.lP.aspectRatio(this.lP.nW,this.nH));this.elArr.push(a)};a.prototype.reset=function(){this.lW=this.nW=0;this.elArr=[];this.total=0};return a}()});v(a,"Series/DrawPointComposition.js",[],function(){var a;(function(a){function c(a){var c=this,g=a.animatableAttribs,d=a.onComplete,b=a.css,h=a.renderer,L=this.series&&this.series.chart.hasRendered?void 0:this.series&&
this.series.options.animation,w=this.graphic;a.attribs=a.attribs||{};a.attribs["class"]=this.getClassName();if(this.shouldDraw())w||(this.graphic=w="text"===a.shapeType?h.text():h[a.shapeType](a.shapeArgs||{}),w.add(a.group)),b&&w.css(b),w.attr(a.attribs).animate(g,a.isNew?!1:L,d);else if(w){var l=function(){c.graphic=w=w&&w.destroy();"function"===typeof d&&d()};Object.keys(g).length?w.animate(g,void 0,function(){l()}):l()}}function k(){return!this.isNull}var d=[];a.compose=function(a){if(-1===d.indexOf(a)){d.push(a);
var q=a.prototype;q.draw=c;q.shouldDraw||(q.shouldDraw=k)}return a}})(a||(a={}));return a});v(a,"Series/Treemap/TreemapPoint.js",[a["Series/DrawPointComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,d,c){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)b.hasOwnProperty(e)&&(a[e]=b[e])};return a(b,c)};return function(b,c){function h(){this.constructor=
b}a(b,c);b.prototype=null===c?Object.create(c):(h.prototype=c.prototype,new h)}}(),p=d.series.prototype.pointClass,r=d.seriesTypes;d=r.pie.prototype.pointClass;var q=c.extend,g=c.isNumber,u=c.pick;c=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.name=void 0;b.node=void 0;b.options=void 0;b.series=void 0;b.value=void 0;return b}k(b,a);b.prototype.getClassName=function(){var a=p.prototype.getClassName.call(this),b=this.series,l=b.options;this.node.level<=b.nodeMap[b.rootNode].level?
a+=" highcharts-above-level":this.node.isLeaf||u(l.interactByLeaf,!l.allowTraversingTree)?this.node.isLeaf||(a+=" highcharts-internal-node"):a+=" highcharts-internal-node-interactive";return a};b.prototype.isValid=function(){return!(!this.id&&!g(this.value))};b.prototype.setState=function(a){p.prototype.setState.call(this,a);this.graphic&&this.graphic.attr({zIndex:"hover"===a?1:0})};b.prototype.shouldDraw=function(){return g(this.plotY)&&null!==this.y};return b}(r.scatter.prototype.pointClass);q(c.prototype,
{setVisible:d.prototype.setVisible});a.compose(c);return c});v(a,"Series/Treemap/TreemapUtilities.js",[a["Core/Utilities.js"]],function(a){var d=a.objectEach,c;(function(a){function c(a,d,g){void 0===g&&(g=this);a=d.call(g,a);!1!==a&&c(a,d,g)}a.AXIS_MAX=100;a.isBoolean=function(a){return"boolean"===typeof a};a.eachObject=function(a,c,g){g=g||this;d(a,function(d,b){c.call(g,d,b,a)})};a.recursive=c})(c||(c={}));return c});v(a,"Series/TreeUtilities.js",[a["Core/Color/Color.js"],a["Core/Utilities.js"]],
function(a,d){function c(a,h){var b=h.before,d=h.idRoot,l=h.mapIdToNode[d],e=h.points[a.i],m=e&&e.options||{},y=[],z=0;a.levelDynamic=a.level-(!1!==h.levelIsConstant?0:l.level);a.name=u(e&&e.name,"");a.visible=d===a.id||!0===h.visible;"function"===typeof b&&(a=b(a,h));a.children.forEach(function(b,e){var m=k({},h);k(m,{index:e,siblings:a.children.length,visible:a.visible});b=c(b,m);y.push(b);b.visible&&(z+=b.val)});b=u(m.value,z);a.visible=0<=b&&(0<z||a.visible);a.children=y;a.childrenTotal=z;a.isLeaf=
a.visible&&!z;a.val=b;return a}var k=d.extend,p=d.isArray,r=d.isNumber,q=d.isObject,g=d.merge,u=d.pick;return{getColor:function(b,c){var d=c.index,h=c.mapOptionsToLevel,l=c.parentColor,e=c.parentColorIndex,m=c.series,y=c.colors,z=c.siblings,g=m.points,k=m.chart.options.chart,x;if(b){g=g[b.i];b=h[b.level]||{};if(h=g&&b.colorByPoint){var q=g.index%(y?y.length:k.colorCount);var p=y&&y[q]}if(!m.chart.styledMode){y=g&&g.options.color;k=b&&b.color;if(x=l)x=(x=b&&b.colorVariation)&&"brightness"===x.key&&
d&&z?a.parse(l).brighten(d/z*x.to).get():l;x=u(y,k,p,x,m.color)}var r=u(g&&g.options.colorIndex,b&&b.colorIndex,q,e,c.colorIndex)}return{color:x,colorIndex:r}},getLevelOptions:function(a){var b=null;if(q(a)){b={};var c=r(a.from)?a.from:1;var d=a.levels;var l={};var e=q(a.defaults)?a.defaults:{};p(d)&&(l=d.reduce(function(a,b){if(q(b)&&r(b.level)){var m=g({},b);var l=u(m.levelIsConstant,e.levelIsConstant);delete m.levelIsConstant;delete m.level;b=b.level+(l?0:c-1);q(a[b])?g(!0,a[b],m):a[b]=m}return a},
{}));d=r(a.to)?a.to:1;for(a=0;a<=d;a++)b[a]=g({},e,q(l[a])?l[a]:{})}return b},setTreeValues:c,updateRootId:function(a){if(q(a)){var b=q(a.options)?a.options:{};b=u(a.rootNode,b.rootId,"");q(a.userOptions)&&(a.userOptions.rootId=b);a.rootNode=b}return b}}});v(a,"Extensions/Breadcrumbs.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"],a["Core/FormatUtilities.js"]],function(a,d,c,k,p){var r=p.format;p=k.addEvent;var q=k.objectEach,g=k.extend,u=k.fireEvent,
b=k.merge,h=k.pick,v=k.defined,w=k.isString;g(c.defaultOptions.lang,{mainBreadcrumb:"Main"});c=function(){function a(e,m){this.group=void 0;this.list=[];this.elementList={};this.isDirty=!0;this.level=0;this.options=void 0;m=b(e.options.drilldown&&e.options.drilldown.drillUpButton,a.defaultBreadcrumbsOptions,e.options.navigation&&e.options.navigation.breadcrumbs,m);this.chart=e;this.options=m||{}}a.prototype.updateProperties=function(a){this.setList(a);this.setLevel();this.isDirty=!0};a.prototype.setList=
function(a){this.list=a};a.prototype.setLevel=function(){this.level=this.list.length&&this.list.length-1};a.prototype.getLevel=function(){return this.level};a.prototype.getButtonText=function(a){var b=this.chart,c=this.options,e=b.options.lang,d=h(c.format,c.showFullPath?"{level.name}":"\u2190 {level.name}");e=e&&h(e.drillUpText,e.mainBreadcrumb);a=c.formatter&&c.formatter(a)||r(d,{level:a.levelOptions},b)||"";(w(a)&&!a.length||"\u2190 "===a)&&v(e)&&(a=c.showFullPath?e:"\u2190 "+e);return a};a.prototype.redraw=
function(){this.isDirty&&this.render();this.group&&this.group.align();this.isDirty=!1};a.prototype.render=function(){var a=this.chart,b=this.options;!this.group&&b&&(this.group=a.renderer.g("breadcrumbs-group").addClass("highcharts-no-tooltip highcharts-breadcrumbs").attr({zIndex:b.zIndex}).add());b.showFullPath?this.renderFullPathButtons():this.renderSingleButton();this.alignBreadcrumbsGroup()};a.prototype.renderFullPathButtons=function(){this.destroySingleButton();this.resetElementListState();this.updateListElements();
this.destroyListElements()};a.prototype.renderSingleButton=function(){var a=this.chart,b=this.list,c=this.options.buttonSpacing;this.destroyListElements();var d=this.group?this.group.getBBox().width:c;b=b[b.length-2];!a.drillUpButton&&0<this.level?a.drillUpButton=this.renderButton(b,d,c):a.drillUpButton&&(0<this.level?this.updateSingleButton():this.destroySingleButton())};a.prototype.alignBreadcrumbsGroup=function(a){if(this.group){var c=this.options,e=c.buttonTheme,d=c.position,g="chart"===c.relativeTo||
"spacingBox"===c.relativeTo?void 0:"scrollablePlotBox",l=this.group.getBBox();c=2*(e.padding||0)+c.buttonSpacing;d.width=l.width+c;d.height=l.height+c;d=b(d);a&&(d.x+=a);d.y=h(d.y,this.yOffset,0);this.group.align(d,!0,g)}};a.prototype.renderButton=function(a,c,d){var e=this,m=this.chart,g=e.options,l=b(g.buttonTheme);c=m.renderer.button(e.getButtonText(a),c,d,function(b){var c=g.events&&g.events.click,d;c&&(d=c.call(e,b,a));!1!==d&&(b.newLevel=g.showFullPath?a.level:e.level-1,u(e,"up",b))},l).addClass("highcharts-breadcrumbs-button").add(e.group);
m.styledMode||c.attr(g.style);return c};a.prototype.renderSeparator=function(a,b){var c=this.chart,d=this.options.separator;a=c.renderer.label(d.text,a,b,void 0,void 0,void 0,!1).addClass("highcharts-breadcrumbs-separator").add(this.group);c.styledMode||a.css(d.style);return a};a.prototype.update=function(a){b(!0,this.options,a);this.destroy();this.isDirty=!0};a.prototype.updateSingleButton=function(){var a=this.chart,b=this.list[this.level-1];a.drillUpButton&&a.drillUpButton.attr({text:this.getButtonText(b)})};
a.prototype.destroy=function(){this.destroySingleButton();this.destroyListElements(!0);this.group&&this.group.destroy();this.group=void 0};a.prototype.destroyListElements=function(a){var b=this.elementList;q(b,function(c,d){if(a||!b[d].updated)c=b[d],c.button&&c.button.destroy(),c.separator&&c.separator.destroy(),delete c.button,delete c.separator,delete b[d]});a&&(this.elementList={})};a.prototype.destroySingleButton=function(){this.chart.drillUpButton&&(this.chart.drillUpButton.destroy(),this.chart.drillUpButton=
void 0)};a.prototype.resetElementListState=function(){q(this.elementList,function(a){a.updated=!1})};a.prototype.updateListElements=function(){var a=function(a,b){return a.getBBox().width+b},b=this,c=b.elementList,d=b.options.buttonSpacing,g=b.list,l=b.group?a(b.group,d):d,h;g.forEach(function(e,m){m=m===g.length-1;if(c[e.level]){h=c[e.level];var k=h.button;h.separator||m?h.separator&&m&&(h.separator.destroy(),delete h.separator):(l+=d,h.separator=b.renderSeparator(l,d),l+=a(h.separator,d));c[e.level].updated=
!0}else{k=b.renderButton(e,l,d);l+=a(k,d);if(!m){var q=b.renderSeparator(l,d);l+=a(q,d)}c[e.level]={button:k,separator:q,updated:!0}}k&&k.setState(m?2:0)})};a.defaultBreadcrumbsOptions={buttonTheme:{fill:"none",height:18,padding:2,"stroke-width":0,zIndex:7,states:{select:{fill:"none"}},style:{color:"#335cad"}},buttonSpacing:5,floating:!1,format:void 0,relativeTo:"plotBox",position:{align:"left",verticalAlign:"top",x:0,y:void 0},separator:{text:"/",style:{color:"#666666"}},showFullPath:!0,style:{},
useHTML:!1,zIndex:7};return a}();d.Breadcrumbs||(d.Breadcrumbs=c,p(a,"getMargins",function(){var a=this.breadcrumbs;if(a&&!a.options.floating&&a.level){var b=a.options,c=b.buttonTheme;c=(c.height||0)+2*(c.padding||0)+b.buttonSpacing;b=b.position.verticalAlign;"bottom"===b?(this.marginBottom=(this.marginBottom||0)+c,a.yOffset=c):"middle"!==b?(this.plotTop+=c,a.yOffset=-c):a.yOffset=void 0}}),p(a,"redraw",function(){this.breadcrumbs&&this.breadcrumbs.redraw()}),p(a,"destroy",function(){this.breadcrumbs&&
(this.breadcrumbs.destroy(),this.breadcrumbs=void 0)}),p(a,"afterShowResetZoom",function(){if(this.breadcrumbs){var a=this.resetZoomButton&&this.resetZoomButton.getBBox(),b=this.breadcrumbs.options;a&&"right"===b.position.align&&"plotBox"===b.relativeTo&&this.breadcrumbs.alignBreadcrumbsGroup(-a.width-b.buttonSpacing)}}),p(a,"selection",function(a){!0===a.resetSelection&&this.breadcrumbs&&this.breadcrumbs.alignBreadcrumbsGroup()}));"";return c});v(a,"Series/Treemap/TreemapComposition.js",[a["Core/Series/SeriesRegistry.js"],
a["Series/Treemap/TreemapUtilities.js"],a["Core/Utilities.js"]],function(a,d,c){var k=c.addEvent,p=c.extend,r=!1;k(a.series,"afterBindAxes",function(){var a=this.xAxis,c=this.yAxis;if(a&&c)if(this.is("treemap")){var k={endOnTick:!1,gridLineWidth:0,lineWidth:0,min:0,minPadding:0,max:d.AXIS_MAX,maxPadding:0,startOnTick:!1,title:void 0,tickPositions:[]};p(c.options,k);p(a.options,k);r=!0}else r&&(c.setOptions(c.userOptions),a.setOptions(a.userOptions),r=!1)})});v(a,"Series/Treemap/TreemapSeries.js",
[a["Core/Color/Color.js"],a["Series/ColorMapMixin.js"],a["Core/Globals.js"],a["Core/Legend/LegendSymbol.js"],a["Core/Series/SeriesRegistry.js"],a["Series/Treemap/TreemapAlgorithmGroup.js"],a["Series/Treemap/TreemapPoint.js"],a["Series/Treemap/TreemapUtilities.js"],a["Series/TreeUtilities.js"],a["Extensions/Breadcrumbs.js"],a["Core/Utilities.js"]],function(a,d,c,k,p,r,q,g,u,b,h){var v=this&&this.__extends||function(){var a=function(b,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,
f){a.__proto__=f}||function(a,f){for(var b in f)f.hasOwnProperty(b)&&(a[b]=f[b])};return a(b,f)};return function(b,f){function n(){this.constructor=b}a(b,f);b.prototype=null===f?Object.create(f):(n.prototype=f.prototype,new n)}}(),w=a.parse;a=c.noop;var l=p.series;c=p.seriesTypes;var e=c.column,m=c.heatmap,y=c.scatter,z=u.getColor,K=u.getLevelOptions,M=u.updateRootId,x=h.addEvent,N=h.correctFloat,F=h.defined,O=h.error,G=h.extend,P=h.fireEvent,I=h.isArray,Q=h.isObject,H=h.isString,C=h.merge,A=h.pick,
R=h.stableSort;u=function(a){function c(){var f=null!==a&&a.apply(this,arguments)||this;f.axisRatio=void 0;f.data=void 0;f.mapOptionsToLevel=void 0;f.nodeMap=void 0;f.options=void 0;f.points=void 0;f.rootNode=void 0;f.tree=void 0;f.level=void 0;return f}v(c,a);c.prototype.algorithmCalcPoints=function(a,c,b,d){var f,n,t,B,g=b.lW,E=b.lH,e=b.plot,h=0,k=b.elArr.length-1;if(c)g=b.nW,E=b.nH;else var l=b.elArr[b.elArr.length-1];b.elArr.forEach(function(a){if(c||h<k)0===b.direction?(f=e.x,n=e.y,t=g,B=a/t):
(f=e.x,n=e.y,B=E,t=a/B),d.push({x:f,y:n,width:t,height:N(B)}),0===b.direction?e.y+=B:e.x+=t;h+=1});b.reset();0===b.direction?b.width-=g:b.height-=E;e.y=e.parent.y+(e.parent.height-b.height);e.x=e.parent.x+(e.parent.width-b.width);a&&(b.direction=1-b.direction);c||b.addElement(l)};c.prototype.algorithmFill=function(a,b,c){var f=[],n,d=b.direction,t=b.x,e=b.y,g=b.width,E=b.height,h,k,l,m;c.forEach(function(c){n=c.val/b.val*b.height*b.width;h=t;k=e;0===d?(m=E,l=n/m,g-=l,t+=l):(l=g,m=n/l,E-=m,e+=m);f.push({x:h,
y:k,width:l,height:m});a&&(d=1-d)});return f};c.prototype.algorithmLowAspectRatio=function(a,b,c){var f=[],n=this,d,t={x:b.x,y:b.y,parent:b},e=0,g=c.length-1,h=new r(b.height,b.width,b.direction,t);c.forEach(function(c){d=c.val/b.val*b.height*b.width;h.addElement(d);h.lP.nR>h.lP.lR&&n.algorithmCalcPoints(a,!1,h,f,t);e===g&&n.algorithmCalcPoints(a,!0,h,f,t);e+=1});return f};c.prototype.alignDataLabel=function(a,b,c){var f=c.style;f&&!F(f.textOverflow)&&b.text&&b.getBBox().width>b.text.textWidth&&b.css({textOverflow:"ellipsis",
width:f.width+="px"});e.prototype.alignDataLabel.apply(this,arguments);a.dataLabel&&a.dataLabel.attr({zIndex:(a.node.zIndex||0)+1})};c.prototype.buildNode=function(a,b,c,d,D){var f=this,n=[],t=f.points[b],e=0,g;(d[a]||[]).forEach(function(b){g=f.buildNode(f.points[b].id,b,c+1,d,a);e=Math.max(g.height+1,e);n.push(g)});b={id:a,i:b,children:n,height:e,level:c,parent:D,visible:!1};f.nodeMap[b.id]=b;t&&(t.node=b);return b};c.prototype.calculateChildrenAreas=function(a,b){var f=this,c=f.options,d=f.mapOptionsToLevel[a.level+
1],n=A(f[d&&d.layoutAlgorithm]&&d.layoutAlgorithm,c.layoutAlgorithm),e=c.alternateStartingDirection,h=[];a=a.children.filter(function(a){return!a.ignore});d&&d.layoutStartingDirection&&(b.direction="vertical"===d.layoutStartingDirection?0:1);h=f[n](b,a);a.forEach(function(a,c){c=h[c];a.values=C(c,{val:a.childrenTotal,direction:e?1-b.direction:b.direction});a.pointValues=C(c,{x:c.x/f.axisRatio,y:g.AXIS_MAX-c.y-c.height,width:c.width/f.axisRatio});a.children.length&&f.calculateChildrenAreas(a,a.values)})};
c.prototype.createList=function(a){var b=this.chart,f=[];if(b.breadcrumbs){var c=0;f.push({level:c,levelOptions:b.series[0]});b=a.target.nodeMap[a.newRootId];for(var d=[];b.parent||""===b.parent;)d.push(b),b=a.target.nodeMap[b.parent];d.reverse().forEach(function(a){f.push({level:++c,levelOptions:a})});1>=f.length&&(f.length=0)}return f};c.prototype.drawDataLabels=function(){var a=this,b=a.mapOptionsToLevel,c,d;a.points.filter(function(a){return a.node.visible}).forEach(function(f){d=b[f.node.level];
c={style:{}};f.node.isLeaf||(c.enabled=!1);d&&d.dataLabels&&(c=C(c,d.dataLabels),a._hasPointLabels=!0);f.shapeArgs&&(c.style.width=f.shapeArgs.width,f.dataLabel&&f.dataLabel.css({width:f.shapeArgs.width+"px"}));f.dlOptions=C(c,f.options.dataLabels)});l.prototype.drawDataLabels.call(this)};c.prototype.drawPoints=function(){var a=this,b=a.chart,c=b.renderer,d=b.styledMode,e=a.options,S=d?{}:e.shadow,g=e.borderRadius,h=b.pointCount<e.animationLimit,l=e.allowTraversingTree;a.points.forEach(function(b){var f=
b.node.levelDynamic,n={},t={},J={},D="level-group-"+b.node.level,k=!!b.graphic,m=h&&k,B=b.shapeArgs;b.shouldDraw()&&(b.isInside=!0,g&&(t.r=g),C(!0,m?n:t,k?B:{},d?{}:a.pointAttribs(b,b.selected?"select":void 0)),a.colorAttribs&&d&&G(J,a.colorAttribs(b)),a[D]||(a[D]=c.g(D).attr({zIndex:1E3-(f||0)}).add(a.group),a[D].survive=!0));b.draw({animatableAttribs:n,attribs:t,css:J,group:a[D],renderer:c,shadow:S,shapeArgs:B,shapeType:"rect"});l&&b.graphic&&(b.drillId=e.interactByLeaf?a.drillToByLeaf(b):a.drillToByGroup(b))})};
c.prototype.drillToByGroup=function(a){var b=!1;1!==a.node.level-this.nodeMap[this.rootNode].level||a.node.isLeaf||(b=a.id);return b};c.prototype.drillToByLeaf=function(a){var b=!1;if(a.node.parent!==this.rootNode&&a.node.isLeaf)for(a=a.node;!b;)a=this.nodeMap[a.parent],a.parent===this.rootNode&&(b=a.id);return b};c.prototype.drillToNode=function(a,b){O(32,!1,void 0,{"treemap.drillToNode":"use treemap.setRootNode"});this.setRootNode(a,b)};c.prototype.drillUp=function(){var a=this.nodeMap[this.rootNode];
a&&H(a.parent)&&this.setRootNode(a.parent,!0,{trigger:"traverseUpButton"})};c.prototype.getExtremes=function(){var a=l.prototype.getExtremes.call(this,this.colorValueData),b=a.dataMax;this.valueMin=a.dataMin;this.valueMax=b;return l.prototype.getExtremes.call(this)};c.prototype.getListOfParents=function(a,b){a=I(a)?a:[];var c=I(b)?b:[];b=a.reduce(function(a,b,c){b=A(b.parent,"");"undefined"===typeof a[b]&&(a[b]=[]);a[b].push(c);return a},{"":[]});g.eachObject(b,function(a,b,f){""!==b&&-1===c.indexOf(b)&&
(a.forEach(function(a){f[""].push(a)}),delete f[b])});return b};c.prototype.getTree=function(){var a=this.data.map(function(a){return a.id});a=this.getListOfParents(this.data,a);this.nodeMap={};return this.buildNode("",-1,0,a)};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.init=function(a,c){var f=this,e=C(c.drillUpButton,c.breadcrumbs);this.colorAttribs=d.SeriesMixin.colorAttribs;var n=x(f,"setOptions",function(a){a=a.userOptions;F(a.allowDrillToNode)&&!F(a.allowTraversingTree)&&
(a.allowTraversingTree=a.allowDrillToNode,delete a.allowDrillToNode);F(a.drillUpButton)&&!F(a.traverseUpButton)&&(a.traverseUpButton=a.drillUpButton,delete a.drillUpButton)});l.prototype.init.call(f,a,c);delete f.opacity;f.eventsToUnbind.push(n);f.options.allowTraversingTree&&(f.eventsToUnbind.push(x(f,"click",f.onClickDrillToNode)),f.eventsToUnbind.push(x(f,"setRootNode",function(a){var b=f.chart;b.breadcrumbs&&b.breadcrumbs.updateProperties(f.createList(a))})),f.eventsToUnbind.push(x(f,"update",
function(a,b){(b=this.chart.breadcrumbs)&&a.options.breadcrumbs&&b.update(a.options.breadcrumbs)})),f.eventsToUnbind.push(x(f,"destroy",function(a){var b=this.chart;b.breadcrumbs&&(b.breadcrumbs.destroy(),a.keepEventsForUpdate||(b.breadcrumbs=void 0))})));a.breadcrumbs||(a.breadcrumbs=new b(a,e));f.eventsToUnbind.push(x(a.breadcrumbs,"up",function(a){a=this.level-a.newLevel;for(var b=0;b<a;b++)f.drillUp()}))};c.prototype.onClickDrillToNode=function(a){var b=(a=a.point)&&a.drillId;H(b)&&(a.setState(""),
this.setRootNode(b,!0,{trigger:"click"}))};c.prototype.pointAttribs=function(a,b){var c=Q(this.mapOptionsToLevel)?this.mapOptionsToLevel:{},f=a&&c[a.node.level]||{};c=this.options;var d=b&&c.states[b]||{},e=a&&a.getClassName()||"";a={stroke:a&&a.borderColor||f.borderColor||d.borderColor||c.borderColor,"stroke-width":A(a&&a.borderWidth,f.borderWidth,d.borderWidth,c.borderWidth),dashstyle:a&&a.borderDashStyle||f.borderDashStyle||d.borderDashStyle||c.borderDashStyle,fill:a&&a.color||this.color};-1!==
e.indexOf("highcharts-above-level")?(a.fill="none",a["stroke-width"]=0):-1!==e.indexOf("highcharts-internal-node-interactive")?(b=A(d.opacity,c.opacity),a.fill=w(a.fill).setOpacity(b).get(),a.cursor="pointer"):-1!==e.indexOf("highcharts-internal-node")?a.fill="none":b&&(a.fill=w(a.fill).brighten(d.brightness).get());return a};c.prototype.setColorRecursive=function(a,b,c,d,e){var f=this,g=f&&f.chart;g=g&&g.options&&g.options.colors;if(a){var h=z(a,{colors:g,index:d,mapOptionsToLevel:f.mapOptionsToLevel,
parentColor:b,parentColorIndex:c,series:f,siblings:e});if(b=f.points[a.i])b.color=h.color,b.colorIndex=h.colorIndex;(a.children||[]).forEach(function(b,c){f.setColorRecursive(b,h.color,h.colorIndex,c,a.children.length)})}};c.prototype.setPointValues=function(){var a=this,b=a.xAxis,c=a.yAxis,d=a.chart.styledMode;a.points.forEach(function(f){var e=f.node,g=e.pointValues;e=e.visible;if(g&&e){e=g.height;var h=g.width,n=g.x,l=g.y,k=d?0:(a.pointAttribs(f)["stroke-width"]||0)%2/2;g=Math.round(b.toPixels(n,
!0))-k;h=Math.round(b.toPixels(n+h,!0))-k;n=Math.round(c.toPixels(l,!0))-k;e=Math.round(c.toPixels(l+e,!0))-k;e={x:Math.min(g,h),y:Math.min(n,e),width:Math.abs(h-g),height:Math.abs(e-n)};f.plotX=e.x+e.width/2;f.plotY=e.y+e.height/2;f.shapeArgs=e}else delete f.plotX,delete f.plotY})};c.prototype.setRootNode=function(a,b,c){a=G({newRootId:a,previousRootId:this.rootNode,redraw:A(b,!0),series:this},c);P(this,"setRootNode",a,function(a){var b=a.series;b.idPreviousRoot=a.previousRootId;b.rootNode=a.newRootId;
b.isDirty=!0;a.redraw&&b.chart.redraw()})};c.prototype.setState=function(a){this.options.inactiveOtherPoints=!0;l.prototype.setState.call(this,a,!1);this.options.inactiveOtherPoints=!1};c.prototype.setTreeValues=function(a){var b=this,c=b.options,f=b.nodeMap[b.rootNode];c=g.isBoolean(c.levelIsConstant)?c.levelIsConstant:!0;var d=0,e=[],h=b.points[a.i];a.children.forEach(function(a){a=b.setTreeValues(a);e.push(a);a.ignore||(d+=a.val)});R(e,function(a,b){return(a.sortIndex||0)-(b.sortIndex||0)});var k=
A(h&&h.options.value,d);h&&(h.value=k);G(a,{children:e,childrenTotal:d,ignore:!(A(h&&h.visible,!0)&&0<k),isLeaf:a.visible&&!d,levelDynamic:a.level-(c?0:f.level),name:A(h&&h.name,""),sortIndex:A(h&&h.sortIndex,-k),val:k});return a};c.prototype.sliceAndDice=function(a,b){return this.algorithmFill(!0,a,b)};c.prototype.squarified=function(a,b){return this.algorithmLowAspectRatio(!0,a,b)};c.prototype.strip=function(a,b){return this.algorithmLowAspectRatio(!1,a,b)};c.prototype.stripes=function(a,b){return this.algorithmFill(!1,
a,b)};c.prototype.translate=function(){var a=this,b=a.options,c=M(a);l.prototype.translate.call(a);var d=a.tree=a.getTree();var e=a.nodeMap[c];""===c||e&&e.children.length||(a.setRootNode("",!1),c=a.rootNode,e=a.nodeMap[c]);a.mapOptionsToLevel=K({from:e.level+1,levels:b.levels,to:d.height,defaults:{levelIsConstant:a.options.levelIsConstant,colorByPoint:b.colorByPoint}});g.recursive(a.nodeMap[a.rootNode],function(b){var c=!1,d=b.parent;b.visible=!0;if(d||""===d)c=a.nodeMap[d];return c});g.recursive(a.nodeMap[a.rootNode].children,
function(a){var b=!1;a.forEach(function(a){a.visible=!0;a.children.length&&(b=(b||[]).concat(a.children))});return b});a.setTreeValues(d);a.axisRatio=a.xAxis.len/a.yAxis.len;a.nodeMap[""].pointValues=c={x:0,y:0,width:g.AXIS_MAX,height:g.AXIS_MAX};a.nodeMap[""].values=c=C(c,{width:c.width*a.axisRatio,direction:"vertical"===b.layoutStartingDirection?0:1,val:d.val});a.calculateChildrenAreas(d,c);a.colorAxis||b.colorByPoint||a.setColorRecursive(a.tree);b.allowTraversingTree&&(b=e.pointValues,a.xAxis.setExtremes(b.x,
b.x+b.width,!1),a.yAxis.setExtremes(b.y,b.y+b.height,!1),a.xAxis.setScale(),a.yAxis.setScale());a.setPointValues()};c.defaultOptions=C(y.defaultOptions,{allowTraversingTree:!1,animationLimit:250,borderRadius:0,showInLegend:!1,marker:void 0,colorByPoint:!1,dataLabels:{defer:!1,enabled:!0,formatter:function(){var a=this&&this.point?this.point:{};return H(a.name)?a.name:""},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:"",pointFormat:"<b>{point.name}</b>: {point.value}<br/>"},ignoreHiddenPoint:!0,
layoutAlgorithm:"sliceAndDice",layoutStartingDirection:"vertical",alternateStartingDirection:!1,levelIsConstant:!0,traverseUpButton:{position:{align:"right",x:-10,y:10}},borderColor:"#e6e6e6",borderWidth:1,colorKey:"colorValue",opacity:.15,states:{hover:{borderColor:"#999999",brightness:m?0:.1,halo:!1,opacity:.75,shadow:!1}}});return c}(y);G(u.prototype,{buildKDTree:a,colorKey:"colorValue",directTouch:!0,drawLegendSymbol:k.drawRectangle,getExtremesFromAll:!0,getSymbol:a,optionalAxis:"colorAxis",parallelArrays:["x",
"y","value","colorValue"],pointArrayMap:["value"],pointClass:q,trackerGroups:["group","dataLabelsGroup"],utils:{recursive:g.recursive}});p.registerSeriesType("treemap",u);"";return u});v(a,"masters/modules/treemap.src.js",[a["Core/Globals.js"],a["Extensions/Breadcrumbs.js"]],function(a,d){a.Breadcrumbs=d})});
//# sourceMappingURL=treemap.js.map