import { currDt } from "/js/utils/common.js";
import { requestGet, apiGet } from "/js/utils/restApi.js";
import { TWebSocket } from "/js/websocket/websocket.js";
import { _errorSwitch } from "./main.js";
let _webSocket = null; // websocket

let _timerFetchFcltStts = null; // 시설물 상태정보 요청 타이머
const requestFetchFcltStts = () => {
    if (_timerFetchFcltStts) window.clearTimeout(_timerFetchFcltStts);
    _timerFetchFcltStts = window.setTimeout(() => fetchFcltStts(), 1 * 60 * 1000);
};
let _timerFetchDbmsStts = null; // 데이터베이스 상태정보 요청 타이머
const requestFetchDbmsStts = () => {
    if (_timerFetchDbmsStts) window.clearTimeout(_timerFetchDbmsStts);
    _timerFetchDbmsStts = window.setTimeout(() => fetchDbmsStts(), 5 * 60 * 1000);
};
let _timerFetchUnitStts = null; // 프로세스 상태정보 요청 타이머
const requestFetchUnitStts = () => {
    if (_timerFetchUnitStts) window.clearTimeout(_timerFetchUnitStts);
    _timerFetchUnitStts = window.setTimeout(() => fetchUnitStts(), 1 * 60 * 1000);
};


// 웹소켓 초기화
export function websocketConnect(clientType) {
    _webSocket = new TWebSocket(clientType, onSocketReceived, onSocketDisconnected, onSocketError, onSocketConnected);
    _webSocket.connect();
}
function onSocketConnected(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketConnected, ${AClientType}, `, AMessage);
}
function onSocketReceived(AClientType, AMessage) {
    console.log(`${currDt()}: onSocketReceived, ${AClientType}, `, AMessage);
    const command = AMessage.command;
    const jsonData = AMessage.data;
    if (command === "itsFcltStts" || command === "bisFcltStts") {
        updateFcltStts(jsonData);
        if (command === "bisFcltStts") {
            requestFetchFcltStts();
        }
    } else if (command === "itsUnitStts" || command === "bisUnitStts") {
        updateUnitStts(jsonData);
        if (command === "bisUnitStts") {
            requestFetchUnitStts();
        }
    }
}

function onSocketDisconnected(AClientType, AMessage) {
     console.log(`${currDt()}: onSocketDisconnected, ${AClientType}, `, AMessage);
}
function onSocketError(AClientType, AMessage) {
     console.log(`${currDt()}: onSocketError, ${AClientType}, `, AMessage);
}
export let _fcltData = null;
// 현장시설물 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
export async function fetchFcltStts() {
    //console.time("***** fetchFcltStts: ");

    const its = apiGet("/api/common/stts/total"); // ITS 상태정보 요청
    const bit = apiGet("/api/bis/stts/bit/total"); // BIT 상태정보 요청

    Promise.all([its, bit])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: FcltStts, ITS(${values[0].fclt_list.length}), BIT(${values[1].fclt_list.length})`);
            _fcltData = [values[0], values[1]];
            updateFcltStts(values[0]);
            updateFcltStts(values[1]);
        })
        .catch((err) => {
            //console.error(`Error in fetchFcltStts ${err}`);
        })
        .finally(() => {
        // console.timeEnd("***** fetchFcltStts: ")
        });

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchFcltStts();
}
export function updateFcltStts(jsonData) {
    jsonData.fclt_list.forEach((el) => {
        setHtml("." + el.fclt_type + "_TOTAL", el.total_cnt);
        if (_errorSwitch) {
            setHtml("." + el.fclt_type + "_NORMAL", el.total_cnt);
            setHtml("." + el.fclt_type + "_ERROR", 0);
            $("." + el.fclt_type + "_ERROR").css('color', 'rgba(255, 255, 255, 0.788)');
        }
        else {
            setHtml("." + el.fclt_type + "_NORMAL", el.normal_cnt);
            setHtml("." + el.fclt_type + "_ERROR", el.error_cnt);
            const color = el.error_cnt === 0 ? 'rgba(255, 255, 255, 0.788)' : 'red';
            $("." + el.fclt_type + "_ERROR").css('color', color);
        }
    });
}
export let _unitData = null;
// 센터프로세스 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
export async function fetchUnitStts() {
    // console.time("***** fetchUnitStts: ");

    const its = apiGet("/api/common/stts/process/its"); // 센터프로세스 ITS
    const bis = apiGet("/api/bis/stts/process"); // 센터프로세스 BIT
    Promise.all([its, bis])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            // console.log(`${currDt()}: UnitStts, ITS(${values[0].length}), BIS(${values[1].length})`);
            _unitData = [values[0], values[1]];
            updateUnitStts(values[0]); //ITS 프로세스
            updateUnitStts(values[1]); //BIS 프로세스
        })
        .catch((err) => {
            // console.error(`Error in fetchUnitStts ${err}`);
        })
        .finally(() => {
            // console.timeEnd("***** fetchUnitStts: ")
    });

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchUnitStts();
}
export function updateUnitStts(jsonData) {
    jsonData.forEach((obj) => {
        const runStts = obj.run_sts.slice(-1);
        let comStts   = null;
        let dbStts    = null;
        if (!_errorSwitch){
            comStts = obj.com_sts.slice(-1);
            dbStts  = obj.db_sts.slice(-1);
            if (runStts == "1") {
                comStts = "1";
                dbStts = "1";
            }
        }
        else {
            comStts = 0;
            dbStts  = 0;
        }

        const comImg = "<img src='/images/application_facility/stts" + comStts + ".png'>";
        const dbImg = "<img src='/images/application_facility/stts" + dbStts + ".png'>";
        setHtml(".comStts_" + obj.syst_id, comImg);
        setHtml(".dbStts_" + obj.syst_id, dbImg);
    });
}

// DBMS 프로세스 상태정보 요청(타이머 또는 웹소켓에 의해 실행됨)
export async function fetchDbmsStts() {
    //console.time("***** fetchDbmsStts: ");

    const dbms = apiGet("/api/common/stts/dbms"); // DBMS STTS

    Promise.all([dbms])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            //console.log(`${currDt()}: DbmsStts, ${values[0].length}`);
            updateDbmsStts(values[0]); //ITS 프로세스
        })
        .catch((err) => {
            console.error(`Error in fetchDbmsStts ${err}`);
        })
        .finally(() =>{
            //console.timeEnd("***** fetchDbmsStts: ")
        });

    // 요청시간을 기준으로 상태정보 요청 타이머 리셋
    requestFetchDbmsStts();
}

function updateDbmsStts(jsonData) {
    jsonData.forEach((obj) => {
        const dbSeverName = $(".db" + obj.db_svr_id + "_dbSeverName");
        const tableSpaceName = $(".db" + obj.db_svr_id + "_tableName");
        const tableReamin = $(".db" + obj.db_svr_id + "_tableRemSpace");
        //const useSession = $(".db" + obj.db_svr_id + "_useSession");
        //setHtml(dbSeverName, obj.db_svr_nm)
        setHtml(tableSpaceName, obj.tbls_nm);
        if (!isNaN(obj.tbls_rmnd_cpct)) {
            const useVal = (100 - Number(obj.tbls_rmnd_cpct)).toFixed(2);
            if (useVal >= 80) {
                tableReamin.css("color","red");
            }
    
            setHtml(tableReamin, useVal);
        }
        else {
            setHtml(tableReamin, '정보없음');
        }
        
        if (!isNaN(obj.use_sesn)) {
            setChart(obj.db_svr_id, Number(obj.use_sesn).toFixed(2), obj.db_svr_nm);
        }
    });
}

function setChart(id, sessionVal, serverName) {
    let color = 'rgb(115, 191, 105)';
    sessionVal = Number(sessionVal);
    if (!sessionVal) {
        sessionVal = 0;
    }
    else if(sessionVal >= 80 ){
        color = '#FF0000';
    }
    
    const chartId = document.querySelector('#db'+ id + '_useSession');
    if (chartId) {
        Highcharts.chart('db' + id + '_useSession', {
            chart: {
                type            : 'solidgauge',
                marginTop       : -120,
                height          : '100%',
			    backgroundColor : '#2d2d33',
            },
            title: {
                text : serverName,
                y    : 20,
                style: {
                    color: 'rgba(160, 159, 159, 0.836)',
                    fontWeight: 'bold',
                },
            },
            pane: {
                center: ['50%', '80%'],
                size: '80%',
                innerSize: '10%',
                startAngle: -100,
                endAngle: 100,
                background: {
                    backgroundColor: '#22252b',
                    innerRadius: '55%',
                    outerRadius: '100%',
                    shape: 'arc',
                    borderColor: 'black',
                    borderWidth: 1,
                },
                height: 170,
            },

            exporting: {
                enabled: false
            },

            tooltip: {
                enabled: false
            },
            
            // the value axis
            yAxis: {
                stops: [//백분율로 색상 분류
                    [0.8, 'rgb(115, 191, 105)'], // green
                    [1, 'red'], // red,
                ],
                plotBands: [{//해당 값까지 바깥쪽 선 그리기
                    from: 0,
                    to: 80,
                    color: 'rgb(115, 191, 105)', // red
                    thickness: '-5%',
                    borderColor:'#22252b',
                    borderWidth: 1
                }, {
                    from: 80,
                    to: 100,
                    color: '#FF0000', // red
                    thickness: '-5%',
                    borderColor:'#22252b',
                    borderWidth: 1
                }]
                ,
                lineWidth: 2,
                lineColor: 'black',
                tickWidth: 0,
                minorTickInterval: null,
                tickAmount: 0,
                labels: {
                    enabled: false
                },
                min: 0,
                max: 100,
                title: {
                    text: ''
                }
            },
            plotOptions: {
                solidgauge: {
                    dataLabels: {
                        y: 1,
                        borderWidth: 0,
                        useHTML: true,
                    }
                }
            },
            credits: {
                enabled: false
            },
            
            series: [{
                name: serverName,
                data: [sessionVal],
                dataLabels: {
                    format:
                    '<div style="text-align:center; margin-top: -20px;">' 
                    + '<span style="font-size:20px; color:' + color + ';">{y}</span><br>'
                    //+ '<span style="font-size:15px; color:rgb(204, 204, 220);">' + serverName + '</span></div>'
                    + '</div>'
                },
            }],
        });
    }
}
function setHtml(tagClass, tagValue) {
    const tag = $(tagClass);
    if (tag) {
        tag.html(tagValue);
    }
}
export function setInnerText(tagId, tagData) {
    const tag = document.getElementById(tagId);
    if (tag) {
        tag.innerText = tagData;
    }
}
