import { TMapMngr } from "/js/vworld/map-mngr.js";
import { LayerType, LayerIndex } from "/js/vworld/map-const.js";
import { apiGet } from "/js/utils/restApi.js";

let _mapManager = null;
const _lyrType = LayerType.IFSC;
const _lyrIdx = LayerIndex.Ifsc1;
const _HIST_TYPE = "IFSC";

//우측 섹션 관련
let _trafHsData = [];
let _trafHsIndex = 0;
let _trafHsTimer = null;
let trafHsTable = null;

//좌측 섹션 관련
let trafHsStartDate = null;
let trafHsEndDate = null;
let trafHsStartTime = null;
let trafHsEndTime = null;
let trafHsSearchBtn = null;
let trafHsPlaySecn = null;
let playBtn = null;
let stopBtn = null;
let rightMove = 22;
let leftMove = 22;
let _selectedDt = null;

//공통
let commonUri = "/api/analysis/traf-hs";
const _pageName = "소통정보이력 분석";

//기본 날짜 세팅
const strtDate = new Date().setDate(new Date().getDate() - 1);
const endDate = new Date().setDate(new Date().getDate() - 1);
const strtTime = new Date();
const endTime = new Date();
strtTime.setHours(new Date().getHours() - 2);
strtTime.setMinutes(new Date().getMinutes() - new Date().getMinutes());
endTime.setMinutes(59);
endTime.setHours(endTime.getHours() - 2);

$(() => {
    //검색시작일시 년월일
    trafHsStartDate = $(".strt-date")
        .dxDateBox({
            type                : "date",
            value               : strtDate,
            width               : 130,
            height              : "28px",
            stylingMode         : "outlined",
            displayFormat       : "yyyy-MM-dd",
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
            onValueChanged(e) {
                trafHsEndDate.option("value", e.value);
            },
        })
        .dxDateBox("instance");

    //검색 시작일시 시간
    trafHsStartTime = $(".strt-time")
        .dxDateBox({
            type                : "time",
            value               : strtTime,
            width               : 75,
            interval            : 10,
            height              : "28px",
            stylingMode         : "outlined",
            displayFormat       : "HH:mm",
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
        })
        .dxDateBox("instance");

    //검색종료일시 년월일
    trafHsEndDate = $(".end-date")
        .dxDateBox({
            type                : "date",
            value               : endDate,
            width               : 130,
            height              : "28px",
            stylingMode         : "outlined",
            displayFormat       : "yyyy-MM-dd",
            disabled            : true,
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)0000-00-00',
        })
        .dxDateBox("instance");

    //검색종료일시 시간
    trafHsEndTime = $(".end-time")
        .dxDateBox({
            type                : "time",
            value               : endTime,
            width               : 75,
            interval            : 10,
            height              : "28px",
            stylingMode         : "outlined",
            displayFormat       : "HH:mm",
            invalidDateMessage  : '형식에 맞게 입력해주세요. ex)00:00',
        })
        .dxDateBox("instance");

    //상단 조회 버튼
    trafHsSearchBtn = $(".traf-hs-search-btn")
        .dxButton({
            stylingMode: "outlined",
            text: "조회",
            icon: "refresh",
            width: "80px",
            onClick() {
                trafHsEvent();
            },
        })
        .dxButton("instance");

    //갱신 주기
    trafHsPlaySecn = $(".play-secn")
        .dxNumberBox({
            value: 5,
            min: 1,
            max: 30,
            width: 70,
            height: 25,
            stylingMode: "outlined",
            showSpinButtons: true,
        })
        .dxNumberBox("instance");

    //실행 버튼
    playBtn = $(".play-btn").dxButton({
        icon: "video",
        stylingMode: "outlined",
        hint: "실행",
        width: 30,
        height: 30,
        onClick() {
            if (_trafHsData[0].length == 0) {
                alertWarning("표출할 정보가 없습니다. 이력정보를 다시 조회하신 후 작업을 진행 하십시요.");
                return;
            }
            _trafHsIndex = 0;
            $('.pointer').css('left',  117);
            dsblOnBtn(trafHsSearchBtn);
            fetchHistData();
            $(".line-bar").off('click');
            trafHsTable.option('disabled', true);
        },
    }).dxButton('instance');

    //멈춤 버튼
    stopBtn = $(".stop-btn").dxButton({
        icon: "square",
        stylingMode: "outlined",
        hint: "멈충",
        width: 30,
        height: 30,
        onClick() {
            if (_trafHsTimer) window.clearTimeout(_trafHsTimer);
            _trafHsTimer = null;
            _trafHsIndex = 0;
            dsblOffBtn(trafHsSearchBtn);
            trafHsTable.option('disabled', false);
            $('.line-bar').on('click',(e)=>lineBarClick(e));
        },
    });

  

    //좌측 하단 눈금 바
    $(".line-bar").on("click", (e) => {
        lineBarClick(e);
    });

    //상단 닫기 버튼
    $(".cancle-button")
        .dxButton({
            text: "닫기",
            icon: "close",
            height: "30px",
            width: "80px",
            stylingMode: "outlined",
            onClick() {
                window.close();
            },
        })
        .dxButton("instance");

    //소통정보 이력분석 테이블
    trafHsTable = $(".traf-hs-table")
        .width("100%")
        .height("100%")
        .dxDataGrid({
            dataSource: null,
            allowColumnReordering: true,
            showColumnLines: true,
            showBorders: true,
            allowColumnResizing: true,
            rowAlternationEnabled: true,
            columnAutoWidth: true,
            focusedRowEnabled: true,
            noDataText: "표출할 정보가 없습니다.",
            selection: {
                mode: "single",
            },
            keyExpr: "no",
            filterRow: {
                visible: true,
                applyFilter: "auto",
                showOperationChooser:false,
            },
            headerFilter: {
                visible: true,
            },
            grouping: {
                autoExpandAll: true,
            },
            scrolling: {
                mode: "virtual",
            },
            groupPanel: {
                visible: true,
                emptyPanelText: "그룹 지을 항목을 여기에 끌어다 놓으세요",
            },
            export: {
                enabled: true,
                texts: {
                    exportAll: "엑셀 파일",
                },
            },
            columns: [
                {
                    dataField: "no",
                    caption: "No.",
                    alignment: "center",
                    sortIndex: 0,
                    sortOrder: "asc",
                },
                {
                    dataField: "stat_fmt",
                    caption: "일시",
                    alignment: "center",
                },
                {
                    dataField: "data_cnt",
                    caption: "건수",
                    alignment: "center",
                },
            ],
            onExporting(e) {
                gridExcellExporting(e, _pageName);
            },
            onRowDblClick(info){
                listDblClick(info.data.stat_dt);
            }
        })
        .dxDataGrid("instance");

    // 지도정보 초기화
    doMap();
});
function lineBarClick(e){
    const x = e.clientX;
    const left = $(".pointer").offset().left;
    switch (true) {
        case x <= 126 && left - leftMove <= 117:
            $(".pointer").css("left", 117);
            break;
        case x >= 337 && left + rightMove >= 337:
            $(".pointer").css("left", 337);
            break;
        case x === left:
            break;
        case x > left:
            $(".pointer").css("left", left + rightMove);
            break;
        case x < left:
            $(".pointer").css("left", left - leftMove);
            break;

        default:
            break;
    }
}
//구간별 데이터 세팅
function trafHsEvent() {
    let TO_DT = null;
    let FROM_DT = null;
    let updateData = {};

    if (!validationCheck(trafHsStartDate, trafHsEndDate, trafHsStartTime, trafHsEndTime)) return false;
    FROM_DT = getDate(trafHsStartDate.option("value"), trafHsStartTime.option("value"));
    TO_DT = getDate(trafHsEndDate.option("value"), trafHsEndTime.option("value"));

    if (FROM_DT > TO_DT) {
        alertWarning("검색 시작 시각이 검색 종료 시각보다 큽니다.", null, trafHsStartDate);
        return false;
    }
    if (Number(FROM_DT.substring(8, 12)) + 300 <= Number(TO_DT.substring(8, 12))) {
        alertWarning("3시간 이상의 정보를 조회할 수 없습니다.", null, trafHsEndTime);
        return false;
    }

    updateData["FROM_DT"] = FROM_DT;
    updateData["TO_DT"] = TO_DT;
    updateData["HIST_TYPE"] = _HIST_TYPE;
    finalEvent(commonUri + "/stat", updateData);
}

//테이블 및 차트 세팅
function finalEvent(uri, updateData) {
    _trafHsData = [];
    let cnt = 1;
    //getData(uri, _trafHsData, updateData);
    getDataAsync(uri, (jsonData)=>{
        _trafHsData = jsonData;
    
        _trafHsIndex = 0;

        if (_trafHsData) {
            _trafHsData.map((item) => {
                item.no = cnt++;
                if (nullChecker(item.stat_dt) !== "") {
                    item.stat_fmt = getParseDateTime(item.stat_dt);
                }
            });
            $(".small-line").empty();
            const lineWidth = $(".line").width();

            leftMove = lineWidth / _trafHsData.length;
            rightMove = lineWidth / _trafHsData.length;
            for (let ii = 0; ii < _trafHsData.length + 1; ii++) {
                $(".small-line").append("<div>");
                if (ii !== 0) {
                    $(".small-line > div:nth-child(" + (ii + 1) + ")").css("margin-left", "calc(220px/" + _trafHsData.length + " - 1px)");
                }
            };
            $('.pointer').css('left',  117);
        }

        trafHsTable.option("dataSource", _trafHsData);

        _mapManager.initTraf(_lyrIdx, true);

        alertConfirm("데이터 조회가 완료 되었습니다. [" + _trafHsData.length + "건]");
    }, null, updateData);
}
/**
 * 지도 인터페이스 함수........
 */
function doMap() {
    _mapManager = new TMapMngr("traf-hs-map", "tooltip");
    _mapManager.setLayerVisible(_lyrIdx, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
    fetchBaseData();
    fetchMapIconBar($('.map-bar'), _mapManager, _lyrIdx, '소통정보 이력분석');
    _mapManager.toggleBaseMap(true);
    _mapManager.showTrafficTooltip(true);
}
/**
 * 기초정보 로딩 및 지도표출, 정보제공구간, 정보제공구간 버텍스
 */
async function fetchBaseData() {
    console.time("***** fetchBaseData: ");

    const ifsc = apiGet("/api/database/ifsc/list"); // 정보제공구간정보 요청
    const vrtx = apiGet("/api/manage/main/map/vrtx/ifsc/3"); // 정보제공구간정보 버텍스 요청
    Promise.all([ifsc, vrtx])
        .then((results) => Promise.all(results.map((r) => r.json())))
        .then((values) => {
            // 도로명을 '시점 -> 종점' 으로 변경
            values[0].map((item) => (item.ifsc_nm = item.strt_nm + " -> " + item.end_nm));
            // 레이어 객체 및 버텍스 생성
            _mapManager.makeTrafficObject(_lyrType, values[0]);
            _mapManager.makeLayer(_lyrIdx, values[1]);
        })
        .catch((err) => {
            console.error(`Error in fetchBaseData ${err}`);
        })
        .finally(() => console.timeEnd("***** fetchBaseData: "));
}
/**
 * 이력 데이터를 조회한다.
 */
function fetchHistDataByDate(stat_dt, addFunc) {
    const getParam = {
        HIST_TYPE: _HIST_TYPE,
        STAT_DT: stat_dt,
    };
    // let histData = [];
    // getData(commonUri + "/hist", histData, getParam);
    // if (histData[0]) {
    //     _mapManager.updateTraf(_lyrIdx, histData[0]);
    // }
    getDataAsync(commonUri + "/hist", (jsonData)=>{
        if (jsonData) {
            _mapManager.updateTraf(_lyrIdx, jsonData);
        }
        
        if (addFunc) {
            addFunc();
        }
    }, null, getParam);

}

function fetchHistData() {
    if (_trafHsTimer) window.clearTimeout(_trafHsTimer);

    if (_trafHsData.length == 0) {
        console.log("history data length === 0");
        return;
    }

    fetchHistDataByDate(_trafHsData[_trafHsIndex].stat_dt, timeFunction);

    
}
function timeFunction(){
    if(_trafHsIndex > 0){
        let left = $('.pointer').offset().left;
        $('.pointer').css('left',  left + rightMove);
    }
    trafHsTable.selectRowsByIndexes([_trafHsIndex]);
    trafHsTable.option('focusedRowIndex', _trafHsIndex);
    _trafHsIndex++;
    if (_trafHsIndex < _trafHsData.length) {
        _trafHsTimer = window.setTimeout(() => fetchHistData(), getValue(trafHsPlaySecn) * 1000);
    }
    else {
        window.setTimeout(()=>{
            dsblOffBtn(trafHsSearchBtn);
            $('.pointer').css('left',  117);
            trafHsTable.option('disabled', false);
            $('.line-bar').on('click',(e)=>lineBarClick(e));
        }, getValue(trafHsPlaySecn) * 1000);
    }
}
function listDblClick(stat_dt){
    if (_selectedDt && _selectedDt === stat_dt) {
        console.log('...selected');
        return
    }
    else {
        _selectedDt = stat_dt;
        fetchHistDataByDate(stat_dt);
    }
}